##Patch file for keen episode 59 - Underworld Ultimate!

#game setups:
%ext ck4
%version 1.4
# Load the modified graphics
%egahead EGAHEAD.CK4

%maphead maphead.ck4
%gamemaps editmaps.ck4

%patchfile $249C2 "Keen4.tli"

#Keenwave patch file; Patch sounds:
%patchfile $20DF0 AUDIOHED.CK4	#Audio header
%patchfile $354F6 AUDIODCT.CK4	#Audio dictionary

#Disable EGAGRAPH check in Keen 4 (Frees 389 bytes at $3CF6, until $3E7B)
%patch $3CE5 $90 $90

#disable DOS screen at intro
%patch $38AD  $90 $90 $90 $90 $90 #Don't load B800
%patch $38D0  $90 $90 $90 $90 $90 #Don't display game info
%patch $19F40 $90 $90 $90         #Don't show 'Loading...' text
%patch $19FA6 $90 $90 $90         #Don't show 'Ready' text
%patch $39B2 $90 $90 $90 $90 $90  #Don't wait for key
%patch $19B2E $CB

#this is for the dos screens at the beginning and end
%patchfile $1FE47 CK4LOAD.BIN

#This controls the position of the frames of level loading anim (keen giving thumbs up)
%patch $6478 $0000W #Y pos
%patch $647F $002DW #X pos

#This controls the position of the frames of level loading anim (keen giving thumbs up)- for after you die (different for some reason)
%patch $640D $0000W #Y pos
%patch $6414 $002DW #X pos

#Disable F10-B cheat (Frees $73B7-$744B)
%patch $73B4 $E9 $0095W

#Count objects (F10-C) cheat disabled
%patch $7458 $EB

#Disable Add VBLs (Free $76DB-$7760)
%patch $76D8 $E9 $0086W

#Disable F10-I
%patch $751F $EB

#Disable F10-S (Free $7670-76C3)
%patch $7668 $EB $5A

#Disable slow motion -Keen 4
%patch $90AE $EB $1F

#Disable F10-Y (Free $77FC-780D)
%patch $77FA $EB $12

#Disable F10-D (Demo recording) (Frees 48 bytes at $746E)
#%patch $746C $EB
#NOTE: If i want to record a demo, turn this off and go into 'MAGE OF THE ANCIENTS' and turn off the last beh. (as its taking over demo code).

#Disable sprite test cheat (Free 390 bytes at $6D39)
%patch $76C4 $EB $12

#Keen 4: Disable individual reports
%patch $72E4 $EB $42 #Right (Frees $72E8-$7327)
%patch $7348 $EB $42 #Left (Frees $734C-$738B)

#Eliminate air-door entry glitch
%patch $2FD5E $0C02W

#WoW exits normally
%patch $9059 $90

#Keen can exit the WoW normally (Going offscreen)
%patch $9056 $83 $3E $A7EDW  $11 $90 $90

##These have an effect on the 'camera'- turning these on starts the 'camera' in one location and then zooms to Keen's location.
#%patch $AFA5 $04
#%patch $AF6B $04
#%patch $AF5F $0004W

#Ammo stunners give Keen
%patch $30246 $0007W #Easy
              $0006W  #Medium
              $0005W  #Hard

#Keen can enter doors 1 tile wide (Walks right 2 pixels instead of 6)
%patch $B9C0 $0000W

#Debug keys always on
%patch $7AB7 $90 $90
%patch $82EB $EB

#Removes the F10 key for cheats (so I can get the backspace thing to work really)
%patch $7ABE $90 $90

#What the backspace key does:
%patch $7469 $C663W $00 $74 $30 
		 $B8 $002BW  $50 $9A $187409F1RL     $83 $C4 $02 					#make sound
		 $C7 $06 $7A5EW $0000W $C7 $06 $7A5CW $0000W $C7 $06 $7A5AW $0000W $E9 $0009W	#clear potions
#33



############################################################################################################################################################################################### GAME INTRO

#Terminator chunks:
#%patch $4EE8 $1282W #COMMANDER

#This makes the star wars story appear after the title screen- then goes to the menu
%patch $521B $9A $03ED18B8RL #$E5 $5D $CB

#turns 'KEEN' off (can use $4F59 down to $4F9F)
%patch $4F56 $E9 $0046W 

#turns 'COMMANDER' off (can use $504D down to $5075)
%patch $504A $E9 $0028W 

#Terminator text palette:
%patch $2F078 $07 $07 $07 $07 $00 $07 $07 $07     #Dark colors
              $13 $13 $13 $13 $03 $00 $13 $13 $1E #Light colors (and border color)

#Terminator text palette 2, screen moves out:
%patch $2F088 $07 $07 $07 $07 $07 $07 $07 $07 #Dark colors
              $07 $07 $07 $07 $07 $07 $07 $07 #Light colors

#makes the credits that come up wobble
#%patch $4012 $0005W

#this makes the credits suddenly appear in the middle of the screen
%patch $4216 $EB

#sorta makes it disappear suddenly - but screwy
#%patch $422F $EB

#interesting - bit screwy though
#%patch $4230 $00F0W

#controls the X position of the credits
%patch $402C $000CW

########'star wars' story#########
#"|---------------------|"
%patch $1EE40
"After all that business" $0A
"in 'The Ruin of Roib'," $0A
"and learning that an" $0A
"underground base of" $0A 
"evil Kreegs are on" $0A
%patch $1EEAB
"Earth, Keen's old ship" $0A
"suddenly dies on him." $0A
"It crashes down to" $0A
"Earth in a wreck, in" $0A 
"the middle of nowhere." $0A
%patch $1EF17
$0A 
"Finding some town, he" $0A
"learns about local" $0A
"sightings of lights" $0A
"flying into caves at" $0A
"night. Keen figures it" $0A
"must be them, secretly" $0A
"building up their base." $0A
$0A
%patch $1EFB1
"Grabbing some old" $0A
"mining equipment, Keen" $0A
"drills down into the" $0A
"Earth, into a forgotten" $0A 
"magical underworld, to" $0A
"find the Kreeg base..." $0A
$00 $00 $00 $00 $00 $00






################################################################################################################################################################################################ MAIN MENU

#%patch $33656 "BEGIN EASY GAME" $00
#              "BEGIN NORMAL GAME" $00
#              "BEGIN HARD GAME" $00
%patch $33656 "ADEPT MODE     " $00
              "MAGE MODE        " $00
              "WAR GOD MODE   " $00
#%patch $33656 "GENTLE MODE    " $00
#              "SO-SO MODE       " $00
#              "FORGET IT MODE " $00
#%patch $33656 "SURFACE MODE   " $00
#              "SHALLOW MODE     " $00
#              "DEEP MODE      " $00

%patch $3372F "NUE GAIM" $00 
              "LODE GAIM" $00 
              "SAYV GAIM" $00
              "CONFEEGUA" $00 
              "END GAIM" $00 
              "REFRESH   " $00
              "KWIT" $00

%patch $33792 " " $00
%patch $337A2 "REELY END CURENT GAIM?" $00
              "PRES Y TO END IT" $00
%patch $337CD "REELY KWIT?" $00
              "PRES Y TO KWIT" $00
%patch $337EA "YOUR IN A GAIM" $00
              "PRES Y TO LODE GAIM" $00
%patch $33810 "YOUR IN A GAIM" $00
              "PRES Y 4 NUE GAIM" $00

#Options menu

%patch $33874 "SKOR BOX (ON)" $00
              "SKOR BOX (OFF)" $00
%patch $33893 "TWOBUTTON FIRING (ON)" $00
              "TWOBUTTON FIRING (OFF)" $00
%patch $338C2 "FIX JERKY MOTION (ON)" $00
              "FIX JERKY MOTION (OFF)" $00
%patch $338EF "SVGA COMPATIBILITY (ON)" $00
              "SVGA COMPATIBILITY (OFF)" $00
%patch $33920 "USE GRAVIS GAMEPAD (ON)" $00
              "USE GRAVIS GAMEPAD (OFF)" $00
%patch $33951 "Skore box now on" $00
              "Skore box now off" $00
              "Pres any ckey" $00
%patch $33CCA "RETERN TO GAIM" $00 
              "PROGRES       " $00
%patch $33D11 "Kwiting..." $00


%patch $1A9CC $08

#%patch $1C54E $60
#%patch $1CA4F $60
#%patch $1CBEF $60
#%patch $1CE65 $56

#%patch $1A949 $12

#text for bottom of main menu - taking it all out
%patch $33C79 $00
%patch $33C85 $00
%patch $33C93 $00
%patch $33CA3 $00

#this seems to take out the bottom bar of the main menu
%patch $1AAC5 $00 

#Where the 'Main Menu' graphic is
#%patch $1CBEF $0059W

#position of the 'Paddle War!' image in paddle war
#%patch $1C6E6 $0062W
#%patch $1C6EA $0052W

#start of paddle war code (currently does nothing)
%patch $1C241 $5F $5E $8B $E5 $5D $CB





######################################################################################################################################################################################### COMPUTER WRIST MENU

#right side graphics positioning
%patch $997C $0000W #V loc
%patch $9980 $0120W #H loc
%patch $963A $0000W #V loc
%patch $963E $0120W #H loc

#bottom graphics positioning
%patch $9668 $00C0W #V loc
%patch $966C $FFF8W #H loc

#Bottom of help screen
%patch $9990 $0000W #V loc
%patch $9994 $0000W #H loc

%patch $98F5 $0006W #Color used for screen background
%patch $99F8 $0006W #Color used behind help pointer
%patch $95FB $0007W #Color used for screen background

#this makes the page number indicator text disappear (only the no. for what page you're on.)
#%patch $975A $00

#Y pos. of page no. indicator text
%patch $97A2 $B3

#X pos. of page no. indicator text
%patch $97A8 $F4




########################################################################################################################################################################################### STATUS WINDOW

#taking out council members; adding a counter for the keys; cannibalising shots, lives and drops counter for potion stuff.
#NOTE: theres tons of $90 values in the code- maybe I could make room later on to put in more stuff.

#Don't draw Council Rescued counter
%patch $7E32 $90 $90 $90 $90 $90 #Rescued text
%patch $7E4D $90 $90 $90 $90 $90 #Background rectangle
%patch $7E6D $90 $90 $90 $90 $90 #Rescued tiles

#Key counter - overtaking the wetsuit status
#Background rectangle
%patch $8059 $0000W #Color
%patch $805D $000AW #Height
%patch $8061 $0010W #Width
%patch $8065 $008FW #Vertical
%patch $8069 $00E0W #Horizontal

#Don't draw 'Press Any Key' pic
#%patch $80C1 $90 $90 $90 $90 $90 #PAK row 1
#%patch $80DF $90 $90 $90 $90 $90 #PAK row 2

#Replace Wetsuit box with new counter (One byte too large!)
%patch $8058 $C7 $06 $A537W  $0050W  $C7 $06 $A535W  $0090W  $90 $90 $90  $90		#the value after the B8 dictates where the text 'KEYS' is read from
             $90 $90 $90 $90 $90     $90 $90 $90 $90 $90 $90 $90 $90 $90  $90 $90
             $90 $90 $90 $90 $90 $90 $90 $90 $90 $90 $90 $90 $90 $90 $90 $90
             $90 $C4 $0A $A1 $CAB5W  $99 $5052W  $B8 $0029W  $50 $B8 $0002W
             $50 $B8 $007FW  $50 $B8 $00DEW  $50 $0E $E8 $FACDW  $83 $C4 $0C

#Relocate end of window one byte
%patch $80A8 $33 $F6 $EB $3D $8B $C6 $05 $0048W $50 $B8 $007CW $50 $8B $C6 $D1 $E0 #the second XXXXW value is the Y of the first row of key tiles
		 $D1 $E0 $D1 $E0 $05 $00CAW $50 $9A $1D060ABBRL $83 $C4 $06 $8B $C6    #the XXXXW value is the X of the first row of key tiles
		 $05 $0052W $50 $B8 $0084W  $50 $8B $C6 $D1 $E0
             $D1 $E0 $D1 $E0 $05 $00CAW $50 $9A $1D060ABBRL $83 $C4 $06
             $46 $83 $FE $02 $7C $BE $E9 $01CAW							#that $01 is what dictates how many tiles to show
#1E
#$B8 $0036W $50 $57 $FF $76 $FC $9A $1D060ABBRL $83 $C4 $06

%patch $2F4BB "GEMS" $00

#Gems
#Background rectangle
%patch $7F2C $008FW #Vertical position
%patch $7F30 $0090W #Horizontal position
#Counter
%patch $7F51 $0085W #Vertical position
%patch $7F5D $0098W #Horizontal position
#Gem text
%patch $7F0C $009AW #Horiz
%patch $7F12 $0079W #Vert

#turn off:
%patch $7F33 $90 $90 $90 $90 $90 #Background rectangle
#%patch $7EB2 $90 $90 $90 $90 $90 #Background rectangle
%patch $7DF5 $90 $90 $90 $90 $90 #Background rectangle
%patch $7D9D $90 $90 $90 $90 $90 #Score background rectangle

#Difficulty background rectangle
%patch $7E9F $0000W #Color

#Background
%patch $7CC9 $0005W #Color (Purple)

#dont draw 'location' backg box.
#%patch $7D16 $90 $90 $90 $90 $90 #Background




############################################################################################################# POTION STUFF

#NOTE: 
#Council Members counter = Blue potion
#Wesuit counter = White potion
#Drops counter = Purple potion

#position of that left bit of status window (wires pic), now used as the 3 potions graphic
%patch $829A $FFB9W #Y
%patch $82A5 $0055W #X
#%patch $8136 $007AW

%patch $813A $FFF1W
%patch $8149 $0050W #X pos
#%patch $817D $0050W

#Don't draw
%patch $7FCE $90 $90 $90 $90 $90 #Lives text
%patch $8018 $90 $90 $90 $90 $90 #Drops text
#%patch $7F7E $90 $90 $90 $90 $90 #Shots text

#Shots text - now used as 'potions' text
%patch $7F72 $0058W #X
%patch $7F78 $0058W #Y
%patch $2F4C0 "POTIONS" $00 

#Shots box - now for blue potion
%patch $7FAC $0002W #Number of digits
%patch $7FA2 $7A5EW #What to track 
#Counter
%patch $7FB0 $0065W #Vertical position
%patch $7FB4 $0072W #Horizontal position
%patch $7F92 $0064W #Vertical position
%patch $7F96 $0070W #Horizontal position

#Lives box - now for white potion
%patch $7FEF $7A5CW #What to track (wetsuit)
#Counter
%patch $7FFD $0075W #Vertical AND horizontal position (Both are equal!)

#Drops - now for the purple potion
#Counter
%patch $804A $0085W #Vertical position
%patch $804E $0070W #Horizontal position

#Location background rectangle
%patch $7D03 $0000W #Color (black)

#turn off:
%patch $7F99 $90 $90 $90 $90 $90 #Background rectangle
%patch $7FE6 $90 $90 $90 $90 $90 #Background rectangle
%patch $8033 $90 $90 $90 $90 $90 #Background rectangle


################################################################################################################################################################################################## ENDING DOC

#image for bottom of page
%patch $9664 $0053W
%patch $9668 $00B0W #Y
%patch $966C $0008W #X






################################################################################################################################################################################################# HIGHSCORES

#Names in the highscores
%patch $33234 "                 " $00
%patch $33274 "                 " $00
%patch $332B4 "                 " $00
%patch $332F4 "                 " $00
%patch $33334 "                 " $00
%patch $33374 "                 " $00
%patch $333B4 "                 " $00
%patch $333F4 "                 " $00

#Points: 
%patch $3326E $00222E00L
%patch $332AE $00186A00L
%patch $332EE $00138800L
%patch $3332E $000EA600L
%patch $3336E $0009C400L
%patch $333AE $0004E200L
%patch $333EE $00027100L
%patch $3342E $00013880L #80,000

#Level high scores are entered in
%patch $5BC0 $0010W

#Main menu actions list
%patch $3CB9 $0448W #3C18: Terminator sequence and title screen
	       $0481W #3C2F: Demo 1
             $046CW #3C3C: Star wars story
             $0481W #3C43: Demo 2
             $046CW #3C51: High score demo
             $0481W #3C58: Demo 3
             $046CW #3C66: Demo 4

#disable demos, except high score demo
%patch $3C32 $90 $90 $90 $90 $90 #Demo 1
%patch $3C47 $90 $90 $90 $90 $90 #Demo 2
%patch $3C5C $90 $90 $90 $90 $90 #Demo 3
%patch $3C6C $90 $90 $90 $90 $90 #Demo 4

#NOTE: DEMO4.CK4 is the demo for the highscore level


#What is displayed in the 'saved' column- whether level 24 is completed or not (and it never is- so it'll always be zero. swish)
%patch $6BAC $7A14W

#NOTE: these also seem to stop the councilmen popping up in the highscores - but some could also be for something else. so if any issues with
#councilman stuffs, check these out.
%patch $6AE4 $7A14W
%patch $6B07 $7A14W
%patch $7E7C $7A14W

#skips code that has to do with the middle column
#%patch $6B9C $E9 $001FW





############################################################################################################################### HIGHSCORE ITEM

%patch $EF2B $154EW #Hard Right Dart 

%patch $FE3E $FF $76 $FC $57 $9A $05C40FB5RL $83 $C4 $04 $B8 $2A3ARW $8A
             $16 $EC $7A $8E $C0 $26 $08 $16 $0167W  $E9 $EFA2W
#29
#GOTTA FIND NEW SPOT FOR THIS CODE - ALREADY USED
#spawn code - $05C40FB5RL
%patch $6BF5  $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $8B $46 $06 $B1 $08
              $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $89 $47 $0C
              $B8 $226AW  $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB
#51^
#$226AW 
%patch $310DA $0167W $0167W $0002W $0000W $0000W $0000W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL  $0000W 






##################################################################################################################################################################################################### LEVELS

#Levels enterable on map
%patch $DF56 $C000W $76 #Minimum - 1
%patch $DF5D $C018W $77 #Maximum

#Allow 24 levels in Keen 4 v1.4:
#First increase the number of levels we can access from the map to maximum (+6)
%patch $DF5D $18 #Number of levels enterable ($18 = 24)
%patch $8CA4 $18 #Number of level song entries (24, see below)

#Give extra levels valid stuff:
#Level name pointers:
%patch $30764 $1F040000RL #Map
              $1F050000RL #Level 1
              $1F060000RL #Level 2
              $1F070000RL #Level 3
              $1F070010RL #Level 4...
              $1F090010RL
              $1F0B0000RL
              $1F0C0010RL
              $1F0E0000RL
              $1F0F0000RL
              $1F100000RL
              $1F110000RL
              $1F110010RL
              $1F130000RL
              $1F130010RL
              $1F150000RL
              $1F150010RL
              $1F150020RL
              $1F180000RL 
              $1F180010RL 
              $1F1A0000RL
              $1F1C0000RL
              $1F1D0000RL
              $1F1D0010RL
              $1F540030RL

#Level entrance text pointers
%patch $307C8 $1F1F0000RL #Map
              $1F210000RL #Level 1
              $1F210020RL #Level 2
              $1F240010RL #Level 3...
              $1F260020RL
              $1F290010RL
              $1F290030RL
              $1F2D0020RL
              $1F300010RL
              $1F330000RL
              $1F350010RL
              $1F380000RL
              $1F3A0000RL
              $1F3A0020RL
              $1F3D0010RL
              $1F400000RL
              $1F430000RL
              $1F430020RL
              $1F470000RL 
              $1F470030RL 
              $1F4B0010RL
              $1F4E0010RL
              $1F4E0030RL
              $1F510020RL
              $1F540010RL

#Level names:
%patch $1F040 "  Underworld   " $00
%patch $1F050 "Mushroom Mines " $00
%patch $1F060 "Tunnel Network " $00
%patch $1F070 "Cave of Secrets" $00
%patch $1F080 "    Cave of    " $0A
%patch $1F090 "   Illusions   " $00
%patch $1F0A0 "  Understream  " $00
%patch $1F0B0 "    Crystal    " $0A
%patch $1F0C0 "  Wonderland!  " $00
%patch $1F0D0 " Ancient Ruins " $00
%patch $1F0E0 " Temple of Om  " $00
%patch $1F0F0 "Realm of Magic " $00
%patch $1F100 " Machined Chasm" $00
%patch $1F110 "   Gateway     " $00
%patch $1F120 "  Lazerwerks   " $00
%patch $1F130 "   Stations    " $00
%patch $1F140 "R 'n R District" $00
%patch $1F150 "Podium of Light" $00
%patch $1F160 "  Scoreboard   " $00
%patch $1F170 "Cave of Boings " $00
%patch $1F180 "Some Other Game" $00
%patch $1F190 "  McZazgag's   " $00
%patch $1F1A0 " Secret Level  " $0A
%patch $1F1B0 "     Stuff     " $00
%patch $1F1C0 "  Great Seal   " $00
%patch $1F1D0 "    Fountain   " $00
%patch $1F1E0 " Drea's Domain " $00
%patch $1F570 " Dark Circuit  " $00

#Keen entering levels
%patch $1F1F0 "Keen explores the" $0A " Underworld  " $00
%patch $1F210 "Keen fracks the " $0A "Mushroom Mines" $00
%patch $1F230 "Keen maps the" $0A " Tunnel Network  " $00
%patch $1F250 " Keen shows everyone " $0A "   the Cave of Secrets   " $00
%patch $1F280 "Keen sees the" $0A "Cave of Illusions" $00
%patch $1F2A0 "Keen splashes" $0A " the Understream " $00
%patch $1F2C0 "   Keen plays in a   " $0A "   Crystal Wonderland!   " $00
%patch $1F2F0 "Keen dusts off" $0A " Ancient Ruins  " $00
%patch $1F310 "Keen plunders the" $0A "Temple of Om " $00
%patch $1F330 "  Keen re-opens the  " $0A "   Realm of Lost Magic   " $00
%patch $1F360 "Keen works the" $0A " Machined Chasm " $00
%patch $1F380 "Keen unlocks" $0A " the Base Gateway " $00
%patch $1F3A0 "Keen tags" $0A "   the Lazerwerks    " $00
%patch $1F3C0 "Keen rides the" $0A "  Base Station  " $00
%patch $1F3E0 "Keen boogies down" $0A "to the R 'n R" $00
%patch $1F400 "  Keen ascends to   " $0A "   the Podium of Lights   " $00
%patch $1F430 "Keen checks his" $0A "    Progress   " $00
%patch $1F450 "Keen finds the" $0A "Cave of Boings" $00
%patch $1F470 "Keen warps to" $0A " Some Other Game " $00
%patch $1F4A0 "Keen finds a" $0A "    McZazgag's    " $00
%patch $1F4C0 "Keen enters Standard" $0A "    Secret Level Stuff    " $00
%patch $1F4F0 "Keen checks out" $0A "the Great Seal " $00
%patch $1F510 "Keen investigates" $0A "the Fountain " $00
%patch $1F530 "Keen appears in" $0A " Drea's Domain " $00
%patch $1F550 " Keen plays " $0A " the Dark Circuit " $00

#death texts
%patch $2F16F "BAM!! DEAD! In the" $00
%patch $2F191 "Exit to Map" $00

#BwB levels:
%patch $60FD $14 $77 $5B #Level $xx and above





###################################################################################################################################################################################################### MUSIC



%patch $8CCD $96 $03 #$2F206

#Change number of songs:
#%patch $8CEF $9B $00
#%patch $8C75 $C891W
#%patch $8C83 $C891W
#%patch $8D83 $C891W

%patch $8CA4 $1A #Number of level song entries (24)- the example on the wiki should be 19 not 18.

%patch $2F206 $06 $00 #Map 0
              $0A $00 #Mushroom Mines 1
              $09 $00 #Tunnel Network 2
              $04 $00 #Cave of Secrets 3
              $04 $00 #Cave of Illusion 4
              $02 $00 #Understream 5
              $02 $00 #Crystal Wonderland 6
              $09 $00 #Ancient Ruins 7
              $04 $00 #Temple of Om 8
              $01 $00 #Realm of Lost Magic 9
              $09 $00 #Black Void 10
              $03 $00 #Gateway 11
              $02 $00 #Lazerwerks 12
              $03 $00 #Station 13
              $03 $00 #R 'n R District 14
              $05 $00 #Podium of Light 15
              $07 $00 #Highscores 16
              $0A $00 #Cave of Boings 17
              $0B $00 #Some Other Game 18
              $0A $00 #McZazgag's 19
		  $0A $00 #Secret Level Stuff 20
		  $07 $00 #Great Seal 21
		  $07 $00 #Statue 22
		  $08 $00 #Drea's Domain 23
		  $00 $00 #Dark Circuit 24

#%patch $5836 $02 $00 #Story demo (lvl 2)
%patch $5835 $90 $90 $90 $90 $90 $90 $90 $90 $90 $90 $90 $90

%patch $9CD7 $17 $00 #Ending Sequence 
#%patch $F107 $0008W #Talking to Lindsey (Ancient)
#%patch $F4CA $FF $FF #Talking to Ancient (Ancient)

#Music names:
#00= 'Little Negative Ditty'
#01= 'Theme'
#02= 'Crystal Music Sortof'
#03= 'Usin' That Low Pitched Sawtooth Mostly'
#04= 'Mysteries Of The Gods'
#05= '1046'
#06= 'Onward O' Ye Game Player'
#07= 'Twinkle Ambience'
#08= 'Grove 2'
#09= 'Clunky Bullshit'
#0A= 'Kidding'
#0B= '"Untitled" by Mr.M'


#Add new music
#Index of first music chunk within audio chunks:
%patch $8CEF $0096W # 98 is hex for 152- the number of the first song in my list.txt. originally $009CW

#Start address of music chunks
#reduce start address by 2x that of "First Audio Entry"
%patch $8C75 $C889W # clear_music()- originally C895W
%patch $8C83 $C889W # clear_music()
%patch $8D83 $C889W # StartMusic()
%patch $8C91 12      # Total Number of Songs

#Play music in the menu
%patch $1CC6F $06BD20C7RL
%patch $1CC6B $0016W      #Play this level's song

#Music for intro
#%patch $3FEF $B8 $0018W $50 $9A $06BD20C7RL $83 $C4 $02 $90 $90
#%patch $400B $B8 $0018W $50 $9A $06BD20C7RL $83

#this is beautiful- plays music in intro, then continues playing during 'star wars' text.
%patch $4EB2 $B8 $0009W $50 $9A $06BD20C7RL $83 $C4 $02 $90 
#%patch $4ECC $B8 $0018W $50 $9A $06BD20C7RL $83 $C4 $02 #-makes the 'progress' level work, but fucks up the intro a bit too much
#%patch $4EC6 $B8 $0018W $50 $9A $06BD20C7RL $83 $C4 $02





#################################################################################################################################################################################### TECH DECO FOR MAP SPRITE

%patch $EF29 $1E40W #Hard Up Dart

#init. code - overtaking some of $0FA80CB0RL    
%patch $10730 $FF $76 $FC $57 $9A $11A200D3RL $83 $C4 $04 
		  $BE $0168W  $EB $0F $B8 $2A3ARW $8A $16 $EC $7A $8E $C0 
              $26 $08 $94 $00 $00 $46 $81 $FE $016EW  $76 $EB $E9 $E6A4W

#spawn code - $11A200D3RL
%patch $11AF3 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL $83 $C4 $02 
		  $83 $3E $7A30W $02 $72 $35
		  $8B $1E $D8 $A7 $C7 $47 $02 $0002W $C7 $47 $20 $0003W $C7 $47 $06 $0000W $8B $46 $06 $B1 $08 
              $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05 $FF00W $89 $47 $0C  
		  $B8 $2288W $50 $53 $9A $09DC118CRL $83 $C4 $04
		  $5D $CB

#decides what to become - $2288W 
%patch $310F8 $0168W $0168W $0003W $0000W $0000W $0001W $0000W $0000W
		  $11A2062ERL $00000000L $09DC176ERL  $0000W 

#deco 1 - $2300W 
%patch $31170 $0168W $0168W $0002W $0000W $0000W $0000W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL  $231EW 

#deco 2 - $22A6W 
%patch $31116 $0169W $0169W $0000W $0000W $0000W $0010W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL  $22E2W 
#deco 2 - 2 - $22E2W 
%patch $31152 $016AW $016AW $0000W $0000W $0000W $0010W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL  $22A6W 

#behaviour - make deco be one of two variaties and make music play - $11A2062ERL
%patch $1204E $55 $8B $EC $56 $57 $8B $76 $06 
		  $C7 $06 $7A20W $0000W 
		  $B8 $0018W $50 $9A $06BD20C7RL $83 $C4 $02
		  $9A $1D02002ARL $3D $0080W $7D $08
		  $C7 $44 $1C $2300W $E9 $0005W
		  $C7 $44 $1C $22A6W 
		  $5F $5E $5D $CB






######################################################################################################################################################################## TECH DECO FOR MAP SPRITE (FOR CHASM)

%patch $EF27 $1E69W #Medium Left Dart

#init. code    
%patch $10759 $FF $76 $FC $57 $9A $11A207DFRL $83 $C4 $04 $E9 $E695W

#spawn code - $11A207DFRL
%patch $121FF $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL $83 $C4 $02 
		  $83 $3E $7A30W $02 $72 $30
		  $8B $1E $D8 $A7 $C7 $47 $20 $0003W $C7 $47 $06 $0000W $8B $46 $06 $B1 $08 
              $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05 $FF00W $89 $47 $0C  
		  $B8 $231EW $50 $53 $9A $09DC118CRL $83 $C4 $04
		  $5D $CB

#deco 1 - $231EW 
%patch $3118E $016BW $016BW $0000W $0000W $0000W $0010W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL  $233CW 
%patch $311AC $016CW $016CW $0000W $0000W $0000W $0010W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL  $231EW 






########################################################################################################################################################################## KEYGEM ACTIVATORS AND SWITCHES

#Disable sprite test cheat
%patch $6D39 $CB

#Door tile replacement code, 2x6 block starting at 0,0 in the level
#Door 1, 6x8 at 0,0 in level
%patch $6D3A  $55 $8B $EC $56 $8B $76 $06 $B8 $0008W  $50 $B8 $0006W  $50 $FF     #Block size is here
              $74 $0C $FF $74 $0A $B8 $0000W  $50 $B8 $0000W  $50 $9A $16540D78RL #Block location here
                      $83 $C4 $0C $5E $5D $CB
#Door 2, 6x8 at 0,8 in level
%patch $6D62  $55 $8B $EC $56 $8B $76 $06 $B8 $0008W  $50 $B8 $0006W  $50 $FF     #Block size is here
              $74 $0C $FF $74 $0A $B8 $0008W  $50 $B8 $0000W  $50 $9A $16540D78RL #Block location here
                      $83 $C4 $0C $5E $5D $CB
#Door 3, 6x8 at 0,16 in level
%patch $6D8A  $55 $8B $EC $56 $8B $76 $06 $B8 $0008W  $50 $B8 $0006W  $50 $FF     #Block size is here
              $74 $0C $FF $74 $0A $B8 $0010W  $50 $B8 $0000W  $50 $9A $16540D78RL #Block location here
                      $83 $C4 $0C $5E $5D $CB
#Door 4, 6x8 at 0,24 in level
%patch $6DB2  $55 $8B $EC $56 $8B $76 $06 $B8 $0008W  $50 $B8 $0006W  $50 $FF     #Block size is here
              $74 $0C $FF $74 $0A $B8 $0018W  $50 $B8 $0000W  $50 $9A $16540D78RL #Block location here
                      $83 $C4 $0C $5E $5D $CB
#Door 5, 6x8 at 0,32 in level
%patch $6DDA  $55 $8B $EC $56 $8B $76 $06 $B8 $0008W  $50 $B8 $0006W  $50 $FF     #Block size is here
              $74 $0C $FF $74 $0A $B8 $0020W  $50 $B8 $0000W  $50 $9A $16540D78RL #Block location here
                      $83 $C4 $0C $5E $5D $CB
#40
#Door sprite actions:
%patch $3065C $0000W $0000W $0000W $0000W $0000W $0008W $0000W $0000W
              $06BD016ARL   $00000000L    $00000000L    $180AW
%patch $3067A $0000W $0000W $0000W $0000W $0000W $0008W $0000W $0000W
              $06BD0192RL   $00000000L    $00000000L    $1828W
%patch $30698 $0000W $0000W $0000W $0000W $0000W $0008W $0000W $0000W
              $06BD01BARL   $00000000L    $00000000L    $02D7W
%patch $2F147 $0000W $0000W $0000W $0000W $0000W $0008W $0000W $0000W
              $06BD01E2RL   $00000000L    $00000000L    $22C4W
%patch $31134 $0000W $0000W $0000W $0000W $0000W $0008W $0000W $0000W
              $06BD020ARL   $00000000L    $00000000L    $0000W

#makes lvl11 and above open the door the default way.
#%patch $C33A $83 $3E $A7EDW $0A $77 $06 $B8 $17ECW $E9 $0004W $90 $B8 $2FA8W 

#$2FA8W - 
#%patch $31E18 $0000W $0000W $0000W $0000W $0000W $000AW $0000W $0000W
 #             $0D8F0F85RL   $00000000L    $00000000L    $2FC6W 
#$2FC6W -
#%patch $31E36 $0000W $0000W $0000W $0000W $0000W $000AW $0000W $0000W
 #             $0D8F0F85RL   $00000000L    $00000000L    $2FE4W 
#$2FE4W -
#%patch $31E54 $0000W $0000W $0000W $0000W $0000W $000AW $0000W $0000W
 #             $0D8F0F85RL   $00000000L    $00000000L    $0000W


#%patch $B99B $0E00W 

#%patch $D1E8 $0D6AW 

#%patch $C349  $E1 $01

#Move switches one tile down (Almost) for Keen4
#%patch $C0B9 $C8 $0016W  $00 $56 $57 $8B $5E $06 $8B $5F $2E $43 $53 
#%patch $C12C $59 $B8 $0001W  $50 $50 $8B $5E $06 $51 $90

#NOTE: block of code starting at $C0B9 I think controls the switches. test out following code to see.
#%patch $C0BB $E9 $013DW

#%patch $C236 $E9 $011CW

#this is kinda interesting- makes the keygem holder tile not animate when you place the gem on it,
#so each time you use a gem on it, it keeps opening up. 
#%patch $C282 $0016W

#This makes the keygem holder tile now be one tile above from the bottom (where it usually is)
#but the actual 'sprite'/layer 3 pointer must be on the bottom, like usual. 
#plus it doesn't actually animate the top tile. pretty pointless in other words.
#%patch $D186 $90 $90 $90 $90 $90 $90 $90 $90 $90 $90 $90

#Keen can open gem holders at any height
#%patch $D18C $EB

#sorta makes the keygem be continuesly usable
#%patch $C254 $E2

#doesn't animate anything
#%patch $C282 $0006W

#%patch $C2E2 $90 $90 $90 $90 $90 $90 $90 $90 $90

#i think this is around the area that has to do with what vertical tiles to change
#%patch $C182 $0003W

#this is the end of the sound code in the switch code- a definite ending
#%patch $C154

#starts to not work at C1AD

#%patch $D22E $50 $9A $1A891AB3RL $5F $5E $8B $E5 $5D $CB

#%patch $D21E $B8 $0001W  $50 $9A $06BD1E11RL									#make 'got gun' sign
#             $83 $C4 $02 $8B $1E $D8 $A7 $C7 $47 $20 $0003W
 #            $8B $44 $0A $89 $47 $0A $8B $44 $28 $2D $0080W
  #           $89 $47 $0C $B8 $39DAW $50 $53 $9A $09DC118CRL $83 $C4 $04
#		 $5F $5E $8B $E5 $5D $CB

#From Lemm - makes the bridges be as high as you want
%patch $C1F2 $0014W






########################################################################################################################################################################## FLAG/THUMBS UP END LEVEL MARKER

#using the original Flag stuff

#Flags are always sitting
#%patch $6146 $0D8F09FDRL

#sprite actions for when you first complete a level, then when you appear on the map and come to it later
%patch $E4A0 $160CW
%patch $E33D $162AW 

#thumbs up
%patch $3047C $0118W $0118W $0001W $0000W $0000W $0020W $0000W $0000W
		  $2EE77150RL $00000000L $09DC176ERL  $162AW 
%patch $3049A $0119W $0119W $0000W $0000W $0000W $0020W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL  $1648W 
%patch $304B8 $0118W $0118W $0000W $0000W $0000W $0020W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL  $162AW 

#balloon - $1666W 
%patch $304D6 $0117W $0117W $0002W $0000W $0000W $0000W $0030W $0030W
		  $11A20BB1RL $00000000L $09DC176ERL  $0000W 
		  
#%patch $304E6 $0D8F0C51RL #Appear with a pop sound

#behaviour - taking over error messages - creates the balloon sprite - $2EE77150RL
#%patch $35FC0 $55 $8B $EC $56 $8B $76 $06 $B8 $0001W  $50 $9A $06BD1E11RL
#          	  $83 $C4 $02 $8B $1E $D8 $A7 $C7 $47 $06 $0000W
#           	  $C7 $47 $20 $0003W  $8B $44 $0A $89 $47 $0A $8B $44 $28 $2D $0080W
#              $89 $47 $0C $B8 $1666W $50 $53 $9A $09DC118CRL      $83 $C4
#              $04 $5E $5D $CB 

%patch $35FC0 $55 $8B $EC $56 $8B $76 $06 
		  $B8 $0001W  $50 $9A $06BD1E11RL $83 $C4 $02 									#create shot
		  $8B $44 $0A $8B $1E $D8 $A7 $C7 $47 $10 $FFFFW $C7 $47 $20 $0003W 				 	#make it go upward
		  $89 $47 $0A $8B $44 $0C   $89 $47 $0C $C7 $47 $06 $0000W  
              $8B $44 $0E $8B $1E $D8 $A7 $B8 $1666W $50 $53 $9A
              $09DC118CRL     $83 $C4 $04 
		  $5E $5D $CB




######################################################################################################################################################################################### 'GREAT SEAL' SPRITE

#A big door that needs 3 'gems' in it to open (needs 3 levels done to open).
#NOTE: The actual main sprite action has no image, but i make it have an image in the spawn code. This way I have it display all seven/eight images with using just the one sprite action

%patch $306EC $011DW #Lindsey Cache start
%patch $30736 $0125W #Lindsey cache end

#taking over Easy Wormouth tile spot
%patch $EE91 $0FAEW #Easy Wormouth (At $F89E)

#init. code
%patch $F89E $FF $76 $FC $57 $9A $2EE77199RL $83 $C4 $04 $C7 $06 $57 $CB
             $0001W  $E9 $F54AW

#spawn code 
%patch $36009 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0009W  
		  $83 $3E $7A24W $01 $75 $1E 												#if lvl3 is done, goto A, else goto B
		  $83 $3E $7A26W $01 $75 $4C 		 										#A- if lvl4 (and lvl3) is done, goto C, else goto D
		  $83 $3E $7A28W $01 $75 $08 $C7 $47 $1E $0124W $E9 $0005W $C7 $47 $1E $0123W $E9 $0049W		#C- if lvl5 (and lvl3 and lvl4) is done, show 3|4|5, else show 3|4
		  $83 $3E $7A26W $01 $75 $17		 										#B- if lvl4 is done, goto E, else goto F
		  $83 $3E $7A28W $01 $75 $08 $C7 $47 $1E $0121W $E9 $0005W $C7 $47 $1E $011FW $E9 $002BW		#E- if lvl5 (and lvl4) is done, show 4|5, else show 4
		  $83 $3E $7A28W $01 $75 $08 $C7 $47 $1E $011EW $E9 $0005W $C7 $47 $1E $011DW $E9 $0014W		#F- if lvl5 is done, show 5, else show 'empty'/no gems.
		  $83 $3E $7A28W $01 $75 $08 $C7 $47 $1E $0122W $E9 $0005W $C7 $47 $1E $0120W 			#D- if lvl5 (and lvl3) is done, show 3|5, else show 3
		  $8B $46 $06 $B1 $08
              $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05 $FF00W  $89 $47 $0C
		  $B8 $0BE4W $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB


#normal door/closed $0BE4W
%patch $2FA54 $0000W $0000W $0002W $0000W $0000W $0040W $0000W $0000W
		  $1F540031RL $00000000L $09DC176ERL  $0BE4W 

#complete door/all gems $0BC6W
%patch $2FA36 $0124W $0124W $0000W $0000W $0000W $0040W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL  $0B8AW 
#opened - $0B8AW 
%patch $2F9FA $0125W $0125W $0002W $0000W $0000W $0000W $0000W $0000W
		  $00000000L $1F540061RL $09DC176ERL  $0000W 

#behaviour - changes sprite action if all 3 levels are done - taking over error messages - $1F540031RL
%patch $1F571 $55 $8B $EC $56 $8B $76 $06
		  $83 $3E $7A24W $01 $75 $1F
		  $83 $3E $7A26W $01 $75 $18
		  $83 $3E $7A28W $01 $75 $11
		  $C7 $47 $1C $0BC6W
		  $B8 $0025W $50 $9A $187409F1RL $83 $C4 $02
		  $5E $5D $CB

#collision - set level 18 as complete - end level - $1F540061RL
%patch $1F5A1 $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $09
		  $C7 $06 $7A42W $0001W $C7 $06 $7A70W $0002W 								
		  $5F $5E $8B $E5 $5D $CB


######################################################################################################################################################################################### BIG CIRCUIT BOARD

#like the Great Seal/medieval door, displays objects that you 'collect' in the Kreeg base levels, and when all collected, will activate a sprite that
#pushes you up and out of the level into the boss level.

%patch $EED3 $288EW #BLANK

#init code - taking over some wormouth behs - $1080097ERL
%patch $1117E $FF $76 $FC $57 $9A $2EE741DBRL $83 $C4 $04 
		 $BE $0179W  $EB $0F $B8 $2A3ARW $8A $16 $EC $7A $8E $C0 
             $26 $08 $94 $00 $00 $46 $81 $FE $0183W  $76 $EB $E9 $DC56W
#41
#^ its at $10986 after this ^
#111A7
#spawn code - $2EE741DBRL
#NOTE: this is taking over a bit of code which i dont know what it does. So it could be fucking something up.
%patch $3304B $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
%patch $3305B $D8 $A7 $C7 $07 $0001W  $C7 $47 $20 $0000W $C7 $47 $06 $0000W
		  $83 $3E $7A36W $01 $75 $1E 												#if lvl12 is done, goto A, else goto B
		  $83 $3E $7A38W $01 $75 $4C 		 										#A- if lvl13 (and lvl12) is done, goto C, else goto D
		  $83 $3E $7A3AW $01 $75 $08 $C7 $47 $1E $0183W $E9 $0005W $C7 $47 $1E $0180W $E9 $0049W		#C- if lvl14 (and lvl12 and lvl3) is done, show 3|4|6, else show 3|4
		  $83 $3E $7A38W $01 $75 $17		 										#B- if lvl13 is done, goto E, else goto F
		  $83 $3E $7A3AW $01 $75 $08 $C7 $47 $1E $0182W $E9 $0005W $C7 $47 $1E $017EW $E9 $002BW		#E- if lvl14 (and lvl4) is done, show 4|6, else show 4
		  $83 $3E $7A3AW $01 $75 $08 $C7 $47 $1E $017FW $E9 $0005W $C7 $47 $1E $017CW $E9 $0014W		#F- if lvl14 is done, show 6, else show 'empty'/no gems.
		  $83 $3E $7A3AW $01 $75 $08 $C7 $47 $1E $0181W $E9 $0005W $C7 $47 $1E $017DW 			#D- if lvl14 (and lvl13) is done, show 3|6, else show 3		  
		  $8B $46 $06 $B1 $08
              $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05 $FF00W  $89 $47 $0C
              $B8 $23F0W $50 $53 $9A $09DC118CRL     $83 $C4 $04 
		  
		  $83 $3E $7A36W $01 $75 $4B $83 $3E $7A38W $01 $75 $44 $83 $3E $7A3AW $01 $75 $3D			#if lvls12,13 and 14 are done, run sprite
		  $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E					
              $D8 $A7 $C7 $47 $20 $0001W $C7 $47 $06 $0000W   $8B $46 $06 $B1 $08
              $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $89 $47 $3E $89 $47 $0C 
              $B8 $240EW $50 $53 $9A $09DC118CRL $83 $C4 $04 
		  $5D $CB

#Circuit board - $23F0W 
%patch $31260 $0000W $0000W $0002W $0000W $0000W $0000W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL  $0000W 
#Green elevation energy - $240EW 
%patch $3127E $017AW $017AW $0003W $0000W $0000W $0007W $0000W $0000W
		  $00000000L $11A20F1BRL $09DC176ERL  $242CW 
%patch $3129C $017BW $017BW $0003W $0000W $0000W $0007W $0000W $0000W
		  $11A20F5BRL $00000000L $09DC176ERL  $240EW 
#Rising Keen - 244AW 
%patch $312BA $0179W $0179W $0003W $0000W $0000W $0001W $0000W $0020W
		  $1931085CRL $00000000L $09DC176ERL  $244AW 


#collision - turns Keen into rising Keen (that you can't control) $11A20F1BRL
%patch $1293B $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $10					#Check for Keen (Type 2)
		  $B8 $244AW $50 $FF $36 $D6 $A7 $9A $09DC120ARL $83 $C4 $04
		  $5F $5E $5D $CB

##collision - turns Keen into rising Keen (that you can't control) $11A20F1BRL
#%patch $1293B $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $27					#Check for Keen (Type 2)
#		  $B8 $244AW $50 $FF $36 $D6 $A7 $9A $09DC120ARL $83 $C4 $04
#		  $FF $44 $3E $8B $44 $3E $3D $0006W $75 $0C								#increments 3E until it goes through it 5 times, then runs the following...
#		  $C7 $06 $7A68W $000FW 
#		  $C7 $06 $7A70W $0002W 
#		  $5F $5E $5D $CB 

#behaviour - make sound - $11A20F5BRL
%patch $1297B $55 $8B $EC $56 $8B $76 $06
		  $B8 $002EW $50 $9A $187409F1RL $83 $C4 $02								#makes sound
		  $5E $5D $CB

#its at 12991 after this ^

#behaviour - $1931085CRL
%patch $19B6C $55 $8B $EC $56 $8B $76 $06 
		  $C7 $47 $10 $FFFFW
		  $FF $44 $3E $8B $44 $3E $3D $0050W $75 $0C								#increments 3E until it goes through it 5 times, then runs the following...
		  $C7 $06 $7A68W $000FW												#this and next line takes you to level 15 (boss level)
		  $C7 $06 $7A70W $0004W 
		  $5E $5D $CB





#################################################################################################################################################################################### CIRCUITRY BALLOON 'ITEM'

#just like the green gem 'items' i did already.

%patch $EE99 $223AW #Inchworm

#init. code
%patch $10B2A $FF $76 $FC $57 $9A $19310C3CRL $83 $C4 $04 
		  $BE $01B7W  $EB $0F $B8 $2A3ARW $8A $16 $EC $7A $8E $C0 
              $26 $08 $94 $00 $00 $46 $81 $FE $01BAW  $76 $EB $E9 $E2AAW
#41
#1099F

#spawn code - $19310C3CRL
%patch $19F4C $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0009W  
		  $83 $3E $A7EDW $0C $75 $08 $C7 $47 $1E $01B8W $E9 $0023W 					#starts to check which level you're in, and what to display.
		  $83 $3E $A7EDW $0D $75 $08 $C7 $47 $1E $01B9W $E9 $0014W
		  $83 $3E $A7EDW $0E $75 $08 $C7 $47 $1E $01BAW $E9 $0005W
		  $C7 $47 $1E $01B7W 
              $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05
              $FF00W  $89 $47 $3E $89 $47 $0C $C7 $47 $10 $0001W  $B8 $271AW 
              $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#its at $19FC0 after this ^

#$271AW 
%patch $3158A $0000W $0000W $0002W $0000W $0000W $0000W $0000W $0000W
		  $11A20E01RL $1931081FRL $09DC176ERL  $0000W 

#collision - when Keen touches it, it displays an edited F10+S text and ends the level - taking over error messages - $1931081FRL
%patch $19B2F $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $74 $03 $E9 $0024W		#check for Keen
		   $9A $06BD0AA0RL $83 $C4 $02									#jumping to text window code, using the F10+S code
		   $9A $1D060A9BRL											#has to do with pausing the text window
		   $B8 $0095W $50 $9A $1E0A0AD3RL $83 $C4 $02							#has to do with pausing the text window (the 0095 is how long its paused)
		   $9A $16540D59RL $C7 $06 $7A70W $0002W 								#clearing window and ending the level
		   $5F $5E $8B $E5 $5D $CB 

#its at $19B6C after this ^

#new F10+S code - $06BD0AA0RL
%patch $7670 $55 $8B $EC $56 $57 $9A $1D060999RL $B8 $0003W $50 $B8 $0018W $50 $9A $19311070RL $83 $C4 $04 $B8 $0569W $50 $9A $19310E1FRL $83 $C4 $02 $5F $5E $5D $CB
#42
#Text
%patch $2F3D9 "You found a bit of CIRCUIT!" $00






####################################################################################################################################################################################### DREA, THE FAE GODDESS

#a character you talk with (replacing Lindsey) and she 'opens your mind' and allows you to see
#more things on the map (causes a level to be flagged as done so as to change tiles on and off
#on the map), and also causes Keen to get all weird for an effect. You encount her twice in the game.

%patch $EE8F $1525W #Lindsey

#init. code - taking over some 'produce slime' beh. ($0FA803A6RL) - 
%patch $FE15 $FF $76 $FC $57 $9A $0D8F0BEFRL $83 $C4 $04 
		 $BE $0160W  $EB $0F $B8 $2A3ARW $8A $16 $EC $7A $8E $C0 
             $26 $08 $94 $00 $00 $46 $81 $FE $0166W  $76 $EB $E9 $EFBFW

#its at FE3E after ^

#spawn code - overtaking flip flag toward marker beh. and the flag land beh. - produces two sprite actions - $0D8F0BEFRL 
%patch $E4DF  $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $8B $46 $06 $B1 $08
              $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05 $FF00W  $89 $47 $0C
              $B8 $1E1AW $50 $53 $9A $09DC118CRL $83 $C4 $04  
		  $83 $3E $7A30W $01 $74 $07											#if lvl9 isnt equal to 2, continue
		  $83 $3E $7A3EW $01 $74 $41											#if lvl16 is done, skip to end
		  $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E					
              $D8 $A7 $C7 $07 $0018W  $C7 $47 $20 $0001W  $8B $46 $06 $B1 $08
              $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $89 $47 $3E $89 $47 $0C 
		  $C7 $47 $10 $0001W 
              $B8 $1E38W $50 $53 $9A $09DC118CRL $83 $C4 $04  
       	  $5D $CB

#'shrine' background deco - $1E1AW 
%patch $30C8A $0160W $0160W $0002W $0000W $0000W $0000W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL  $0000W 

#Drea- $1E38W 
%patch $30CA8 $0161W $0161W $0001W $0000W $0000W $0010W $0000W $0000W
		  $11A20E01RL $00000000L $09DC176ERL  $1E56W 
%patch $30CC6 $0162W $0162W $0001W $0000W $0000W $0010W $0000W $0000W
		  $11A20E01RL $00000000L $09DC176ERL  $1E38W 

#Keen spazzing out - going up/right - 1ECEW 
%patch $30D3E $0163W $0163W $0004W $0000W $0000W $0007W $000AW $000AW
		  $0FA808A1RL $00000000L $09DC176ERL  $2210W 
%patch $31080 $0164W $0164W $0004W $0000W $0000W $0007W $000AW $000AW
		  $0FA808A1RL $00000000L $09DC176ERL  $1ECEW 

#Star explosion - $222EW 
%patch $3109E $0165W $0165W $0003W $0000W $0000W $000AW $0000W $0010W
		  $00000000L $00000000L $09DC176ERL  $224CW 
%patch $310BC $0166W $0166W $0003W $0000W $0000W $000AW $0000W $0010W
		  $00000000L $00000000L $09DC176ERL  $11C0W 

#what changes what Drea and Keen says (now its if lvl9 is complete or not)
%patch $EFB4 $7A30W $01 $73 
%patch $F031 $7A30W $01 $75 

#No 'Lindsey says' text
%patch $EFAA $90 $90 $90 $90 $90

#turn off sound
#%patch $EFD8 $E9 $0009W
#makes the level's music play when talking to Drea
%patch $EFD9 $0017W $50 $9A $06BD20C7RL $83 $C4 $02

%patch $EF61 $006FW #Cache Keen head
%patch $F06C $006FW #show keen head

#Texts
%patch $30844 $1A82W #Drea 1...
%patch $30846 $1B07W #Drea 2
%patch $30848 $1B65W #Reply 1
%patch $3084A $1AF2W #Reply 2

#Lindsey's window
%patch $EF74 $000AW #Height
%patch $EF78 $001CW #Width

#positioning of one of Keen's head pics
#%patch $F01A $0060W 

%patch $308F2 "I am Drea, the Fae Goddess." $0A $0A
              "I will open your mind now," $0A
              "William, for you to see" $0A
              "things you couldn't see" $0A 
		  "before." $00
#112 long ^

%patch $30962 "I... I feel weird..." $00
# ^21
%patch $30977 $0A
		  "I will open your mind" $0A
		  "even further now... though" $0A
		  "you might see things you" $0A
		  "wish you didn't..." $00
#94 long ^

%patch $309D5 "Oh man, not this again." $00

#turns keen into another sprite action
%patch $F0B3 $B8 $1ECEW $50 $FF $36 $D6 $A7 $9A $09DC120ARL $83 $C4 $04 $90 $90 $90 $90

#this changes Drea's sprite type so it only effects you once; also takes over code that causes her to disappear
%patch $CDFF $C7 $44 $00 $0005W 
#%patch $CDF9 $9A $0D8F014FRL

#Keen spazzing out's floating upward behaviour - $0FA808A1RL
%patch $10321 $55 $8B $EC $56 $8B $76 $06 
		  $FF $44 $3E $8B $44 $3E $3D $0008W $76 $40			#incr. 3E until...
		  $8B $44 $3E $3D $0010W $76 $45
		  $8B $44 $3E $3D $0018W $76 $4A
		  $8B $44 $3E $3D $0020W $76 $4F

		  $8B $44 $3E $3D $0028W $76 $20					#incr. 3E until...
		  $8B $44 $3E $3D $0030W $76 $25
		  $8B $44 $3E $3D $0038W $76 $2A
		  $8B $44 $3E $3D $0040W $76 $2F

		  $8B $44 $3E $3D $0048W $76 $34

		  $C7 $44 $10 $FFFFW 
		  $C7 $44 $0E $0001W
		  $E9 $000AW	
		  $C7 $44 $10 $0001W 
		  $C7 $44 $0E $0001W
		  $E9 $000AW	
		  $C7 $44 $10 $0001W 
		  $C7 $44 $0E $FFFFW
		  $E9 $000AW	
		  $C7 $44 $10 $FFFFW 
		  $C7 $44 $0E $FFFFW
		  $E9 $0023W	
		  $C7 $44 $1C $222EW 							#changes sprite action
		  $C7 $44 $3E $0000W 							#sets the 3E counter to zero
		  $C7 $06 $7A3EW $0001W 						#set lvl 16 as done
 		  $83 $3E $7A30W $01 $75 $0C						#if lvl9=done...
		  $C7 $06 $7A30W $0002W 						#then set lvl9 to 2
		  $C7 $06 $7A20W $0000W 						#and set lvl1 as undone
#		  $C7 $06 $7A3AW $0000W							#and set lvl14 as undone
		  $90 $90 $90 $90 $90 $90
		  $B8 $000AW $50 $9A $187409F1RL $83 $C4 $02 			#play sound
		  $5E $5D $CB

#$FF $44 $3E $8B $44 $3E $3D $0045W $75 $0A

##Keen spazzing out's floating upward behaviour - $2EE741ADRL
#%patch $3301D $55 $8B $EC $56 $8B $76 $06 
#		  $C7 $44 $10 $FFFFW
#		  $B8 $000AW $50 $9A $187409F1RL $83 $C4 $02			#play sound
#		  $83 $3E $7A30W $01 $75 $0C						#if lvl9=done...
#		  $C7 $06 $7A30W $0002W 						#then set lvl9 to 2
#		  $C7 $06 $7A20W $0000W 						#and set lvl1 as undone
#		  $5E $5D $CB

#sprite tile interaction - makes Keen turn back to normal when hitting a tile - $2EE741DBRL
#%patch $3304B $55 $8B $EC $56 $8B $76 $06 $83 $7C 
#		  $003AW $75 $06 $83 $7C $003CW $74 $13 
#		  $B8 $222EW $50 $FF $36 $D6 $A7 $9A $09DC120ARL $83 $C4 $04 $5E $5D $CB					#change sprite action
#		  $FF $74 $20 $33 $C0 $50 $FF $74 $1E $FF $74 $0C $FF $74 $0A $8B $C6 $05 $46 $00 $50 
#		  $9A $16541641RL $83 $C4 $0C $C7 $06 $7A3EW $0001W $5E $5D $CB							#set lvl 16 as done
#^ 76 long
#orignal sprite-tile interaction for dart hitting things
#%patch $3302C $55 $8B $EC $56 $8B $76 $06 $83 $7C $0036W $75 $12 $83 $7C $0038W $75 $0C $83 $7C 
#		  $003AW $75 $06 $83 $7C $003CW $74 $0C $56 $9A $06BD1E8BRL $83 $C4 $02 
#		  $5E $5D $CB
#		  $FF $74 $20 $33 $C0 $50 $FF $74 $1E $FF $74 $0C $FF $74 $0A $8B $C6 $05 $46 $00 $50 
#		  $9A $16541641RL $83 $C4 $0C $5E $5D $CB


#$C7 $06 $7A22W $0002W





############################################################################################################################################################### KREEG BASE AND OPEN PASSAGEWAY ON MAP SPRITE

#an invisible 'sprite' that uses Miragia code to make the Kreeg Base appear on the map when level 1 is incomplete, or make the open
#passageway appear after you first talk to Drea (when lvl16 is flagged as complete).

#overtaking Miragia stuff

%patch $EEC5 $0479W #Miragia

%patch $ED69 $FF $76 $FC $57 $9A $0FA80000RL     $83 $C4 $04 $E9 $0085W

%patch $FAAA $1DFCW 

#blank for kreeg base - $1DFCW 
%patch $30C6C $0000W $0000W $0002W $0000W $0000W $0000W $0000W $0000W
		  $2EE74342RL $00000000L $09DC176ERL  $0000W 
#blank for passageway - $235AW
%patch $311CA $0000W $0000W $0002W $0000W $0000W $0000W $0000W $0000W
		  $2EE745F6RL $00000000L $09DC176ERL  $0000W

#behaviour - checks if lvl1 or lvl16 is done, then does Miragia code - taking over error messages - $2EE74342RL
%patch $331B2 $55 $8B $EC $56 $8B $76 $06
		  $83 $3E $7A20W $01 $75 $03 $E9 $001EW 
		  $B8 $0012W  $50 $B8 $001AW  $50 $FF
              $74 $0C $FF $74 $0A $B8 $0040W  $50 $B8 $0000W  $50 $9A $16540D78RL
              $83 $C4 $0C
		  $83 $3E $7A3EW $01 $74 $03 $E9 $002CW
		  $B8 $0001W  $50 $9A $06BD1E11RL
              $83 $C4 $02 $8B $1E $D8 $A7 
              $8B $44 $0A $89 $47 $0A $8B $44 $28 $2D $0080W
              $89 $47 $0C $B8 $235AW $50 $53 $9A $09DC118CRL $83 $C4
              $04 $5E $5D $CB
		  

#beh. - $2EE745F6RL
%patch $33466 $55 $8B $EC $56 $8B $76 $06
		  $C7 $44 $0A $003CW										#position in level
		  $C7 $44 $0C $001CW										#position in level
		  $B8 $0005W  $50 $B8 $0010W  $50 $FF
              $74 $0C $FF $74 $0A $B8 $0052W  $50 $B8 $0000W  $50 $9A $16540D78RL
              $83 $C4 $0C
		  $5E $5D $CB
		  

#old one-
#2EE745F6RL
#%patch $33466 $55 $8B $EC $56 $8B $76 $06
#		  $83 $3E $7A3EW $01 $75 $03 $E9 $001EW 
#		  $B8 $0005W  $50 $B8 $0010W  $50 $FF
 #             $74 $0C $FF $74 $0A $B8 $0052W  $50 $B8 $0000W  $50 $9A $16540D78RL
  #            $83 $C4 $0C $5E $5D $CB







############################################################################################################################################################################################## GNOMES ON MAP

#you talk to these guys on the map, just ripped it off the Yakki from the Ruin of Roib, and pretty much are the council members. 
#Only most of these guys give you things now.

#Keen's reply window
%patch $F54A $000AW #Height
%patch $F44E $001AW #Width

#Disable Council Member message window
%patch $F52E $90 $90 $90 $90 $90
%patch $F544 $90 $90 $90 $90 $90
%patch $F534 $0004W

#Completely disable Council Member messages- turned it off- wasnt sure what difference it made
%patch $CD93 $13

#don't play second sound when encountering yakki
%patch $CDAF $90 $90 $90 $90 $90 

#Disable member windows (Fix this, it is code!) Add window clear
%patch $6ADD $9A $0E8F0BA5RL

#This makes talking to the Yakki mark something set to 0 I think. i forget what this is about.
%patch $F5E0 $7A4EW

#dont change music
%patch $F4CD $90 $90 $90 $90 $90 #Don't change music for member
%patch $F5E7 $90 $90 $90 $90 $90


####################################################################################################################################################################### POTION GNOME

#this gnome gives you a 1-UP, then a few levels later, a second 1-UP.

%patch $EEED $12D6W #Easy Up Dart

#init. code
%patch $FBC6 $FF $76 $FC $57 $9A $0D8F0F85RL $83 $C4 $04 $90 $90 $90 $90 $90 $90 $E9 $F222W
#21
#spawn code - taking over some of the 'make lightning' beh. - $0D8F0F85RL 
%patch $E875 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0005W  $C7 $47 $06 $0000W $C7 $47 $02 $0002W $8B $46 $06 $B1 $08
              $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $89 $47 $0C
              $B8 $0A40W $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

%patch $2F8B0 $0116W $0116W $0004W $0000W $0000W $0012W $0000W $0000W
		  $2EE741ADRL $1080066FRL $09DC176ERL  $0A5EW 
%patch $2F8CE $011CW $011CW $0004W $0000W $0000W $0012W $0000W $0000W
		  $00000000L $1080066FRL $09DC176ERL  $0A40W 
#1-UP sign - $0A22W 
%patch $2F892 $011AW $011AW $0003W $0000W $0000W $0040W $0000W $0000W
		  $11A20E01RL $00000000L $09DC176ERL  $0000W


#collision - when contacting the council member/gnome - $1080066FRL
#%patch $10E6F $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $1B
#		  $83 $3E $7A2AW $01 $74 $03 $E9 $0013W							#if lvl6 doesn't = 1, skip
#		  $C7 $06 $7A5EW $0000W $C7 $06 $7A2AW $0002W $FF $06 $7A6AW $E9 $0006W 	#set council stat to 0, set lvl6 to 2, increment lives
#		  $C7 $06 $7A5EW $0001W 									#set council stat to 1
#		  $9A $0E8F0BA5RL     $9A $16540D59RL $5F $9A $0D8F014FRL
#		  $83 $3E $7A5EW $02 $75 $03 $E9 $0014W							#if lvl6 = 2...
#		  $B8 $0011W $50 $9A $187409F1RL $83 $C4 $02						#...play this sound
#		  $C7 $44 $1C $0A22W $E9 $0005W								#turn into 1-UP image
#		  $C7 $44 $1C $35FCW 										#else turn into nothing
 #             $5F $5E $8B $E5 $5D $CB

#collision - when contacting the council member/gnome - $1080066FRL
%patch $10E6F $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $1B
		  $83 $3E $7A4CW $00 $74 $03 $E9 $0009W							#if lvl23 doesn't = 0, skip
		  $C7 $06 $7A4EW $0000W $E9 $0006W 								#set council stat to 0
		  $C7 $06 $7A4EW $0001W 									#set council stat to 1
		  $9A $0E8F0BA5RL     $9A $16540D59RL $5F $9A $0D8F014FRL
		  $83 $3E $7A4CW $01 $75 $03 $E9 $001EW							#if lvl23 = 1...
		  $C7 $06 $7A4CW $0001W $FF $06 $7A6AW 							#set lvl23 to 1, increment lives
		  $B8 $0011W $50 $9A $187409F1RL $83 $C4 $02						#...play this sound
		  $C7 $44 $1C $0A22W $E9 $0005W								#turn into 1-UP image
		  $C7 $44 $1C $35FCW 										#else turn into nothing
              $5F $5E $8B $E5 $5D $CB

#$35FCW - nothingness

#beh. - clears the mooning/keys counter when you get to the map - $2EE741ADRL
%patch $3301D $55 $8B $EC $56 $8B $76 $06
		  $C7 $06 $CAB5W $0000W 
		  $5E $5D $CB

####################################################################################################################################################################### WISE GNOME

#just gives you a message

%patch $EEEF $12EBW #Easy Right Dart

#init. code
%patch $FBDB $FF $76 $FC $57 $9A $108004A6RL $83 $C4 $04 $E9 $F20DW

#spawn code - taking over Berkeloid flame beh. - $108004A6RL 
%patch $10CA6 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0005W  $C7 $47 $06 $0000W $C7 $47 $20 $0003W $8B $46 $06 $B1 $08
              $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $89 $47 $0C
              $B8 $0A04W $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#0A04W 
%patch $2F874 $0116W $0116W $0003W $0000W $0000W $0012W $0000W $0000W
		  $00000000L $108006DBRL $09DC176ERL  $1492W 
%patch $30302 $011CW $011CW $0003W $0000W $0000W $0012W $0000W $0000W
		  $00000000L $108006DBRL $09DC176ERL  $0A04W 

#collision - $108006DBRL
%patch $10EDB $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $1B
		  $C7 $06 $7A4EW $0002W 									#changes council state to 2
		  $9A $0E8F0BA5RL     $9A $16540D59RL $5F $9A $0D8F014FRL
		  $C7 $44 $1C $35FCW 
		  $5E $8B $E5 $5D $CB



####################################################################################################################################################################### RICH GNOME

#he gives you 50k points when you talk to him, then after that you can't talk to him anymore

%patch $EEF1 $12FAW #Easy Down Dart

#init. code
%patch $FBEA $FF $76 $FC $57 $9A $108004E7RL $83 $C4 $04 $E9 $F1FEW

#spawn code - taking over Berkeloid flame beh. - $108004E7RL 
%patch $10CE7 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0005W  $C7 $47 $06 $0000W $C7 $47 $20 $0003W $8B $46 $06 $B1 $08
              $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $89 $47 $0C
		  $83 $3E $7A4AW $02 $74 $0D									#if lvl22=2, then skip to the end (show nothing)
              $B8 $14B0W $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#14B0W 
%patch $30320 $0116W $0116W $0003W $0000W $0000W $0012W $0000W $0000W
		  $00000000L $1080070BRL $09DC176ERL  $14CEW 
%patch $3033E $011CW $011CW $0003W $0000W $0000W $0012W $0000W $0000W
		  $00000000L $1080070BRL $09DC176ERL  $14B0W 

#collision - overtaking some foot spawn code - $1080070BRL
%patch $10F0B $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $1B
		  $C7 $06 $7A4EW $0003W 									#changes council stat to 2
		  $C7 $06 $7A4CW $0000W										#set lvl23 to 0 (to get another 1-UP from the Potion Gnome).
		  $9A $0E8F0BA5RL     $9A $16540D59RL $5F $9A $0D8F014FRL
		  $B8 $C350W $50 $9A $06BD1EF2RL $83 $C4 $02 						#gives 50k points
		  $B8 $0008W $50 $9A $187409F1RL $83 $C4 $02						#plays sound
		  $C7 $06 $7A4AW $0002W 									#makes lvl22 = 2
		  $C7 $44 $1C $35FCW 
		  $5E $8B $E5 $5D $CB

####################################################################################################################################################################### OPERATOR GNOME

#this gnome asks you for 250k points to operate a bridge, which is required to finish the game. 

%patch $EEF3 $1309W #Easy Left Dart 

#init. code
%patch $FBF9 $FF $76 $FC $57 $9A $0E8F1061RL    $83 $C4 $04 $E9 $F1EFW

#spawn code - taking over some of the swimming keen collision - $0E8F1061RL    
%patch $F951  $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0005W  $C7 $47 $06 $0000W  $C7 $47 $20 $0003W  $8B $46 $06 $B1 $08
              $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $89 $47 $0C
		  $83 $3E $7A46W $02 $74 $0D									#if lvl22=2, then skip to the end (show nothing)
              $B8 $1E74W $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB
#67 ^

#1ABEW 
%patch $30CE4 $0116W $0116W $0003W $0000W $0000W $0012W $0000W $0000W
		  $1A8919F3RL $000021BBRL $09DC176ERL  $1A0AW 
%patch $3087A $011CW $011CW $0003W $0000W $0000W $0012W $0000W $0000W
		  $00000000L $000021BBRL $09DC176ERL  $1E74W 

#collision - $0E8F10AARL
%patch $21BB $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $48
		 $C7 $06 $7A4EW $0004W 
		 $9A $0E8F0BA5RL $9A $16540D59RL 
		 $83 $3E $7A52W $04 $72 $2C								#if you have X amount of points...
		 $FF $0E $7A52W $FF $0E $7A52W $FF $0E $7A52W 
		 $FF $0E $7A52W 
		 $C7 $06 $7A4EW $0005W 	
		 $C7 $06 $7A46W $0002W									#set lvl21 to 1 (to 'make' bridge).							
		 $9A $0E8F0BA5RL $9A $16540D59RL $5F $9A $0D8F014FRL				#set council stat to 5 and talk again
		 $C7 $44 $1C $35FCW 
		 $5F $5E $8B $E5 $5D $CB
#106 ^
#43
#Bridge on map:
#beh. - $000021BBRL
#%patch $21BB $55 $8B $EC $56 $8B $76 $06
#		 $C7 $44 $0A $0041W										#X position in level
#		 $C7 $44 $0C $0036W										#Y position in level
#		 $B8 $0003W  $50 $B8 $0007W  $50 $FF							#size
 #            $74 $0C $FF $74 $0A $B8 $0057W  $50 $B8 $0000W  $50 $9A $16540D78RL		#position copied from
  #           $83 $C4 $0C $5E $5D $CB

#beh. - do the miragia stuff when you re-enter the Map after the lvl18=1 thing - $1A8919F3RL
%patch $1C283 $55 $8B $EC $56 $8B $76 $06
		  $83 $3E $7A46W $02 $75 $28
		  $C7 $44 $0A $0041W										#X position in level
		 $C7 $44 $0C $0036W										#Y position in level
		 $B8 $0003W  $50 $B8 $0007W  $50 $FF							#size
             $74 $0C $FF $74 $0A $B8 $0057W  $50 $B8 $0000W  $50 $9A $16540D78RL		#position copied from
             $83 $C4 $0C   
		  $5E $5D $CB


#this is 500,000 points:
#$C7 $06 $7A52W $0008W 		
#$C7 $06 $7A50W $A120W 

####################################################################################################################################################################### BLACKSMITH GNOME

#this gnome gives you 10 shots if you are low on ammo

%patch $EF0D $1318W #Up Mine (blank tile next to gun)

#init. code
%patch $FC08 $FF $76 $FC $57 $9A $10800CEARL $83 $C4 $04 $E9 $F1E0W

#spawn code - taking over some of the moving plat. spawn code - $10800CEARL
%patch $114EA $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
             $D8 $A7 $C7 $07 $0005W  $C7 $47 $06 $0000W $C7 $47 $20 $0003W  $8B $46 $06 $B1 $08
             $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $89 $47 $0C
             $B8 $1A28W $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#1A28W 
%patch $30898 $0116W $0116W $0003W $0000W $0000W $0012W $0000W $0000W
		  $00000000L $2EE7067FRL $09DC176ERL  $1A46W 
%patch $308B6 $011CW $011CW $0003W $0000W $0000W $0012W $0000W $0000W
		  $00000000L $2EE7067FRL $09DC176ERL  $1A28W 
#'gun got' image - $1A64W 
%patch $308D4 $011BW $011BW $0003W $0000W $0000W $0045W $0000W $0000W
		  $11A20E01RL $00000000L $09DC176ERL  $35FCW 

#collision - $2EE7067FRL
%patch $2F4EF $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08
		  $C7 $06 $7A4EW $0006W 
		  $9A $0E8F0BA5RL $9A $16540D59RL $5F $9A $0D8F014FRL
		  $83 $3E $7A58W $09 $77 $19							#if you have less than 10 shots...
		  $83 $06 $7A58W $0A  								#gives you 10 shots...
		  $B8 $0009W $50 $9A $187409F1RL $83 $C4 $02				#...play this sound...
		  $C7 $44 $1C $1A64W $E9 $0005W						#...and turn into 'got gun' image
		  $C7 $44 $1C $35FCW 
		  $5E $8B $E5 $5D $CB

####################################################################################################################################################################### GARDENER GNOME

#this gnome gives you a golden booze bottle if you 'release' the fungus mite thats in the McZazgag secret level.

%patch $EF19 $1464W #Mooning Keen

#init. code
%patch $FD54 $FF $76 $FC $57 
		 $83 $3E $7A22W $02 $74 $08 											#if lvl2=2, then skip to end (show nothing)
		 $9A $2EE7416CRL $83 $C4 $04 $E9 $F093W

#spawn code - overtaking error messages - $2EE7416CRL
%patch $32FDC $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
             $D8 $A7 $C7 $07 $0005W  $C7 $47 $06 $0000W $C7 $47 $20 $0003W  $8B $46 $06 $B1 $08
             $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $89 $47 $0C
#		 $83 $3E $7A22W $02 $75 $0D 											#if lvl2=2, then skip to end (show nothing)
             $B8 $1E92W $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#1A82W 
%patch $30D02 $0116W $0116W $0003W $0000W $0000W $0012W $0000W $0000W
		  $00000000L $06BD07E7RL $09DC176ERL  $1EB0W 
%patch $30D20 $011CW $011CW $0003W $0000W $0000W $0012W $0000W $0000W
		  $00000000L $06BD07E7RL $09DC176ERL  $1E92W 

#collision - $06BD07E7RL
%patch $73B7  $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08
		  $83 $3E $7A3CW $01 $75 $09 
		  $C7 $06 $7A4EW $0008W $E9 $0006W
		  $C7 $06 $7A4EW $0007W 
		  $9A $0E8F0BA5RL $9A $16540D59RL $5F $9A $0D8F014FRL
		  $C7 $44 $1C $35FCW 
		  $83 $3E $7A3CW $01 $75 $2D
  		  $B8 $002EW $50 $9A $187409F1RL $83 $C4 $02
 		  $9A $06BD0B4ERL											#jumping to Gold Booze Bottle text window, using the F10+B code
		  $9A $1D060A9BRL											#has to do with pausing the text window
		  $B8 $0095W $50 $9A $1E0A0AD3RL $83 $C4 $02						#has to do with pausing the text window (the 0095 is how long its paused)
		  $9A $16540D59RL 										#clearing window
		  $C7 $06 $7A22W $0002W										#set lvl2 as 2
		  $5E $8B $E5 $5D $CB

#111^

######################################################################################################################################################################## MESSAGES

%patch $F580 $7A4EW #What is counted (Current level)

#Bitmap cache (3 bitmaps, 104-6)
%patch $F4AE $006EW #Cache Council Member graphic
%patch $F4B5 $006EW #Cache Talking Keen head
%patch $F4BC $0070W #Cache Keen's thumbs up

%patch $F55A $006EW #Bitmap displayed (105)

#this could be where the number of messages is counted: $F54A

#Replies pointer list
%patch $3084C $1C01W #First reply
              $1C45W #Second reply
              $1C74W #Third...
              $1CBFW #4
		  $1D11W #5
		  $1D50W #6
	  	  $1D5AW #7
		  $1DADW #8
		  $727EW #9
#86
#reply 1
%patch $30A71 "Here, have this" $0A
		  "'life potion' I" $0A
		  "just cooked up." $0A
              "Hope you like it!" $00
#reply 2
%patch $30AB5 "I'm busy making more" $0A
		  "potions. Come back" $0A
		  "later." $00

#reply 3
%patch $30AE4 "I sense... there are" $0A
		  "great machines" $0A
		  "around... which are" $0A
		  "somehow cloaked..." $00

#reply 4
%patch $30B2F "I'm the richest" $0A
		  "gnome ever. Here," $0A
		  "take all these" $0A
		  "points! They mean" $0A
		  "nothing to me." $00

#reply 5
%patch $30B81 "It'll cost around" $0A
		  "250,000 points" $0A
		  "for me to operate" $0A
		  "the bridge." $00

#reply 6
%patch $30BC0 "...Yoink!" $00

#reply 7
%patch $30BCA "I usually fix" $0A
		  "swords, but I 'spose" $0A
		  "I could recharge" $0A
		  "your gun a bit if" $0A 
		  "you need it." $00

#reply 8
%patch $30C1D "Theres treasure" $0A
		  "buried under my" $0A
		  "fungus garden, but" $0A
		  "its too overgrown!" $00 
#70^

#reply 9
%patch $360EE "A mite came and ate" $0A
		  "away my garden," $0A
		  "but now I got the" $0A
		  "treasure under it!" $0A
		  "You can have it." $00
#^90
#%patch $2F590 "A mite came and ate" $0A
#		  "away my garden!" $0A
#		  "Have the treasure" $0A
#		  "under it." $0A

#%patch $F4D5 $E9 $0056W

#Disable Council Member message window
%patch $F52E $90 $90 $90 $90 $90
%patch $F544 $90 $90 $90 $90 $90
%patch $F534 $0004W





############################################################################################################################################################################################### BRIDGE ON MAP

#closed bridge on map, that appears when you give the Operator Gnome a bunch of points (see above).

#overtaking first 'blank' tile spawning spot
%patch $EED1 $03B2W 

%patch $306EA $01C4W #Dart shooter Cache start
%patch $30734 $01CAW #Dart shooter cache end

#init. code
%patch $ECA2 $FF $76 $FC $57 $9A $0E8F10AARL $83 $C4 $04 $C7 $06 $55 $CB
             $0001W  $E9 $0146W
#ECB7
#spawn code $0E8F10AARL
%patch $F99A  $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0001W  $C7 $47 $02 $0001W $C7 $47 $06 $0000W $C7 $47 $20 $0001W 
		  $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $89 $47 $0C
		  $83 $3E $7A46W $02 $75 $10 
              $B8 $35A2W $50 $53 $9A $09DC118CRL     $83 $C4 $04 $E9 $000DW
		  $B8 $38CCW  $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#38CCW 
%patch $3273C $01C4W $01C4W $0002W $0000W $0000W $0000W $0000W $0000W
		  $1A8919B7RL $00000000L $09DC176ERL  $0000W 
#3908W   
%patch $32778 $01C5W $01C5W $0000W $0000W $0000W $0008W $0000W $0000W
		  $1A8919CDRL $00000000L $09DC176ERL  $3944W 
#$3944W 
%patch $327B4 $01C6W $01C6W $0000W $0000W $0000W $0008W $0000W $0000W
		  $00000000L   $00000000L   $09DC176ERL $32D2W
#$32D2W
%patch $32142 $01C7W $01C7W $0000W $0000W $0000W $0008W $0000W $0000W
		  $00000000L   $00000000L   $09DC176ERL $3368W 
#$3368W 
%patch $321D8 $01C4W $01C4W $0000W $0000W $0000W $0008W $0000W $0000W
		  $00000000L   $00000000L   $09DC176ERL $3908W   


#$35A2W - Bridge rises
%patch $32412 $01C8W $01C8W $0000W $0000W $0000W $0008W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL $36B0W 
#$36B0W 
%patch $32520 $01C9W $01C9W $0002W $0000W $0000W $0008W $0000W $0000W
		  $1A8919F3RL $00000000L $09DC176ERL $361AW

#beh. - turn into gnome turning crank anim - $1A8919B7RL
%patch $1C247 $55 $8B $EC $56 $8B $76 $06
		  $83 $3E $7A46W $02 $75 $05
		  $C7 $44 $1C $3908W   
		  $5E $5D $CB

#beh. - after X amount of times turning crank, bridge appears - $1A8919CDRL
%patch $1C25D $55 $8B $EC $56 $8B $76 $06
		  $FF $44 $3E $8B $44 $3E $3D $0008W $75 $05									#incr. 3E until its 6, then...
		  $C7 $44 $1C $35A2W 
		  $B8 $0018W $50 $9A $187409F1RL $83 $C4 $02									#plays sound
  		  $5E $5D $CB







################################################################################################################################################################################## GOLDEN BOOZE BOTTLE ITEM

#5 collectable booze bottles hidden in 5 levels, which once picked up in a level can't be found again in that level. 
#They show up on the 'Fountain' detailed in that section

%patch $EED7 $11BEW #Swim Keen (At $FAAE)

#init code - overtaking a few of the Miragia anim behaviours
%patch $FAAE $83 $3E $A7EDW $03 $75 $07 $83 $3E $7A20W $02 $74 $5E											#if cur.lvl = 3, then if lvl1 = 2 go to end
		 $83 $3E $A7EDW $06 $75 $07 $83 $3E $7A22W $02 $74 $50											#if cur.lvl = 0, then if lvl2 = 2  go to end
		 $83 $3E $A7EDW $08 $75 $07 $83 $3E $7A24W $02 $74 $42											#if cur.lvl = 8, then if lvl3 = 2  go to end
		 $83 $3E $A7EDW $0A $75 $07 $83 $3E $7A26W $02 $74 $34											#if cur.lvl = 10, then if lvl4 = 2 go to end
		 $83 $3E $A7EDW $0D $75 $07 $83 $3E $7A28W $02 $74 $26											#if cur.lvl = 13, then if lvl5 = 2 go to end
		 $FF $76 $FC $57 $9A $2EE7462ARL $83 $C4 $04 
		 $BE $0133W  $EB $0F $B8 $2A3ARW $8A $16 $EC $7A $8E $C0 
             $26 $08 $94 $00 $00 $46 $81 $FE $0134W  $76 $EB $E9 $F2E0W
#46
#spawn code - overtaking error messages - $2EE7462ARL
%patch $3349A $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $001EW $8B $46 $06 $B1 $08
              $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05 $FF00W  $89 $47 $0C
              $B8 $0B4EW $50 $53 $9A $09DC118CRL  $83 $C4 $04 $5D $CB

#$0B4EW 
%patch $2F9BE $0133W $0133W $0000W $0000W $0000W $0040W $0000W $0000W
		  $00000000L $1A891DB2RL $09DC176ERL  $0FA4W 
#$0FA4W 
%patch $2FE14 $0134W $0134W $0000W $0000W $0000W $0040W $0000W $0000W
		  $00000000L $1A891DB2RL $09DC176ERL  $0B4EW 

#collision - overtaking some Paddle War code - $1A891DB2RL
%patch $1C642 $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $6D							#Check for Keen (Type 2)
		  $83 $3E $A7EDW $03 $75 $06 $C7 $06 $7A20W $0002W									#if cur.lvl = 3, set lvl1 to 2, else...
		  $83 $3E $A7EDW $06 $75 $06 $C7 $06 $7A22W $0002W									#if cur.lvl = 0, set lvl2 to 2, else...
		  $83 $3E $A7EDW $08 $75 $06 $C7 $06 $7A24W $0002W									#if cur.lvl = 8, set lvl3 to 2, else...
		  $83 $3E $A7EDW $0A $75 $06 $C7 $06 $7A26W $0002W									#if cur.lvl = 10, set lvl4 to 2, else...
		  $83 $3E $A7EDW $0D $75 $06 $C7 $06 $7A28W $0002W									#if cur.lvl = 13, set lvl5 to 2, else...
		  $C7 $44 $1C $28BEW 														#change to a blank sprite action
		  $B8 $0025W $50 $9A $187409F1RL $83 $C4 $02
		  $9A $06BD0B4ERL											#jumping to text window code, using the F10+B code
		  $9A $1D060A9BRL											#has to do with pausing the text window
		  $B8 $0095W $50 $9A $1E0A0AD3RL $83 $C4 $02						#has to do with pausing the text window (the 0095 is how long its paused)
		  $9A $16540D59RL 										#clearing window
		  $5F $5E $5D $CB

#the text 
%patch $2F337 "You find a GOLD BOOZE BOTTLE!" $00

#new F10+B code
%patch $771E $55 $8B $EC $56 $57 $9A $1D060999RL $B8 $0003W $50 $B8 $001EW $50 $9A $19311070RL $83 $C4 $04 $B8 $04C7W $50 $9A $19310E1FRL $83 $C4 $02 $5F $5E $5D $CB

#42
#73B7

#orig - 73C8


################################################################################################################################################################################################## FOUNTAIN

#a decorative sprite that basically displays the number of golden booze bottles you've found.
#and if all 5 are found, creates a doorway to a secret level.

%patch $EED5 $122EW #BLANK (At $FB1E)

#init. code - overtaking some of the Miragia behaviours.
%patch $FB1E $FF $76 $FC $57 $9A $108009A7RL $83 $C4 $04 
		 $BE $0126W  $EB $0F $B8 $2A3ARW $8A $16 $EC $7A $8E $C0 
             $26 $08 $94 $00 $00 $46 $81 $FE $0132W  $76 $EB $E9 $F2B6W

#$FB47

#NOTE: im using the lvl6 value for how many bottles the fountain contains (i.e which sprite pic to use).

#spawn code- taking over error messages - $108009A7RL
%patch $111A7 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $000EW $C7 $47 $06 $0000W $C7 $47 $20 $0000W 

		  $C7 $06 $7A1EW $0001W													#set lvl0=1 (to clear it when entering level).
		  $83 $3E $7A20W $02 $75 $04 $FF $06 $7A1EW									#if lvl1=2, increment lvl0	
		  $83 $3E $7A22W $02 $75 $04 $FF $06 $7A1EW									#if lvl2=2, increment lvl0	
		  $83 $3E $7A24W $02 $75 $04 $FF $06 $7A1EW									#if lvl3=2, increment lvl0	
		  $83 $3E $7A26W $02 $75 $04 $FF $06 $7A1EW									#if lvl4=2, increment lvl0	
		  $83 $3E $7A28W $02 $75 $04 $FF $06 $7A1EW									#if lvl5=2, increment lvl0

		  $83 $3E $7A1EW $01 $75 $08 $C7 $47 $1E $0126W $E9 $004BW 							#if lvl0=1, show 0 BOTTLES
		  $83 $3E $7A1EW $02 $75 $08 $C7 $47 $1E $0127W $E9 $003CW 							#if lvl0=2, show 1 BOTTLE
		  $83 $3E $7A1EW $03 $75 $08 $C7 $47 $1E $0128W $E9 $002DW 							#if lvl0=3, show 2 BOTTLES
		  $83 $3E $7A1EW $04 $75 $08 $C7 $47 $1E $0129W $E9 $001EW 							#if lvl0=4, show 3 BOTTLES
		  $83 $3E $7A1EW $05 $75 $08 $C7 $47 $1E $012AW $E9 $000FW 							#if lvl0=5, show 4 BOTTLES
		  $83 $3E $7A1EW $06 $75 $05 $C7 $47 $1E $012BW $E9 $0022W 							#if lvl0=6, show 5 BOTTLES

		  $8B $46 $06 $B1 $08
              $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $89 $47 $0C
              $B8 $0C98W $50 $53 $9A $09DC118CRL  $83 $C4 $04 $E9 $001FW						#make 'normal' fountain
		  $8B $46 $06 $B1 $08
              $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $89 $47 $0C
		  $B8 $0B30W $50 $53 $9A $09DC118CRL  $83 $C4 $04 								#make fountain that produces doorway
		  $5D $CB

#its at 112A7 after this ^

#fountain - activate secret level entrance - $0B30W 
%patch $2F9A0 $0000W $0000W $0000W $0000W $0000W $0025W $0000W $0000W
		  $2EE74080RL $00000000L $09DC176ERL  $0C98W 
#fountain 2 - just still - $0C98W 
%patch $2FB08 $0000W $0000W $0002W $0000W $0000W $0000W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL  $0000W 

#doorway - $0BA8W 
%patch $2FA18 $012DW $012DW $0003W $0000W $0000W $000EW $0000W $0000W
		  $00000000L $00000000L $09DC176ERL  $0CB6W 
#doorway - $0CB6W 
%patch $2FB26 $012EW $012EW $0003W $0000W $0000W $000EW $0000W $0000W
		  $00000000L $00000000L $09DC176ERL  $0CD4W 
#doorway - $0CD4W 
%patch $2FB44 $012FW $012FW $0003W $0000W $0000W $000EW $0000W $0000W
		  $00000000L $00000000L $09DC176ERL  $0E78W 
#doorway - $0E78W 
%patch $2FCE8 $0130W $0130W $0003W $0000W $0000W $000EW $0000W $0000W
		  $00000000L $00000000L $09DC176ERL  $0E96W 
#doorway - $0E96W 
%patch $2FD06 $0131W $0131W $0003W $0000W $0000W $000EW $0000W $0000W
		  $00000000L $00000000L $09DC176ERL  $0EB4W 
#doorway - $0EB4W 
%patch $2FD24 $0132W $0132W $0002W $0000W $0000W $0000W $0000W $0000W
		  $00000000L $0D8F0FC6RL $09DC176ERL  $0000W

#$83 $3E $7A2AW $01 $75 $08 $C7 $47 $1E $0121W $E9 $0005W $C7 $47 $1E $0120W $E9 $0049W

#beh. - create the secret level opening sequence - $2EE74080RL
%patch $32EF0 $55 $8B $EC $56 $8B $76 $06
		  $B8 $0001W  $50 $9A $06BD1E11RL
              $83 $C4 $02 $8B $44 $0A $8B $1E $D8 $A7 
		  $89 $47 $0A $8B $44 $0C   $89 $47 $0C $C7 $47 $20 $0001W 
              $B8 $0004W  $50 $9A $187409F1RL     $83 $C4 $02								#create sound
              $8B $44 $0E $8B $1E $D8 $A7 $B8 $0BA8W $50 $53 $9A
              $09DC118CRL     $83 $C4 $04 
  		  $5E $5D $CB

#col. - takes you to secret level - $0D8F0FC6RL
%patch $E8B6  $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $0C 
		  $C7 $06 $7A68W $0014W												
		  $C7 $06 $7A70W $0004W
		  $5F $5E $5D $CB
#32
# E8D6, $0D8F0FE6RL


################################################################################################################################################################################### COMMANDER KEEN character

#Cache - map keen
%patch $306E4 $00FDW #Map Keen Cache start
%patch $3072E $011CW #Map Keen cache end

#keen's cache
%patch $306D2 $007CW #Keen Cache start
%patch $3071C $00CEW #Keen cache end

#Keen's spawn height
%patch $B833 $FE5FW #15 pixels up- maybe try $FEDFW

#this makes map keen able to talk to council members (just changed its collision)
%patch $30352 $0B8014A9RL
%patch $30370 $0B8014A9RL
%patch $3038E $0B8014A9RL
%patch $303AC $0B8014A9RL
%patch $303CA $0B8014A9RL
%patch $303E8 $0B8014A9RL
%patch $30406 $0B8014A9RL
%patch $30424 $0B8014A9RL

#stops map keen from waving
%patch $30378 $14ECW

#adjusting shot positions when keen shoots
#Keen' shot - Up 
%patch $CA6D $0080W #Vertical position
%patch $CA74 $0060W #Horizontal position
#Right Keen - Right 
%patch $C9B1 $00DCW #Vertical position
%patch $C9B8 $0110W #Horizontal position
#Left Keen - Left 
%patch $C9CD $00DCW #Vertical position
%patch $C9D4 $0080W #Horizontal position
#Keen - Down while jumping 288,128
%patch $CA2D $0190W #Vertical position
%patch $CA34 $00E6W #Horizontal position
#Keen - Up while jumping 
%patch $CA4D $00A0W #Vertical position
%patch $CA54 $00ADW #Horizontal position
#Right Keen - Right on poles 
%patch $CA94 $0040W #Vertical position
%patch $CA9B $0140W #Horizontal position
#Left Keen - Down on poles
%patch $CB35 $01F4W #Vertical position
%patch $CB3C $0140W #Horizontal position
#Right Keen - Down on poles
%patch $CB18 $01F4W #Vertical position
%patch $CB1F $0000W #Horizontal position
#Right Keen - Up on poles
%patch $CAD6 $FFF5W #Vertical position
%patch $CADD $0000W #Horizontal position
#Left Keen - Up on poles
%patch $CAF1 $FFF5W #Vertical position
%patch $CAF8 $012CW #Horizontal position
#Right Keen - Jumping Right
%patch $C9F4 $0060W #Vertical position
%patch $C9FB $0110W #Horizontal position
#Left Keen - Left 32,0
%patch $CA10 $0060W #Vertical position

#Keen's shot's foreground value
%patch $E5A1 $0001W

#Keen's new 'bored' anims
%patch $2F838 $0094W $0094W $0003W $0000W $0001W $006EW $0000W $0000W 
		  $0B80045CRL $0B8014A9RL   $0B801AA2RL   $09E6W   #holding bottle

%patch $2F856 $0093W $0093W $0003W $0000W $0001W $0028W $0000W $0000W 
		  $0B80045CRL $0B8014A9RL   $0B801AA2RL   $09C8W	#drinking from bottle

#when getting out of 'bored' loop, goes to standing
%patch $BC95 $098CW


#after Keen finishes looking down, turn into standing Keen (makes the screen stay lowered until you jump).
%patch $BE24 $098CW
#%patch $CC07 $098CW

#makes keen's sliding down pole just 1 frame
%patch $2FDF6 $00B7W $00B7W
%patch $2FE12 $0F86W

#the images for picking point items up
%patch $30284 $0099W #100
%patch $30286 $009AW #200
%patch $30288 $009BW #500
%patch $3028A $009CW #1000
%patch $3028C $009DW #2000
%patch $3028E $009EW #5000
%patch $30290 $00CBW #1-Up - now its the 'key got' image
%patch $30292 $00B8W #gun

#where the flower gettin' images are at
%patch $30DB6 $0095W $0095W
%patch $30DD4 $0096W $0096W
%patch $30DF2 $0097W $0097W

#%patch $1BF95 $0095W

#keen climbing over edges
#%patch $301A2 $001EW
#%patch $301C0 $001EW
%patch $301FC $0028W

#this controls ledge climbing keen's foreground value
%patch $C966 $0002W

#new sprite positions for some of the pogoing frames
%patch $2FFB8 $00B9W
%patch $2FF9A $00BAW
%patch $2FF7C $00BAW

#this adjusts the height that keen spawns at when he exits a door
%patch $C07B $01A9W

#this makes keen jump normally when in easy mode
%patch $C3E7 $90 $90
#this makes keen pogo normally when in easy mode
%patch $C55C $90 $90

#one of keen's dying frames- made one of em a jumping frame
#%patch $2FB80 $0089W $0089W

#moved around the first keen pogoing right frame
%patch $2FFB8 $00A3W

#moved around the second keen pogoing right frame
%patch $2FF7C $0098W
%patch $2FF9A $0098W

#basically stops Keen from mooning
%patch $BC32 $09C8W




####the great campaign to save memory###

#one of the walking frames- theres only 3 sprites for it now, repeating one of them here (you can't tell the difference).
%patch $2FF40 $008BW $0083W

#making one of the shot's frames repeat- so also using only 3 sprites for it.
%patch $30602 $00AFW $00AFW

#for keen entering doorway anim- took out 2 of the frames.
#%patch $2FCE8 $00C5W $00C5W
#%patch $2FD06 $00C8W $00C8W
#%patch $2FD24 $00C8W $00C8W

#entering doorway - making it super small now
%patch $2FCE6 $0ED2W 
%patch $2FD42 $00C4W $00C4W

#pole climbing- took out a frame
%patch $2FDBA $00BCW $00B5W
%patch $2FDA0 $0000W
%patch $2FD8C $0012W
%patch $2FDAA $0012W

%patch $2FDF4 $0F68W 

#skips a climbing-up-from-ledge sprite action, cause i took out a frame from the anim.
%patch $C8FB $1346W

#rearranging sprite pics into their new place
%patch $301B6 $0085W $00B1W
%patch $301D4 $008DW $00BDW
%patch $301F2 $00A2W $00B6W

%patch $2FF7E $00C7W
%patch $2FF9C $00C7W
%patch $2FFBA $00C6W

#%patch $2FB62 $0091W $0091W #dying frame

#Keen can enter doors 1 tile wide (Walks right 2 pixels instead of 6)
%patch $B9C0 $0000W

############################################################################################## DEAD KEEN

##New Kill Keen code
#%patch $CBE9  $55 $8B $EC $83 $3E $D1 $C5 $00 $74 $03 $E9 $002FW 
#		  $81 $7C $1C $36CEW $75 $18 												#if the swimming keen action is currently on...
#		  $B8 $0017W $50 $9A $187409F1RL $83 $C4 $02									#then play sound...
#		  $C7 $06 $CAB5W $0000W $C7 $06 $7A70W $0001W 									#and reset key counter and end level
#		  $B8 $0CF2W $50 $FF $36 $D6 $A7 $9A $09DC120ARL $83 $C4 $04 $5D $CB
#62

##New Kill Keen code
#%patch $CBE9  $55 $8B $EC $83 $3E $D1 $C5 $00 $74 $03 $E9 $0056W 
#		  $B8 $0CF2W $50 $FF $36 $D6 $A7 $9A $09DC120ARL $83 $C4 $04 
#	  	  $B8 $0017W $50 $9A $187409F1RL $83 $C4 $02 									#play sound...
#		  $B8 $0001W  $50 $9A $06BD1E11RL										
 #             $83 $C4 $02 $8B $44 $0A $8B $1E $D8 $A7 $89 $47 $0A $8B $44 $0C
  #            $89 $47 $0C $C7 $47 $20 $0003W  $C7 $47 $06 $0000W  
   #           $8B $44 $0E $8B $1E $D8 $A7 $B8 $0CF2W $50 $53 $9A
    #          $09DC118CRL     $83 $C4 $04
	#	  $5D $CB

#101

##New Kill Keen code
%patch $CBE9  $55 $8B $EC $83 $3E $D1 $C5 $00 $74 $03 $E9 $004EW  $83 $3E $29
              $C6 $00 $74 $03 $E9 $0044W  $8B $1E $D6 $A7 $81 $7F $1C $D4 $0C
              $75 $03 $E9 $0036W 
		  $C7 $47 $00 $0001W  $C7 $47 $06 $0000W
	  	  $B8 $0017W $50 $9A $187409F1RL $83 $C4 $02 									#play sound...
		  $B8 $0CF2W $50 $FF $36 $D6 $A7 $9A $09DC120ARL $83 $C4 $04 
		  $C7 $06 $CAB5W $0000W
		  $C7 $06 $7A70W $0001W
		  $5D $CB

##what to turn into when Keen dies (in the default way).
#%patch $CC6C $0CF2W
#%patch $CC7E $0CF2W

#new 'dying' Keen actions - $0CF2W - CURRENTLY NOT USING MOST OF THESE
%patch $2FB62 $0080W $0080W $0000W $0000W $0000W $0001W $0000W $0000W 
		  $0B80144ERL $00000000L   $09DC176ERL    $0D10W 
%patch $2FB80 $0080W $0080W $0000W $0000W $0000W $0020W $0000W $0000W 
		  $00000000L   $00000000L   $09DC176ERL    $0D2EW 
%patch $2FB9E $0081W $0081W $0000W $0000W $0000W $0020W $0000W $0000W 
		  $00000000L   $00000000L   $09DC176ERL    $0D4CW 
%patch $2FBBC $FFFFW $FFFFW $0000W $0000W $0000W $0020W $0000W $0000W 
		  $0B801467RL $00000000L   $09DC176ERL    $35FCW

#beh. - some misc code for dying keen - $0B80144ERL
%patch $CC4E $55 $8B $EC $56 $8B $76 $06 
#		 $C7 $44 $00 $0001W
#		 $C7 $44 $06 $0000W
		 $C7 $44 $20 $0003W
		 $5E $5D $CB
#37

#beh. - changes lvl state and resets key counter - $0B801467RL
%patch $CC67 $55 $8B $EC $56 $8B $76 $06 
		 $C7 $06 $CAB5W $0000W
		 $C7 $06 $7A70W $0001W
		 $5E $5D $CB
#22

#$C7 $44 $1C $35FCW






############################################################################################################################################################################################ SWIMMING KEEN

#start of swimming - $150AW 
#%patch $3037A $0090W $0088W $0003W $0000W $0000W $0001W $0000W $0000W
#		  $1080011ERL $0B8014A9RL    $09DC176ERL    $36CEW 

#swimming Keen - $36CEW 
%patch $3253E $0090W $0088W $0003W $0000W $0000W $0001W $0000W $0000W
		  $0E8F0E17RL $0B8014A9RL    $09DC176ERL    $171AW 
#swimming Keen 2 - floats up - $171AW 
%patch $3058A $0090W $0088W $0003W $0000W $0000W $0001W $0000W $0000W
		  $11A20E01RL $0B8014A9RL    $09DC176ERL    $11C0W 

#these take out the bubble production
%patch $F8F1 $35FCW
%patch $F8F8 $35FCW
%patch $F8FF $35FCW #No bubbles or sound
%patch $F69C $5E $5D $CB

#Keen transforms when touching Moon tile
%patch $D1F8 $81 $7C $1C $36CEW $74 $1F $C7 $44 $1C $36CEW $EB $18
#14^
#%patch $D1F8 $B8 $36CEW $50 $FF $36 $D6 $A7 $9A $09DC120ARL $83 $C4 $04 $EB $14
#18^

#collision for swim keen - $0B801462RL
#%patch $CC62 $55 $8B $EC $56 $57 $8B $7E $06 $8B $76 $08 
#		 $8B $04 $3D $11 $00 $75 $03 $E9 $0152W $7F $19 $3D $0004W 
#		 $74 $30 $3D $06 $00 $75 $03 $E9 $00B7W $3D $0F $00 $75 $03 $E9 $13 $01 
#		 $5F $5E $5D $CB

##beh. for swim keen - $0B801462RL
#%patch $CC62 $55 $8B $EC $56 $8B $76 $06 
#		 $81 $7C $1C $0CF2W $75 $0C 
#		 $C7 $06 $CAB5W $0000W
#		 $C7 $06 $7A70W $0001W
#		 $5E $5D $CB

#col. for swim keen - $0B801462RL
#%patch $CC62 $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 
#		 $81 $7C $1C $0CF2W $75 $0C 
#		 $C7 $06 $CAB5W $0000W
#		 $C7 $06 $7A70W $0001W
#		 $5F $5E $5D $CB





################################################################################################################################################################################# SHOOTABLE WALL - LEFT WALLS 

#It looks like a piece of wall that when you shoot, it 'breaks open'.
#I had to do this in a weird way- by having the piece of wall be a sprite, with blocking 
#tiles obstructing the passage with an item property, cause when you shoot the sprite
#wall it changes into a number of sprites, one being an invisible sprite with the 
#smirky's 'eating tiles' code and it falls, taking out the blocking tiles with the
#item property as it goes down, thus opening up the passageway. The other
#sprites the wall sprite produces are the obvious open passageway and bits of
#debris flying out.

#For 'rock' walls and 'ruins' walls

#overtaking Cloud enemy

#NOTE: using the egg collision.

#Cache - im caching *all* the shootable wall sprites. whatever.
%patch $30708 $01E7W #Cloud Cache start
%patch $30752 $01F6W #Cloud cache end

#Cloud and foot init. codes
%patch $EA79 $FF $76 $FC $57 $9A $108001C2RL     $83 $C4 $04 
		 $C7 $06 $73 $CB $0001W 
		 $E9 $036FW

#Cloud Spawning code - taking over a bit of the foot spawn code
%patch $109C2 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $000DW  $C7 $47 $02 $0002W $C7 $47 $06 $0000W 
              $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $89
              $47 $0C $B8 $0001W  $89 $47 $0E $89 $47 $10 
		  $83 $3E $A7EDW $06 $77 $06 										#if cur.lvl > 6...
		  $B8 $28A0W $E9 $0003W $B8 $2E9AW $50 $53							#then show rock wall, else show ruins wall
              $9A $09DC118CRL    $83 $C4 $04 $5D $CB

#Rock - Still wall
%patch $31710 $01F2W $01F2W $0002W $0000W $0000W $0000W $0000W $0000W
		  $00000000L $0FA80627RL $09DC176ERL $0000W
#Clears away blocking tiles - $28BEW 
%patch $3172E $01F2W $01F2W $0003W $0000W $0000W $0030W $0000W $0000W
	  	  $09DC16C9RL $00000000L $11A203DERL    $0000W #$262AW 11A203DERL    
#Rock - Opened wall - $262AW 
%patch $3149A $01F3W $01F3W $0002W $0000W $0000W $0000W $0000W $0000W
	  	  $00000000L $00000000L $09DC176ERL $0000W
#Rock Bit - $28DCW
%patch $3174C $01F4W $01F4W $0003W $0000W $0000W $0090W $0000W $0000W
		  $09DC16C9RL $00000000L $0FA8097FRL    $0000W
#Rock Bit - $28FAW
%patch $3176A $01F5W $01F5W $0003W $0000W $0000W $0090W $0000W $0000W
		  $09DC16C9RL $00000000L $0FA8097FRL    $0000W

#Ruins - still wall - $2E9AW
%patch $31D0A $01EEW $01EEW $0002W $0000W $0000W $0000W $0000W $0000W
		  $00000000L $0FA80627RL $09DC176ERL    $0000W
#Ruins - open wall - $2EB8W 
%patch $31D28 $01EDW $01EDW $0002W $0000W $0000W $0000W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL    $0000W
#Ruins - left bit of wall - $2ED6W 
%patch $31D46 $01EDW $01EDW $0002W $0000W $0000W $0000W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL    $0000W
#Ruins - bit of stone 1- $2EF4W 
%patch $31D64 $01ECW $01ECW $0003W $0000W $0000W $0090W $0000W $0000W
		  $09DC16C9RL $00000000L $09DC176ERL    $0000W
#Ruins - bit of stone 2- $2F12W 
%patch $31D82 $01EBW $01EBW $0003W $0000W $0000W $0090W $0000W $0000W
		  $09DC16C9RL $00000000L $09DC176ERL    $0000W

#collision - taking over egg collision - $0FA80627RL    
%patch $100A7 $55 $8B $EC $56 $57 $8B $76 $06 									#standard beginning
		  $8B $7E $08 $83 $3D $03 $74 $03 $E9 $00D3W 							#if shot, then...
		  $83 $3E $A7EDW $06 $77 $08 										#if cur.lvl > 6...
		  $C7 $44 $1C $262AW $E9 $000AW									#turn into opened rock wall, else...
		  $C7 $44 $1C $2EB8W $C7 $44 $20 $0003W								#turn into opened ruins wall
		  $8B $1E $D8 $A7 $8B $44 $0A $89 $47 $0A $8B $44 $0C $89 $47 $0C $C7 $47 $06 $0000W			#makes 'invisi wall' that clears away tiles
		  $B8 $28BEW $50 $53 $9A $09DC118CRL $83 $C4 $04 
		  $B8 $0001W  $50 $9A $06BD1E11RL $83 $C4 $02
	  	  
		  $8B $1E $D8 $A7 $8B $44 $0A $89 $47 $0A $8B $44 $0C $89 $47 $0C 			#makes piece of rock 1
		  $C7 $47 $16 $0014W  $C7 $47 $18 $FFD8W 
	  	  $83 $3E $A7EDW $06 $77 $06 										#if cur.lvl > 6, change to this or that
		  $B8 $28FAW $E9 $0003W $B8 $2F12W 
		  $50 $53 $9A $09DC118CRL $83 $C4 $04 $B8 $0001W  $50 $9A $06BD1E11RL $83 $C4 $02

		  $8B $1E $D8 $A7 $8B $44 $0A $89 $47 $0A $8B $44 $0C $89 $47 $0C 			#makes piece of rock 2
		  $C7 $47 $16 $002EW  $C7 $47 $18 $FFE8W 
	 	  $83 $3E $A7EDW $06 $77 $06 										#if cur.lvl > 6, change to this or that
		  $B8 $28DCW $E9 $0003W $B8 $2EF4W 
		  $50 $53 $9A $09DC118CRL $83 $C4 $04 $B8 $0001W  $50 $9A $06BD1E11RL $83 $C4 $02  

		  $B8 $001DW $50 $9A $187409F1RL $83 $C4 $02							#plays sound
		  $5F $5E $5D $CB

#some more space at $1018D after this code ^

#$B8 $262AW $50 $57 $56 $9A $09DC1695RL $83 $C4 $06 

#cutting the 'eat tiles' beh. short, so doesnt make other sprites pop up
%patch $11DC6 $90 $90 $90 $90 $90 $90 $90 $90 $90 $90 $90 $90 $90

#cuts the 'eat tiles' sprite-tile intc. short, so you can't actually see the sprite 
%patch $11E47 $5E $5D $CB


##		  $57 $9A $0D8F0D43RL $83 $C4 $02
#              $B8 $2EB8W $50 $56 $9A $09DC120ARL     $83 $C4 $04 $B8 $0001W  $50
#              $9A $06BD1E11RL     $83 $C4 $02






################################################################################################################################################################################ SHOOTABLE WALL - RIGHT WALLS

#for 'rock' walls and 'base/tech' walls

#overtaking Foot stuff 

#Foot initiation code; 
#note: theres more room to fit atleast 1 more initation code after this (Foot initiation code is originally big).
%patch $EA8E $FF $76 $FC $57 $9A $10800219RL $83 $C4 $04 $C7 $06 $73 $CB
             $0001W  $E9 $035AW

#Foot spawning code and some inchworm - $10800219RL
%patch $10A19 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $000DW  $C7 $47 $02 $0002W $C7 $47 $06 $0000W 
              $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $89
              $47 $0C $B8 $0001W  $89 $47 $0E $89 $47 $10 
		  $83 $3E $A7EDW $0A $77 $06 										#if cur.lvl > 10...
		  $B8 $2648W $E9 $0003W $B8 $2F30W $50 $53							#then show rock wall, else show base wall
              $9A $09DC118CRL    $83 $C4 $04 $5D $CB

#Rock - Still wall - $2648W
%patch $314B8 $01F0W $01F0W $0002W $0000W $0000W $0000W $0000W $0000W
		  $00000000L $1A891C69RL $09DC176ERL $0000W
#Rock - Clears away blocking tiles - $2666W 
#%patch $314D6 $0081W $0081W $0002W $0000W $0000W $0040W $0000W $0000W
#	  	  $09DC16C9RL $00000000L $11A203DERL    $0000W 
#Rock - Opened wall - $2972W 
%patch $317E2 $01F1W $01F1W $0002W $0000W $0000W $0000W $0000W $0000W
	  	  $00000000L $00000000L $09DC176ERL $0000W

#Base - still - $2F30W 
%patch $31DA0 $01EAW $01EAW $0002W $0000W $0000W $0000W $0000W $0000W
		  $00000000L $1A891C69RL $09DC176ERL $0000W
#Base - opened wall - left bit/behind - $2F4EW 
%patch $31DBE $01E8W $01E8W $0002W $0000W $0000W $0000W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL $0000W
#Base - opened wall - right bit/infront - $2F6CW 
%patch $31DDC $01E9W $01E9W $0002W $0000W $0000W $0000W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL $0000W
#Base - zap - $2F8AW 
%patch $31DFA $01E7W $01E7W $0003W $0000W $0000W $0010W $0000W $0000W
		  $09DC16C9RL $00000000L $09DC176ERL    $0000W

#collision - taking over some 'paddle war' code - $1A891C69RL
%patch $1C4F9 $55 $8B $EC $56 $57 $8B $76 $06 									#standard beginning
		  $8B $7E $08 $83 $3D $03 $74 $03 $E9 $010DW 							#if shot, then...
		  $83 $3E $A7EDW $0A $77 $08 										#if cur.lvl > 10...
		  $C7 $44 $1C $2972W $E9 $000AW									#turn into opened rock wall, else...
		  $C7 $44 $1C $2F6CW $C7 $44 $20 $0003W 								#turn into opened base wall (right) and make it infront of things
		  $8B $1E $D8 $A7 $8B $44 $0A $89 $47 $0A $8B $44 $0C $89 $47 $0C $C7 $47 $06 $0000W			#makes 'invisi wall' that clears away tiles
		  $B8 $28BEW $50 $53 $9A $09DC118CRL $83 $C4 $04 
		  $B8 $0001W  $50 $9A $06BD1E11RL $83 $C4 $02
	  	  
%patch $1C553 $83 $3E $A7EDW $0B $72 $2E 										#if cur.lvl < 11, skip...
		  $8B $1E $D8 $A7 $8B $44 $0A $89 $47 $0A $8B $44 $0C $89 $47 $0C 			#make 'backing'/left part of opened base wall
		  $C7 $47 $20 $0001W 
		  $B8 $2F4EW 
		  $50 $53 $9A $09DC118CRL $83 $C4 $04 $B8 $0001W  $50 $9A $06BD1E11RL $83 $C4 $02

		  $8B $1E $D8 $A7 $8B $44 $0A $89 $47 $0A $8B $44 $0C $89 $47 $0C 			#makes piece of rock 1
		  $C7 $47 $16 $FFE4W  $C7 $47 $18 $FFEFW $C7 $47 $20 $0003W 
		  $83 $3E $A7EDW $0A $77 $06 										#if cur.lvl > 10, change to this or that
		  $B8 $28FAW $E9 $0003W $B8 $2F8AW 
		  $50 $53 $9A $09DC118CRL $83 $C4 $04 $B8 $0001W  $50 $9A $06BD1E11RL $83 $C4 $02

		  $8B $1E $D8 $A7 $8B $44 $0A $89 $47 $0A $8B $44 $0C $89 $47 $0C 			#makes piece of rock 2
		  $C7 $47 $16 $FFEEW  $C7 $47 $18 $FFC8W 
	 	  $83 $3E $A7EDW $0A $77 $06 										#if cur.lvl > 10, change to this or that
		  $B8 $28DCW $E9 $0003W $B8 $2F8AW 
		  $50 $53 $9A $09DC118CRL $83 $C4 $04 $B8 $0001W  $50 $9A $06BD1E11RL $83 $C4 $02  

		  $B8 $001DW $50 $9A $187409F1RL $83 $C4 $02							#plays sound
		  $5F $5E $5D $CB

#from poison slug col. code - makes shot go 'zap' i think
#$B8 $206CW  $50 $57 $56 $9A $09DC1695RL     $83 $C4 $06


#i dont remember what this is, but i think its about the tile eating tile intrac.
#stops some sprite from appearing
%patch $11E14 $0000W





############################################################################################################################################################################################# 'PUZZLE' CRATE

#taking over the 'medium up dart' tile spot
%patch $EF21 $03F3W 

#Cache - using the dart cache
%patch $3070E $015DW #Darts Cache start
%patch $30758 $015FW #Darts cache end

#init code - taking over the Wetsuit init code.
%patch $ECE3 $FF $76 $FC $57 $9A $11A20FD1RL     $83 $C4 $04 $C7 $06 $79 $CB
             $0001W  $E9 $0105W
#21
#spawn code - using the wetsuit's spawn code
%patch $129F1 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0013W  $C7 $47 $20 $0000W  $8B $46 $06 $B1 $08
              $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05 $FFFFW  $89 $47 $0C
              $B8 $36ECW $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB
	  
#still - $36ECW 
%patch $3255C $015DW $015DW $0000W $0000W $0000W $0005W $0000W $0000W
		  $00000000L $0FA800C7RL $09DC176ERL    $36ECW 
#'whiteflash' - $370AW 
%patch $3257A $015FW $015FW $0000W $0000W $0000W $000AW $0000W $0000W
		  $00000000L $00000000L $09DC176ERL    $36ECW 
#broken crate- $3728W 
%patch $32598 $015EW $015EW $0002W $0000W $0000W $0000W $0000W $0000W
		  $00000000L $00000000L $0FA8097FRL    $0000W 
#gem - $3746W 
%patch $325B6 $00F3W $00F3W $0000W $0000W $0000W $0020W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL    $2CD8W 
#gem - $2CD8W 
%patch $31B48 $00F2W $00F2W $0000W $0000W $0000W $0020W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL    $3746W 

#collision - if shot, change sprite action - $0FA800C7RL
%patch $FB47 $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08
		 $83 $3D $03 $75 $0E 										#if shot...
             $B8 $370AW  $50 $57 $56 $9A $09DC1695RL $83 $C4 $06 					#change sprite action/remove shot
		 $83 $3D $0A $75 $57										#if sprite type touches it...
		 $C7 $44 $1C $3728W 										#change to broken crate pic			
		 $B8 $0001W  $50 $9A $06BD1E11RL								#making gem 
             $83 $C4 $02 $8B $44 $0A $05 $0164W $8B $1E $D8 $A7
		 $89 $47 $0A $8B $44 $0C $05 $FF04W    $89 $47 $0C $C7
             $07 $0004W  $B8 $0004W  $50 $9A $187409F1RL     $83 $C4 $02			#note: changed sprite type to make it a collectable
             $8B $44 $0E $8B $1E $D8 $A7 $B8 $2CD8W $50 $53 $9A
             $09DC118CRL     $83 $C4 $04 
		 $B8 $001DW $50 $9A $187409F1RL $83 $C4 $02						#makes sound
		 $5F $5E $5D $CB






######################################################################################################################################################################################### CURSED ORB (enemy)

#still shootable orb that shoots projectiles in 7 random directions
#NOTE: changes shot renewing speed depending on game difficulty

#'medium right dart' tile spot
%patch $EF23 $048EW

%patch $30706 $01D2W #Bounder Cache start
%patch $30750 $01D4W #Bounder cache end

#init. code - taking over more dart init code
%patch $ED7E $FF $76 $FC $57 $9A $00002149RL $83 $C4 $04 $C7 $06 $71 $CB
             $0001W  $E9 $006AW

#spawn code - taking over some cloud and inchworm spawn code space i think - $00002149RL 
%patch $2149 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0013W  $C7 $47 $02 $0000W  $C7 $47 $20 $0002W  
		  $8B $46 $06 $B1 $08
              $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05 $FF00W  $89 $47 $0C
		  $83 $3E $7A6CW $02 $75 $10 
		  $B8 $3296W $50 $53 $9A $09DC118CRL $83 $C4 $04 $E9 $0024W
		  $83 $3E $7A6CW $03 $75 $10 
		  $B8 $0AB8W $50 $53 $9A $09DC118CRL $83 $C4 $04 $E9 $000DW
              $B8 $3926W $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#at $21BB after this ^

#orb - easy mode - 3926W 
%patch $32796 $01D2W $01D2W $0001W $0000W $0000W $0080W $0000W $0000W
		  $1A891B2ERL $11A20EE6RL $09DC176ERL $3926W 
#orb - medium mode - 3296W 
%patch $32106 $01D2W $01D2W $0001W $0000W $0000W $0040W $0000W $0000W
		  $1A891B2ERL $11A20EE6RL $09DC176ERL $3296W 
#orb - hard mode - 0AB8W
%patch $2F928 $01D2W $01D2W $0001W $0000W $0000W $0020W $0000W $0000W
		  $1A891B2ERL $11A20EE6RL $09DC176ERL $0AB8W



#shot - 3278W 
%patch $320E8 $01D4W $01D4W $0001W $0000W $0000W $0050W $0030W $0030W
		  $09DC16C9RL $09DC1752RL    $09DC176ERL $0000W
#broken orb - 325AW 
%patch $320CA $01D3W $01D3W $0002W $0000W $0000W $0000W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL $0000W

#behaviour - creates shot sprite action; randomises its trajectory direction - $1A891B2ERL
%patch $1C3BE $55 $8B $EC $56 $8B $76 $06 
		  $B8 $0001W  $50 $9A $06BD1E11RL											#create shot
              $83 $C4 $02 
		  
		  $9A $1D02002ARL $3D $0020W  $7D $14										#randomising code
		  $8B $44 $0A $8B $1E $D8 $A7 $C7 $47 $10 $FFFFW $C7 $47 $18 $0060W $E9 $00CFW			#shoot upward

		  $9A $1D02002ARL $3D $0030W  $7D $14										#randomising code
		  $8B $44 $0A $8B $1E $D8 $A7 $C7 $47 $0E $FFFFW $C7 $47 $16 $0060W $E9 $00B1W			#shoot left

%patch $1C40D $9A $1D02002ARL $3D $0040W  $7D $14										#randomising code
		  $8B $44 $0A $8B $1E $D8 $A7 $C7 $47 $0E $0001W $C7 $47 $16 $0060W $E9 $0093W			#shoot right

		  $9A $1D02002ARL $3D $0052W  $7D $1E
		  $8B $44 $0A $8B $1E $D8 $A7 $C7 $47 $0E $0001W $C7 $47 $16 $0060W 					#shoot right up diagonal
		  $C7 $47 $10 $FFFFW $C7 $47 $18 $0060W $E9 $006BW

		  $9A $1D02002ARL $3D $0065W  $7D $1E
		  $8B $44 $0A $8B $1E $D8 $A7 $C7 $47 $0E $FFFFW $C7 $47 $16 $0060W 					#shoot left up diagonal
		  $C7 $47 $10 $FFFFW $C7 $47 $18 $0060W $E9 $0043W

		  $9A $1D02002ARL $3D $0080W  $7D $1E
		  $8B $44 $0A $8B $1E $D8 $A7 $C7 $47 $0E $FFFFW $C7 $47 $16 $0060W 					#shoot left down diagonal
		  $C7 $47 $10 $0001W $C7 $47 $18 $0060W $E9 $001BW

		  $8B $44 $0A $8B $1E $D8 $A7 $C7 $47 $0E $0001W $C7 $47 $16 $0060W 					#shoot right down diagonal
		  $C7 $47 $10 $0001W $C7 $47 $18 $0060W 
		  
		  $89 $47 $0A $8B $44 $0C   $89 $47 $0C $C7 $47 $02 $0002W  $C7
              $47 $06 $0000W  
		  $B8 $0004W  $50 $9A $187409F1RL     $83 $C4 $02
              $8B $44 $0E $8B $1E $D8 $A7 $B8 $3278W $50 $53 $9A
              $09DC118CRL     $83 $C4 $04 
		  $5E $5D $CB
#315^ in size

#collision - orb gets shot; changes action - also can kill Keen if touched - taking over some dart shooter beh. - $11A20EE6RL 
%patch $12906  $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $09
               $9A $0B8013E9RL     $5F $5E $5D $CB $83 $3D $03 $75 $13 $C7 $44 $20 $0001W $B8 $325AW  $50 $57 $56 $9A $09DC1695RL
               $83 $C4 $06 $5F $5E $5D $CB

#then its 1293B after that ^


##################################################################################################################################################################################### MINE VERTICAL PLATFORM

#overtaking dropping platform

#Cache
%patch $30704 $01E4W #Cache start
%patch $3074E $01E5W #Cache end

#%patch $11853 $01E5W #Platform moving up right side flame
#%patch $118AD $01E6W #Platform moving down/still right side flame

%patch $31FF8 $01E4W $01E4W $0004W $0000W $0000W $0008W $0000W $0000W
		  $09DC1847RL    $00000000L $09DC176ERL $31A6W
%patch $32016 $01E5W $01E5W $0004W $0000W $0000W $0008W $0000W $0000W
		  $09DC1847RL    $00000000L $09DC176ERL $3188W

#produce a sound if Keen is close enough, and run the platform's B sprite hitting code- taking over slug's sprite-tile inter - $09DC1847RL    
%patch $B607  $55 $8B $EC $56 $8B $76 $06 
		  $8B $44 $0A $8B $1E $D6 $A7 $2B $47 $0A $99 $33 $C2 					#checks if Keen is X distance away
		  $2B $C2 $3D $0900W $7D $20 
		  $8B $44 $0C $8B $1E $D6 $A7 $2B $47 $0C $99 $33 $C2 					#checks if Keen is Y distance away
		  $2B $C2 $3D $0900W $7D $0C 
		  $B8 $0005W $50 $9A $187409F1RL $83 $C4 $02 $9A $10800D44RL $5E $5D $CB

#the platform stops when offscreen (to stop the sound).
#%patch $11915 $0003W

#makes it move upward.
%patch $11939 $FFFFW

%patch $11553 $0045W #Vertical speed




########################################################################################################################################################################### MOVING STONE PLATFORM - VERTICAL

#it drops down to the B sprite then stops.

#overtaking 'Right Platform' tile spot
%patch $EEBB $0408W

#init code
%patch $ECF8  $FF $76 $FC $57 $9A $3D74007ARL $83 $C4 $04 $B8 $2A3ARW $8A
              $16 $EC $7A $8E $C0 $26 $08 $16 $01E3W  $E9 $00E8W
#29
#spawn code - taking over more code at end of exe - $3D74007ARL
%patch $3D7BA $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0014W  $C7 $47 $02 $0002W  $C7 $47 $06 $0003W  
		  $C7 $47 $20 $0000W  $8B $46 $06 $B1 $08
              $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05 $FF00W  $89 $47 $0C
              $B8 $3386W  $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#$3386W 
%patch $321F6 $01E3W $01E3W $0002W $0000W $0000W $0016W $0000W $0000W 
		  $10801182RL $00000000L $09DC176ERL $3368W 

#the falling stone's speed
%patch $119A2 $0050W

#these make it work right - make a noise as it moves, hits B sprites and tiles
%patch $119BB $74 $3B 
%patch $119D9 $75 $15 
%patch $119EE $74 $14 $C7 $44 $0E $0000W $E9 $0011W $B8 $002AW $50 $9A $187409F1RL $83 $C4 $02 $C7 $44 $0E $FFFFW $5F $5E $8B $E5 $5D $CB



 

######################################################################################################################################################################### MOVING STONE PLATFORM - HORIZONTAL

#NOTE: the above stone platform sprite *must* be in same level as this one, cause this
#sprite caches no sprites. (did it to save space).

#it moves to the left, hits B sprite then stops.

#overtaking 'Down Platform' tile spot
%patch $EEBD $03E4W

#init. code
%patch $ECD4 $FF $76 $FC $57 $9A $3D7400F7RL $83 $C4 $04 $E9 $011AW
#15
#spawn code - $3D7400F7RL
%patch $3D837 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0014W  $C7 $47 $02 $0002W  $8B $46 $06 $B1 $08
              $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 #$05 $FF30W  
		  $89 $47 $0C
		  $8B $1E $D8 $A7 $C7 $47 $0E $FFFFW  $C7 $47 $16 $0080W 
              $B8 $334AW  $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#$334AW 
%patch $321BA $01E3W $01E3W $0002W $0000W $0000W $0010W $0000W $0000W 
		  $037D0526RL $00000000L $09DC176ERL $32F0W

#beh. - bounce off B sprite - $037D0526RL
%patch $3CF6 $55 $8B $EC $83 $EC $04 $56 $57 $8B $7E $06 $8B $45 $0E $BA $001CW
                 $F7 $EA $F7 $2E $4C $A5 $A3 $23 $C9 $8B $45 $10 $BA $001CW
             $F7 $EA $F7 $2E $4C $A5 $A3 $21 $C9 $8B $45 $26 $03 $06 $23 $C9
             $89 $46 $FE $B1 $08 $D3 $E8 $89 $46 $FC $8B $45 $30 $3B $46 $FC
             $75 $3B $8B $5D $2E $D1 $E3 $8B $9F $25 $C9 $D1 $EB $D1 $E3 $8E
             $06 $EB $A7 $8B $46 $FC $D1 $E0 $03 $D8 $26 $83 $3F $1F $74 $15 
		 $8B $45 $28 $25 $FF $00 $BA $FF $00 $2B $D0 $89 $16 $21 $C9 $39 
		 $3E $6E $7A $75 $14 $C7 $44 $0E $0000W $E9 $0011W $B8 $002AW $50 $9A $187409F1RL $83 $C4 $02 $C7 $44 $0E $FFFFW $5F $5E $8B $E5 $5D $CB
#12
##beh. - Controllable platform - will only move when you're on it - bounce off B sprite - $037D0526RL
#%patch $3CF6 $55 $8B $EC $83 $EC $04 $56 $57 $8B $7E $06 $8B $45 $0E $BA $001CW
 #                $F7 $EA $F7 $2E $4C $A5 $A3 $23 $C9 $8B $45 $10 $BA $001CW
  #           $F7 $EA $F7 $2E $4C $A5 $A3 $21 $C9 $8B $45 $26 $03 $06 $23 $C9
   #          $89 $46 $FE $B1 $08 $D3 $E8 $89 $46 $FC $8B $45 $30 $3B $46 $FC
    #         $75 $3B $8B $5D $2E $D1 $E3 $8B $9F $25 $C9 $D1 $EB $D1 $E3 $8E
     #        $06 $EB $A7 $8B $46 $FC $D1 $E0 $03 $D8 $26 $83 $3F $1F $74 $15 
	#	 $8B $45 $28 $25 $FF $00 $BA $FF $00 $2B $D0 $89 $16 $21 $C9 $39 
	#	 $3E $6E $7A $74 $08 $C7 $44 $0E $0000W $E9 $0005W $C7 $44 $0E $FFFFW $5F $5E $8B $E5 $5D $CB






#################################################################################################################################################################################################### POTIONS!

#3 potion sprites you can collect in levels, which show up on counters in the status window when you press ENTER.
#The combination of a number of each you collect can give you/produce items, like a 'crafting' system.

#NOTE: 
#Councilman vari = Blue potion
#Wesuit vari = White potion
#Drops vari = Purple potion
 
#collision code- $06BD07E7RL - keen can pick it up; produces 'sparkles'; produces sound; increments certain variables; does all 'crafting' stuffs - $19310A2DRL
#NOTE: All 3 potions point to different beginnings of this code (all to save space).
#NOTE: The 'got image' sprite actions create the sounds and the smoke.
%patch $19D3D $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3E $7A5EW $0F $74 $0C	#if blue=15, skip to end code (dont pick anything up)
		  $83 $3D $02 $75 $07 $FF $06 $7A5EW $E9 $0048W $5F $5E $5D $CB			#incr. councilman vari
		  $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3E $7A5CW $0F $74 $0C	#if white=15, skip to end
		  $83 $3D $02 $75 $07 $FF $06 $7A5CW $E9 $0026W $5F $5E $5D $CB			#incr. Wetsuit vari
		  $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3E $7A5AW $0F $74 $0C	#if purple=15, skip to end
		  $83 $3D $02 $75 $07 $FF $06 $7A5AW $E9 $0004W $5F $5E $5D $CB			#incr. Drops vari
		  
%patch $19DA3 $83 $3E $7A5EW $00 $75 $21 $83 $3E $7A5CW $0A $75 $1A $83 $3E $7A5AW $00 $75 $13 			#1UP - if blue=0, white=10, purple=0	
		  $C7 $44 $1C $2CF6W $C7 $06 $7A5CW $0000W $FF $06 $7A6AW $5F $5E $5D $CB	 			#turn into 1-Up; set white potion to 0; incr. lives								

		  $83 $3E $7A5EW $0A $75 $22 $83 $3E $7A5CW $00 $75 $1B $83 $3E $7A5AW $00 $75 $14 			#30 Ammo - if blue=10, white=0, purple=0	
		  $C7 $44 $1C $2C06W $C7 $06 $7A5EW $0000W $83 $06 $7A58W $1E $5F $5E $5D $CB 			#make got image; set blue potion to 0; incr. ammo count by 20	

		  $83 $3E $7A5EW $05 $75 $35 $83 $3E $7A5CW $05 $75 $2E $83 $3E $7A5AW $05 $75 $27 			#30k points - if blue=5, white=5, purple=5	
		  $C7 $44 $1C $2C24W $C7 $06 $7A5EW $0000W $C7 $06 $7A5CW $0000W $C7 $06 $7A5AW $0000W 		#make got image; set potions to 0; add points
		  $B8 $7530W  $50 $9A $06BD1EF2RL $83 $C4 $02 $5F $5E $5D $CB 

		  $83 $3E $7A5EW $04 $75 $27 $83 $3E $7A5CW $00 $75 $20 $83 $3E $7A5AW $06 $75 $19 			#Key - if blue=4, white=0, purple=6	
		  $C7 $44 $1C $2C42W $C7 $06 $7A5EW $0000W $C7 $06 $7A5AW $0000W 						#make got image; set potions to 0; incr. keys
		  $FF $06 $CAB5W $5F $5E $5D $CB 	

%patch $19E5E $83 $3E $7A5EW $0F $75 $23 $83 $3E $7A5CW $00 $75 $1C $83 $3E $7A5AW $02 $75 $15 			#Death - if blue=15, white=0, purple=2	
		  $C7 $06 $7A5EW $0000W $C7 $06 $7A5AW $0000W $C7 $44 $1C $2C60W 						#make explosion; set potions to 0
		  $5F $5E $5D $CB 	

		  $83 $3E $7A5EW $04 $75 $29 $83 $3E $7A5CW $06 $75 $22 $83 $3E $7A5AW $03 $75 $1B 			#Plush Toy - if blue=4, white=6, purple=3	
		  $C7 $44 $1C $2C7EW $C7 $06 $7A5EW $0000W $C7 $06 $7A5CW $0000W $C7 $06 $7A5AW $0000W 		#make toy sprite; set potions to 0
		  $5F $5E $5D $CB 	

		  $83 $3E $7A5EW $0F $75 $29 $83 $3E $7A5CW $0F $75 $22 $83 $3E $7A5AW $0F $75 $1B 			#Nothing; clear potions - if blue=15, white=15, purple=15	
		  $C7 $44 $1C $2D14W $C7 $06 $7A5EW $0000W $C7 $06 $7A5CW $0000W $C7 $06 $7A5AW $0000W 		#make smoke sprite; set potions to 0
		  $5F $5E $5D $CB	

		  $83 $3E $7A5EW $06 $75 $29 $83 $3E $7A5CW $05 $75 $22 $83 $3E $7A5AW $0D $75 $1B 			#Secret level portal - if blue=6, white=5, purple=13	
		  $C7 $44 $1C $2CBAW $C7 $06 $7A5EW $0000W $C7 $06 $7A5CW $0000W $C7 $06 $7A5AW $0000W 		#make portal; set potions to 0
		  $5F $5E $5D $CB	
		  											
		  $C7 $44 $1C $1F46W  $B8 $000AW $50 $9A $187409F1RL  $83 $C4 $02 
		  $5F $5E $5D $CB

#Secret level portal - $2CBAW 
%patch $31B2A $007CW $007CW $0003W $0000W $0000W $0001W $0000W $0000W 
		  $108000D2RL $00000000L $09DC176ERL $2E22W 
#Secret level portal - $2E22W 
%patch $31C92 $007CW $007CW $0003W $0000W $0000W $0020W $0000W $0000W 
		  $00000000L $00000000L $09DC176ERL $2C9CW 
#Secret level portal 1 - $2C9CW 
%patch $31B0C $007CW $007CW $0003W $0000W $0000W $0010W $0000W $0000W 
		  $00000000L $00000000L $09DC176ERL $2E04W 
#Secret level portal 2 - $2E04W 
%patch $31C74 $007DW $007DW $0003W $0000W $0000W $0010W $0000W $0000W 
		  $00000000L $037D067FRL $09DC176ERL $2C9CW 

#Plush toy 1 - $2C7EW 
%patch $31AEE $0000W $0000W $0003W $0000W $0000W $0001W $0000W $0000W 
		  $108000D2RL $00000000L $09DC176ERL $2DC8W 
#Plush toy 2 - falls and hits floor - $2DC8W 
%patch $31C38 $007FW $007FW $0002W $0000W $0000W $0000W $0000W $0000W 
		  $09DC16C9RL $00000000L $0FA8097FRL    $0000W

#Explosion (for Kill Keen recipe) - $2C60W 
%patch $31AD0 $00CFW $00CFW $0003W $0000W $0000W $0003W $0000W $0000W 
		  $1080014ARL $00000000L $09DC176ERL $2DAAW 
#Explosion 2 - kills keen - 2DAAW 
%patch $31C1A $00CFW $00CFW $0003W $0000W $0000W $0030W $0000W $0000W 
		  $0B8013E9RL $00000000L $09DC176ERL $0000W

#Key got image 1 - $2C42W 
%patch $31AB2 $0000W $0000W $0003W $0000W $0000W $0001W $0000W $0000W 
		  $108000D2RL $00000000L $09DC176ERL $2DE6W
#Key got image 1 - $2DE6W
%patch $31C56 $00CBW $00CBW $0001W $0000W $0000W $0060W $0000W $0000W 
		  $10800160RL $00000000L $09DC176ERL $0000W

#Points got image 1 - $2C24W 
%patch $31A94 $0000W $0000W $0003W $0000W $0000W $0001W $0000W $0000W 
		  $108000D2RL $00000000L $09DC176ERL $2D8CW 
#Points got image 2 - $2D8CW 
%patch $31BFC $007EW $007EW $0001W $0000W $0000W $0060W $0000W $0000W 
		  $00000000L $00000000L $09DC176ERL $0000W

#Gun got image 1 - $2C06W 
%patch $31A76 $0000W $0000W $0003W $0000W $0000W $0001W $0000W $0000W 
		  $108000D2RL $00000000L $09DC176ERL $2D6EW 
#Gun got image 2 - $2D6EW 
%patch $31BDE $00B8W $00B8W $0001W $0000W $0000W $0060W $0000W $0000W 
		  $10800134RL $00000000L $09DC176ERL $0000W

#1-UP image 1 - $2CF6W 
%patch $31B66 $0000W $0000W $0003W $0000W $0000W $0001W $0000W $0000W 
		  $108000D2RL $00000000L $09DC176ERL $2D50W 
#1-UP image 2 - $2D50W 
%patch $31BC0 $009FW $009FW $0001W $0000W $0000W $0060W $0000W $0000W 
		  $1080011ERL $00000000L $09DC176ERL $0000W


#smoke 1 - $2D14W 
%patch $31B84 $0080W $0080W $0003W $0000W $0000W $0030W $0000W $0000W 
		  $00000000L $00000000L $09DC176ERL $2D32W 
#smoke 2 - $2D32W 
%patch $31BA2 $0081W $0081W $0003W $0000W $0000W $0030W $0000W $0000W 
		  $00000000L $00000000L $09DC176ERL $0000W

#behaviour - make smoke - $108000D2RL
%patch $108D2 $55 $8B $EC $56 $8B $76 $06 $B8 $0001W  $50 $9A $06BD1E11RL
              $83 $C4 $02 $8B $1E $D8 $A7 $C7 $47 $20 $0003W $C7 $47 $02 $0002W 
              $8B $44 $0A $89 $47 $0A $8B $44 $28 $2D $0200W 					#the $2D $XXXXW at the end is how far up the stars comes out from
	        $89 $47 $0C $B8 $2D14W $50 $53 $9A $09DC118CRL      $83 $C4 $04 
		  $B8 $0016W $50 $9A $187409F1RL  $83 $C4 $02 						#make sound
		  $5E $5D $CB

#behaviour - make 1-UP sound - $1080011ERL
%patch $1091E $55 $8B $EC $56 $8B $76 $06 
		  $B8 $0011W $50 $9A $187409F1RL  $83 $C4 $02 						#make sound
		  $5E $5D $CB
#behaviour - make GUN sound - $10800134RL
%patch $10934 $55 $8B $EC $56 $8B $76 $06 
		  $B8 $0009W $50 $9A $187409F1RL  $83 $C4 $02 						#make sound
		  $5E $5D $CB
#behaviour - make EXPLOSION sound - $1080014ARL
%patch $1094A $55 $8B $EC $56 $8B $76 $06 
		  $B8 $0009W $50 $9A $187409F1RL  $83 $C4 $02 						#make sound
		  $5E $5D $CB
#behaviour - make KEY sound - $10800160RL
%patch $10960 $55 $8B $EC $56 $8B $76 $06 
		  $B8 $0024W $50 $9A $187409F1RL  $83 $C4 $02 						#make sound
		  $5E $5D $CB
#22^
#collision - 'warps' Keen to lvl18 - $037D067FRL
%patch $3E4F $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $0C 
		  $C7 $06 $7A68W $0012W												
		  $C7 $06 $7A70W $0004W
		  $5F $5E $5D $CB


############################################################################################################################################# BLUE POTION

%patch $EECB $04CAW #'I Keen' - blue potion

#initiation code - taking over mine's one
%patch $EDBA $FF $76 $FC $57 $9A $11A20826RL $83 $C4 $04 $E9 $0034W

#Blue potion spawning code
%patch $12246 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 
		  $89 $47 $3E $89 $47 $0C $C7 $47 $10 $0001W  $B8 $2ABCW 
              $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#$2ABCW 
%patch $3192C $00CCW $00CCW $0002W $0000W $0000W $0000W $0000W $0000W 
		  $11A20E01RL $19310A2DRL $09DC176ERL $0000W


############################################################################################################################################# WHITE POTION

%patch $EECD $04D9W #'Mom'

#initiation code - taking over mine's one
%patch $EDC9 $FF $76 $FC $57 $9A $11A20861RL $83 $C4 $04 $E9 $0025W

#spawn code
%patch $12281 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 
		  $89 $47 $3E $89 $47 $0C $C7 $47 $10 $0001W  $B8 $2ADAW 
              $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#$2ADAW 
%patch $3194A $00CDW $00CDW $0002W $0000W $0000W $0000W $0000W $0000W 
		  $11A20E01RL $19310A4FRL $09DC176ERL $0000W


############################################################################################################################################# PURPLE POTION

%patch $EECF $147AW #'Dad'

#initiation code - taking over mine's one
%patch $FD6A $FF $76 $FC $57 $9A $11A2089CRL $83 $C4 $04 $E9 $F084W

#spawn code
%patch $122BC $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 
		  $89 $47 $3E $89 $47 $0C $C7 $47 $10 $0001W  $B8 $2BE8W
              $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#$2BE8W
%patch $31A58 $00CEW $00CEW $0002W $0000W $0000W $0000W $0000W $0000W 
		  $11A20E01RL $19310A71RL $09DC176ERL $0000W

#the jump conditions- if wetsuit variable is equal to 3
#%patch $744C $83 $3E $7A5CW $03 $74 $03 $E9 $0034W $8B $1E $D8 $A7 $89 $47 $0A 
#             $8B $44 $0C $05 $0100W  $89 $47 $0C $C7 $47 $20 $0003W  $B8 $7A5CW 
#             $50 $53 $9A $09DC118CRL     $83 $C4 $04 $B8 $0001W  $50 $9A
#             $06BD1E11RL     $83 $C4 $02 $8B $44 $0A $05 $0100W  $E9 $000FW




############################################################################################################################################################################################ TREASURE CHESTS

#you can pick up tile based keys which open up 4 types of sprite based treasure chests, each containing different things.

######################################################################################################### KEY

#Overtaking the 1-UP tile property

#increments the 'Mooning Variable' now, which is where the number of keys collected are stored.
%patch $CFCD $CAB5W

#around where the sound is controlled:
#%patch $CF97 $90 $90 $90 $90 $B8 $000AW $50
#%patch $CF9B $B8 $000AW $50

#this is the sound that plays when you pick up the 1-UP
%patch $30260 $0024W

#the key's 'got image'
#%patch $30290 $00CBW

#NOTE: cause I can't seem to change the sound for the 1-UP tile, maybe consider recreating the 1-UP sprite from scratch 
#(wouldn't really take up any extra memory- i use the sprite version anyways)
#(also can't seem to change its 'got' image)

#If touching normal tile with moon variable = 1, set it to 0
%patch $D0F6 $CAB5W  $01 $75 $06 $90 $90 $90 $90 $90 $90

#If mooning variable = 1, moon, set to 2
%patch $BC24 $CAB5W  $01 $75 $0E $90 $90 $90 $90 $90 $90

##################################################################################################### CHEST 1

#this chest contains nothing

#'hard dart down' tile spot
%patch $EF2D $3EB6W 

#initiation code - this and following chest init. codes take over the dart initiation codes.
%patch $127A6 $FF $76 $FC $57 $9A $11A20E3BRL     $83 $C4 $04 $E9 $C648W

#spawning code
%patch $1285B $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $001EW  $C7 $47 $02 $0001W  $8B $46 $06 $B1 $08
              $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05 $FF40W  $89 $47 $0C
              $B8 $3962W  $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#closed chest
%patch $327D2 $00B9W $00B9W $0002W $0000W $0000W $0000W $0000W $0000W
		  $00000000L $1A891AFFRL $09DC176ERL $0000W 
#open chest - $3980W 
%patch $327F0 $00BAW $00BAW $0003W $0000W $0000W $0001W $0000W $0000W
		  $10800AA7RL $00000000L $09DC176ERL $150AW 
#open chest 2 - $150AW 
%patch $3037A $00BAW $00BAW $0002W $0000W $0000W $0000W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL $0000W 

#collision - if you have more than one 'key', it changes sprite action - taking over paddle war code - $1A891AFFRL
%patch $1C38F $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $13				#checks for Keen touching it
		  $83 $3E $CAB5W  $00 $7F $03 $E9 $0009W $C7 $44 $1C $3980W 
		  $FF $0E $CAB5W  #$B8 $0018W $50 $9A $187409F1RL  $83 $C4 $02 				#decreases key counter by 1
		  $5F $5E $5D $CB

#beh. - make sound - $10800AA7RL
%patch $112A7 $55 $8B $EC $56 $8B $76 $06 
		  $B8 $0018W $50 $9A $187409F1RL  $83 $C4 $02 
		  $5E $5D $CB

##################################################################################################### CHEST 2

#this chest contains 20,000 points

#'Hard Left dart' tile spot (At $ED3C)
%patch $EF2F $3EC5W 

#init. code
%patch $127B5 $FF $76 $FC $57 $9A $11A20E7ARL     $83 $C4 $04 $E9 $C639W

#spawning code
%patch $1289A $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $001EW  $C7 $47 $02 $0001W  $8B $46 $06 $B1 $08
              $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05 $FF40W  $89 $47 $0C
              $B8 $399EW $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#closed chest - $399EW 
%patch $3280E $00B9W $00B9W $0002W $0000W $0000W $0000W $0000W $0000W
		  $00000000L $1A891A8FRL $09DC176ERL $0000W 
#'gun got' image - $39DAW 
%patch $3284A $00C8W $00C8W $0003W $0000W $0000W $0040W $0000W $0000W
		  $11A20E01RL $00000000L $09DC176ERL $0000W

#collision - if you have more than one 'key', it changes sprite action, gives ammo, makes 'got' image - taking over Paddle War code - $1A891A8FRL
%patch $1C31F $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $5C				#checks for Keen touching it
		  $83 $3E $CAB5W  $00 $7F $03 $E9 $0052W $C7 $44 $1C $150AW 
		  $B8 $4E20W  $50 $9A $06BD1EF2RL $83 $C4 $02 							#give 20k ammo
		  $B8 $0001W  $50 $9A $06BD1E11RL									#make 'got gun' sign
              $83 $C4 $02 $8B $1E $D8 $A7 $C7 $47 $06 $0000W
              $8B $44 $0A $89 $47 $0A $8B $44 $28 $2D $02C0W
              $89 $47 $0C $B8 $39DAW $50 $53 $9A $09DC118CRL $83 $C4 $04
		  $FF $0E $CAB5W  $B8 $001AW $50 $9A $187409F1RL  $83 $C4 $02 				#decreases key counter by 1 and plays sound
		  $5F $5E $5D $CB


################################################################################################## CHEST 3

#this chest contains 5,000 score

#'Medium Dopefish' tile spot
%patch $EF31 $045BW
#%patch $EF31 $046AW

#init. code
%patch $ED4B $FF $76 $FC $57 $9A $1080015DRL $83 $C4 $04 $E9 $00A3W

#spawning code - taking over some F10 + B cheat - $1080015DRL
%patch $1095D $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $001EW  $C7 $47 $02 $0001W  $8B $46 $06 $B1 $08
              $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05 $FF40W  $89 $47 $0C
              $B8 $39F8W $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB
#^63 long

#20526  $1FE406E6RL 

#closed chest - $39F8W 
%patch $32868 $00B9W $00B9W $0002W $0000W $0000W $0000W $0000W $0000W
		  $00000000L $06BD069DRL $09DC176ERL $0000W 
#'5,000 got image' - $39BCW 
%patch $3282C $009EW $009EW $0003W $0000W $0000W $0040W $0000W $0000W
		  $11A20E01RL $00000000L $09DC176ERL $0000W

#collision - if you have more than one 'key', it changes sprite action, gives score, makes 'got' image - 
#taking over some F10 + Y cheat code - $06BD069DRL
%patch $726D  $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $5C				#checks for Keen touching it
		  $83 $3E $CAB5W  $00 $7F $03 $E9 $0052W $C7 $44 $1C $150AW 
		  $B8 $1388W  $50 $9A $06BD1EF2RL $83 $C4 $02 							#gives 5,000 score
		  $B8 $0001W  $50 $9A $06BD1E11RL									#makes '5,000' sign
              $83 $C4 $02 $8B $1E $D8 $A7 $C7 $47 $06 $0000W
              $8B $44 $0A $89 $47 $0A $8B $44 $28 $2D $02C0W
              $89 $47 $0C $B8 $39BCW $50 $53 $9A $09DC118CRL $83 $C4 $04
		  $FF $0E $CAB5W  $B8 $001AW $50 $9A $187409F1RL  $83 $C4 $02 				#decreases key counter by 1 and plays sound
		  $5F $5E $5D $CB
#^115 long




################################################################################################## CHEST 4

#this chest contains a 1-Up

#'Hard Dopefish' tile spot.
%patch $EF33 $046AW

#init. code
%patch $ED5A $FF $76 $FC $57 $9A $06BD0710RL $83 $C4 $04 $E9 $0094W

#spawning code - taking over more F10 + Y cheat - $06BD0710RL
%patch $72E0  $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $001EW  $C7 $47 $02 $0001W  $8B $46 $06 $B1 $08
              $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05 $FF40W  $89 $47 $0C
              $B8 $3A16W $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#closed chest - $3A16W 
%patch $32886 $00B9W $00B9W $0002W $0000W $0000W $0000W $0000W $0000W
		  $00000000L $06BD074FRL $09DC176ERL $0000W
#'got' image - $38AEW 
%patch $3271E $009FW $009FW $0003W $0000W $0000W $0040W $0000W $0000W
		  $11A20E01RL $00000000L $09DC176ERL $0000W

#collision - if you have more than one 'key', it changes sprite action, gives score, makes 'got' image - taking over F10 + Y cheat - $06BD074FRL
%patch $731F  $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $57				#checks for Keen touching it
		  $83 $3E $CAB5W  $00 $7F $03 $E9 $004DW $C7 $44 $1C $150AW 
		  $FF $06 $7A6AW												#adds 1 to your lives
		  $B8 $0001W  $50 $9A $06BD1E11RL									#makes 'got' sign
              $83 $C4 $02 $8B $1E $D8 $A7 $C7 $47 $20 $0003W
              $8B $44 $0A $05 $0080W $89 $47 $0A $8B $44 $28 $2D $01C0W
              $89 $47 $0C $B8 $38AEW $50 $53 $9A $09DC118CRL $83 $C4 $04
		  $FF $0E $CAB5W  $B8 $001AW $50 $9A $187409F1RL  $83 $C4 $02 				#decreases key counter by 1 and plays sound
		  $5F $5E $5D $CB






################################################################################################################################################################################################### 1-UP ITEM

%patch $EF09 $3AA4W

#init. code
%patch $12394 $FF $76 $FC $57 $9A $06BD0951RL $83 $C4 $04 $E9 $CA5AW

#spawn code - $06BD0951RL
%patch $7521 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0001W $C7 $47 $06 $0000W $8B $46 $06 $B1 $08 
		  $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $89 $47 $3E 
		  $89 $47 $0C $B8 $1528W $50 $53 $9A $09DC118CRL 
		  $83 $C4 $04 $5D $CB

#1528W
%patch $30398 $00C5W $00C5W $0000W $0000W $0000W $0014W $0000W $0000W
		  $00000000L $06BD0990RL $09DC176ERL $1546W 
#1546W 
%patch $303B6 $00A6W $00A6W $0000W $0000W $0000W $0014W $0000W $0000W
		  $00000000L $06BD0990RL $09DC176ERL $1528W

#collision - do 1-UP stuff - $06BD0990RL
%patch $7560 $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $09
		 $C7 $44 $1C $1564W $FF $06 $7A6AW
		 $5F $5E $5D $CB
#$5F $5E $8B $E5 $5D $CB 
#1564W 
%patch $303D4 $009FW $009FW $0000W $0000W $0000W $0001W $0000W $0000W
		  $1080011ERL $00000000L $09DC176ERL $1582W 
#1582W 
%patch $303F2 $009FW $009FW $0000W $0000W $0000W $0060W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL $0000W




########################################################################################################################################################################################### END LEVEL BALLOON

#taking over the council member tile place/spawning spot

#Member spawning code
%patch $FCE9  $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0005W $C7 $47 $06 $0000W $8B $46 $06 $B1 $08 
		  $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05 $FF00W  $89 $47 $3E 
		  $89 $47 $0C $C7 $47 $10 $0001W  $B8 $1FB8W $50 $53 $9A $09DC118CRL 
		  $83 $C4 $04 $5D $CB

%patch $306F2 $00D0W #Council Member/balloon Cache start
%patch $3073C $00D2W #Council member/balloon cache end

#sitting balloon
%patch $30E28 $00D2W $00D2W $0000W $0000W $0000W $0020W $0000W $0000W
		  $00000000L $0FA80369RL $09DC176ERL $1FD6W
%patch $30E46 $00D0W $00D0W $0000W $0000W $0000W $0020W $0000W $0000W
		  $00000000L $0FA80369RL $09DC176ERL $1FB8W 
#balloon rising into the air- $1FF4W 
%patch $30E64 $00D1W $00D1W $0003W $0000W $0000W $0080W $0000W $0000W
		  $11A20BB1RL $00000000L $09DC176ERL $2012W 
#ends the level
%patch $30E82 $00D1W $00D1W $0002W $0000W $0000W $0000W $0000W $0000W
		  $11A20BEBRL $00000000L $09DC176ERL $0000W 

#balloon collision- turns sitting balloon to rising balloon; produces sound. 
#overtaking the two behaviours that have to do with the slug randomly producing slime - $0FA80369RL 
%patch $FDE9  $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $11
             $C7 $44 $1C $1FF4W  $B8 $0006W $50 $9A $187409F1RL  $83 $C4 $02 
		 $5F $5E $5D $CB

#balloon floating upward- overtaking some of the seasprite's floating behaviour. - $11A20BB1RL 
%patch $125D1 $55 $8B $EC $56 $8B $76 $06 $B8 $08 $00 $50 $FF $74 $10 $56 $9A $09DC1517RL
		  $83 $C4 $06 $8B $44 $3E $2B $44 $0C $3D $0030W $7E $05 $C7 $44 $10 $FFFFW $8B 
		  $44 $0C $2B $44 $3E $3D $20 $00 $7E $05 $C7 $44 $10 $FFFFW $5E $5D $CB

#behaviour which ends the level (sets the level state to 3) - $11A20BEBRL
%patch $1260B $55 $8B $EC $56 $8B $76 $06 $C7 $44 $04 $0001W $C7 $06 $CAB5W $0000W $C7 $06 $7A70W $0002W $5E $5D $CB

#NOTE: I had to take 6DF off of the segment code of the far call to work it out.






######################################################################################################################################################################################### FUNGUS MITE BALLOON

#just like the green gem balloon and circuit balloon, but changes Gardener Gnome stuff on map

%patch $EEE9 $03C7W #Medium Wormouth

#init. code
%patch $ECB7 $FF $76 $FC $57 $9A $2EE7402DRL $83 $C4 $04 $B8 $2A3ARW $8A
             $16 $EC $7A $8E $C0 $26 $08 $16 $014FW  $E9 $0129W
#29^
#spawn code
%patch $32E9D $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0001W $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A 
		  $8B $46 $08 $D3 $E0  $89 $47 $3E $89 $47 $0C $C7 $47 $10 $0001W  
		  $B8 $0FC2W $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#$0FC2W
%patch $2FE32 $014FW $014FW $0002W $0000W $0000W $0000W $0000W $0000W
		  $11A20E01RL $06BD0B0BRL $09DC176ERL $0000W 

##collision - when Keen touches it, it displays an edited F10+V text and ends the level - $06BD0B0BRL 
%patch $76DB $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $74 $03 $E9 $002AW		#check for Keen
		   $9A $2EE740CBRL $83 $C4 $02									#jumping to text window code, using the F10+Y code
		   $9A $1D060A9BRL											#has to do with pausing the text window
		   $B8 $0095W $50 $9A $1E0A0AD3RL $83 $C4 $02							#has to do with pausing the text window (the 0095 is how long its paused)
		   $9A $16540D59RL 											#clearing the window
		   $C7 $06 $7A3CW $0001W										#set lvl15 as done, to clear fungus garden on map etc.
		   $C7 $06 $7A70W $0002W 										#ending the level
		   $5F $5E $8B $E5 $5D $CB 

#new F10+V code - 2EE740CBRL
%patch $32F3B $55 $8B $EC $56 $57 $9A $1D060999RL $B8 $0003W $50 $B8 $0018W $50 $9A $19311070RL $83 $C4 $04 $B8 $0585W $50 $9A $19310E1FRL $83 $C4 $02 $5F $5E $5D $CB
#42


%patch $2F3F5 "You released a FUNGUS MITE!" $00



#11A20E3BRL     


############################################################################################################################################################################################# GREEN GEM ITEM

#Special green gem 'items' that appear on levels 3,4 and 6, that 'unlock' the big medieval door mini-level 19
#(really just displays a text and ends the level)

#Left Platform tile spot 
%patch $EEBF $0FC3W #(At $F8B3)

#init. code - taking over more 'swim keen 2' behaviour
%patch $F8B3 $FF $76 $FC $57 $9A $11A20AA7RL     $83 $C4 $04 $BE $01A6W  
		 $EB $0F $B8 $2A3ARW $8A $16 $EC $7A $8E $C0 
             $26 $08 $94 $00 $00 $46 $81 $FE $01A8W  $76 $EB $E9 $F521W

#Schoolfish spawn code
%patch $124C7 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0009W  
		  $83 $3E $A7EDW $03 $75 $08 $C7 $47 $1E $01A6W $E9 $0014W 					#starts to check which level you're in, and what to display.
		  $83 $3E $A7EDW $04 $75 $08 $C7 $47 $1E $01A8W $E9 $0005W
		  $C7 $47 $1E $01A7W 
              $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05
              $FF00W  $89 $47 $3E $89 $47 $0C $C7 $47 $10 $0001W  $B8 $0B6CW 
              $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#$0B6CW
%patch $2F9DC $0000W $0000W $0003W $0000W $0000W $0020W $0000W $0000W
		  $11A20E01RL $2EE77241RL $09DC176ERL $0B6CW 

#disable F10 + Y cheat
%patch $77FC $C647W

#collision - when Keen touches it, it displays an edited F10+Y text and ends the level - taking over error messages - $2EE77241RL
%patch $360B1 $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $74 $03 $E9 $0024W		#check for Keen
		   $9A $06BD0673RL $83 $C4 $02									#jumping to text window code, using the F10+Y code
		   $9A $1D060A9BRL											#has to do with pausing the text window
		   $B8 $0095W $50 $9A $1E0A0AD3RL $83 $C4 $02							#has to do with pausing the text window (the 0095 is how long its paused)
		   $9A $16540D59RL $C7 $06 $7A70W $0002W 								#clearing window and ending the level
		   $5F $5E $8B $E5 $5D $CB 



#stops the F10+Y thing from actually 'working'- kills it prematurely- so just shows text
%patch $7269 $5F $5E $5D $CB

#Show tile properties window
%patch $724E $0004W #Window height
%patch $7252 $001EW #Window width

%patch $2F314 "You release a WEIRD SHAPED GEM!" $00





############################################################################################################################################################################################ ILLUSORY FRIES

#looks like the typical fries collectible, but when you get close to it it fades out and disappears. Mainly for the 'Cave of Illusion' level.

#Medium Down Dart tile spot
%patch $EF25 $01B3W

#init code - taking over some Foot init. code  
%patch $EAA3 $FF $76 $FC $57 $9A $06BD0232RL $83 $C4 $04 $B8 $2A3ARW $8A
             $16 $EC $7A $8E $C0 $26 $08 $16 $014EW  $E9 $033DW

#after this ^ its $EAC0

#spawn code - $06BD0232RL
%patch $6E02  $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0010W  $C7 $47 $02 $0001W  $C7 $47 $20 $0000W
              $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A $8B $46 $08 $05 $FFFFW
              $D3 $E0 $89 $47 $0C $B8 $33C2W  $50 $53 $9A $09DC118CRL     $83
              $C4 $04 $5D $CB

#still fries - $33C2W 
%patch $32232 $00E5W $00E5W $0000W $0000W $0000W $0020W $0000W $0000W
		  $06BD0276RL $00000000L $09DC176ERL $33E0W    
%patch $32250 $00E6W $00E6W $0000W $0000W $0000W $0020W $0000W $0000W
		  $06BD0276RL $00000000L $09DC176ERL $33C2W 
#half disappeared - $33FEW 
%patch $3226E $014EW $014EW $0000W $0000W $0000W $0010W $0000W $0000W
		  $06BD0276RL $00000000L $09DC176ERL $0000W 

#behaviour - $06BD0276RL
%patch $6E46  $55 $8B $EC $56 $8B $76 $06 
		  $8B $44 $0A $8B $1E $D6 $A7 $2B $47 $0A $99 $33 $C2 					#checks if Keen is X distance away
		  $2B $C2 $3D $0500W $7D $19 
		  $8B $44 $0C $8B $1E $D6 $A7 $2B $47 $0C $99 $33 $C2 					#checks if Keen is Y distance away
		  $2B $C2 $3D $0500W $7D $05 $C7 $44 $1C $33FEW $5E $5D $CB





########################################################################################################################################################################################## GLOW WORM (enemy)

#overtaking the Poison Slug position

#Cache
%patch $306E6 $0135W #Slug Cache start
%patch $30730 $0140W #Slug cache end

#the first sprite action is now:
%patch $FDDB $208AW 

%patch $FD9C $0001W

#invisible
%patch $30EA0 $013FW $013FW $0001W $0000W $0001W $000AW $0080W $0000W
		  $10800793RL    $00000000L $09DC1795RL    $2030W
#rising out of the ground - $204EW 
%patch $30EBE $013BW $013BW $0001W $0000W $0000W $0018W $0000W $0000W
		  $09DC16C9RL $00000000L $09DC176ERL    $206CW 
%patch $30EDC $013CW $013CW $0001W $0000W $0000W $0018W $0000W $0000W
		  $09DC16C9RL $00000000L $09DC176ERL    $3A34W 
#walking around - $208AW 
%patch $30EFA $0137W $0138W $0001W $0000W $0001W $000BW $0010W $0010W
		  $09DC16C9RL $0FA804BERL    $09DC1795RL    $20A8W
%patch $30F18 $0135W $013AW $0001W $0000W $0001W $000BW $0010W $0010W
		  $108007D2RL   $0FA804BERL    $09DC1795RL    $0B12W 
%patch $2F982 $0136W $0139W $0001W $0000W $0001W $000BW $0010W $0010W
		  $108007D2RL   $0FA804BERL    $09DC1795RL    $208AW 
#digging into the ground - $20C6W  
%patch $30F36 $013DW $013DW $0001W $0000W $0001W $0010W $0000W $0000W
		  $09DC16C9RL $00000000L $09DC176ERL    $20E4W
%patch $30F54 $013EW $013EW $0001W $0000W $0001W $0010W $0000W $0000W
		  $09DC16C9RL $00000000L $09DC176ERL    $2030W

#still - jump in air - $3A34W 
%patch $328A4 $0136W $0139W $0004W $0000W $0000W $000AW $0030W $0030W
		  $00002105RL $0FA804BERL    $09DC176ERL    $38EAW 
#still - fall down to ground - $38EAW 
%patch $3275A $0136W $0139W $0002W $0000W $0000W $0050W $0030W $0030W
		  $09DC16C9RL $0FA804BERL    $000020CBRL $0AF4W
 
#smoke - dead enemy - $0AF4W
%patch $2F964 $0140W $0140W $0002W $0000W $0000W $0000W $0020W $0020W
		  $09DC16C9RL $00000000L $09DC1913RL    $0000W

##behaviour- glow worm randomly digs out of the ground; makes a sound- taking over some of the inchworm collision - $10800793RL    
#%patch $10F93 $55 $8B $EC $56 $8B $76 $06 $9A $1D02002ARL     $3D $0240W  $7D
#              $14 $C7 $44 $1C $204EW $B8 $000BW $50 $9A $187409F1RL $83 $C4 $02 $E9 $0005W $C7 $44 $1C $2030W  
#		       $5E $5D $CB

#behaviour- glow worm randomly digs out of the ground; makes a sound- taking over some of the inchworm collision - $10800793RL    
%patch $10F93 $55 $8B $EC $56 $8B $76 $06 $9A $1D02002ARL     $3D $0240W  $7D
              $11 $C7 $44 $1C $204EW $B8 $000BW $50 $9A $187409F1RL $83 $C4 $02 
		       $5E $5D $CB

#behaviour 2- glow worm randomly digs back into the ground; makes a sound- taking over some of the inchworm collision - $108007D2RL   
%patch $10FD2 $55 $8B $EC $56 $8B $76 $06 $9A $1D02002ARL     $3D $0030W  $7D
              $11 $C7 $44 $1C $20C6W $B8 $000BW $50 $9A $187409F1RL $83 $C4 $02
		       $5E $5D $CB

#collision - kill keen or get shot and die - taking over Mad Mushroom collision - $0FA804BERL    
%patch $FF3E $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $05 		#Check for Keen (Type 2)
         	 $9A $0B8013E9RL     $83 $3D $03 $75 $13 $B8 $0AF4W 				#If Keen, kill him; check for shot (Type 3)
	       $50 $57 $56 $9A $09DC1695RL     $83 $C4 $06 $83 $6C $18 $05 $90 $5F $5E $5D $CB	

#sprite-tile intr. - turns into itself when it lands (so falls instead of just flips in the air) - $000020CBRL 
%patch $20CB  $55 $8B $EC $56 $8B $76 $06 $83 $7C $36 
		  $00 $74 $0D $B8 $208AW $50 $56 $9A $09DC120ARL $83 $C4 $04 
		  $FF $74 $20 $33 
		  $C0 $50 $FF $74 $1E $FF $74 $0C $FF $74 
		  $0A $8B $C6 $05 $46 $00 $50 $9A 
		  $16541641RL $83 $C4 $0C $5E $5D $CB	

#beh. - jump into the air, for when it pops out of the ground - $00002105RL 
%patch $2105 $55 $8B $EC $56 $8B $76 $06
		 $83 $6C $18 $05 
		 $C7 $44 $18 $FFD8W 
		 $C7 $44 $10 $FFFFW
		 $5E $5D $CB

					






###################################################################################################################################################################################### BLOCKER/FUNGUS (enemy)

#a deadly still enemy that, when shot, dips into a hole temporarily, before coming back up and being still and deadly again.

#taking over Up Platform's tile spot
%patch $EEB9 $0372W #(At $EC62)

#using Mooning Keen cache
%patch $30716 $0159W #MoonKeen Cache start
%patch $30760 $015CW #MoonKeen cache end

#overtaking Moving Platform initi. and spawn code
%patch $EC62 $FF $76 $FC $57 $9A $10800CABRL $83 $C4 $04 $C7 $06 $81 $CB
             $0001W  $E9 $0186W

#off-screen time
%patch $114C4 $0001W

%patch $114AB $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $001EW  $C7 $47 $02 $0001W  $8B $46 $06 $B1 $08
              $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05 $FE20W  $89 $47 $0C
              $B8 $2684W  $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#still - $2684W 
%patch $314F4 $0159W $0159W $0000W $0000W $0001W $0015W $0000W $0000W
		  $00000000L  $06BD02ADRL $09DC176ERL $26A2W  
%patch $31512 $015AW $015AW $0000W $0000W $0001W $0015W $0000W $0000W
		  $00000000L  $06BD02ADRL $09DC176ERL $2684W 
#slinks into hole - $26C0W 
%patch $31530 $015BW $015BW $0000W $0000W $0001W $0010W $0000W $0000W
		  $00000000L  $00000000L  $09DC176ERL $26DEW
%patch $3154E $015CW $015CW $0000W $0000W $0001W $00A0W $0000W $0000W
		  $00000000L  $00000000L  $09DC176ERL $26FCW 
%patch $3156C $015BW $015BW $0000W $0000W $0001W $0010W $0000W $0000W
		  $00000000L  $00000000L  $09DC176ERL $2684W 

#collision - touching it kills you; shooting it changes sprite type - $06BD02ADRL
%patch $6E7D  $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $09
              $9A $0B8013E9RL     $5F $5E $5D $CB $83 $3D $03 $75 $13 $C7 $44
              $16 $0000W $B8 $26C0W  $50 $57 $56 $9A $09DC1695RL
              $83 $C4 $06 $5F $5E $5D $CB





############################################################################################################################################################################################### GNOME (enemy)

#NOTE: use this code for taking points off:
##Items cheat decreases Keen's ammo by 99 each time
#%patch $7556 $83 $0E $7A58W  $63

#overtaking egg tile position and initiation code

%patch $30718 $00DCW #Egg Cache start
%patch $30762 $00E1W #Egg cache end

#Egg initiation code
%patch $EB01 $FF $76 $FC $57 $9A $0FA8055DRL     $83 $C4 $04 $C7 $06 $83 $CB
             $0001W  $E9 $02E7W

#gnome standing still - $2120W 
%patch $30F90 $00DDW $00DEW $0000W $0000W $0001W $0040W $0000W $0000W
		  $00000000L  $1080084ERL $09DC176ERL $213EW 
#goes for the leap-
%patch $30FAE $00DFW $00E0W $0002W $0000W $0000W $0000W $0000W $0000W
		  $09DC16C9RL $1080084ERL $10800C71RL    $0000W
#falling - $217AW 
%patch $30FEA $00DDW $00DEW $0000W $0000W $0000W $0001W $0000W $0000W
		  $10800B42RL $1080084ERL $10800C71RL    $2198W 
#starting to leap again or something - $2198W 
%patch $31008 $00DFW $00E0W $0002W $0000W $0000W $0000W $0000W $0000W
		  $09DC16C9RL $1080084ERL $10800C71RL    $0000W
#the 'score stolen!' sign - $215CW 
%patch $30FCC $00E1W $00E1W $0003W $0000W $0000W $0080W $0000W $0010W
		  $00000000L $00000000L $09DC176ERL $0000W 
#shot - $0A9AW
%patch $2F90A $00DCW $00DCW $0002W $0000W $0000W $0000W $0000W $0000W
		  $09DC16C9RL $00000000L $09DC1913RL    $0000W 


#spawning code; taking over the egg's one.
%patch $FFDD  $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0008W  $C7 $47 $02 $0001W  $8B $46 $06 $B1 $08
              $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05 $FF00W  $89 $47 $0C
              $B8 $2120W $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#the lick sprite-tile inter. - what it turns into as it leaps.
%patch $1147F $217AW 

#movement behaviour code- it randomly goes to the first 'standing still' sprite action.
%patch $11342 $55 $8B $EC $83 $EC $02 $56 $57 $8B $76 $06 $9A $1D02002ARL
              $3D $0064W  $7D $05 $C7 $44 $1C $2120W  
		  $8B $44 $0A $8B $1E 								#Check Keen's location
              $D6 $A7 $3B $47 $0A $76 $07 $C7 $44 $0E $FFFFW  $EB $05 $C7 $44 #Change H direction to follow him
              $0E $0001W  $8B $44 $0E $B1 $06 $D3 $E0 $89 $44 $16 $C7 $44 $18
              $FFE0W $5F $5E $8B $E5 $5D $CB 

#collision code- overtaking more inchworm code- steals some score (if you have any), then plays sound; if gnome is shot, dies - $0FA803EARL    
%patch $1104E $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $74 $03 $E9 $005EW				#Check for Keen (Type 2)
        	  $83 $3E $7A50W $2E $76 $76 $83 $06 $7A50W $EE $83 $06 $7A50W $EE $90 $90				#steals some points
		  $B8 $0001W  $50 $9A $06BD1E11RL											#making sign
              $83 $C4 $02 $8B $44 $0A $8B $1E $D8 $A7 
		  $89 $47 $0A $8B $44 $0C $89 $47 $0C $C7 $47 $20 $0003W  $C7 $47 $06 $0000W  
		  $C7 $47 $02 $0003W $8B $44 $0E $8B $1E $D8 $A7 $B8 $215CW $50 $53 $9A
              $09DC118CRL $83 $C4 $04
		  $B8 $0016W $50 $9A $187409F1RL $83 $C4 $02									#making sound
		  $83 $3D $03 $75 $1A $B8   												#If Keen, kill him; check for shot (Type 3)
	        $0A9AW $50 $57 $56 $9A $09DC1695RL     $83 $C4 $06 								#If shot, become $XXXX
      	  $8B $44 $0E $D1 $E0 $D1 $E0 $D1 $E0 $89 $44 $16 $5F $5E $5D
              $CB






########################################################################################################################################################################################### UGGBUG (enemy)

#overtaking Arachnut's stuff
#they pounce at Keen when hes on the same floor level as them- reminds me of those creatures from the first Abe's Odyssey game.
#You can shoot them to make them sit still for a second.

#cache
%patch $306FC $01A9W #Arachnut Cache start
%patch $30746 $01ACW #Arachnut cache end

#still - $2378W 
%patch $311E8 $01A9W $01ABW $0002W $0000W $0001W $0020W $0000W $0000W
		  $2EE73B28RL $09DC1752RL    $0FA8097FRL    $2396W 
#%patch $31206 $01A9W $01ABW $0001W $0000W $0001W $0020W $0000W $0000W
#		  $2EE73B28RL $00000000L $0FA8097FRL    $2378W 
#pounces at Keen - $23B4W
%patch $31224 $01AAW $01ACW $0004W $0000W $0000W $0001W $0040W $0040W
		  $2EE73B5ARL $0000211DRL $2EE73EE5RL    $23D2W
%patch $31242 $01AAW $01ACW $0002W $0000W $0000W $0000W $0000W $0000W
		  $09DC16C9RL $0000211DRL $2EE74F3BRL	$2378W 

#still, after being shot - $0AD6W
%patch $2F946 $01A9W $01ABW $0003W $0000W $0000W $0050W $0000W $0000W
		  $09DC16C9RL $09DC1752RL    $0FA8097FRL    $2378W 

#Spawn height:
%patch $1053E $FE1AW

#%patch $10527 $0000W

#behaviour - if Keen is roughly on floor level with them, change sprite action - taking over some error messages - $2EE73B28RL
%patch $32998 $55 $8B $EC $56 $8B $76 $06 $8B $44 $0C $8B $1E $D6 $A7 $2B $47 $0C $99 $33 $C2 
		  $2B $C2 $3D $0200W $7D $14 $F7 $EA $89 $44 $16 $8B $44 $18 $F7 $2E $4C $A5 $A3 
		  $21 $C9 $C7 $44 $1C $23B4W $5E $5D $CB

#behaviour - jumps after Keen - $2EE73B5ARL
#%patch $329CA $55 $8B $EC $83 $EC $02 $56 $57 $8B $76 $06 
#		  $8B $44 $0A $8B $1E $D6 $A7 $3B $47 $0A $76 $12 							#checks if Keen is left or right
#		  $C7 $44 $10 $FFFFW $C7 $44 $0E $FFFFW $C7 $44 $18 $0105W $E9 $000FW				#moves in one diagonal direction...
#		  $C7 $44 $10 $FFFFW $C7 $44 $0E $0001W $C7 $44 $18 $0105W 						#moves in the other
#		  $5F $5E $8B $E5 $5D $CB

#behaviour - jumps after Keen - $2EE73B5ARL
%patch $329CA $55 $8B $EC $83 $EC $02 $56 $57 $8B $76 $06 $8B $44 $0A $8B $1E		 #Check Keen's location
              $D6 $A7 $3B $47 $0A $76 $07 $C7 $44 $0E $FFFFW  $EB $05 $C7 $44		 #Change H direction to follow him
              $0E $0001W  $8B $44 $0E $B1 $05 $D3 $E0 $89 $44 $16 $C7 $44 $18		 #i changed $05 to $06 - it effects the size of the jump
              $FFE0W $5F $5E $8B $E5 $5D $CB


#sprite-tile interac. - makes enemy jump - taking over error messages - $2EE73EE5RL
%patch $32D55 $55 $8B $EC $56 $8B $76 $06 $83 $7C $36 $00 $74 $0D $B8 $23B4W $50 $56 $9A $09DC120ARL 
		  $83 $C4 $04 $FF $74 $20 $33 $C0 $50 $FF $74 $1E $FF $74 $0C $FF $74 $0A $8B $C6 $05 
		  $46 $00 $50 $9A $16541641RL $83 $C4 $0C $5E $5D $CB

#behaviour - goes back to walking sprite action - taking over other error messages - $2EE74F3BRL
%patch $33DAB $55 $8B $EC $56 $8B $76 $06 $83 $7C $36 $00 $74 $0D $B8 $2378W $50 $56 $9A $09DC120ARL 
		  $83 $C4 $04 $FF $74 $20 $33 $C0 $50 $FF $74 $1E $FF $74 $0C $FF $74 $0A $8B $C6 $05 
		  $46 $00 $50 $9A $16541641RL $83 $C4 $0C $5E $5D $CB

#collision - kills Keen or changes sprite action - $0000211DRL
%patch $211D  $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $05 	#Check for Keen (Type 2)
         	  $9A $0B8013E9RL     $83 $3D $03 $75 $0E $B8 $0AD6W				#If Keen, kill him; check for shot (Type 3)
	        $50 $57 $56 $9A $09DC1695RL     $83 $C4 $06 $5F $5E $5D $CB 





############################################################################################################################################################################################## GOBLIN (enemy)

#overtaking Mimrock's stuff
#walks around, shoots a 'magic' projectile at Keen which temporarily turns him into
#one of 3 inanimate objects.

#start positioning
%patch $11E97 $FF20W

#off-screen activity
%patch $11E80 $0000W

#Foreground
%patch $11E85 $0002W

#how far up its spawned
%patch $11E97 $FE80W

#walking - $343AW 
%patch $322AA $0184W $0187W $0001W $0000W $0001W $0008W $0015W $0000W
		  $11A204F8RL $11A20566RL $09DC1795RL    $3458W 
%patch $322C8 $0185W $0188W $0001W $0000W $0001W $0008W $0015W $0000W
		  $11A204F8RL $11A20566RL $09DC1795RL    $3476W 
%patch $322E6 $0184W $0187W $0001W $0000W $0001W $0008W $0015W $0000W
		  $11A204F8RL $11A20566RL $09DC1795RL    $3494W 
%patch $32304 $0186W $0189W $0001W $0000W $0001W $0008W $0015W $0000W
		  $11A204F8RL $11A20566RL $09DC1795RL    $343AW 
#shooting - $34B2W 
%patch $32322 $018AW $018BW $0003W $0000W $0001W $0030W $0000W $0000W
		  $00000000L $11A20566RL $09DC176ERL    $343AW 
#shot - $34D0W 
%patch $32340 $0095W $0095W $0004W $0000W $0000W $0075W $0090W $0090W
		  $2EE700B6RL $2EE74109RL $09DC176ERL    $0000W 

#Keen as a clock - $3566W 
%patch $323D6 $018EW $018EW $0003W $0000W $0000W $0001W $0000W $0000W
		  $11A20079RL $00000000L $0FA8097FRL    $3584W 
%patch $323F4 $018EW $018EW $0003W $0000W $0000W $00A0W $0000W $0000W
		  $09DC16C9RL $00000000L $0FA8097FRL    $361AW
#Keen as a teapot - $3638W
%patch $324A8 $018FW $018FW $0003W $0000W $0000W $0001W $0000W $0000W
		  $11A20079RL $00000000L $0FA8097FRL    $3656W
%patch $324C6 $018FW $018FW $0003W $0000W $0000W $00A0W $0000W $0000W
		  $09DC16C9RL $00000000L $0FA8097FRL    $361AW
#Keen as a candle - $3674W
%patch $324E4 $0190W $0190W $0003W $0000W $0000W $0001W $0000W $0000W
		  $11A20079RL $00000000L $0FA8097FRL    $3692W
%patch $32502 $0190W $0190W $0003W $0000W $0000W $00A0W $0000W $0000W
		  $09DC16C9RL $00000000L $0FA8097FRL    $361AW
#Normal Keen (only diff. is that it produces smoke) - $361AW
%patch $3248A $018EW $018EW $0000W $0000W $0000W $0001W $0000W $0000W
		  $11A20079RL $00000000L $09DC176ERL    $098CW 

#Smoke - $35C0W
%patch $32430 $0080W $0080W $0000W $0000W $0000W $0014W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL    $35DEW
%patch $3244E $0081W $0081W $0000W $0000W $0000W $0014W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL    $0000W 
#nothing - $35FCW
%patch $3246C $FFFFW $FFFFW $0000W $0000W $0000W $0010W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL    $0000W
#dead - $0A7CW
%patch $2F8EC $018CW $018CW $0002W $0000W $0000W $0000W $0000W $0000W
		  $09DC16C9RL $00000000L $09DC1913RL    $0000W

##collision - taking over Mimrock collision (one of them anyways)- $11A20566RL
#%patch $11F86  $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $09 		#Check for Keen (Type 2)
#	         $9A $0B8013E9RL     $5F $5E $5D $CB $83 $3D $03 $75 $1F $B8     		#If Keen, kill him; check for shot (Type 3)
#	         $0A7CW $50 $57 $56 $9A $09DC1695RL     $83 $C4 $06 $C7 $44 $18     		#If shot, become $206C
#	         $FFE8W  $8B $44 $0E $D1 $E0 $D1 $E0 $D1 $E0 $89 $44 $16 $5F $5E $5D 		#Jump into the air $FFE8
#	         $CB

#collision - taking over Mimrock collision (one of them anyways)- doesn't kill Keen now though - $11A20566RL
%patch $11F86  $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $03 $75 $1F 		#Check for Keen (Type 2)
   		   $B8 $0A7CW $50 $57 $56 $9A $09DC1695RL     $83 $C4 $06 $C7 $44 $18     	#If shot, become $206C
	         $FFE8W  $8B $44 $0E $D1 $E0 $D1 $E0 $D1 $E0 $89 $44 $16 $5F $5E $5D 		#Jump into the air $FFE8
	         $CB

#behaviour - randomly goes to shooting sprite action - taking over both Mimrock's behaviour and collision - $11A204F8RL 
%patch $11F18 $55 $8B $EC $83 $EC $02 $56 $57 $8B $76 $06 
		  $9A $1D02002ARL $3D $0014W $7D $53 $C7 $44 $1C $34B2W 				 			#randomly goes to shooting sprite action
		  $B8 $0001W  $50 $9A $06BD1E11RL											#create shot
              $83 $C4 $02 $8B $44 $0A $8B $1E $D8 $A7  
		  $89 $47 $0A $8B $44 $0C $05 $FF34W  $89 $47 $0C $C7 $47 $20 $0003W  
		  $C7 $47 $06 $0000W  $C7 $47 $02 $0003W  
		  $B8 $0004W  $50 $9A $187409F1RL $83 $C4 $02 								 	#create sound
		  $8B $44 $0E $8B $1E $D8 $A7 $B8 $34D0W $50 $53 $9A
              $09DC118CRL     $83 $C4 $04 $5F $5E $8B $E5 $5D $CB 

#collision - turns Keen into objects - taking over error messages - $$2EE74109RL
%patch $32F79 $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $4F						#'If you touch Keen, then...'
              $C7 $44 $1C $35FCW													#changes to nothing (disappears)
		  $9A $1D02002ARL $3D $0030W $7D $13 										#randomly choses to turn Keen into a...
		  $B8 $3566W $50 $FF $36 $D6 $A7 $9A $09DC120ARL $83 $C4 $04 $E9 $002DW					#clock
		  $9A $1D02002ARL $3D $0080W $7D $13 
		  $B8 $3638W $50 $FF $36 $D6 $A7 $9A $09DC120ARL $83 $C4 $04 $E9 $0010W					#teapot
		  $B8 $3674W $50 $FF $36 $D6 $A7 $9A $09DC120ARL $83 $C4 $04 						#candle
		  $5F $5E $5D $CB	


#behaviour - produces smoke sprite action - taking over 'move up to get items' behaviour - $11A20079RL 
%patch $11A99 $55 $8B $EC $83 $EC $02 $56 $57 $8B $76 $06 $C7 $47 $06 $0003W  					#sets clipping to 3 (have to have this. trust me)
		  $B8 $0001W  $50 $9A $06BD1E11RL $83 $C4 $02 $8B $44 $0A $8B $1E $D8 $A7  				#create smoke
		  $89 $47 $0A $8B $44 $0C $05 $0000W  $89 $47 $0C $C7 $47 $20 $0003W  
		  $B8 $0006W  $50 $9A $187409F1RL $83 $C4 $02 									#create sound
		  $8B $44 $0E $8B $1E $D8 $A7 $B8 $35C0W $50 $53 $9A
              $09DC118CRL     $83 $C4 $04 $5F $5E $8B $E5 $5D $CB

#its at $11AF3 after this ^

#behavior - movement for shot - basically goes toward Keen - overtaking some unused text - $2EE700B6RL
%patch $2EF26 $55 $8B $EC $56 $8B $76 $06 $83 $7C $3E $00 $75 $18 $8B $44 $0A 
              $8B $1E $D6 $A7 $3B $47 $0A $73 $07 $C7 $44 $0E $0001W  $EB $05 
              $C7 $44 $0E $FFFFW  $8B $44 $0C $8B $1E $D6 $A7 $3B $47 $0C $73 
              $07 $C7 $44 $10 $0001W  $EB $05 $C7 $44 $10 $FFFFW  $5E $5D $CB




################################################################################################################################################################################ MAGE OF THE ANCIENTS (enemy)

#overtaking Seasprite's stuff.
#sits still, will chose between firing zappy things, or killing Keen sequence.

%patch $30712 $0143W #Sprite Cache start
%patch $3075C $014AW #Sprite cache end

#spawning code, overtaking seasprite's
%patch $1257F $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $001EW  $C7 $47 $02 $0000W $C7 $47 $06 $0000W  
		  $8B $46 $06 $B1 $08
              $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05 $FE50W  $89 $47 $0C
              $B8 $37A0W $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#standing still - $37A0W 
%patch $32610 $0143W $0143W $0000W $0000W $0001W $0080W $0000W $0000W
		  $00000000L $108005B5RL    $09DC176ERL  $37BEW  
#decides what to do
%patch $3262E $0143W $0143W $0002W $0000W $0001W $0000W $0000W $0000W
		  $11A20C18RL $108005B5RL    $09DC176ERL  $0000W  

#casts green balls - $37DCW 
%patch $3264C $0144W $0144W $0003W $0000W $0001W $0030W $0000W $0000W
		  $11A20C40RL $108005B5RL    $09DC176ERL  $37A0W 
#green ball 1- $37FAW 
%patch $3266A $0149W $0149W $0004W $0000W $0000W $000AW $0040W $0040W
		  $11A205C1RL    $09DC1752RL    $09DC176ERL  $3818W 
#green ball 2- $3818W 
%patch $32688 $014AW $014AW $0004W $0000W $0000W $000AW $0040W $0040W
		  $11A205C1RL    $09DC1752RL    $09DC176ERL  $330EW 
#green ball 3- $330EW 
%patch $3217E $0149W $0149W $0004W $0000W $0000W $000AW $0040W $0040W
		  $11A205C1RL    $09DC1752RL    $09DC176ERL  $332CW 
#green ball 4- $332CW 
%patch $3219C $014AW $014AW $0004W $0000W $0000W $000AW $0040W $0040W
		  $11A205C1RL    $09DC1752RL    $09DC176ERL  $0000W 

#slowly making red fire - $3836W 
%patch $326A6 $0145W $0145W $0004W $0001W $0001W $0060W $0000W $0000W
		  $06BD0B78RL $108005B5RL    $09DC176ERL  $3854W 
%patch $326C4 $0146W $0146W $0004W $0001W $0001W $0060W $0000W $0000W
		  $06BD0ACARL $108005B5RL    $09DC176ERL  $3872W 
%patch $326E2 $0147W $0147W $0004W $0001W $0001W $0060W $0000W $0000W
		  $06BD07BARL $108005B5RL    $09DC176ERL  $3890W

#casts red fire; kills keen - $3890W
%patch $32700 $0148W $0148W $0003W $0000W $0001W $0080W $0000W $0000W
		  $10800838RL $00000000L $09DC176ERL  $37A0W

#behaviour- shoots out deadly green balls - $11A20C40RL
%patch $12660 $55 $8B $EC $56 $8B $76 $06 
		  $B8 $0001W  $50 $9A $06BD1E11RL						#first shot- shoots upward
              $83 $C4 $02 $8B $44 $0A $05 $0064W $8B $1E $D8 $A7 
		  $89 $47 $0A $8B $44 $0C $05 $FD80W   $89 $47 $0C $C7 $47 $02 $0003W  
		  $C7 $47 $06 $0000W $C7 $47 $20 $0003W $B8 $0004W  $50 $9A $187409F1RL     $83 $C4 $02
              $8B $44 $0E $8B $1E $D8 $A7 $B8 $37FAW $50 $53 $9A
              $09DC118CRL     $83 $C4 $04 
		  $5E $5D $CB

#              $83 $C4 $02 $8B $44 $0A $05 $0064W $8B $1E $D8 $A7 $89 $47 $0A $8B $44 $0C
#              $05 $0064W  $89 $47 $0C $C7 $47 $20 $0003W 

#behaviour- randomly going in four directions - $11A205C1RL    
%patch $11FE1 $55 $8B $EC $56 $8B $76 $06 
		  $9A $1D02002ARL $3D $0060W $7D $0D $C7 $44 $0E $FFFFW $C7 $44 $16 $0018W $E9 $0038W 			#randomly go left
		  $9A $1D02002ARL $3D $0080W $7D $0D $C7 $44 $0E $0001W $C7 $44 $16 $0018W $E9 $0021W 			#ranomly go right
		  $9A $1D02002ARL $3D $0090W $7D $0D $C7 $44 $10 $0001W $C7 $44 $18 $0018W $E9 $000AW 			#ranomly go up
		  $C7 $44 $10 $FFFFW $C7 $44 $18 $0018W $5E $5D $CB									#randomly go down

#collision - for enemy; kills Keen, become smoke if shot - $108005B5RL    
%patch $10DB5 $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $09
              $9A $0B8013E9RL     $5F $5E $5D $CB 
		  $83 $3D $03 $75 $0E $B8 $2D14W $50 $57 $56 $9A $09DC1695RL
              $83 $C4 $06 $5F $5E $5D $CB


#behaviour- decides whether to shoot green balls or make red fire - $11A20C18RL 
%patch $12638 $55 $8B $EC $83 $EC $02 $56 $57 $8B $76 $06 $9A $1D02002ARL
              $3D $00E0W  $7D $08 $C7 $44 $1C $37DCW $E9 $0005W $C7 $44 $1C $3836W 
		  $5F $5E $8B $E5 $5D $CB 

#behaviour- instantly kills Keen - taking over more inchworm code - $10800838RL
%patch $11038 $55 $8B $EC $83 $EC $02 $56 $57 $8B $76 $06 $9A $0B8013E9RL
		  $5F $5E $8B $E5 $5D $CB

#beh. - make first sound - $06BD0B78RL
%patch $7748 $55 $8B $EC $56 $8B $76 $06 
		 $B8 $002FW  $50 $9A $187409F1RL     $83 $C4 $02
		 $5E $5D $CB

#beh. - make second sound - $06BD0ACARL
%patch $769A $55 $8B $EC $56 $8B $76 $06 
		 $B8 $002EW  $50 $9A $187409F1RL     $83 $C4 $02
		 $5E $5D $CB

#beh. - make third sound - $06BD07BARL
%patch $738A $55 $8B $EC $56 $8B $76 $06 
		 $B8 $002DW  $50 $9A $187409F1RL     $83 $C4 $02
		 $5E $5D $CB



############################################################################################################################################################################################# CREEPER (enemy)

#slowly wanders back and forth, is indistructible.
#overtaking Lick's stuff.

%patch $30702 $01D5W #Lick Cache start
%patch $3074C $01DAW #Lick cache end

#spawning code
%patch $112C8 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0012W  $C7 $47 $06 $0001W  $C7 $47 $20 $0001W
              $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05
              $FD90W  $89 $47 $0C $B8 $0001W  $89 $47 $0E $89 $47 $10 $B8 $25B2W 
                  $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#walking $25B2W 
%patch $31422 $01D5W $01D8W $0000W $0000W $0001W $0038W $0000W $0000W
		  $10800BFDRL    $09DC1752RL    $09DC1795RL    $25D0W 
%patch $31440 $01D6W $01D9W $0001W $0000W $0001W $0010W $0010W $0000W
		  $00000000L $09DC1752RL    $09DC1795RL    $25EEW 
%patch $3145E $01D5W $01D8W $0000W $0000W $0001W $0038W $0000W $0000W
		  $10800BFDRL    $09DC1752RL    $09DC1795RL    $260CW 
%patch $3147C $01D7W $01DAW $0001W $0000W $0001W $0010W $0010W $0000W
		  $00000000L $09DC1752RL    $09DC1795RL    $25B2W 

#fur ball - $0AD6W
#%patch $2F946 $01DBW $01DBW $0003W $0000W $0000W $0010W $0060W $0060W
#		  $09DC16C9RL $00000000L $1080097ERL    $0AB8W
#%patch $2F928 $01DCW $01DCW $0003W $0000W $0000W $0010W $0060W $0060W
#		  $09DC16C9RL $00000000L $1080097ERL    $0AD6W

#collision - if shot, turn into 'fur ball', or kill you - taking over Lick collision - $10800BFDRL    
#%patch $113FD $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $05 		#Check for Keen (Type 2)
 #        	  $9A $0B8013E9RL     $83 $3D $03 $75 $0E $B8 $0AD6W				#If Keen, kill him; check for shot (Type 3)
#	        $50 $57 $56 $9A $09DC1695RL     $83 $C4 $06 $5F $5E $5D $CB	

#beh. - randomly change walking direction - $10800BFDRL    
%patch $113FD $55 $8B $EC $56 $8B $76 $06 $8B $44 $0A $8B $76 $06 $9A $1D02002ARL
              $3D $0064W  $7D $08 $C7 $44 $0E $FFFFW  $5E $5D $CB $C7 
              $44 $0E $0001W  $5E $5D $CB

#%patch $11222 $0AD6W
#%patch $1126F $0AD6W
#%patch $1127E $0AD6W

#%patch $111C4 $9A $1D02002ARL $3D $0064W  $7D $05 $C7 $44 $1C $25B2W

#%patch $111AE $0040W
#%patch $111BC $FF10W
#%patch $111FE $0040W
#%patch $11260 $0040W

#%patch $111DB $0001W
#%patch $111F8 $FFFFW





######################################################################################################################################################################################## DRONE v2.0 (enemy)

#flys around toward Keen, if close enough, shoots 4 shots in 4 directions.

#overtaking skypest's stuff

#Skypest
#%patch $EA50 $83 $3E $7A6CW  $03 $7D $03 $E9 $03A3W  $83 $3E $7A6CW  $02 $7D
#             $03 $E9 $0399W  $FF $76 $FC $57 $9A $0FA80B67RL     $83 $C4 $04
#             $90 $90 $90 $90 $90 $90  $E9 $0384W

#foreground
%patch $10605 $0003W

#'sprite active type'
%patch $10600 $0004W

#Skypest cache
%patch $306FE $01BBW #Skypest Cache start
%patch $30748 $01C3W #Skypest cache end

#Flying
%patch $312F6 $01BBW $01BBW $0003W $0000W $0000W $0008W $0030W $0030W
		  $11A20711RL $0FA80B1CRL    $11A20A3CRL    $24A4W 
%patch $31314 $01BCW $01BCW $0003W $0000W $0000W $0008W $0030W $0030W
		  $11A20711RL $0FA80B1CRL    $11A20A3CRL    $24C2W 
%patch $31332 $01BDW $01BDW $0003W $0000W $0000W $0008W $0030W $0030W
		  $06BD043BRL $0FA80B1CRL    $11A20A3CRL    $24E0W 
%patch $31350 $01BEW $01BEW $0003W $0000W $0000W $0008W $0030W $0030W
		  $11A20711RL $0FA80B1CRL    $11A20A3CRL    $2486W 

#shooting - $24FEW 
%patch $3136E $01BDW $01BDW $0000W $0000W $0000W $0010W $0000W $0000W
		  $06BD02E2RL $0FA80B1CRL    $09DC176ERL    $251CW 
%patch $3138C $01BFW $01BFW $0000W $0000W $0000W $0040W $0000W $0000W
		  $00000000L $0FA80B1CRL    $09DC176ERL    $2486W 

#shots - $253AW 
%patch $313AA $01C0W $01C0W $0001W $0000W $0000W $000FW $0030W $0030W
		  $00000000L $09DC1752RL    $09DC176ERL    $2558W 
%patch $313C8 $01C1W $01C1W $0001W $0000W $0000W $000FW $0030W $0030W
		  $00000000L $09DC1752RL    $09DC176ERL    $2576W 
%patch $313E6 $01C0W $01C0W $0001W $0000W $0000W $000FW $0030W $0030W
		  $00000000L $09DC1752RL    $09DC176ERL    $2594W 
%patch $31404 $01C1W $01C1W $0001W $0000W $0000W $000FW $0030W $0030W
		  $00000000L $09DC1752RL    $09DC176ERL    $0000W 

#exploding - $307AW 
%patch $31EEA $01C2W $01C2W $0000W $0000W $0000W $0025W $0000W $0000W
		  $00000000L $09DC1752RL    $09DC176ERL    $3098W
%patch $31F08 $01C3W $01C3W $0000W $0000W $0000W $0025W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL    $0000W 

#behaviour- turns into shooting drone when keen is a certain distance away (both X and Y) - $06BD043BRL
%patch $700B  $55 $8B $EC $56 $8B $76 $06 
		  $8B $44 $0A $8B $1E $D6 $A7 $2B $47 $0A $99 $33 $C2 					#checks if Keen is X distance away
		  $2B $C2 $3D $0600W $7D $19 
		  $8B $44 $0C $8B $1E $D6 $A7 $2B $47 $0C $99 $33 $C2 					#checks if Keen is Y distance away
		  $2B $C2 $3D $0600W $7D $05 $C7 $44 $1C $24FEW $5E $5D $CB

#behaviour- produces 4 shots in a '+' formation- $06BD02E2RL
%patch $6EB2  $55 $8B $EC $56 $8B $76 $06 $B8 $0001W  $50 $9A $06BD1E11RL						#first shot- shoots upward
              $83 $C4 $02 $8B $44 $0A $05 $0064W $8B $1E $D8 $A7 $C7 $47 $10 $FFFFW
		  $89 $47 $0A $8B $44 $0C   $89 $47 $0C $C7 $47 $20 $0003W  $C7 $47 $06 $0000W  $C7
              $47 $02 $0003W  $B8 $0027W  $50 $9A $187409F1RL     $83 $C4 $02
              $8B $44 $0E $8B $1E $D8 $A7 $B8 $253AW  $50 $53 $9A
              $09DC118CRL     $83 $C4 $04 
		  $B8 $0001W  $50 $9A $06BD1E11RL											#second shot- shoots downward
              $83 $C4 $02 $8B $44 $0A $05 $0064W $8B $1E $D8 $A7 $89 $47 $0A $8B $44 $0C
              $05 $0064W  $89 $47 $0C $C7 $47 $20 $0003W  $C7 $47 $06 $0000W  $C7
              $47 $02 $0003W  $B8 $0027W  $50 $9A $187409F1RL     $83 $C4 $02
              $8B $44 $0E $8B $1E $D8 $A7 $C7 $47 $10 $0001W $B8 $253AW  $50 $53 $9A
              $09DC118CRL     $83 $C4 $04
%patch $6F62  $B8 $0001W  $50 $9A $06BD1E11RL											#third shot- shoots right
              $83 $C4 $02 $8B $44 $0A $8B $1E $D8 $A7 $C7 $47 $0E $0001W 
		  $89 $47 $0A $8B $44 $0C $05 $0064W  $89 $47 $0C $C7 $47 $20 $0003W  $C7 $47 $06 $0000W  $C7
              $47 $02 $0003W  $B8 $0027W  $50 $9A $187409F1RL     $83 $C4 $02
              $8B $44 $0E $8B $1E $D8 $A7 $B8 $253AW  $50 $53 $9A
              $09DC118CRL     $83 $C4 $04
		  $B8 $0001W  $50 $9A $06BD1E11RL											#fourth shot- shoots left
              $83 $C4 $02 $8B $44 $0A $8B $1E $D8 $A7 $C7 $47 $0E $FFFFW 
		  $89 $47 $0A $8B $44 $0C $05 $0064W  $89 $47 $0C $C7 $47 $20 $0003W  $C7 $47 $06 $0000W  $C7
              $47 $02 $0003W  $B8 $0027W  $50 $9A $187409F1RL     $83 $C4 $02
              $8B $44 $0E $8B $1E $D8 $A7 $B8 $253AW  $50 $53 $9A
              $09DC118CRL     $83 $C4 $04 $5E $5D $CB

#its $7042 after this ^

#beginning of whats left of the EGAGRAPH check code - $037D067FRL
#%patch $3E4F

#New collision for Skypest, stunnable
#%patch $3D1D $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $09 #Check for Keen (Type 2)
#         $9A $0B8013E9RL     $5F $5E $5D $CB $83 $3D $03 $75 $1F $B8     #If Keen, kill him; check for shot (Type3)
#         $24C2W  $50 $57 $56 $9A $09DC1695RL     $83 $C4 $06 $C7 $44 $18     #If shot, become $24C2W
#         $FFE8W  $8B $44 $0E $D1 $E0 $D1 $E0 $D1 $E0 $89 $44 $16 $5F $5E $5D #Jump into the air $FFE8
#             $CB

#behaviour - react to B sprite; change sprite action - $3D740151RL
#%patch $3D891 

#collision - taking over Arachnut's two collisions - $0FA80B1CRL    
%patch $1059C $55 $8B $EC $56 $8B $76 $08 $83 $3C $03 $75 $13 $B8 $307AW 
		  $50 $56 $FF $76 $06 $9A $09DC1695RL $83 $C4 $06 $5E $5D $CB 
		  $83 $3C $02 $75 $11 $9A $0B8013E9RL 
		  $B8 $0004W $50 $9A $187409F1RL $83 $C4 $02					#sound
		  $5E $5D $CB




################################################################################################################################################################################ KREEG LAZER INFANTRY (enemy)

#taking over Berkeloid's stuff

#in the init code - points to spawn code
#%patch $EA02 $11A20E7ARL     

#caching
%patch $30754 $0201W #Berkeloid cache end

#V distance next to Keen to throw more fireballs:
%patch $10C6D $FF05W #-1 tile
%patch $10C75 $0500W #+1 tile

#Randomly turn to face Keen
%patch $10C1C $80

#first sprite action
%patch $10BFD $2B16W

#sprite-tile interaction- makes falling Kreeg turn into walking Kreeg when hitting the ground- this is for if the Kreeg falls off an edge - 
#taking over some text- $2EE700F6RL - MOVE THIS, JEEZ
%patch $2EF66 $55 $8B $EC $56 $8B $76 $06 $83 $7C $36 
		  $00 $74 $19 $B8 $2B16W $50 $56 $9A 
		  $09DC120ARL $83 $C4 $04 
		  $B8 $0004W $50 $9A $187409F1RL $83 $C4 $02					#sound
		  $FF $74 $20 $33 
		  $C0 $50 $FF $74 $1E $FF $74 $0C $FF $74 
		  $0A $8B $C6 $05 $46 $00 $50 $9A 
		  $16541641RL $83 $C4 $0C $5E $5D $CB

#behaviour - create lazer shot - taking over some of the Blue Bird flying behaviour - $0FA80712RL
%patch $10192 $55 $8B $EC $56 $8B $76 $06 $B8 $0001W  $50 $9A $06BD1E11RL $83 $C4 $02 
		  $8B $44 $0A $8B $1E $D6 $A7 $3B $47 $0A $76 $09 						#checks if Keen is left or right
		  $8B $44 $0A $05 $0000W $E9 $0006W $8B $44 $0A $05 $19A0W 					#make lazer shot
		  $8B $1E $D8 $A7 $89 $47 $0A $8B $44 $0C
              $89 $47 $0C $C7 $47 $20 $0003W  $C7 $47 $06 $0000W  $C7
              $47 $02 $0002W  $B8 $0029W  $50 $9A $187409F1RL     $83 $C4 $02
              $8B $44 $0E $8B $1E $D8 $A7 $C7 $47 $10 $0001W $B8 $2BCAW $50 $53 $9A
              $09DC118CRL     $83 $C4 $04 
		  $B8 $0001W  $50 $9A $06BD1E11RL $83 $C4 $02 							#makes 'second' lazer shot (to make it longer).
		  $8B $44 $0A $8B $1E $D6 $A7 $3B $47 $0A $76 $09 						#checks if Keen is left or right
		  $8B $44 $0A $05 $0C00W $E9 $0006W $8B $44 $0A $05 $2500W 					
		  $8B $1E $D8 $A7 $89 $47 $0A $8B $44 $0C
              $89 $47 $0C $C7 $47 $20 $0003W  $C7 $47 $06 $0000W  $C7
              $47 $02 $0002W  $8B $44 $0E $8B $1E $D8 $A7 $C7 $47 $10 $0001W 
		  $B8 $2BCAW $50 $53 $9A $09DC118CRL  $83 $C4 $04 $5E $5D $CB

#collision - if shot, changes sprite action depending on direction of shot - $108008EFRL    
%patch $110EF $55 $8B $EC $56 $57 $8B $7E $06 $8B $76 $08 $83 $3C $02 $75 $05
              $9A $0B8013E9RL     $83 $3C $03 $75 $2A $83 $7C $0E $01 $75 $10
              $B8 $2AF8W $50 $57 $56 $9A $09DC1695RL $83 $C4 $06 $EB $14 
		  $83 $7C $0E $FF $75 $0E $B8 $2AF8W $50 $57 $56 $9A $09DC1695RL 
		  $83 $C4 $06 $5F $5E $5D $CB

#sprite-tile inter. - jumps into the air - $10800938RL
%patch $11138 $55 $8B $EC $56 $8B $76 $06 $83 $7C $3A $00 $74 $05 $C7 $44 $18
              $0000W  $83 $7C $36 $00 $74 $08 $C7 $44 $18 $0000W  $FF $44 $3E 				#Stop moving when hitting the ground
              $C7 $44 $18 $FFD8W  $FF $74 $20 $33 $C0 $50 $FF $74 $1E $FF $74 $0C $FF $74 $0A 		#Small jump
              $8B $C6 $05 $46 $00 $50 $9A $16541641RL     $83 $C4 $0C $5E $5D
              $CB

#beh - $1080055ERL    
%patch $10D5E $55 $8B $EC $56 $8B $76 $06 $8B $1E $D6 $A7 $C7 $44 $0E $FFF0W $56
              $9A $09DC1315RL     $83 $C4 $02 $5E $5D $CB
            
#turns off a sound in the walking beh.
%patch $10C92 $90 $90 $90 $90 $90 $90 $90 $90 $90 $90 $90 $90 



#9
#flying from shot - $2AF8W
%patch $31968 $01F7W $01F7W $0003W $0000W $0000W $0020W $0000W $0000W
     		  $0FA80BE7RL $00000000L    $10800938RL $2BACW

#falling - $2BACW
%patch $31A1C $01F7W $01F7W $0002W $0000W $0000W $0020W $0080W $0080W
     		  $09DC16C9RL  $00000000L    $2EE700F6RL $2B16W

#Walking frames:
%patch $32124 $01FAW $01FEW $0002W $0000W $0000W $0008W $0000W $0000W
     		  $09DC16C9RL $108008EFRL    $2EE700F6RL $0000W 
%patch $31986 $01F8W $01FCW $0000W $0001W $0001W $0008W $0060W $0000W
     		  $00000000L $108008EFRL    $09DC1795RL $2B34W  
%patch $319A4 $01F9W $01FDW $0000W $0001W $0001W $0008W $0060W $0000W
     		  $00000000L $108008EFRL    $09DC1795RL $2B52W  
%patch $319C2 $01FAW $01FEW $0000W $0001W $0001W $0008W $0060W $0000W
     		  $1080040BRL $108008EFRL    $09DC1795RL $2B16W


#Kreeg firing frames:
%patch $319E0 $01FFW $0200W $0000W $0000W $0001W $0001W $0000W $0000W
     		  $0FA80712RL $108008EFRL    $09DC176ERL    $2B8EW
%patch $319FE $01FFW $0200W $0000W $0000W $0001W $0050W $0000W $0000W
     		  $00000000L $108008EFRL    $09DC176ERL     $32B4W  #$2BACW
#%patch $31A1C $01FFW $0200W $0000W $0000W $0001W $0050W $0000W $0000W
#     		  $00000000L $10800530RL $09DC176ERL    $32B4W 
#Lazer shot - $2BCAW
%patch $31A3A $0201W $0201W $0000W $0000W $0000W $0050W $0000W $0000W
		  $00000000L $09DC1752RL $09DC176ERL    $0000W 




######################################################################################################################################################################################## KREEG SHIP (enemy)

#Starts off still and bobbing, then when Keen closes up, flys around and drops a series of projectiles when 
#Keen is below.

#taking over the Bluebird's stuff

#Cache
%patch $306F4 $016FW #Blue bird Cache start
%patch $3073E $0173W #Blue bird cache end

#spawning code - note: I mooshed together the bluebird and lindsey spawn codes, wasnt really sure
#what I was doing - taking over some foot and nearby spawn codes - $108002B4RL
%patch $10AB4 $55 $8B $EC $B8 $01 $00 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B
              $1E $D8 $A7 $C7 $07 $001BW  $C7 $47 $02 $0001W  $C7 $47 $20 $0002W
              $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0
              $05 $FF00W  $89 $47 $3E $89 $47 $0C $C7 $47 $10 $0001W $8B $47 $0A $8B $1E $D6 $A7 $3B $47 $0A
              $73 $0B $8B $1E $D8 $A7 $C7 $47 $0E $0001W  $EB $09 $8B $1E $D8
              $A7 $C7 $47 $0E $FFFFW  $8B $1E $D8 $A7 $C7 $47 $10 $0001W $B8 $30D4W 
              $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#blue bird init. code pointing to spawn code
%patch $EDF0 $108002B4RL

#first sprite action to use
%patch $10099 $30D4W 

#still - $30D4W 
%patch $31F44 $016FW $0170W $0002W $0000W $0000W $0000W $0000W $0000W
		  $06BD0472RL $0FA80840RL $09DC176ERL    $0000W 
#flying - $30F2W 
%patch $31F62 $016FW $0170W $0002W $0000W $0000W $0010W $0000W $0000W
		  $0D8F07ABRL $0FA80840RL $0FA80D0BRL    $30F2W 

#shot - $3110W 
%patch $31F80 $0172W $0172W $0002W $0000W $0000W $0000W $0000W $0000W
		  $09DC16C9RL $09DC1752RL    $2EE772E5RL $0000W 
#shot burst - $312EW 
%patch $31F9E $0173W $0173W $0001W $0000W $0000W $0020W $0000W $0000W
		  $00000000L $09DC1752RL    $09DC176ERL    $0000W 

#falling - $314CW
%patch $31FBC $016FW $0170W $0002W $0000W $0000W $0000W $0000W $0000W
		  $09DC16C9RL $00000000L $2EE70427RL $0000W 
#dead - $30B6W 
%patch $31F26 $0171W $0171W $0002W $0000W $0000W $0000W $0000W $0000W
		  $09DC16C9RL $00000000L $09DC1913RL    $0000W 

 

#behaviour - makes it bob when stationairy; change sprite action when Keen approaches - $06BD0472RL
%patch $7042  $55 $8B $EC $56 $8B $76 $06 
		  $B8 $0008W $50 $FF $74 $10 $56 $9A $09DC1517RL $83 $C4 $06 $8B $44 $3E $2B 
		  $44 $0C $3D $0020W $7E $05 $C7 $44 $10 $0001W $8B $44 $0C $2B $44 $3E $3D $0020W $7E $05 
		  $C7 $44 $10 $FFFFW 
		  $8B $44 $0A $8B $1E $D6 $A7 $2B $47 $0A $99 $33 $C2 					#checks if Keen is X distance away
		  $2B $C2 $3D $0700W $7D $19 
		  $8B $44 $0C $8B $1E $D6 $A7 $2B $47 $0C $99 $33 $C2 					#checks if Keen is Y distance away
		  $2B $C2 $3D $0700W $7D $05 $C7 $44 $1C $30F2W $5E $5D $CB

#behaviour - Kreeg ship flys (ripped directly off from skypest) - drop projectiles when Keen is under him - 
#taking over 'Keen on Foot' and 'Map Keen Swimming' beh. codes - $0D8F07ABRL
%patch $E09B  $55 $8B $EC $56 $8B $76 $06 
		  $8B $44 $0A $8B $1E $D6 $A7 $2B $47 $0A $99 $33 $C2 							#checks if Keen is X distance away
		  $2B $C2 $3D $0100W $7F $3D 	
		  $B8 $0001W  $50 $9A $06BD1E11RL											#start of making shot
              $83 $C4 $02 $8B $1E $D8 $A7 $C7 $47 $02 $0002W
              $8B $44 $0A $89 $47 $0A $8B $44 $28 $2D $FF30W
              $89 $47 $0C $B8 $3110W $50 $53 $9A $09DC118CRL      $83 $C4 $04 	
		  $B8 $0020W $50 $9A $187409F1RL $83 $C4 $02									#making sound
		  $9A $1D02002ARL $3B $06 $4C 											#start of the flying code.
		  $A5 $73 $08 $8B $44 $0E $F7 $D8 $89 $44 $0E $83 $7C $10 $FF 
		  $75 $10 $9A $1D02002ARL $3B $06 $4C $A5 $73 $05 $C7 $44 
		  $10 $0001W $83 $7C $10 $01 $75 $17 $9A $1D02002ARL $8B 
		  $16 $4C $A5 $D1 $E2 $3B $C2 $73 $08 $8B $44 $10 $F7 $D8 $89 
		  $44 $10 $B8 $14 $00 $50 $FF $74 $0E $56 $9A $09DC13FERL
		  $83 $C4 $06 $B8 $14 $00 $50 $FF $74 $10 $56 $9A $09DC1517RL 
		  $83 $C4 $06 
		  $5E $5D $CB

#its at $E15C after this ^

#sprite-tile interaction for shot- change to burst when hits ground - 
#taking over some text *and* some non text, so theres a possibility it could cause an error - $2EE772E5RL
%patch $36155 $55 $8B $EC $56 $8B $76 $06 $83 $7C $38 $00 $75 $06 $83 $7C 
		 $3C $00 $74 $05 $C7 $47 $20 $0003W $83 $7C $36 $00 $74 $19 
		 $B8 $001FW $50 $9A $187409F1RL $83 $C4 $02 $B8 $312EW 
		 $50 $56 $9A $09DC120ARL $83 $C4 $04 $FF $74 $20 $33 $C0 
		 $50 $FF $74 $1E $FF $74 $0C $FF $74 $0A $8B $C6 $05 $46 $00 
		 $50 $9A $16541641RL $83 $C4 $0C $5E $5D $CB

#at $361AC after this ^

#what the kreeg ship/blue bird turns into when shot
%patch $102E9 $314CW

#sprite-tile interaction - changes falling Kreeg Ship when hitting the ground - taking over some text - $2EE70427RL
%patch $2F297 $55 $8B $EC $56 $8B $76 $06 $83 $7C $38 $00 $75 $06 $83 $7C 
		  $3C $00 $74 $05 $C7 $47 $20 $0003W $83 $7C $36 $00 $74 $0D 
		  $B8 $30B6W 
		  $50 $56 $9A $09DC120ARL $83 $C4 $04 $FF $74 $20 $33 $C0 
		  $50 $FF $74 $1E $FF $74 $0C $FF $74 $0A $8B $C6 $05 $46 $00 
		  $50 $9A $16541641RL $83 $C4 $0C $5E $5D $CB



########################################################################################################################################################################################## GHOST FISH (enemy)

#swims back and forth, and bobs up and down slightly

#taking over the underwater mine tile spots
%patch $EF0F $0439W #Easy fish
%patch $EF11 $042FW #Medium fish
%patch $EF13 $0425W #Hard fish

#cache - using the underwater mine cache
%patch $30714 $0204W #start
%patch $3075E $0207W #end

#init code - taking over some of the 'swim keen' one (to take over more of it's code, work backwards from here)
%patch $ED15 $83 $3E $7A6CW  $03 $7D $03 $E9 $00EFW  $83 $3E $7A6CW  $02 $7D
             $03 $E9 $00E5W  $FF $76 $FC $57 $9A $3D740000RL $83 $C4 $04
             $C7 $06 $7F $CB $0001W  $E9 $00BFW
#41
#spawn code - taking over code after official end of exe - $3D740000RL
%patch $3D740 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0020W  $C7 $47 $02 $0001W  $C7 $47 $20 $0000W
              $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05
              $FF00W  $89 $47 $3E $89 $47 $0C $C7 $47 $10 $0001W  $B8 $341CW 
              $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#$341CW 
%patch $3228C $0206W $0204W $0004W $0000W $0000W $000AW $000AW $0005W
		  $3D74004DRL $09DC1752RL    $09DC176ERL $33A4W 
#$33A4W 
%patch $32214 $0207W $0205W $0004W $0000W $0000W $000AW $000AW $0005W
		  $11A20E01RL $09DC1752RL    $09DC176ERL $341CW 

#behaviour - bob 'up and down' and reverse direction randomly- $3D74004DRL
%patch $3D78D $55 $8B $EC $56 $8B $76 $06  
		  $9A $1D02002ARL $3D $0080W $7D $0D													#randomly chose to...
		  $C7 $44 $0E $0001W $C7 $44 $08 $0015W $E9 $000AW											#move to the right (for a period of time)
   		  $C7 $44 $0E $FFFFW $C7 $44 $08 $0015W 													#move to the left (for a period of time)
		  $5E $5D $CB




##################################################################################################################################################################################### FAERIE (harmless enemy)

#overtaking Smirky's stuff

#Cache
%patch $306F0 $0152W #Treasure Eater Cache start
%patch $3073A $0153W #Treasure Eater cache end

#flying - $31E2W
%patch $32052 $0152W $0152W $0003W $0000W $0000W $0008W $0000W $0000W
		  $0FA80BE7RL $00000000L $0FA80D0BRL    $3200W 
%patch $32070 $0153W $0153W $0003W $0000W $0000W $0008W $0000W $0000W
		  $0FA80BE7RL $00000000L $0FA80D0BRL    $31E2W

#%patch $10683 $FFF5W

#Skypest flying tile collision
%patch $1078B $55 $8B $EC $56 $8B $76 $06 $83 $7C $3A $00 $74 $0A $C7 $44 $18 $0008W #Move down off ceilings
              $C7 $44 $10 $0001W   $83 $7C $3C $00 $74 $0A $C7 $44 $16  		 #Hit right wall
              $0000W  $C7 $44 $0E $FFFFW  $83 $7C $38 $00 $74 $0A $C7 $44 $16 $0000W #Hit left wall
              $C7 $44 $0E $0001W  $FF $74 $20 $33 $C0 $50 $FF $74 $1E $FF $74   	 #Draw sprite
              $0C $FF $74 $0A $8B $C6 $05 $46 $00 $50 $9A $16541641RL     $83 $C4
              $0C $5E $5D $CB





####################################################################################################################################################################################################### BOSS

#it follows you around invisibly, then, after a certain time, appears in a ghostly fashion where you are located, standing still. 
#It then shoots balls of power at you, which you can shoot out with your gun. 
#There are also Keen Balloons floating around the level, and the aim is to make the boss appear where a 
#balloon is, which makes the balloon pop, scaring the boss and making the boss fall to the ground, where he 
#nurses his soar head for a bit before going back to his usual routine. 
#After you make him fall a few times, he falls down 'dead' permanently, triggering the end sequence when you 
#walk over to his body.

#NOTE: using the lvl11 game counter for how many times the boss falls till he dies for the end game.

%patch $306F8 $0193W #Dopefish Cache start
%patch $30742 $01A5W #Dopefish cache end

%patch $EEA1 $0255W #Easy Dopefish

#Dopefish
%patch $EB45 $FF $76 $FC $57 $9A $11A20690RL $83 $C4 $04 $C7 $06 $63 $CB
             $0001W  $E9 $02A3W

#Dopefish spawn code - $11A20690RL
%patch $120B0 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0015W  $C7 $47 $02 $0002W  $C7 $47 $06 $0000W  $C7 $47 $20 $0002W    $8B $46 $06 $B1 $08
              $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05 $FF00W  $89 $47 $0C
              $B8 $2738W $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#start - $2738W 
%patch $315A8 $0193W $0193W $0002W $0000W $0000W $0008W $0000W $0000W
		  $11A2077ARL $00000000L $09DC176ERL    $0000W 

#Still - $2756W 
%patch $315C6 $0193W $0193W $0000W $0000W $0000W $000FW $0000W $0000W
		  $00000000L $193109FBRL $09DC176ERL    $2774W 
#Still - $2774W 
%patch $315E4 $0194W $0194W $0000W $0000W $0000W $000FW $0000W $0000W
		  $19310CB6RL $09DC1752RL    $09DC176ERL    $2756W 

#shooting - $2918W 
%patch $31788 $019CW $019CW $0000W $0000W $0000W $000FW $0000W $0000W
		  $00000000L $09DC1752RL    $09DC176ERL    $2936W 
#shooting - $2936W 
%patch $317A6 $019DW $019DW $0000W $0000W $0000W $000FW $0000W $0000W
		  $19310917RL $09DC1752RL    $09DC176ERL    $2918W 

#fading out - $27B0W 
%patch $31620 $0195W $0195W $0000W $0000W $0000W $0040W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL    $27CEW 
#invisible - $27CEW 
%patch $3163E $FFFFW $FFFFW $0004W $0000W $0000W $0170W $0260W $0260W
		  $2EE700B6RL $00000000L $09DC176ERL    $27ECW 
#fading in - $27ECW 
%patch $3165C $0195W $0195W $0000W $0000W $0000W $0040W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL    $2756W 

#Shot - $2792W 
%patch $31602 $0196W $0196W $0003W $0000W $0000W $000AW $0040W $0040W
		  $1931097DRL $11A209B0RL $09DC176ERL    $280AW 
#Shot - $280AW 
%patch $3167A $0197W $0197W $0003W $0000W $0000W $000AW $0040W $0040W
		  $1931097DRL $11A209B0RL $09DC176ERL    $2792W 
#Shot - dying - $2828W 
%patch $31698 $0198W $0198W $0004W $0000W $0000W $000CW $0010W $0010W
		  $11A20711RL $00000000L $09DC176ERL    $0000W 

#Falling - $2954W 
%patch $317C4 $0193W $0193W $0002W $0000W $0000W $0000W $0000W $0000W
		  $09DC16C9RL $00000000L $10800071RL $0000W 
#Knocked out - decides what to do - $2990W 
%patch $31800 $019EW $019EW $0002W $0000W $0000W $0000W $0000W $0000W
		  $11A2091CRL $00000000L $09DC176ERL    $0000W 
#Knocked out - $29AEW 
%patch $3181E $019EW $019EW $0000W $0000W $0000W $0020W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL    $2A44W 

#Head scratch - make stars - $2A44W 
%patch $318B4 $019FW $019FW $0000W $0000W $0000W $0001W $0000W $0000W
		  $11A208D7RL $00000000L $09DC176ERL    $29EAW 
#Stars - $2A62W 
%patch $318D2 $01A2W $01A2W $0000W $0000W $0000W $000AW $0000W $0000W
		  $11A20F71RL $00000000L $09DC176ERL    $2A80W 
#Stars - $2A80W 
%patch $318F0 $01A3W $01A3W $0000W $0000W $0000W $000AW $0000W $0000W
		  $00000000L $00000000L $09DC176ERL    $2A9EW 
#Stars - $2A9EW 
%patch $3190E $01A4W $01A4W $0000W $0000W $0000W $000AW $0000W $0000W
		  $00000000L $00000000L $09DC176ERL    $2A62W 

#Head scratch - $29EAW 
%patch $3185A $019FW $019FW $0000W $0000W $0000W $0015W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL    $2A08W 
#Head scratch 2 - $2A08W 
%patch $31878 $01A0W $01A0W $0000W $0000W $0000W $0015W $0000W $0000W
		  $11A2011FRL $00000000L $09DC176ERL    $29EAW 
#Head scratch - fade out - $2A26W 
%patch $31896 $01A1W $01A1W $0000W $0000W $0000W $0040W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL    $27CEW 

#Dead - ends game - $29CCW 
%patch $3183C $019EW $019EW $0002W $0000W $0000W $0015W $0000W $0000W
		  $00000000L $06BD0058RL $09DC176ERL    $0000W 

#behaviour - when you get close enough, it'll change sprite action (And play message) - also resets lvl11 game stat - $11A2077ARL 
%patch $1219A $55 $8B $EC $56 $8B $76 $06 
		  $C7 $06 $7A34W $0002W
		  $8B $44 $0A $8B $1E $D6 $A7 $2B $47 $0A $99 $33 $C2 						#checks if Keen is X distance away
		  $2B $C2 $3D $0500W $7D $41 
		  $8B $44 $0C $8B $1E $D6 $A7 $2B $47 $0C $99 $33 $C2 						#checks if Keen is Y distance away
		  $2B $C2 $3D $0500W $7D $2D 
		  $83 $3E $7A36W $02 $74 $1B											#if lvl12=2, skip message (so it only displays the message once)
		  $B8 $001EW  $50 $9A $187409F1RL $83 $C4 $02 								#create sound
		  $9A $0E8F0A66RL $9A $0E8F0AE2RL $9A $16540D59RL							#display message then clear it away
		  $C7 $44 $1C $2756W $C7 $06 $7A36W $0002W $5E $5D $CB						#change sprite action and set lvl12=2

#edits for the 'can't swim!' message, which is what im using for above
%patch $309EE "I AM AXIT, THE ANCIENT" $0A
		  "REPTILIAN GOD OF THE" $0A
		  "UNDERWORLD. YOU ARE ALL" $0A
		  "INTRUDERS IN MY WORLD," $0A
		  "AND WILL ALL BE" $0A
		  "STOPPED." $00
#116
#1580 difference
%patch $2F565 $0A
		  "Well crap." $00

%patch $F3A5 $1B7EW #Text read from
%patch $F370 $000AW #Window height
%patch $F374 $001CW #Window width
%patch $F364 $0071W #Cache chunk 111
%patch $F380 $0071W #Display chunk 111
%patch $F38F $0033W #'Width of image'

#this is now the wetsuit collecting windows stuffs stuffs
%patch $F3DF $B8 $0070W $50 $9A $12A61117RL $83 $C4 $02 $B8 $0008W $50 $B8 $001AW 
		 $50 $9A $19311070RL $83 $C4 $04 $B8 $0070W $50 $FF $36 $DE $A7 $A1 $33 
		 $A5 $03 $06 $31 $A5 $2D $0030W $50 $9A $1D060C79RL $83 $C4 $06 $83 $2E 
		 $31 $A5 $30 $83 $06 $35 $A5 $0C $B8 $06F5W $50 $9A $19310EBDRL $83 $C4 $02 
		 $9A $1D060A9BRL $B8 $001EW $50 $9A $1E0A0AD3RL $83 $C4 $02 $9A $146008A8RL 
		 $9A $14600EDFRL $9A $12A614EDRL $5D $CB


#behaviour - when you get close enough, it'll change sprite action (And play message) - also resets lvl11 game stat - $1931085CRL
#%patch $19B6C $55 $8B $EC $56 $8B $76 $06 
#		  $C7 $06 $7A34W $0002W
#		  $8B $44 $0A $8B $1E $D6 $A7 $2B $47 $0A $99 $33 $C2 						#checks if Keen is X distance away
#		  $2B $C2 $3D $0600W $7D $19 
#		  $8B $44 $0C $8B $1E $D6 $A7 $2B $47 $0C $99 $33 $C2 						#checks if Keen is Y distance away
#		  $2B $C2 $3D $0600W $7D $0A $9A $0E8F0A66RL $C7 $44 $1C $2756W $5E $5D $CB
 
#behaviour - shoots a sprite action - $19310917RL
%patch $19C27 $55 $8B $EC $56 $8B $76 $06 $B8 $0001W  $50 $9A $06BD1E11RL
              $83 $C4 $02 $8B $1E $D8 $A7 $C7 $47 $02 $0002W
              $C7 $47 $20 $0003W $C7 $47 $06 $0000W   $8B $44 $0A $89 $47 $0A $8B $44 $28 $2D $0350W 		#the $2D $XXXXW at the end is how far up the shot comes out from
	        $89 $47 $0C $B8 $2792W $50 $53 $9A $09DC118CRL      $83 $C4 $04 
		  $B8 $001FW  $50 $9A $187409F1RL $83 $C4 $02 								 	#create sound
		  $FF $44 $3E $8B $44 $3E $3D $0005W $75 $0A									#incr. 3E until its 6, then...
		  $C7 $44 $1C $27B0W 													#change sprite action
		  $C7 $44 $3E $0000W  
		  $5E $5D $CB

#shot collision - taking over dopefish collision - $11A209B0RL 
%patch $123D0 $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $09 					#Check for Keen (Type 2)
      	  $9A $0B8013E9RL     $5F $5E $5D $CB $83 $3D $03 $75 $0E 							#check for shot
		  $B8 $2828W $50 $57 $56 $9A $09DC1695RL $83 $C4 $06 								#turn to dying shot (and make keen's shot splatter/die)
		  $5F $5E $5D $CB
		 
#behaviour - shot's movement - $1931097DRL 
%patch $19C8D $55 $8B $EC $56 $8B $76 $06 $83 $7C $3E $00 $75 $18 $8B $44 $0A 		#If Keen is level with fish, skip l\r stuff
              $8B $1E $D6 $A7 $3B $47 $0A $73 $07 $C7 $44 $0E $0001W  $EB $05 		#Check for Keen h, set h direction
              $C7 $44 $0E $FFFFW  $B8 $0015W  $50 $FF $74 $0E $56 $9A         		#Set h speed = $A
	        $09DC149FRL  $83 $C4 $06 $8B $44 $0C $8B $1E $D6 $A7 $3B $47 $0C $73 		#Check for Keen v
              $14 $B8 $0015W  $50 $B8 $0001W  $50 $56 $9A $09DC1517RL     $83 		#Set v speed and direction
              $C4 $06 $5E $5D $CB $B8 $0015W  $50 $B8 $FFFFW  $50 $56 $9A
              $09DC1517RL $83 $C4 $06 
		  $FF $44 $3E $8B $44 $3E $3D $0045W $75 $0A									#incr. 3E until its 6, then...
		  $C7 $44 $1C $2828W 													#change sprite action
		  $C7 $44 $3E $0000W 
		  $5E $5D $CB

#collision - change sprite action when touching the boss's sprite type - $193109FBRL
%patch $19D0B $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $16 $75 $1E 
		  $B8 $2882W $50 $57 $9A $09DC120ARL $83 $C4 $04								#make balloon change sprite action
		  $C7 $44 $1C $2954W 
		  $B8 $0028W  $50 $9A $187409F1RL $83 $C4 $02 								 	#create sound
		  $5F $5E $5D $CB

#behaviour - after a while, change sprite action - $19310CB6RL
%patch $19FC6 $55 $8B $EC $56 $8B $76 $06 
		  $FF $44 $3E $8B $44 $3E $3D $0006W $75 $0A									#incr. 3E until its 6, then...
		  $C7 $44 $1C $2918W 													#change sprite action
		  $C7 $44 $3E $0000W 
		  $5E $5D $CB

#sprite-tile inter. - turn the falling boss into another sprite action - $10800071RL 
%patch $10871 $55 $8B $EC $56 $8B $76 $06 $83 $7C $38 $00 $75 $06 $83 $7C 
		  $3C $00 $74 $05 $C7 $44 $16 $0000W $C7 $44 $06 $0003W $C7 $44 $20 $0003W $83 $7C $36 $00 $74 $19 
		  $B8 $002AW $50 $9A $187409F1RL $83 $C4 $02 $B8 $2990W 
		  $50 $56 $9A $09DC120ARL $83 $C4 $04 $FF $74 $20 $33 $C0 
		  $50 $FF $74 $1E $FF $74 $0C $FF $74 $0A $8B $C6 $05 $46 $00 
		  $50 $9A $16541641RL $83 $C4 $0C $5E $5D $CB

#behaviour - increments lvl11 counter, decides which action to turn into according to difficulty level and lvl11 counter - $11A2091CRL
%patch $1233C $55 $8B $EC $56 $8B $76 $06 
		  $83 $3E $7A6CW $03 $75 $0F												#if game is in HARD mode...
		  $83 $3E $7A34W $07 $75 $2D $C7 $44 $1C $29CCW $E9 $002EW							#if lvl11 = 7, change sprite action
		  $83 $3E $7A6CW $02 $75 $0F												#if game is in NORMAL mode...
		  $83 $3E $7A34W $05 $75 $17 $C7 $44 $1C $29CCW $E9 $0018W							#if lvl11 = 5, change sprite action
		  $83 $3E $7A34W $03 $75 $08 $C7 $44 $1C $29CCW $E9 $0009W							#if lvl11 = 3, change sprite action (for EASY mode)
		  $FF $06 $7A34W														#increment lvl11 counter
		  $C7 $44 $1C $29AEW 													#change sprite action to the one that leads to boss resuming routine
		  $5E $5D $CB
#difficulty = 7A6CW
#lvl11 = 7A34W

#behaviour - after a while, change sprite action - for head scratching - $11A2011FRL
%patch $11B3F $55 $8B $EC $56 $8B $76 $06 
		  $C7 $47 $06 $0000W   
		  $C7 $47 $20 $0002W   
		  $FF $44 $3E $8B $44 $3E $3D $000AW $75 $0A									#incr. 3E until its 6, then...
		  $C7 $44 $1C $2A26W 													#change sprite action
		  $C7 $44 $3E $0000W 
		  $5E $5D $CB

#behaviour - make sprite (knock out stars) - $11A208D7RL
%patch $122F7 $55 $8B $EC $56 $8B $76 $06 $B8 $0001W  $50 $9A $06BD1E11RL
              $83 $C4 $02 $8B $1E $D8 $A7 $C7 $47 $20 $0003W $C7 $47 $02 $0002W $C7 $47 $06 $0000W 
              $8B $44 $0A $89 $47 $0A $8B $44 $28 $2D $0250W 								#the $2D $XXXXW at the end is how far up the stars comes out from
	        $89 $47 $0C $B8 $2A62W $50 $53 $9A $09DC118CRL      $83 $C4 $04 
		  $5E $5D $CB

#behaviour - make sound and change action after a while (for knock out stars) - $11A20F71RL
%patch $12991 $55 $8B $EC $56 $8B $76 $06 
		  $B8 $0012W  $50 $9A $187409F1RL $83 $C4 $02 								 	#create sound
		  $FF $44 $3E $8B $44 $3E $3D $000EW $75 $0A									#incr. 3E until its 6, then...
		  $C7 $44 $1C $0000W 													#change sprite action (to nothing - disappear)
		  $C7 $44 $3E $0000W 
		  $5E $5D $CB

#this collision sets the level state to 13 which wins the game, from levellass. - $06BD0058RL
%patch $6C28 $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $C6 $4C $83 $3D
              $02 $75 $06 $C7 $06 $7A70W  $000DW $5F $5E $5D $CB #$EB $7E
#29
#State 13 wins game
%patch $6BD9 $0EB2W



############################################################################################################################################################################################## 'BOSS BALLOON'

#this is a balloon that floats in a spot, and when the boss touches it, it 'pops'.

%patch $EEA3 $026AW #Schoolfish 



#init. code
%patch $EB5A $FF $76 $FC $57 $9A $1A891A46RL $83 $C4 $04 $E9 $0294W

#spawn code - $1A891A46RL
%patch $1C2D6 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0016W  $C7 $47 $02 $0001W  $C7 $47 $20 $0000W
              $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 
		  $89 $47 $3E $89 $47 $0C $C7 $47 $10 $0001W  
		  $B8 $2846W $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#$2846W 
%patch $316B6 $0199W $0199W $0003W $0000W $0000W $000FW $0000W $0000W
		  $11A20E01RL $00000000L $09DC176ERL    $2864W 
#$2864W 
%patch $316D4 $019AW $019AW $0003W $0000W $0000W $000FW $0000W $0000W
		  $11A20E01RL $00000000L $09DC176ERL    $2846W 
#'Pop!' - $2882W
%patch $316F2 $019BW $019BW $0000W $0000W $0000W $0040W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL    $0000W 








######################################################################################################################################################################################### SPRINGY MUSHROOM

#makes Keen jump really high.
#taking over Mad Mushroom's stuff.

#Cache
%patch $306E8 $0156W #Mushroom Cache start
%patch $30732 $0158W #Mushroom cache end

#what the first sprite action is in the spawning code
%patch $FF05 $2102W 

#still - $2102W 
%patch $30F72 $0156W $0156W $0002W $0000W $0000W $0000W $0000W $0000W
		  $00000000L $10800610RL $09DC176ERL $2102W 
#springs - $21B6W
%patch $31026 $0158W $0158W $0000W $0000W $0000W $000BW $0000W $0000W
		  $00000000L $00000000L $09DC176ERL $21D4W 
%patch $31044 $0157W $0157W $0000W $0000W $0000W $0020W $0000W $0000W
		  $00000000L $00000000L $09DC176ERL $2102W 
#Keen being launched into the air - $21F2
%patch $31062 $0090W $0088W $0003W $0000W $0000W $0020W $0000W $0000W
		  $0FA80493RL $00000000L $0B801C48RL    $11C0W 

#collision - If you use any jump action on mushroom (i.e if you jump on it) will 
#change Keen's sprite action - overtaking berkeloid's walking sprite-tile intrc. - $10800610RL    
%patch $10E10 $55 $8B $EC $56 $57 $8B $7E $06 $8B $76 $08 $81 $7C $1C $11C0W 
              $74 $1C $81 $7C $1C $1166W $74 $15 $81 $7C $1C $1184W $74 $0E $81 $7C $1C $11A2W $74 $07 $81 $7C $1C $11C0W $75 $2D
              $B8 $21B6W $50 $57 $9A $09DC120ARL $B8 $21F2W $50 $FF $36 $D6 $A7 $9A $09DC120ARL $83 $C4 $04
   		  $83 $C4 $04 $B8 $001CW 
              $50 $9A $187409F1RL     $83 $C4 $02 $C7 $05 $0001W  $5F $5E $5D
              $CB

#at 10E6F after this ^

#behaviour - throws Keen into the air/makes big jump - overtaking Mad Mushroom's behaviour 
#(the mad mushroom's collision comes right after this code, so i can put the sound code in here rather than above) - $0FA80493RL 
%patch $FF13 $55 $8B $EC $56 $8B $76 $06 $C7 $44 $16 $0000W $C7 $44 $18 $FF95W $C7 $06 $21 $C9 $0000W $C7 $06 $BB $CA $0002W $C7 $44 $1C $66 $11 $5E $5D $CB





############################################################################################################################################################################# INVINCIBILITY POTION/'POWERUP'

#overtaking first 'blank' tile spawning spot
#%patch $EED1 $0122W

#overtaking lindsey's initiation/spawning code.
#%patch $EA12 

#Lindsey spawn code - DONT USE THIS SPOT
#%patch $127D5 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
#              $D8 $A7 $C7 $07 $000DW  $C7 $47 $06 $0000W  $C7 $47 $20 $0003W
#              $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05
#              $FF00W  $89 $47 $3E $89 $47 $0C $C7 $47 $10 $0001W  $B8 $38EAW
#              $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#potion bottle actions - $38EAW 
#%patch $3275A $00D2W $00D2W $0003W $0000W $0000W $0020W $0000W $0000W
#		  $11A20E01RL $1080080FRL   $09DC176ERL $3908W   
#%patch $32778 $00D3W $00D3W $0003W $0000W $0000W $0020W $0000W $0000W
#		  $11A20E01RL $1080080FRL   $09DC176ERL $38EAW 
#actual invincibility power actions - $3926W 
#%patch $32796 $00D4W $00D4W $0003W $0000W $0000W $0001W $0040W $0000W
#		  $11A20AF6RL $00000000L   $09DC176ERL $3944W 
#%patch $327B4 $00D5W $00D5W $0003W $0000W $0000W $0001W $0040W $0000W
#		  $0B800B5BRL $00000000L   $09DC176ERL $3926W 

#collision - produces different sprite action; produces sound; sets sprite type to 3 (same as Keen's shot) - taking over more of the inchworm collision - $1080080FRL   
#%patch $1100F $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $15
 #             $C7 $44 $1C $3926W $B8 $0006W $50 $9A $187409F1RL  $83 $C4 $02 $C7 $04 $0003W
#		  $5F $5E $5D $CB

#%patch $1253C $0040W
#%patch $12558 $0040W
#%patch $1256C $0040W

#Schoolfish behavior code
#%patch $12516 $55 $8B $EC $56 $8B $76 $06 $83 $7C $3E $00 $75 $18 $8B $44 $0A #If Keen is level with fish, skip l\r stuff
#              $8B $1E $D6 $A7 $3B $47 $0A $73 $07 $C7 $44 $0E $0001W  $EB $05 #Check for Keen h, set h direction
#              $C7 $44 $0E $FFFFW  $B8 $0080W  $50 $FF $74 $0E $56 $9A         #Set h speed = $A
#         $09DC149FRL  $83 $C4 $06 $8B $44 $0C $8B $1E $D6 $A7 $3B $47 $0C $73 #Check for Keen v
#              $14 $B8 $0080W  $50 $B8 $0001W  $50 $56 $9A $09DC1517RL     $83 #Set v speed and direction
#              $C4 $06 $5E $5D $CB $B8 $0080W  $50 $B8 $FFFFW  $50 $56 $9A
#              $09DC1517RL $83 $C4 $06 $5E $5D $CB

#%patch $12516 $55 $8B $EC $56 $8B $76 $06 $83 $7C $3E $00 $75 $18 $8B $44 $0A 
#		   $83 $1E $D6 $A7 $3B $47 $0A $73 $07 $C7 $47 $0E $0001W $EB $05
#		   $C7 $47 $0E $FFFFW $B8 $0040W  $5E $5D $CB




################################################################################################################################################################################# 'STARS' FOR STUNNED SPRITES

#List
%patch $B7E2 $19CBW #B78B: 8
             $19CEW #B78E: 9
             $19CEW #B78E: 9
             $1997W #B757: 2
             $19CEW #B78E: 9
             $19CEW #B78E: 9
             $19CEW #B78E: 9
             $19B2W #B772: 5
             $19CEW #B78E: 9
             $19CEW #B78E: 9
             $19A8W #B768: 4
             $19C1W #B781: 7
             $19CEW #B78E: 9
             $19BCW #B77C: 6
             $1992W #B752: 1
             $19CEW #B78E: 9
             $19CEW #B78E: 9
             $19CEW #B78E: 9
             $19CEW #B78E: 9
             $19CEW #B78E: 9
             $19CEW #B78E: 9
             $19A1W #B761: 3

#Type 1
%patch $B752 $BF $FF00W  $EB $37

#Type 2
%patch $B757 $C7 $46 $FE $0080W  $BF $FF80W  $EB $2D

#Type 3
%patch $B761 $C7 $46 $FE $0080W $EB $26

#Type 4
%patch $B768 $C7 $46 $FE $0040W  $BF $FF80W $EB $1C

#Type 5
%patch $B772 $C7 $46 $FE $0040W  $BF $FEA2W  $EB $12

#Type 6
%patch $B77C $BF $FF80W  $EB $0D

#Type 7
%patch $B781 $C7 $46 $FE $FFC0W  $BF $FF80W  $EB $03

#Type 8 (Same as type 6) (for slug)
%patch $B78B $BF $FF00W #highest i can get it 

#Type 9 (No changes made)

#Star animations
%patch $B7BD $00A4W #Animation used
%patch $B7B3 $0002W #Number of frames
%patch $B7A9 $0002W 





########################################################################################################################################################################################### COLOUR PALETTES

#Story background palette:
%patch $2F05E $00 $00 $00 $00 $05 $00 $00 $00 #Dark colors
              $1A $1A $1A $1A $1A $1A $1A $1A #Light colors

%patch $1AA06 $04         #Selected text color
%patch $1AA0D $1D         #Unselected text color

%patch $1AA40 $1D         #Menu bottom text color

%patch $1AE6C $04 #Top text
%patch $1AEA3 $1D #Bar in the middle
%patch $1AEC8 $1D #Bottom text

#MENU
%patch $1AC5B $00 #Background color 
#%patch $1AE6C $00 #Top text
%patch $1AEA3 $00 #Bar in the middle

%patch $1A9CC $00 #size of menu box

%patch $1AB14 $00         #Top line color (Light green)
%patch $1AAC1 $00         #Bottom line color (Light green)

%patch $1B35E $04         #Changing key box color 2 
%patch $1B381 $04         #Changing key box
%patch $1B64F $04
%patch $1B987 $04
#%patch $1BC7E $04 #Text color modifier
%patch $1BEA7 $00 #Box background color
%patch $1BFB1 $04

#Load menu
#%patch $1CC69 $04 #Unknown text color (Black)
#%patch $1CD8E $04 #Loading menu text (Black)

#%patch $1B2F6 $04 #Control text

#%patch $1AABF $04







################################################################################################################################################################################################ TMP PATCHES

#This causes a sprite to make Keen slide as he walks- good for ice terrains or escalators or whatever.
#collision - changes Keen's sprite action when you're touching the sprite, otherwise turns him back to normal - $1FE409BBRL
#%patch $207FB $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $81 $7C $1C $36CEW $74 $15			#If it touches Keen, then...
#		  $B8 $36CEW $50 $FF $36 $D6 $A7 $9A $09DC120ARL $83 $C4 $04 					#change Keen to 'swimming' sprite action.
#		  $83 $3D $02 $75 $10												#if touching Keen again...
#		  $B8 $10B2W $50 $FF $36 $D6 $A7 $9A $09DC120ARL $83 $C4 $04 					#turns Keen into an ordinary sprite action/back to normal.
#		  $5F $5E $5D $CB	




################################################################################################################################################################################################### NOTES

#In the Kreeg Infantry enemy code- the 'produce shot' behaviour is taking over some section that isn't text, so it *may* cause issues
#(may be related to demos). Try moving it if theres some weird errors that i can't fix.

#You can also use he space at $3D740 onwards in the data segment (Past the end of the executable.) This is $2EE7E8D0RL as a pointer and gives you a good snippet of space. 
#The F10+Y and F10+D cheats also produce a big volume of space if disabled. (Demos at least can be recorded by temporarily disabling the relevant patches, recording the demo the re-enabling.)

#this code turns Keen's sprite into any sprite action you want.
#$B8 $21F2W $50 $FF $36 $D6 $A7 $9A $09DC120ARL $83 $C4 $04

#about councilman icons popping up in highscores:
#from highscores section: 'these changed stats also seem to stop the councilmen popping up in the highscores - but some could also be for something else. so if any issues with
#councilman stuffs, check these out.'

#NOTE: don't use Lindsey spawn code at $127D5 - schoolfish spawn code, before that, is cutting into it a bit.

%end