%ext ck5
%version 1.4

#Patch files
%egahead EGAHEAD.CK5             # Load the modified graphics
%maphead maphead.ck5             # Load gamemaps
%patchfile $25B22 keen5.tli      # Load modified tiles

#Optimize memory for faster load times
%patch $13CC9                                                 $55 $8B $EC $56  
             $57 $8C $DA $C4 $7E $0A $C5 $76  $06 $8B $4E $0E $D1 $E9 $FC $F3  
             $A5 $73 $01 $A4 $8E $DA $5F $5E  $5D $CB


#########################
#    Star Wars Text     #
#########################

#Story background palette:
%patch $304DE $00 $01 $02 $03 $04 $10 $06 $07 #Dark colors
              $1F $1F $1F $1F $1F $1F $1F $1F #Light colors

%patchfile $1FDE0 "STORY.CK5"	 #'star wars text' story


#########################
# Terminator text	#
#########################

#Terminator text palette:
%patch $304F8 $00 $0A $0A $1A $01 $01 $01 $01     #Dark colors
              $11 $11 $11 $11 $13 $13 $13 $13 $00 #Light colors (and border color)


#Terminator text palette 2, screen moves out:
%patch $30509 $00 $0A $0A $1A $01 $01 $01 $01     #Dark colors
              $11 $11 $11 $11 $13 $13 $13 $0A $00 #Light colors (and border color)


#########################
#     Screen Stuff      #
#########################

%patchfile $20cd7 ck5load.bin

#Fix small error with end screen
%patch $3036F $00


#########################
# Game over stuff	#
#########################

#Remove galaxy explode sequence
%patch $F6E2 $EB $0A
%patch $F664 $EB $0A
%patch $F6B1 $EB $0E
%patch $F714 $EB $0A
%patch $F725 $90 $90


#########################
#      Cheats stuff     #
#########################

#This removes the F10 key 
#patch $7A79 $90 $90

#Debug keys always on
%patch $7A72 $90 $90

#Disable F10-C cheat, broken and we need the space
%patch $7401 $EB $19

#Disable sprite test cheat (Free 390 bytes at $6CEE)
%patch $7679 $EB $12

#Warp cheat can access all levels
%patch $7799 $17

#Text
%patch $30864 " Warp to which level(1-23):" $00


################
#  Highscores  #
################

#High Scores
%patch $33D56 "Id Software - '91"
%patch $33D96 "Bubbatom         "
%patch $33DD6 "Levellass        "
%patch $33E16 "thehackercat     "
%patch $33E56 "_mr_m_           "
%patch $33E96 "                 "
%patch $33ED6 "Scudder          "
%patch $33F16 "                 "


################
# Flag stuff   #
################

#Shrink Map Keen cache (Also caches map blocker)
%patch $31A80 $0110W #Cache end

#Move flag animations
%patch $317CA $010CW $010CW
%patch $317E8 $010DW $010DW
%patch $31806 $010EW $010EW
%patch $31824 $010FW $010FW


####################################################################################
#  Allow 24 levels in Keen 5 v1.4:                                                 #
#  First increase the number of levels we can access from the map to maximum (+6)  #
####################################################################################


%patch $D2C2 $18 #Number of levels enterable ($18 = 24)
%patch $8C20 $1C #Number of level song entries (28, includes ending, G.O., story and help!)

#BwB levels: Level 10 only
%patch $60B3 $0A $74

#Level entrance pointers
%patch $31B18 $201A0000RL #Level 0
              $201B000ERL #Level 1
              $201D000ARL #Level 2
              $201F000ERL #Level 3
              $20210009RL #Level 4
              $20230005RL #Level 5
              $2025000BRL #Level 6
              $20210009RL #Level 7
              $20280001RL #Level 8
              $20210009RL #Level 9
              $202A0003RL #Level 10
              $202D0000RL #Level 11
              $202F0002RL #Level 12
              $20320003RL #Level 13
              $20350004RL #Level 14
              $20370004RL #Level 15
              $203A0005RL #Level 16
              $20210009RL #Level 17
              $203C000DRL #Level 18
              $20210009RL #Level 19
              $203F0007RL #Level 20
              $20210009RL #Level 21
              $2041000CRL #Level 22
              $20210009RL #Level 23

#Level name pointers
%patch $31AB4 $201B0002RL #Level 0
              $20440001RL #Level 1
              $201E000DRL #Level 2
              $20450003RL #Level 3
              $20460007RL #Level 4
              $20470005RL #Level 5
              $20480008RL #Level 6
              $20480008RL #Level 7
              $2049000DRL #Level 8
              $2049000DRL #Level 9
              $204A000FRL #Level 10
              $202E0005RL #Level 11
              $204C0006RL #Level 12
              $204D0005RL #Level 13
              $20360008RL #Level 14
              $20390009RL #Level 15
              $204D000DRL #Level 16
              $204D000DRL #Level 17
              $204D000DRL #Level 18
              $204D000DRL #Level 19
              $2040000ERL #Level 20
              $204E000CRL #Level 21
              $20430001RL #Level 22
              $204F0007RL #Level 23

#Level texts
%patch $201A0 "Keen races around" $0A
              "The Suburbs" $00
%patch $201BE "Keen awakens to his" $0A
              "Bedroom" $00
%patch $201DA "Keen wades through" $0A
              "The Sewer System" $00
%patch $201FE "Keen pigs out at" $0A
              "Scudder's" $00
%patch $20219 "Keen reaches the" $0A
              "Checkpoint" $00
%patch $20235 "Keen darts through" $0A
              "the Deserted Block" $00
%patch $2025B "Keen slinks into The" $0A
              "Unoccupied House" $00
%patch $20281 "Keen calls into The" $0A
              "Casey's Place" $00
%patch $202A3 "Keen takes a break" $0A
              "in the Backyard" $0A
              "Clubhouse" $00
%patch $202D0 "Keen barges into the" $0A
              "Golden House" $00
%patch $202F2 "Keen jumps the fence" $0A
              "to the Bleach" $0A
              "Colored House" $00
%patch $20323 "Keen clambers onto" $0A
              "the Bus roof to find" $0A
              "Mortimer" $00
%patch $20354 "Keen intrudes in on" $0A
              "The Mansion" $00
%patch $20374 "The Player cheats" $0A
              "their way into the" $0A
              "High Scores" $00
%patch $203A5 "Keen ends up at the" $0A
              "Neighbor's Backyard" $00
%patch $203CD "Keen arrives at the" $0A
              "Neighbor's Front" $0A
              "Yard" $00
%patch $203F7 "Keen tramples over" $0A
              "the Cosy Dwelling" $00
%patch $2041C "Keen trespasses into" $0A
              "Mr Jenkins Yard" $00
%patch $20441 "The Blaze's Place" $00
%patch $20453 "Scudders Burger Bar" $00
%patch $20467 "The Storeroom" $00
%patch $20475 "The Deserted Block" $00
%patch $20488 "The Unoccupied House" $00
%patch $2049D "The Casey's Place" $00
%patch $204AF "The Backyard" $0A
              "Clubhouse" $00
%patch $204C6 "Bleached House" $00
%patch $204D5 "The Bus" $00
%patch $204DD "The Neighbor's" $00
%patch $204EC "The Garden" $00
%patch $204F7 "Mr Jenkins House" $00


##########################
#    Musics and Sounds   #
##########################

#Keenwave patch file; Patch sounds Keen 5:
%patchfile $21C80 AUDIOHED.CK5	#Audio header

#Add two extra songs:
#Index of first music chunk within audio chunks:
%patch $8C61 $00BEW

#Start address of music chunks
%patch $8BF1 $BF41W #Clear_music()
%patch $8BFF $BF41W #Clear_music()
%patch $8CF5 $BF41W #StartMusic()
%patch $8C0D $10    #Total Number of Songs


###############################################
#   This is the music played in each level:   #
###############################################

#             VALUE   LEVEL                      MUSIC PLAYED            LEVEL No
%patch $3067A $0000W #Map                       (Rio Funk)                0
              $0006W #Blazes                    (Keen Sense)              1
              $0008W #Sewer                     (Serious Business)        2
              $0009W #Scudder's Burger Bar 1    (Baddest Genius)          3
              $0001W #Scudder's Byrger Bar 2    (4 foot hero)             4
              $0004W #Deserted                  (Hillville)               5
              $0007W #House 1                   (Keens Machine)           6
              $0009W #House 2                   (Baddest Genius)          7
              $0001W #Caseys                    (Tricked)                 8
              $0005W #Caseys2                   (The Commander)           9
              $000EW #ClubH                     ()                        10
              $0004W #Yellow n White            (HillVille)               11
              $0005W #Yellow n White 2          (The Commander)           12
              $0001W #Bus Battle                (MisirKeen 2)             13
              $0003W #Mansion                   (Sidewalk Shuffle)	  14
              $000DW #High Scores               (Tricked)                 15
%patch $3069C $000AW #Neighbour's 1             (4 Foot Hero)		  16
              $000CW #Neighbour's 2             ()			  17 --------
              $000CW #Neighbour's 3             (Keen Machine)  	  18
              $0002W  #Neighbour's 4            (Herbie 2)                19 --------
              $0004W  #Cosey Dwelling           (Hillville)               20
              $0002W  #Garden                   (Tricked)                 21
              $0007W  #Mr Jenkins               (Keen Machine)            22
              $000AW  #Mr Jenkins               (4 foot hero)             23
              $000DW  #End Sequence (NO LEVEL!) (Soul Genius)             N/A
              $000BW  #Help menu (NO LEVEL!)    (The Keenest)             N/A
              $000CW  #Game Over (NO LEVEL!)    (Night)                   N/A
              $0007W  #Story (NO LEVEL!)        (Night)                   N/A

#End sequence song: 24
%patch $EC67 $0018W

#Help sequence song: 25
%patch $EABD $0019W

#Ending sequence: 26
%patch $EC67 $001AW

#Game over: 27
%patch $F808 $001BW


#############################
#  You didn't make it past: #
#############################

#Level end text
%patch $305E3 "You didn't make it past"
%patch $305FB "Try Again"
%patch $30605 "  Exit to Suburbs "



###################################
#              Misc               #
###################################

#Status bar
%patch $30907 "KEYS" $00 
              "AMMO" $00 
              "KEENS" $00 
              "ENERGY " $00

#Change keycard text
%patch $308E8 "BAG" $00

###################################
#   Custom door sizes in Keen 5   #
###################################

#Disable EGAGRAPH check in Keen 5 (Frees 389 bytes at $3CF0)
%patch $3CDF $90 $90

#New-door opening code
%patch $3CF0 $55 $8B $EC $83 $EC $26 $56 $57 $8D $46 $DA $8B $F8 $8B $5E $06
             $8B $5F $0C $D1 $E3 $8B $87 $87 $BF $D1 $E8 $D1 $E0 $8B $16 $51
             $9E $8B $5E $06 $8B $5F $0A $D1 $E3 $03 $C3 $89 $56 $FC $89 $46
             $FA $C7 $46 $FE $00 $00 $EB $29 $33 $F6 $EB $15 $8B $C6 $D1 $E0
             $C4 $5E $FA $03 $D8 $26 $8B $07 $2D $0004W  $89 $05 $83 $C7 $02 #Door width in tileset
             $46 $83 $FE $04 $7C $E6 $FF $46 $FE $A1 $4C $9E $D1 $E0 $01 $46
             $FA $83 $7E $FE $04 $7C $D1 $B8 $0004W  $50 $B8 $0004W  $50 $8B #Door size h AND v = 4x4
             $5E $06 $FF $77 $0C $FF $77 $0A $B8 $0001W  $50 $16 $8D $46 $DA
             $50 $9A $174E0F25RL     $83 $C4 $0E $5F $5E $8B $E5 $5D $CB

#Alter door actions to use new V-card type behavior
%patch $318F6  $0000W $0000W $0000W $0000W $0000W $000FW $0000W $0000W
               $037D0520RL   $00000000L    $00000000L    $15D4W
%patch $31914  $0000W $0000W $0000W $0000W $0000W $000FW $0000W $0000W
               $037D0520RL   $00000000L    $00000000L    $15F2W
%patch $31932  $0000W $0000W $0000W $0000W $0000W $000FW $0000W $0000W
               $037D0520RL   $00000000L    $00000000L    $0000W

##################################################
# Automatically win game when entering level 13: #
##################################################

%patch $D2E6 $0F920545RL
%patch $FE65 $55 $8B $EC $56 $8B $76 $06 $83 $3E $6F68W  $0D $75 $06 $C7 $06
             $6F70W $000FW   $EB $0C $B8 $000CW  $50 $9A $196E09EFRL     $83
             $C4 $02 $5E $5D $CB

#########################
#Uplev\Winlev sprites	#
#########################

#Compact left\right Keen spawn to create space $EE96-EEBA
%patch $EEBB $B8 $0001W $EB $03

#Keen right uses compact spawn (At $EEBB)
%patch $F4C6 $016BW

#New sprite spawn 1 (Goes to end of spawn 2)
%patch $EE96 $57 $56 $9A $06B90000RL    $EB $07

#New sprite spawn 2 both cache $0110
%patch $EE9F $57 $56 $9A $06B9003ARL     $83 $C4 $04 $B8 $2B7BRW  $8A $16
             $EC $6F $8E $C0 $26 $08 $16 $0110W  $E9 $04EDW

#Pointers to new sprites
%patch $F59C $0146W #Uplevel (At $EE96)
%patch $F59E $014FW #Winlevel (At $EE9F)

#Uplevel spawning code = $06B90000RL
%patch $6B90 $55 $8B $EC $33 $C0 $50 $9A $06B91DCDRL     $83 $C4 $02 $8B $1E
             $40 $9E $C7 $07 $0006W  $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A
             $8B $46 $08 $D3 $E0 $89 $47 $3E $89 $47 $0C $B8 $00F2W  $50 $53
             $9A $090B11C4RL     $83 $C4 $04 $5D $CB

#Winlevel spawning code = $06B9003ARL
%patch $6BCA $55 $8B $EC $33 $C0 $50 $9A $06B91DCDRL     $83 $C4 $02 $8B $1E
             $40 $9E $C7 $07 $0006W  $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A
             $8B $46 $08 $D3 $E0 $89 $47 $3E $89 $47 $0C $B8 $0110W  $50 $53
             $9A $090B11C4RL     $83 $C4 $04 $5D $CB

#Uplevel action = $00F2
%patch $30432 $0110W $0110W $0002W $0000W $0000W $0000W $0000W $0000W
              $00000000L    $06B9015ERL   $090B17B5RL   $00F2W

#Winlevel action = $0110
%patch $30450 $0110W $0110W $0002W $0000W $0000W $0000W $0000W $0000W
              $00000000L    $06B9017ERL   $090B17B5RL   $0110W

#Uplevel collision: increment curr_lev and set level state to restart level = $06B9015ERL
%patch $6CEE $55 $8B $EC $56 $57 $8B $7E $06 $8B $76 $08 $81 $7C $1C $127EW
             $7F $0A $FF $06 $6F68W  $C7 $06 $6F70W  $0003W  $5F $5E $5D $CB

#Winlevel collision: mark previous level as done and set level state to win level = $06B9017ERL
%patch $6D0E $55 $8B $EC $56 $57 $8B $7E $06 $8B $76 $08 $81 $7C $1C $127EW
             $7F $12 $8B $1E $55 $9E $D1 $E3 $C7 $87 $6F1AW  $0001W  $C7 $06
             $6F70W  $0002W $5F $5E $5D $CB


################################
# Text Boxes and Keycard Stuff #
################################

#Don't lose  V card on starting a level
%patch $6A2B $EB $04 

#Display Card only if Keen has actually got card (+2!)
%patch $7E34 $02 $75 

#Items cheat gives card properly (+2!)
%patch $7513 $6F5AW $0002W 

#V Card is now Card Objects (Mom, Card and Lev 13 Block)
%patch $F550 $03B7W #Card Objects (At $F107) 

#QED\Fuse spawns Card Objects
%patch $F107 $57 $56 $9A $11C41D56RL     $83 $C4 $04 $C7 $06 $C2A1W  $0001W 
             $E9 $028DW 

#Card Objects spawn code; spawn on leves: 1:Mom, 0:Block, Else:Card =$11C41D56RL 
%patch $13996 $55 $8B $EC $33 $C0 $50 $9A $06B91DCDRL     $83 $C4 $02 $8B $1E 
              $40 $9E $C7 $07 $000FW  $C7 $47 $02 $0002W  $C7 $47 $20 $0000W 
              $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $3E $89 $47 $0A $8B $46 $08 
              $D3 $E0 $89 $47 $0C $83 $3E $6F68W  $00 $74 $0C $83 $3E $6F68W
              $01 $74 $0A $B8 $1AE6W  $EB $08 $B8 $1B22W  $EB $03 $B8 $3186W
              $50 $53 $9A $090B11C4RL     $83 $C4 $04 $5D $CB

#Mom action: sit invisible (Uses uplev invisible sprite) =$3186W 
%patch $334C6 $0110W $0110W $0000W $0000W $0001W $0014W $0000W $0000W 
              $00000000L    $06B901A6RL   $090B17B5RL   $3186W

#Mom collision: If Keen, 0-card activate fuse window, sound, upcard, refresh screen =$05C10E69RL
%patch $6D36 $55 $8B $EC $56 $8B $76 $08 $83 $3C $02 $75 $27 $83 $3E $6F5AW
             $00 $75 $20 $FF $06 $6F5AW  $B8 $000DW  $50 $9A $196E09EFRL
             $83 $C4 $02 $9A $0ED50AF4RL     $C7 $06 $6F70W  $0006W  $9A
         $0CCB0153RL     $5E $5D $CB

#Card actions: sit and animate =$1AE6W
%patch $31E26 $00CFW $00CFW $0000W $0000W $0001W $0014W $0000W $0000W 
              $00000000L    $06B90E68RL   $090B17B5RL   $1B04W 
%patch $31E44 $00D0W $00D0W $0000W $0000W $0001W $0014W $0000W $0000W 
              $00000000L    $06B90E68RL   $090B17B5RL   $1AE6W 

#Card collision: If Keen card=2, state=dofuse =$06B90E68RL 
%patch $79F6 $EB $5C $55 $8B $EC $56 $8B $76 $08 $83 $3C $02 $75 $0C $C7 $06
             $6F5AW  $0002W  $C7 $06 $6F70W  $000EW  $5E $5D $CB

#Change fuse cal to complete BOTH Scudders levels
%patch $6A8B $8B $1E $55 $9E $D1 $E3 $C7 $87 $6F1AW  $0001W $9A
             $0ED50AF4RL     $EB $30

#Map blocker action: Also sit invisible =$1B22W
%patch $31E62 $0110W $0110W $0002W $0000W $0001W $0014W $0000W $0000W 
              $00000000L    $06B90E83RL   $090B17B5RL   $1B22W

#Map blocker collision: If rightkey, not 2 card then do-window, =$06B90E83RL
%patch $7A13 $55 $8B $EC $56 $8B $76 $08 $83 $3E $6F5AW  $02 $74 $29 $83 $3E
             $9E36W  $01 $75 $22 $C7 $44 $1C $13B6W  $B8 $000EW  $50 $9A
         $196E09EFRL     $83 $C4 $02 $9A $0ED50AF4RL     $C7 $06 $6F70W
         $0006W  $C7 $06 $9E36W  $0000W  $5E $5D $CB

#New fuse window: 3 unique messages =$9A $0ED50AF4RL
%patch $F844 $55 $8B $EC $9A $196E0AFBRL     $9A $13A014CARL     $B8 $2B7BRW
             $8A $16 $EC $6F $8E $C0 $26 $08 $16 $005AW  $8E $C0 $26 $08 $16
             $005BW  $33 $C0 $50 $9A $13A01848RL     $83 $C4 $02 $9A $1E000995RL
                     $B8 $0008W  $50 $B8 $001AW  $50 $9A $1A2B106ERL     $83
             $C4 $04 $83 $2E $99 $9B $30 $B8 $005AW  $50 $FF $36 $46 $9E $A1
             $9B $9B $03 $06 $99 $9B $50 $9A $1E000C75RL     $83 $C4 $06 $83
             $06 $9D $9B $0C $83 $3E $6F68W  $00 $74 $11 $83 $3E $6F68W  $01
             $74 $05 $B8 $E140W  $EB $08 $B8 $0004W  $EB $03 $B8 $E0C0W  $50
             $9A $1A2B0EBBRL     $83 $C4 $02 $9A $1E000A97RL     $B8 $001EW
             $50 $9A $1F030ADFRL     $83 $C4 $02 $9A $155A08A5RL     $9A
         $155A0EDCRL     $B8 $005BW  $50 $FF $36 $46 $9E $A1 $9B $9B $03 $06
             $99 $9B $50 $9A $1E000C75RL     $83 $C4 $06 $9A $1E000A97RL
             $9A $155A08A5RL     $9A $155A0EDCRL     $9A $13A014EARL     $9A
             $06B9204ERL     $5D $CB

#Mom message (Level 1) =$0004W
%patch $30344 "I'm off now!" $0A
              "I'll see you later" $0A
              "tonight. Bye!" $00

#Map block message (Level 0) =$E0C0W
%patch $3E400 "My school bag" $0A 
              "isn't here." $0A
              "I'm not getting on the" $0A
              "bus until I've found it!" $00

#Card message (Other levels) =$E140W
%patch $3E480 "Hey, what did I tell you?" $0A
              "I'll have to get my" $0A
              "brother back for this!" $0A
              "Now I can catch the bus!" $00

#######################################
#                                     #
#   ___---===Enemy Patches===---___   #
#                                     #
#######################################

#########################
#Stun star fixes	#
#########################

#Exceptions
%patch $AA7A $3D $15 $00 $74 $0C #Shikadi goto type 1
%patch $AA7F $3D $0E $00 $74 $0D #Ampton goto type 2
%patch $AA84 $3D $10 $00 $74 $10 #Volte Face goto type 3

#Type 1: Larger value is higher up
%patch $AA8B $81 $EF $00A0W  $EB $08

#Type 2: Larger value is higher up
%patch $AA91 $81 $EF $00B0W  $EB $06 $EB $04

#Type 3
%patch $AA99 $81 $EF $0080W

#No stun stars for Shikadi
%patch $33194 $090B17B5RL


#########################
#   Shelley - Beehive   #
#########################

#Shelley explode on contact with Keen 
%patch $11AAE $90 $90 $90 $90 $90 
%patch $11AC0 $EB

#Smash smoke harmless 
%patch $32896 $00000000L
%patch $328B4 $00000000L
%patch $328D2 $00000000L
%patch $328F0 $00000000L

#Fragments harmless 
%patch $3290E $00000000L
%patch $3292C $00000000L

#Shelley just sits there (No animation, no attack)
%patch $3275A $0002W
%patch $3276E $090B17B5RL

#Shelley has ONE animation
%patch $32756 $01ACW $01ACW

#Shelley smash spawns sphereful (bees) 
%patch $11A5A $303AW

#Shelley fragment right
%patch $11A52 $0007W #Width 
%patch $11A57 $0000W #Height


########################
#   Sphereful - Bees   #
########################

#Sphereful slaved to Shelley: change cache, free 16K memory!
%patch $31A34 $01ADW #Sphereful cache start
%patch $31A88 $01B4W #Cache end

#Don't make sounds:
%patch $13727 $90 $90 $90 $90 $90 #Sphereful hit walls
%patch $13741 $90 $90 $90 $90 $90 #Sphereful hit ceiling
%patch $13787 $90 $90 $90 $90 $90 #Sphereful hit floor

#Slave Sphereful to Shelley: Change animations
%patch $3337A $01ADW $01B0W
%patch $33398 $01AEW $01AFW
%patch $333B6 $01AFW $01AEW
%patch $333D4 $01B0W $01ADW

#Slave Sphereful to Shelley: Change diamond animations
%patch $137C0 $01B1W


#########################
#  Korath - Pitchforker #
#########################

#Korath are deadly, shootable
%patch $13956 $55 $8B $EC $56 $8B $76 $08 $83 $3C $02 $75 $08 $9A $0AAF1517RL #Check for Keen, if yes, kill
                      $5E $5D $CB $83 $3C $03 $75 $10 $B8 $3168W  $50 $56 $FF #Check for Keen shot, if yes, stun
                  $76 $06 $9A $090B16CDRL     $83 $C4 $06 $5E $5D $CB

#Korath seeks Ken after standing
%patch $13921 $55 $8B $EC $56 $8B $76 $06 $9A $1DFB0036RL     $3D $0010W  $7D
              $1D $8B $44 $0A $8B $1E $3E $9E $3B $47 $0A $7D $07 $C7 $44 $0E
              $0001W  $EB $05 $C7 $44 $0E $FFFFW  $C7 $44 $1C $314AW  $5E $5D $CB

#Spawn height - adjusted
%patch $138EC $FDC0W #2 1/4 tiles up

#Cache:
%patch $31A50 $0111W #Korath cache start
%patch $31AA4 $011AW #Cache end

#Move Korath animations for Master boss:
%patch $33412 $0111W $0115W
%patch $33430 $0112W $0116W
%patch $3344E $0113W $0117W
%patch $3346C $0114W $0118W
%patch $3348A $0119W $0119W
%patch $334A8 $011AW $011AW


#########################
#   Shikadi - Janitor   #
#########################

#Shikadi's strength
%patch $12EFA $0003W


#########################
#  Shockshund - Bully   #
#########################

#Shooting Shocksund fires like a Master
%patch $33240 $11C40EDARL

#Shocksund makes Shock shot instead of Master shot
%patch $12B36 $2FA4W

#Shot position
%patch $12B2C $0100W #Horizontal when shooting right
%patch $12B3D $0040W #Vertical

#Shocksund's shot moves like Masters, but with 2 frames
%patch $332F4 $090B172CRL
%patch $33312 $090B172CRL

#Double Shocksund jump height 
%patch $13306 $FFB0W #Random jump 
%patch $13495 $FFB0W #At platform edges 

#Halve Shocksund jump frequency: 
%patch $132C9 $08

#Shocksund's shot's collision transforms Keen
%patch $1358B $56 $9A $037D05AFRL     $83 $C4 $02 $EB $19

#New transform, stun Keen
%patch $3D7F $55 $8B $EC $56 $8B $76 $06 $B8 $014DW  $50 $56
             $9A $090B1242RL     $83 $C4 $04 $5E $5D $CB

#Stunned Keen action (Read book type) =$014DW
%patch $3048D $008EW $008EW $0000W $0000W $0001W $004CW $0000W $0000W
              $00000000L    $0AAF1597RL   $0AAF1AC6RL   $0AFEW

#On death set type = 1 (Unstunnable)
%patch $C023 $C7 $07 $0001W $90 $90

#Type 1 is not removed on falling out of level
%patch $8F6E $01 $7F $EB $3D

#Shocksund starts level in falling action (Negate height)
%patch $13296 $2F86W


#########################
#Spindred - Pogostickers#
#########################

#Basic Patch taken from Keen 9

#Spindred jump height
%patch $12A65 $C8 $FF

#Spindred bounces on the floor exclusively
%patch $12A32 $FF $FF #Bounce 65'535 times on the floor before...
%patch $129E5 $03 $00 #Bouncing 3 times on the ceiling


#########################
#Volteface - SugarChild #
#########################

#Initial Volte-face direction: Right 
%patch $10B93 $C7 $47 $0E $0001W 
%patch $10B10 $0001W 

#New Volte-face actions, act like a horizontal platform 
%patch $3200C $01A1W $01A3W $0003W $0000W $0000W $0006W $0000W $0000W 
              $0F92127ERL   $0F92149DRL   $090B17B5RL   $1CEAW 
%patch $3202A $01A2W $01A4W $0003W $0000W $0000W $0006W $0000W $0000W 
              $0F92127ERL   $0F92149DRL   $090B17B5RL   $1CCCW 

#Stunned Volte-face stuns permanently 
%patch $32084 $01A5W $01A5W $0002W $0000W $0000W $0000W $0000W $0000W 
              $090B1710RL   $00000000L    $090B195ARL   $0000W 

#Custom Volte-Face speed 
%patch $10B9E $55 $8B $EC $83 $EC $04 $56 $57 $8B $7E $06 $83 $3E $85 $BF $00 
              $75 $1F $83 $3E $83 $BF $00 $75 $18 $8B $45 $0E $BA $0020W  $F7 
              $EA $F7 $2E $B4 $9B $A3 $85 $BF $8B $45 $10 $BA $0020W  $E9 
          $F721W  $5F $5E $8B $E5 $5D $CB


#########################
#   Ampton - Gramps     #
#########################

#Ampton takes 3x longer to turn
%patch $3259E $0028W

#Ampton caches pink shots when spawning
%patch $F152 $0021W

#Little Ampton randomly switch flips (SIDE EFFECT: No pole sliding!) =$110202ABRL
%patch $112CB $55 $8B $EC $56 $8B $76 $06 $9A $1DFB0036RL     $3D $0010W  $7D
              $05 $C7 $44 $1C $2308W  $5E $5D $CB

#Ampton shoot behavior =$110202C4RL
%patch $112E4 $55 $8B $EC $56 $57 $8B $76 $06 $83 $7C $0E $01 $75 $0A $8B $44
              $0A $05 $0070W  $8B $F8 $EB $03 $8B $7C $0A $B8 $1E3AW  $50 $8B
              $44 $0C $05 $0190W  $50 $57 $9A $0F920003RL     $83 $C4 $06 $3D
              $FF $FF $74 $21 $8B $44 $0E $BA $003CW  $F7 $EA $8B $1E $40 $9E
              $89 $47 $16 $8B $44 $0E $89 $47 $0E $B8 $001DW  $50 $9A $196E09EFRL
                      $83 $C4 $02 $5F $5E $5D $CB

#Ampton shoot frame (1 frame long, left and right are different)
%patch $32648 $019AW $019BW $0000W $0000W $0001W $0012W $0000W $0000W
              $110202C4RL   $11020615RL   $090B17B5RL   $21DCW

#Pink Shots
#2 frame shot sequence 
%patch $321B4 $1E3AW 

#Shots have different frames moving left and right 
%patch $3217A $00ECW $00EEW 
%patch $32198 $00EDW $00EFW

#Ampton kills Keen if he touches him
%patch $11645 $EB $05

#Don't play Ampton stunned sound
%patch $1167B $EB $0A

#Spawn height
%patch $11290 $FE10W #7px up


#########################
#    Master - Mort      #
#########################

#Expand Master cache
%patch $31A2E $011BW #Master cache start

#Master makes Master shot instead of Shocksund's
%patch $13350 $2C20W





#########################
#   Robo Red - Vacuum   #
#########################

#Red harmless, blocks shots, can be pogoed on to kill 
%patch $1264D $55 $8B $EC $56 $57 $8B $7E $06 $8B $76 $08 $81 $7C $1C $1008W 
              $74 $07 $81 $7C $1C $1026W  $75 $13 $C7 $45 $1C $012EW  $B8 $0021W 
                  $50 $9A $196E09EFRL     $83 $C4 $02 $EB $17 $81 $7C $1C $1502W 
                  $72 $10 $81 $7C $1C $155CW  $77 $09 $56 $9A $0CCB10B3RL      
                  $83 $C4 $02 $5F $5E $5D $CB 

#Change other collisions to not kill Keen 
%patch $32AA6 $11C40A0DRL #Pause before shooting 
%patch $32AC4 $11C40A0DRL #Pause between shots 
%patch $32AE2 $11C40A0DRL #Shooting 

#Stunned Red action = $012EW 
%patch $3046E $00E6W $00E6W $0002W $0000W $0000W $0000W $0000W $0000W 
              $090B1710RL   $00000000L    $090B17DCRL   $0000W 

#Red caches extra frame 
%patch $EFCE  $29D6W 
%patch $119A6 $B8 $2B7BRW $8A $16 $EC $6F $8E $C0 $26 $08 $16 $00E6W $E9 $D9F0W 

#Red shoots randomly 
%patch $12603 $EB $19 
%patch $12624 $0010W #Shoot frequency 
%patch $12643 $0001W #When Keen lands near Red (6) 

#Red can't be lured off ledges 
%patch $32ABC $0000W 
%patch $12711 $5F $5E $5D $CB 

#Red's shots only move horizontally 
%patch $126EE $C7 $47 $18 $0000W $EB $10 
%patch $126E3 $001EW #Horizontal speed

#Tweak right position of Red's rightwards shots
%patch $126BD $0125W # '0080' = 0.5 tiles right

#No Stun Stars for Red
%patch $3046E $00E6W $00E6W $0002W $0000W $0000W $0000W $0000W $0000W
              $090B1710RL   $00000000L    $090B17B5RL   $0000W


#########################
#Spirogrip		#
#########################

#Tweak charge frequency
%patch $127F7 $28


#########################
#Slicestar - Car	#
#########################

#Car horizontal action =$23BCW
%patch $326FC $0181W $0181W $0002W $0000W $0000W $0000W $0000W $0000W
              $0ED509DARL   $00000000L    $090B17B5RL   $0000W

#Car vertical action =$02D8W
%patch $30618 $0182W $0182W $0002W $0000W $0000W $0000W $0000W $0000W
              $0F9212B5RL   $00000000L    $090B17B5RL   $0000W

#Car has no clipping
%patch $1175F $C7 $47 $06 $0000W

#Car horizontal behavior: on [B] turn clockwise =$0ED509DARL
%patch $F72A $55 $8B $EC $83 $EC $04 $56 $57 $8B $7E $06 $8B $45 $0E $BA $000CW
                 $F7 $EA $F7 $2E $B4 $9B $A3 $85 $BF $8B $45 $10 $BA $000CW
             $F7 $EA $F7 $2E $B4 $9B $A3 $83 $BF $8B $45 $26 $03 $06 $85 $BF
             $89 $46 $FE $B1 $08 $D3 $E8 $89 $46 $FC $8B $45 $30 $3B $46 $FC
             $74 $4A $8B $5D $2E $D1 $E3 $8B $9F $87 $BF $D1 $EB $D1 $E3 $8E
             $06 $53 $9E $8B $46 $FC $D1 $E0 $03 $D8 $26 $83 $3F $73 $75 $2C
             $83 $7D $0E $01 $74 $07 $C7 $45 $10 $FFFFW  $EB $05 $C7 $45 $10
             $0001W  $C7 $45 $0E $0000W  $C7 $45 $1C $02D8W  $8B $46 $FE $25
             $FF $00 $8B $16 $85 $BF $2B $D0 $89 $16 $85 $BF $5F $5E $8B $E5
             $5D $CB

#Car vertical behavior: on [B] turn clockwise =$0F9212B5RL
%patch $10BD5 $55 $8B $EC $83 $EC $04 $56 $57 $8B $7E $06 $8B $45 $0E $BA $000CW
                  $F7 $EA $F7 $2E $B4 $9B $A3 $85 $BF $8B $45 $10 $BA $000CW
              $F7 $EA $F7 $2E $B4 $9B $A3 $83 $BF $8B $45 $26 $03 $06 $85 $BF
              $89 $46 $FE $B1 $08 $D3 $E8 $89 $46 $FC $8B $45 $30 $3B $46 $FC
              $90 $90 $8B $5D $2E $D1 $E3 $8B $9F $87 $BF $D1 $EB $D1 $E3 $8E
              $06 $53 $9E $8B $46 $FC $D1 $E0 $03 $D8 $26 $83 $3F $74 $75 $2C
              $83 $7D $10 $FF $74 $07 $C7 $45 $0E $FFFFW  $EB $05 $C7 $45 $0E
              $0001W  $C7 $45 $10 $0000W  $C7 $45 $1C $23BCW  $8B $46 $FE $25
              $FF $00 $8B $16 $85 $BF $2B $D0 $89 $16 $85 $BF $5F $5E $8B $E5
              $5D $CB

%end