#################################################
#Patchfile for Valentine's Keen			#
#################################################


#################################################
#FILES						#
#################################################

%ext ck4
%maphead maphead.ck4				#New levels
%egahead EGAHEAD.CK4				#New graphics
%egadict EGADICT.CK4				#Use KG graphics
%patchfile $249C2 "Keen4.tli"			#New tile properties
%patchfile $20DF0 AUDIOHED.CK4			#Audio header
%patchfile $354F6 EGADICT.CK4			#Audio dictionary


#################################################
#Misc end patches				#
#################################################

#BwB level(s):
%patch $60FD $0F $74 #Castle Ramenstein (If not complete, game is unwon.)

#F10-W wins game (Replace F10-D)
%patch $7467 $83 $3E $C669W  $00 $74 $30 $83 $3E $C631W  $00 $74 $29 $83 $3E
             $7ADCW  $00 $74 $05 $9A $037D0329RL     $C7 $06 $7A70W  $0003W
             $B8 $0001W  $5F $5E $8B $E5 $5D $CB

#Don't show ending sequence 'page ready' animation
%patch $9D0F $90 $90 $90 $90 $90
%patch $9D42 $90 $90 $90 $90 $90

#Exit text
%patch $2F191 "Take a long walk" $00

#Text color - confirm new game
%patch $1AEA3 $000FW #Bar
%patch $1AE6C $0F    #You're...
%patch $1AEC8 $0F    #Press...

#Level state list (Offset 5C40)
%patch $6BC1 $0E71W #Didn't make it past (At $6AB1)
             $0E78W #Complete level (At $6B1E via $6AB8)
             $0EB2W #Win game (At $6AB8)

#Got Wetsuit code, move to level 15 (Offs $0E78)
%patch $6AB8 $83 $3E $7A5CW  $00 $74 $5F $C7 $06 $7A68W  $000EW $EB $70

#Default high score names
%patch $33234 "Levellass        " $00
%patch $33274 "Paramultart      " $00
%patch $332B4 "Ceilick          " $00
%patch $332F4 "Lemm             " $00
%patch $33334 "Robert           " $00
%patch $33374 "Scarlet          " $00
%patch $333B4 "Szemi            " $00
%patch $333F4 "Mortimer         " $00

#Points: (10'000)
%patch $3326E $0000EA60L #60K
%patch $332AE $0000C350L #50K
%patch $332EE $00009C40L #40K
%patch $3332E $000088B8L #35K
%patch $3336E $00007530L #30K
%patch $333AE $000061A8L #25K
%patch $333EE $00004E20L #20K
%patch $3342E $00002710L #10K

#What F10-E sets (Change level state to 1)
%patch $74BA $7A70W  $0001W


#################################################
#Map foot tweaking stuff for secret level, etc	#
#################################################

#What picks the Foot destination to use
%patch $DE36 $7A34W  $0000W $75

#Foot location 1: (When exiting broom ride)
%patch $DE43 $09
%patch $DE58 $62

#Location 2: (When exiting Witch cottage)
%patch $DE78 $19
%patch $DE8C $13

#Fix animations for map-keen-foot (Now only 1 frame)
%patch $30302 $0118W $0119W
%patch $3031E $1492W

#Wave after foot dropoff
%patch $E107  $150AW #Map Keen waving when bored 1


#################################################
#Wetsuit -> book				#
#################################################

#Alter Wetsuit cache and animations
%patch $ECE6 $018BW #Start AND finish, 1 frame cached

#Sitting Wetsuit
%patch $328A4 $018BW $018BW

#Wetsuit sprite collision - don't check if Keen is in the air
%patch $12A30 $55 $8B $EC $56 $57 $8B $7E $06 $8B $76 $08 $83 $3C $02 $75 $25
              $C7 $06 $7A5CW  $0001W  $B8 $002DW  $50
              $9A $187409F1RL     $83 $C4 $02 $9A $0E8F0AE2RL     $9A $16540D59RL
                      $C7 $06 $7A70W  $0002W  $83 $C7 $4C $5F $5E $5D $CB

#Change text
%patch $F435 $3B12W #Text read from

%patch $32982 "'Summoning Holy Fire for" $0A
              "Fun and Vengance.'" $0A $0A
              "Sounds like a real page-" $0A
              "turner!" $00


#################################################
#Council member -> holy fire			#
#################################################

#Use this as it fits, member is a different sprite now

#Change cache to hold fire animations (286-298)
%patch $306F2 $011EW #Council Member Cache start
%patch $3073C $012AW #Council member cache end

#Spawn height
%patch $FD19 $FFFFW

#Alter spawn action and type to h.f.
%patch $FCFD  $16	#Sprite type
%patch $FD46  $1E1AW	#Spawn flame

#Inactive flame - one action
%patch $30C8A $01A5W $01A5W $0002W $0000W $0000W $0018W $0000W $0000W
              $09DC1701RL   $11A202FDRL   $09DC176ERL   $1E1AW

#Active flame actions, 4 frames
%patch $2F90A $011EW $0121W $0000W $0000W $0000W $0012W $0000W $0000W
              $03ED01FDRL   $1FE40347RL   $09DC176ERL   $0AB8W
%patch $2F928 $011FW $0120W $0000W $0000W $0000W $0012W $0000W $0000W #Use random_smoke
              $03ED01FDRL   $108008D9RL   $09DC176ERL   $015BW
%patch $2EFCB $0120W $011FW $0000W $0000W $0000W $0012W $0000W $0000W
              $03ED01FDRL   $1FE40347RL   $09DC176ERL   $1A82W
%patch $308F2 $0121W $011EW $0000W $0000W $0000W $0012W $0000W $0000W
              $0FA803A6RL   $108008D9RL   $09DC176ERL   $0A9AW

#Inactive flame colision - react to Keen's reading actions to activate = $11A202FDRL
%patch $11D1D $55 $8B $EC $56 $57 $8B $7E $06 $8B $76 $08 $81 $7C $1C $0B4EW
              $74 $0E $81 $7C $1C $0B6CW  $74 $07 $81 $7C $1C $0B8AW  $75 $1D
              $B8 $0A9AW  $50 $57 $9A $09DC120ARL     $83 $C4 $04 $B8 $0018W
              $50 $9A $187409F1RL     $83 $C4 $02 $C7 $05 $0001W  $5F $5E $5D
              $CB

#Flame behavior, randomly change action (to emit smoke!) = $03ED01FDRL
%patch $40CD  $55 $8B $EC $83 $EC $02 $56 $8B $76 $06 $9A $1D02002ARL     $89
              $46 $FE $A1 $4C $A5 $D1 $E0 $D1 $E0 $D1 $E0 $3B $46 $FE $76 $05
              $C7 $44 $1C $1A82W  $5E $8B $E5 $5D $CB

#Flame smoking code (Regular)
%patch $FE26 $55 $8B $EC $56 $8B $76 $06 $B8 $0001W  $50 $9A $06BD1E11RL
             $83 $C4 $02 $8B $1E $D8 $A7 $C7 $07 $0015W  $C7 $47 $06 $0000W
             $C7 $47 $10 $0001W  $8B $44 $0A $89 $47 $0A $8B $44 $28 $2D $0180W
                 $89 $47 $0C $B8 $325AW $50 $53 $9A $09DC118CRL      $83 $C4
             $04 $5E $5D $CB

#Flame collision, become smoke when hit by explosion actions = $1FE40347RL
%patch $20187 $55 $8B $EC $56 $57 $8B $7E $06 $8B $76 $08 $81 $7C $1C $3386W
              $75 $05 $C7 $47 $1C $3278W  $5F $5E $5D $CB

#Emitted smoke actions, animate and rise; 9 actions (Smirky actions) = 325A
%patch $320CA $0122W $0122W $0001W $0000W $0000W $0008W $0000W $FFF8W
              $0000000L     $0000000L     $09DC176ERL   $3278W
%patch $320E8 $0123W $0123W $0001W $0000W $0000W $0008W $0000W $FFF8W
              $0000000L     $0000000L     $09DC176ERL   $3296W
%patch $32106 $0124W $0123W $0001W $0000W $0000W $0008W $0000W $FFF8W
              $0000000L     $0000000L     $09DC176ERL   $32B4W
%patch $32124 $0125W $0123W $0001W $0000W $0000W $0008W $0000W $FFF8W
              $0000000L     $0000000L     $09DC176ERL   $32D2W
%patch $32142 $0126W $0123W $0001W $0000W $0000W $0008W $0000W $FFF8W
              $0000000L     $0000000L     $09DC176ERL   $32F0W
%patch $32160 $0127W $0123W $0001W $0000W $0000W $0008W $0000W $FFF8W
              $0000000L     $0000000L     $09DC176ERL   $330EW
%patch $3217E $0128W $0128W $0001W $0000W $0000W $0008W $0000W $FFF8W
              $0000000L     $0000000L     $09DC176ERL   $332CW
%patch $3219C $0129W $0129W $0001W $0000W $0000W $0008W $0000W $FFF8W
              $0000000L     $0000000L     $09DC176ERL   $334AW
%patch $321BA $012AW $012AW $0001W $0000W $0000W $0008W $0000W $FFF8W
              $0000000L     $0000000L     $09DC176ERL   $0000W



#################################################
#Wormouth->Chuck boss				#
#################################################

#Change wormouth cahce to cahce boss anims
%patch $30700 $01A5W #421
%patch $3074A $01CAW #457

#Boss flapping actions 6+1 frames (One hidden tries to shoot Keen.)
%patch $3154E $01C4W $01BEW $0003W $0000W $0000W $000AW $0000W $0000W
              $11A2033ERL   $1FE401B9RL   $09DC176ERL   $26FCW
%patch $3156C $01C5W $01BFW $0003W $0000W $0000W $000AW $0000W $0000W
              $11A2033ERL   $1FE401B9RL   $09DC176ERL   $271AW
%patch $3158A $01C6W $01C0W $0003W $0000W $0000W $000AW $0000W $0000W
              $11A2033ERL   $1FE401B9RL   $09DC176ERL   $2738W
%patch $315A8 $01C1W $01BBW $0003W $0000W $0000W $000AW $0000W $0000W
              $11A2033ERL   $1FE401B9RL   $09DC176ERL   $2756W
%patch $315C6 $01C2W $01BCW $0003W $0000W $0000W $000AW $0000W $0000W
              $11A2033ERL   $1FE401B9RL   $09DC176ERL   $2774W
%patch $315E4 $01C2W $01BCW $0003W $0000W $0000W $0004W $0000W $0000W #This frame aims to fire
              $11A203A7RL   $1FE401B9RL   $09DC176ERL   $2792W
%patch $31602 $01C3W $01BDW $0003W $0000W $0000W $000AW $0000W $0000W
              $11A2033ERL   $1FE401B9RL   $09DC176ERL   $26DEW

#Shooting action, 2 frames, 1 flashes, 1 shoots
%patch $31620 $01C2W $01BCW $0003W $0000W $0000W $000AW $0000W $0000W #Green flash Keen
              $1FE40000RL   $108008D9RL   $00000000L    $27CEW
%patch $3163E $01C2W $01BCW $0000W $0000W $0000W $0004W $0000W $0000W #Make shot
              $11A203DERL   $108008D9RL   $09DC176ERL   $26DEW

#Chuck's shot actions, 4 frames, dartlike
%patch $3165C $01B3W $01AFW $0001W $0000W $0000W $0006W $0040W $0000W
              $00000000L    $09DC1752RL   $11A20CA1RL   $280AW
%patch $3167A $01B4W $01B0W $0001W $0000W $0000W $0006W $0040W $0000W
              $00000000L    $09DC1752RL   $11A20CA1RL   $2828W
%patch $31698 $01B5W $01B1W $0001W $0000W $0000W $0006W $0040W $0000W
              $00000000L    $09DC1752RL   $11A20CA1RL   $2846W
%patch $316B6 $01B6W $01B2W $0001W $0000W $0000W $0006W $0040W $0000W
              $00000000L    $09DC1752RL   $11A20CA1RL   $27ECW

#Hurt Chuck - Screech while injured = $3B60W
%patch $329D0 $01C4W $01BEW $0000W $0000W $0000W $0038W $0000W $0000W
              $6BD008FRL    $00000000L    $09DC176ERL   $26FCW

#Dead Chuck - Sit while injured = $3B7EW -> win game
%patch $329EE $01C4W $01BEW $0003W $0000W $0000W $0038W $0000W $0000W
              $00000000L    $00000000L    $09DC176ERL   $3B9CW
%patch $32A0C $01C4W $01BEW $0000W $0000W $0000W $0008W $0000W $0000W
              $03ED0229RL   $00000000L    $09DC176ERL   $02D7W

#Dead Boss behavior: Set level state to 3 = $03ED0229RL
%patch $40F9  $55 $8B $EC $56 $8B $76 $06 $C7 $06 $70 $7A $0003W 
              $5E $5D $CB

#Boss behavior, chase Keen scoolfish style = $11A2033ERL
%patch $11D5E $55 $8B $EC $56 $8B $76 $06 $83 $7C $3E $00 $75 $18 $8B $44 $0A #If Keen is level with fish, skip l\r stuff
              $8B $1E $D6 $A7 $3B $47 $0A $73 $07 $C7 $44 $0E $0001W  $EB $05 #Check for Keen h, set h direction
              $C7 $44 $0E $FFFFW  $B8 $000AW  $50 $FF $74 $0E $56 $9A         #Set h speed = $A
         $09DC149FRL  $83 $C4 $06 $8B $44 $0C $8B $1E $D6 $A7 $3B $47 $0C $73 #Check for Keen v
              $14 $B8 $000AW  $50 $B8 $0001W  $50 $56 $9A $09DC1517RL     $83 #Set v speed and direction
              $C4 $06 $EB $12 $90 $B8 $000AW  $50 $B8 $FFFFW $50 $56 $9A
              $09DC1517RL $83 $C4 $06 $5E $5D $CB 

#Chuck aim to fire at Keen behavior, go to $27B0 = $11A203A7RL
%patch $11DC7 $55 $8B $EC $56 $8B $76 $06 $8B $1E $D6 $A7 $8B $47 $24 $3B $44
              $28 $73 $21 $8B $47 $28 $3B $44 $24 $76 $19 $8B $47 $0A $3B $44
              $0A $73 $07 $C7 $44 $0E $FFFFW  $EB $05 $C7 $44 $0E $0001W  $C7 #Face Keen to shoot at him
              $44 $1C $27B0W  $5E $5D $CB                                     #Change action to shoot

#Chuck flash before shooting behavior (Accessory animation display) = $1FE40000RL
%patch $1FE40 $55 $8B $EC $56 $8B $76 $06 $8B $44 $0A $8B $1E $D6 $A7 $3B $47	 #Seek Keen
              $0A $76 $07 $C7 $44 $0E $FFFFW  $EB $05 $C7 $44 $0E $0001W  $E8
              $0003W  $5E $5D $CB 
                                  $8B $76 $06 $FF $74 $20 $33 $C0 $50 $FF $74
              $1E $FF $74 $0C $FF $74 $0A $8B $C6 $05 $0046W  $50 $9A $16541641RL
                      $83 $C4 $0C $8B $16 $4A $A5 $A1 $48 $A5 $B1 $02 $9A
          $00003194RL     $25 $01 $00 $8B $F8 $83 $7C $0E $01 $74 $2B $B8 $0001W #Draw left flash
                  $50 $33 $C0 $50 $8B $C7 $05 $01B7W  $50 $8B $44 $0C $05 $FFD0W
              $50 $8B $44 $0A $2D $0220W  $50 $8B $C6 $05 $0040W  $50 $9A
          $16541641RL     $83 $C4 $0C $EB $29 $B8 $0001W  $50 $33 $C0 $50 $8B	 #Draw right flash
              $C7 $05 $01B9W  $50 $8B $44 $0C $05 $FFD0W  $50 $8B $44 $0A $2D
              $FE10W  $50 $8B $C6 $05 $0040W  $50 $9A $16541641RL     $83 $C4
              $0C $9A $1D02002ARL     $3D $0020W  $7D $13 $8B $C6 $05 $0040W	 #Remove flash and shoot
              $50 $9A $1654185BRL     $83 $C4 $02 $C7 $44 $1C $27CEW  $5F $5E
              $5D $CB

#Chuck fire at Keen behavior = $11A203DERL
%patch $11DFE $55 $8B $EC $56 $8B $76 $06 $B8 $0001W  $50 $9A $06BD1E11RL
              $83 $C4 $02 $8B $44 $0A $8B $1E $D8 $A7 $89 $47 $0A $8B $44 $0C
              $05 $0040W  $89 $47 $0C $C7 $47 $20 $0000W  $C7 $07 $001FW  $C7
              $47 $02 $0003W  $B8 $0004W  $50 $9A $187409F1RL     $83 $C4 $02
              $8B $44 $0E $8B $1E $D8 $A7 $89 $47 $0E $B8 $27ECW  $50 $53 $9A
              $09DC118CRL     $83 $C4 $04 $B8 $0026W  $50 $9A $187409F1RL
              $83 $C4 $02 $5E $5D $CB

#Explosion actions = $2864W
%patch $316D4 $01AEW $01AEW $0000W $0000W $0000W $0008W $0000W $0000W
              $1FE400D3RL   $00000000L    $09DC176ERL   $2882W
%patch $316F2 $01ADW $01ADW $0000W $0000W $0000W $0008W $0000W $0000W
              $00000000L    $00000000L    $09DC176ERL   $3386W
%patch $321F6 $01ACW $01ACW $0000W $0000W $0000W $0008W $0000W $0000W
              $00000000L    $00000000L    $09DC176ERL   $33A4W
%patch $32214 $01ABW $01ABW $0000W $0000W $0000W $0008W $0000W $0000W
              $00000000L    $00000000L    $09DC176ERL   $33C2W
%patch $32232 $01AAW $01AAW $0000W $0000W $0000W $0008W $0000W $0000W
              $00000000L    $00000000L    $09DC176ERL   $33E0W
%patch $32250 $01A9W $01A9W $0000W $0000W $0000W $0008W $0000W $0000W
              $00000000L    $00000000L    $09DC176ERL   $33FEW
%patch $3226E $01A8W $01A8W $0000W $0000W $0000W $0008W $0000W $0000W
              $00000000L    $00000000L    $09DC176ERL   $341CW
%patch $3228C $01A7W $01A7W $0000W $0000W $0000W $0008W $0000W $0000W
              $00000000L    $00000000L    $09DC176ERL   $02D7W
%patch $2F147 $01A6W $01A6W $0000W $0000W $0000W $0008W $0000W $0000W
              $00000000L    $00000000L    $09DC176ERL   $332CW

#Explosions behavior, spawn four clouds of smoke (Used twice) = $1FE400D3RL
%patch $1FF13 $55 $8B $EC $56 $8B $76 $06 $8B $44 $0A $B8 $002DW  $50 $9A $187409F1RL     $83 $C4 #Play sound $2D
              $02  $B8 $01 $00 $50 $9A $06BD1E11RL
              $83 $C4 $02 $8B $44 $0A $2D $0080W  $8B $1E $D8 $A7 $89 $47 $0A #Up smoke
              $8B $44 $0C $05 $0100W  $89 $47 $0C $C7 $47 $10 $0001W  $B8 $325AW
                  $50 $53 $9A $09DC118CRL     $83 $C4 $04 $B8 $0001W  $50 $9A
              $06BD1E11RL     $83 $C4 $02 $8B $44 $0A $05 $0100W  $8B $1E $D8 #Left smoke
              $A7 $89 $47 $0A $8B $44 $0C $05 $0180W  $89 $47 $0C $C7 $47 $10 
              $0001W  $B8 $325AW  $50 $53 $9A $09DC118CRL     $83 $C4 $04 $B8
              $0001W  $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $44 $0A $05 $0280W
%patch $1FFA3     $8B $1E $D8 $A7 $89 $47 $0A $8B $44 $0C $05 $0100W  $89 $47 #Right smoke
              $0C $C7 $47 $10 $0001W  $B8 $325AW  $50 $53 $9A $09DC118CRL     
              $83 $C4 $04 $B8 $0001W  $50 $9A $06BD1E11RL     $83 $C4 $02 $8B
              $44 $0A $8B $1E $D8 $A7 $89 $47 $0A $8B $44 $0C $2D $0080W  $89 #Down smoke
              $47 $0C $C7 $47 $10 $0001W  $B8 $325AW  $50 $53 $9A $09DC118CRL
                  $83 $C4 $04 $5E $5D $CB

#Chuck collision: kill Keen block Keen's shots, fire plays sound, makes 4 explosions and increments counter = $1FE401B9RL
%patch $1FFF9 $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $09	#Kill Keen
              $9A $0B8013E9RL     $5F $5E $5D $CB $83 $3D $03 $75 $12 $B8
          $26DEW  $50 $57 $56 $9A $09DC1695RL     $83 $C4 $06 $5F $5E $5D $CB	#If shot, block, 'change' to flying chuck (I.e. no change)
              $83 $3D $15 $75 $F7 $FF $06 $7A60W  $83 $3E $7A60W  $04 $76 $06	#If fire, inc counter_redgem, if counter = 99...
              $B8 $3B7EW  $50 $EB $04 $B8 $3B60W  $50 $57 $56 $9A $09DC1695RL	#Change to Dead_Chuck, else change to Hurt_Chuck
                  $83 $C4 $06 $B8 $0001W  $50 $9A $06BD1E11RL     $83 $C4 $02   #Make first explosion
              $8B $44 $0A $2D $0080W  $8B $1E $D8 $A7 $89 $47 $0A $8B $44 $0C
              $2D $0200W  $89 $47 $0C $C7 $47 $20 $0003W  $B8 $2864W  $50 $53
              $9A $09DC118CRL     $83 $C4 $04 $B8 $0001W  $50 $9A $06BD1E11RL	#Make second explosion
                  $83 $C4 $02 $8B $44 $0A $2D $0080W  $8B $1E $D8 $A7 $89 $47
              $0A $8B $44 $0C $05 $0200W  $89 $47 $0C $C7 $47 $20 $0003W  $B8
              $2864W  $50 $53 $9A $09DC118CRL     $83 $C4 $04 $B8 $0001W  $50	#Make third explosion
              $9A $06BD1E11RL     $83 $C4 $02 $8B $44 $0A $05 $0080W  $8B $1E
              $D8 $A7 $89 $47 $0A $8B $44 $0C $05 $0200W  $89 $47 $0C $C7 $47
              $20 $0003W  $B8 $2864W  $50 $53 $9A $09DC118CRL     $83 $C4 $04
%patch $200E9 $B8 $0001W  $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $44 $0A $2D	#Make fourth explosion
              $0080W  $8B $1E $D8 $A7 $89 $47 $0A $8B $44 $0C $2D $0100W  $89
              $47 $0C $C7 $47 $20 $0003W  $B8 $2864W  $50 $53 $9A $09DC118CRL
                  $83 $C4 $04 $5F $5E $5D $CB

#Free data to $1FF13-$20DEF


#################################################
#Bounder ->  Fanguard shooter			#
#################################################

#Alter cache to hold 3 animations (l/r/ shots)
%patch $30706 $01C8W #Bounder Cache start
%patch $30750 $01CAW #Bounder cache end

#Bounder Spawning code
%patch $110EA $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0008W  $C7 $47 $02 $0001W  $C7 $47 $20 $0000W 
              $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05
              $FF80W  $89 $47 $0C $C7 $47 $10 $0001W  $C7 $47 $0E $0000W  $B8
              $2F12W  $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#Bounder move action, 2 frames, 1 shoots
%patch $31D82 $01C9W $01CAW $0002W $0000W $0000W $0000W $0000W $0000W
              $10800D44RL   $00000000L    $10800F56RL   $2F30W
%patch $31DA0 $01C9W $01CAW $0002W $0000W $0000W $0000W $0000W $0000W
              $10800D44RL   $00000000L    $10800F56RL   $2F12W

#Bounder's shot (Dartlike)
%patch $31DDC $01C9W $01CAW $0001W $0000W $0000W $000AW $0060W $0000W
              $00000000L    $0D8F0BADRL   $11A20CA1RL   $2F6CW

#Stunned, falling bounder
%patch $31DBE $01C9W $01CAW $0002W $0000W $0000W $0000W $0040W $0000W
              $10800D44RL   $00000000L    $10800F56RL   $2F4EW

#Bounder collision; deadly destructable = $11A20494RL
%patch $11EB4 $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $09 #Check for Keen (Type 2)
              $9A $0B8013E9RL     $5F $5E $5D $CB $83 $3D $03 $75 $1F $B8         #If Keen, kill him; check for shot (Type 3)
              $2F4EW  $50 $57 $56 $9A $09DC1695RL     $83 $C4 $06 $C7 $44 $18     #If shot, become $206C
              $FFE8W  $8B $44 $0E $D1 $E0 $D1 $E0 $D1 $E0 $89 $44 $16 $5F $5E $5D #Jump into the air $FFE8
              $CB





#################################################
#Med wormouth -> bouncy sphere			#
#################################################

#Reroute med wormouth spawn
%patch $EEE9 $3605W #Medium Wormouth (At $11EF5)

#Sphere spawn code - cache 455
%patch $11EF5 $FF $76 $FC $57 $9A $1FE402E1RL     $83 $C4 $04 $B8 $2A3ARW $8A
              $16 $EC $7A $8E $C0 $26 $08 $16 $01C7W  $E9 $CEEBW #To $EDFD

#Sphere spawn = $1FE402E1RL
%patch $20121 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0008W  $C7 $47 $02 $0001W  $C7 $47 $20 $0000W
              $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05
              $FE8FW  $89 $47 $0C $9A $1D02002ARL     $3D $0080W  $7D $0B $8B
              $1E $D8 $A7 $C7 $47 $0E $0001W  $EB $09 $8B $1E $D8 $A7 $C7 $47
              $0E $FFFFW  $8B $1E $D8 $A7 $B8 $3368W  $50 $53 $9A $09DC118CRL
                  $83 $C4 $04 $5D $CB

#Sphere action - sit and bounce
%patch $321D8 $01C7W $01C7W $0002W $0000W $0000W $0000W $0000W $0000W
              $10800D44RL   $0FA804BERL   $09DC176ERL   $3368W


#################################################
#Oracle Janitor is boss start conversation	#
#################################################

#SIDE EFFECT: Need different sprite for member hints
#Frees all but one behavior

#Need to point to new code; old code can be used elsewhere
%patch $EED3 $130EW #Blank $28 used

#Hint initiation, cache 226
%patch $FBFE $FF $76 $FC $57 $9A $03ED0176RL     $83 $C4 $04 $B8 $2A3ARW $8A
             $16 $EC $7A $8E $C0 $26 $08 $16 $00E2W  $E9 $F1E2W #To $EDFD

#New spawn code for Member = $03ED0176RL
%patch $4046 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
             $D8 $A7 $C7 $07 $0005W  $C7 $47 $02 $0001W  $C7 $47 $20 $0000W
             $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A $8B $46 $08 $05 $FFFFW
             $D3 $E0 $89 $47 $0C $B8 $1FB8W  $50 $53 $9A $09DC118CRL     $83
             $C4 $04 $5D $CB

#Hint collision; if Keen run oracle windows and transform = $03ED01BARL
%patch $408A  $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $16
              $C7 $44 $1C $1F46W  $9A $0E8F07D9RL     $9A $16540D59RL     $56
              $9A $06BD1E8BRL     $83 $C4 $02 $5F $5E $5D $CB

#Council member doesn't do anything
%patch $30E28 $01A5W $01A5W $0002W $0000W $0000W $0000W $0000W $0000W
              $09DC1701RL   $03ED01BARL   $09DC1795RL   $1FB8W

#Oracle Janitor messages
%patch $1F12E "What do we have here?" $0A $0A
              "Another child with" $0A
              "another magic slingshot." $0A $0A
              "Do you think mere stones" $0A
              "concern me now?" $00
%patch $1F19B $0A $0A  "How do you feel about" $0A
              "holy fire?" $00
%patch $1F1BE "Worried, but you'll" $0A
              "notice a definite lack" $0A
              "of it here and your" $0A
              "utter inability to make" $0A
              "any!" $00
%patch $1F21A $0A $0A "Let me introduce you to" $0A
              "a good book..." $00

#Council windows: 1
%patch $F117 $001BW  #Width
%patch $F113 $000AW  #Height
%patch $F16E $018CW  #Time displayed
%patch $F146 $1F12RW #Text read from 1
%patch $F14A $000EW  #2

#Window 2
%patch $F0ED $0069W #Keen cached
%patch $F194 $0069W  #Keen second
%patch $F188 $001BW  #Width
%patch $F184 $000AW  #Height
%patch $F1DF $00ACW  #Time displayed
%patch $F1B7 $1F19RW #Text read from 1
%patch $F1BB $000BW  #2

#Window 3
%patch $F1F9 $001BW  #Width
%patch $F1F5 $000AW  #Height
%patch $F205 $006EW  #Chuck again
%patch $F252 $014CW  #Time displayed
%patch $F22A $1F1BRW #Text read from 1
%patch $F22E $000EW  #2

#Windows 4
%patch $F26C $001BW  #Width
%patch $F268 $000AW  #Height
%patch $F2C3 $00ACW  #Time displayed
%patch $F0F4 $0072W  #Angry Keen cached
%patch $F278 $0072W  #Bitmap displayed
%patch $F29B $1F21RW #Text read from 1
%patch $F29F $000AW  #2

#Oracle Janitor windows don't wait for player keypress
%patch $F17E $90 $90 $90 $90 $90 #Window 1
%patch $F1EF $90 $90 $90 $90 $90 #Window 2
%patch $F262 $90 $90 $90 $90 $90 #Window 3
%patch $F2D3 $90 $90 $90 $90 $90 #Window 4

#Don't display window 5
%patch $F2D8 $EB $62


#################################################
#Lindsey (2 kinds)				#
#################################################

#Lindsey uses new spawn
%patch $EE8F $12D4W 

#Developer 1 initiation, cache 460
%patch $FBC4 $FF $76 $FC $57 $9A $11A202B9RL     $83 $C4 $04 $B8 $2A3ARW $8A
             $16 $EC $7A $8E $C0 $26 $08 $16 $01CCW  $E9 $F21CW #To $EDFD

#Developer 1 spawn = $11A202B9RL
%patch $11CD9 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0018W  $C7 $47 $02 $0001W  $C7 $47 $20 $0000W
              $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05
              $FFEFW  $89 $47 $0C $B8 $38EAW  $50 $53 $9A $09DC118CRL     $83
              $C4 $04 $5D $CB

#Developer 1 action, wait to be hit
%patch $3275A $01CCW $01CCW $0002W $0000W $0000W $0000W $0000W $0000W
              $09DC1701RL   $108008D9RL   $09DC1795RL   $38EAW

#Item raygun is 2nd developer
%patch $EF0B $12F1W

#Developer 2 initiation, cache 459
%patch $FBE1 $FF $76 $FC $57 $9A $11A20DB5RL     $83 $C4 $04 $B8 $2A3ARW $8A
             $16 $EC $7A $8E $C0 $26 $08 $16 $01CBW  $E9 $F1FFW #To $EDFD

#Developer 2 spawn = $11A20DB5RL
%patch $127D5 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0018W  $C7 $47 $02 $0001W  $C7 $47 $20 $0000W
              $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05
              $FFEFW  $89 $47 $0C $B8 $3908W  $50 $53 $9A $09DC118CRL     $83
              $C4 $04 $5D $CB

#Second developer action, same as 1st
%patch $32778 $01CBW $01CBW $0002W $0000W $0000W $0000W $0000W $0000W
              $09DC1701RL   $108008D9RL   $09DC1795RL   $3908W


#Level where Lindsey gives the Miragia hint instead of the Pyramid one:
%patch $EFB6 $09 $75 #Hillville

#Level where Keen gives the Miragia reply instead of the Pyramid one:
%patch $F033 $09 $75 #Hillville

#No 'Lindsey says' text
%patch $EFAA $90 $90 $90 $90 $90

#Lindsey's window
%patch $EF74 $0009W #Height

#Texts
%patch $30844 $1ADCW #Lass
%patch $30846 $1B52W #Lick
%patch $30848 $1BC7W #Reply 1
%patch $3084A $1C02W #Reply 2

#Don't display Lindsey's head
%patch $EF8F $90 $90 $90 $90 $90

#Messages
%patch $3094C $8D "n? How did-" $0A
              "nevermind, Para locked" $0A
              "me in here and ran off!" $0A
              "You can have my" $0A
              "supplies since I won't" $0A
              "need them anymore." $00
%patch $309C2 "Wow " $8D "n, you're" $0A
              "thorough! I haven't" $0A
              "even finished beta-" $0A
              "testing this game yet!" $0A
              "Take this candy and" $0A
              "don't tell anyone." $00
%patch $30A37 "No problem Lass! This" $0A
              "Para sounds like a" $0A
              "shifty character!" $00
%patch $30A72 "Thanks 'Lick! But isn't" $0A
              "there another guy" $0A
              "working on this game?" $00


#################################################
#Council members				#
#################################################

#Right mine is now hint
%patch $EF0F $12B7W

#Hint initiation, cache 252
%patch $FBA7 $FF $76 $FC $57 $9A $11A20250RL     $83 $C4 $04 $B8 $2A3ARW $8A
             $16 $EC $7A $8E $C0 $26 $08 $16 $00FCW  $E9 $F239W #To $EDFD

#Hint spawn = $11A20250RL
%patch $11C70 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0005W  $C7 $47 $02 $0001W  $C7 $47 $20 $0000W
              $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A $8B $46 $08 $05 $FFFFW
              $D3 $E0 $89 $47 $0C $B8 $1FD6W  $50 $53 $9A $09DC118CRL     $83
              $C4 $04 $5D $CB

#Hint collision; if Keen run oracle windows and transform = $11A20294RL
%patch $11CB4 $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $0F
              $C7 $44 $1C $1F46W  $9A $0E8F0BA5RL     $9A $16540D59RL     $5F
              $5E $8B $E5 $5D $CB

#Hint action -sit to be collided with
%patch $30E46 $00FCW $00FCW $0002W $0000W $0000W $0000W $0000W $0000W
              $09DC1701RL   $11A20294RL   $09DC1795RL   $1FD6W

#Remove Council Member window
%patch $F52E $90 $90 $90 $90 $90
%patch $F544 $90 $90 $90 $90 $90
%patch $F534 $0004W

#Play a sound when the member is rescued
%patch $F4CA $002BW $50 $9A $187409F1RL

#Same music plays after Member rescued
%patch $F5E7 $90 $90 $90 $90 $90

#Change bitmap when window displayed
%patch $F4AE $001EW #Cache Council Member graphic
%patch $F55A $001EW #Bitmap displayed (18)

#Disable member windows (Fix this, it is code!) Add window clear
%patch $6ADD $9A $0E8F0BA5RL

%patch $F586 $3FF4W #Location of text pointer list
%patch $F580 $A7EDW #What is counted (Current level)
%patch $F54A $0009W #Height

#Message list
%patch $32E64 $3F3CW #Level 0 - default message
              $3F8DW #Level 1
              $3F3CW #Level 2
              $3F3CW #Level 3
              $3F3CW #Level 4
              $3F3CW #Level 5
              $3F3CW #Level 6
              $3FBBW #Level 7
              $3F3CW #Level 8
              $3F3CW #Level 9
              $3F3CW #Level 10
              $3FBBW #Level 11
              $3FBBW #Level 12
              $3F3CW #Level 13
              $3F3CW #Level 14
              $401CW #Level 15
              $416EW #Level 16
              $3F3CW #Level 17
              $3F3CW #Level 18
              $3F3CW #Level 19

#Messages
%patch $32DAC "Count Chuck is more" $0A		#3F3C
              "powerful than ever" $0A
              "now, only holy fire" $0A
              "can hope to stop him." $00
%patch $32DFD "Stand on the hexagram" $0A	#3F8D
              "to summon a" $0A
              "broomstick!" $00
%patch $32E2B "Press left to brake" $0A		#3FBB
              "your stick and up and" $0A
              "down to steer." $00
%patch $32E8C "Gain and lose your" $0A		#401C
              "little key, find the" $0A
              "way to victory!" $00
%patch $32FDE "The doors here are" $0A		#416E
              "hard to see, they're" $0A
              "just black holes..." $00

#################################################
#Main meu stuff					#
#################################################

#Main Menu
%patch $1A9C6 $B0 $07 $50 #Background 1 (Dark grey)
              $B0 $07 $50 #Background 2 (Should match back 1)
              $B0 $9F $50 #Width of background box
%patch $1AA06 $0F         #Selected text color (Light green)*
%patch $1AA0D $0F         #Unselected text color (Dark green)*
%patch $1AA33 $0F         #Unknown text color (Light grey)*
%patch $1AB14 $08         #Top line color (Light green)
%patch $1AAC1 $08         #Bottom line color (Light green)
%patch $1AA40 $0F         #Menu bottom text color (Dark green)*
%patch $1AABF $00         #Unknown menu bottom text color (Black)*
%patch $1FDF2 $48FFW	  #Change PW call
%patch $3376F "SKULL & BONES" $00

#Save\load game menu
%patch $1BC73 $08 #Selected text and box
%patch $1BC77 $0F #Unselected text and box
%patch $1BC7E $07 #Text color modifier
%patch $1BEA7 $07 #Box background color
%patch $1BFAF $08 #Saving game text color
%patch $1BFB1 $07 #Saving game background color

#Fix Paddle War screen colors
%patch $1C635 $0007W #CP background color
%patch $1C66D $0007W #PP background color
%patch $1C5FA $0007W #B background color
%patch $1C5FE $0006W #B BG box height AND width
%patch $1C350 $0007W #B background color 2
%patch $1C354 $0006W #B BG box height AND width 2
%patch $1C1C2 $0007W #Background color K
%patch $1C204 $0007W #Background color C
%patch $1C70E $0008W #Color (Bottom bar)
%patch $1C712 $0091W #Vertical location
%patch $1C6F6 $0008W #Color (Top bar)


#################################################
#MISC						#
#################################################

#Keen 4 - Disable 2 button firing in demo mode
%patch $8B8B  $90 $90 $90 $90 $90 $90 $90

#Count objects cheat disabled
%patch $7458 $EB

#Terminator text palette:
%patch $2F078 $00 $04 $04 $14 $01 $01 $01 $01 #Dark colors
              $11 $11 $11 $11 $13 $13 $13 $13 #Light colors

#Terminator text palette 2, screen moves out:
%patch $2F088 $00 $00 $04 $04 $14 $01 $01 $01 #Dark colors
              $01 $11 $11 $11 $11 $13 $13 $13 #Light colors

#Don't display credit bitmaps in terminator sequence (Frees $4007-$41A7)
%patch $4006 $CB

#Skip initialization screen
%patch $38AD  $90 $90 $90 $90 $90 #Don't load B800
%patch $38D0  $90 $90 $90 $90 $90 #Don't display game info
%patch $19F40 $90 $90 $90         #Don't show 'Loading...' text
%patch $19FA6 $90 $90 $90         #Don't show 'Ready' text
%patch $39B2 $90 $90 $90 $90 $90  #Don't wait for key

#Disable a 2 Enter
%patch $82E4 $EB

#Debug keys always on
%patch $7AB7 $90 $90

#Disable BAT option
%patch $7851 $EB

#Number of different tiles in door -1
%patch $E8C7 $0003W
%patch $E8D2 $0003W

#Infinite shots in Keen 4
%patch $E56B $7A58W $00 $EB	#Shoot even with 0 shots
%patch $E57E $9090W $9090W	#Don't lose a shot

#Border color- disable to free up space
%patch $73C3 $90 $90

#Disable F10 - N F10-S, F10-V AND F10 - W (Free $75F0-77F9)
%patch $75EF $E9 $0208W

#Stop the knockout stars appearing
%patch $B7B3 $0004W

#Don't display Keen's shots on scoreboard
%patch $DB74 $90 $90 #Ammo

#Don't display wetsuit, elders or keens on status box
%patch $806C $90 $90 $90 $90 $90 #Wetsuit text white box
%patch $8091 $90 $90 $90 $90 $90 #If got wetsuit
%patch $809F $90 $90 $90 $90 $90 #If not got wetsuit
%patch $7FCE $90 $90 $90 $90 $90 #Lives label
%patch $7FE6 $90 $90 $90 $90 $90 #Lives black box
%patch $8002 $90 $90 $90         #Lives got
%patch $7E32 $90 $90 $90 $90 $90 #Rescued label
%patch $7E4D $90 $90 $90 $90 $90 #Black box
%patch $7E6D $90 $90 $90 $90 $90 #Rescued tiles

#Drops text
%patch $2F4CB "HEARTS" $00

#Difficulty box is black
%patch $7E9F $0000W #Color

#KEYS
%patch $7F0C $0061W #Horizontal (Text)
%patch $7F12 $0055W #Vertical
%patch $7F28 $0042W #Width (Backing)
%patch $7F2C $005FW #Vertical position
%patch $7F30 $004FW #Horizontal position
%patch $7F51 $0060W #Vertical position (Counter)
%patch $7F5D $0061W #Horizontal position

#Make shots counter into lives counter and move it
%patch $7F72 $0058W #Horizontal (Text)
%patch $7F78 $006DW #Vertical
%patch $7F7B $0655W #Text read from
%patch $7F8E $0042W #Width (Box)
%patch $7F92 $0077W #Vertical position
%patch $7F96 $004FW #Horizontal position
%patch $7FA2 $7A6AW #What to track (Counter)
%patch $7FAC $0008W #Number of digits
%patch $7FB0 $0078W #Vertical position
%patch $7FB4 $0050W #Horizontal position

#Drops text
%patch $800C $00BAW #Horizontal
%patch $8012 $006DW #Vertical

#Background rectangle
%patch $8024 $000AW #Height
%patch $8028 $0042W #Width
%patch $802C $0077W #Vertical
%patch $8030 $00AFW #Horizontal

%patch $8046 $0008W #Number of digits
%patch $804A $0078W #Vertical position
%patch $804E $00B0W #Horizontal position

#Press
%patch $80B2 $008CW #Vertical position
%patch $80BE $0078W #Horizontal position
%patch $80D0 $0094W #Vertical position
%patch $80DC $0078W #Horizontal position


#################################################
#Lass's big extra level patch			#
#################################################

#First increase the number of levels we can access from the map to maximum (+6)
%patch $DF5D $C018W #Number of levels enterable ($18 = 24)

#Add temporary text values to lists:
#Level name pointers:
%patch $30764 $1EE6000BRL #Map
              $1EE50005RL #Meadow trail
              $1EE8000CRL #Graveyard
              $1EEB0007RL #Pumpkin patch
              $1EED0004RL #Tomb hall
              $1EEF000DRL #Swamp
              $1EF20002RL #Dead forest
              $1EF3000DRL #Old Shack
              $1EF5000DRL #Boneyard
              $1EF80009RL #Bonepile crypt
              $1EFA000FRL #Cavern of despair
              $1EFD0006RL #Broom ride
              $1F0F000CRL #Witch's Cottage
              $1EFF0005RL #The void
              $1F010007RL #Chuck's lair
              $1F11000CRL #Castle Ramenstein
              $1F03000ERL #Stumbledark
              $1F050007RL #Keen's house
              $1F080002RL #Penny Lane
              $1F0A0003RL #Hall of fame
              $1F0D0004RL #Bourke st
              $1F52000CRL #Fan's house
              $1F50000FRL #Carpe jugulum
              $1F1C0000RL
              $1F1C0000RL

#Level entrance text pointers
%patch $307C8 $1EE60002RL #Map
              $1EE40000RL #Meadow trail
              $1EE70007RL #Graveyard
              $1EE90006RL #Pumpkin patch
              $1EEC0005RL #Tomb hall
              $1EED000ERL #Swamp
              $1EF00009RL #Dead forest
              $1EF2000ERL #Old Shack
              $1EF4000BRL #Boneyard
              $1EF60006RL #Bonepile crypt
              $1EF90008RL #Cavern of despair
              $1EFC0005RL #Broom ride
              $1F0E0002RL #Witch's Cottage
              $1EFE0001RL #The void
              $1EFF000ERL #Chuck's Lair
              $1F110000RL #Castle Ramenstein
              $1F020004RL #In the dark
              $1F04000ARL #Keen's house
              $1F06000BRL #Penny Lane
              $1F08000dRL #Hall of fame
              $1F0A000FRL #Bourke st
              $1F51000DRL #Fan's house
              $1F4E0005RL #Carpe jugulum
              $1F510000RL
              $1F510000RL

#Level names (And entry texts)
%patch $1EE40 $8D "n strolls along" $0A
              "the Meadow Trail" $00
%patch $1EE62 $8D "n takes" $0A
              "A Long Walk"  $00
%patch $1EE77 $8D "n stumbles past" $0A
              "the Graveyard" $00
%patch $1EE96 $8D "n plants his feet" $0A
              "firmly in the" $0A
              "Pumpkin Patch" $00
%patch $1EEC5 $8D "n breaks into" $0A
              "Tomb Hall" $00
%patch $1EEDE $8D "n slowly squishes" $0A
              "through the Slimy" $0A
              "Swamp" $00
%patch $1EF09 $8D "n sets out to prune" $0A
              "The Dead Forest" $00
%patch $1EF2E $8D "n breaks into" $0A
              "The Old Shack" $00
%patch $1EF4B $8D "n rattles by the" $0A
              "Boneyard" $00
%patch $1EF66 $8D "n makes no bones" $0A
              "about walking by" $0A
              "Bonepile Crypt" $00
%patch $1EF98 $8D "n has high spirits in" $0A
              "The Cavern Of Despair" $00
%patch $1EFC5 $8D "n takes a short" $0A
              "Broom Ride" $00
%patch $1EFE1 $8D "n journeys through" $0A
              "The Void" $00
%patch $1EFFE $8D "n braves the dangers" $0A
              "of Chuck's Lair" $00
%patch $1F024 $8D "n stumbles blindly" $0A
              "about In The Dark" $00
%patch $1F04A $8D "n goes home" $00
              "The Blaze Household" $00
%patch $1F06B $8D "n briskly walks along" $0A
              "Penny Lane" $00
%patch $1F08D "Call ID! " $8D "n is in" $0A
              "the High Scores" $00
%patch $1F0AF $8D "n wonders how to" $0A
              "get, how to get to" $0A
              "Bourke Street" $00
%patch $1F0E2 $8D "n makes a clean" $0A
              "sweep of Witch's Cottage" $00
%patch $1F110 $8D "n assaults Castle" $0A
              "Ramenstein" $00
%patch $1F4E5 $8D "n finds Carpe Jugulum" $0A
              "a pain in the neck" $00 
              "Carpe Jugulum" $00
%patch $1F51D $8D "n breaks into" $0A
              "Old Mr. Kimple's House" $00
#patch $1EF98 $8D "n has high spirits of" $0A


#################################################
#COMPUTER WRIST					#
#################################################

#Help screen backgrounds are black:
%patch $99F8 $0000W #Color used behind help pointer
%patch $95FB $0000W #Color black used for other screen backgrounds
%patch $95FB $0000W

#Don't cache undisplayed graphics (Free memory)
%patch $9934 $90 $90 $90 $90 $90 #Left of help screen
%patch $9940 $90 $90 $90 $90 $90 #Right of help screen
%patch $994C $90 $90 $90 $90 $90 #Bottom of help screen

#Don't display main helpscreen bitmaps:
%patch $995C $90 $90 $90 $90 $90 #Top of help screen
%patch $996F $90 $90 $90 $90 $90 #Left of help screen
%patch $9983 $90 $90 $90 $90 $90 #Right of help screen
%patch $9997 $90 $90 $90 $90 $90 #Bottom of help screen

%patch $99DE $0016W #Height of hand options 1
%patch $99FC $0016W #Height of hand options 2
%patch $9A07 $0016W #Height of hand options 3

%patch $99A0 $0006W #Help options (At 96,8)
%patch $99A4 $0000W #V loc
%patch $99A8 $0000W #H loc

%patch $99E3 $0036W #V loc 1
%patch $9A0C $0036W #V loc 2
%patch $99E7 $0030W #H loc 1
%patch $9A10 $0030W #H loc 2


#################################################
#Keen						#
#################################################

#Keen shoots in an arc not a line:
#Set up shot to have h and v speeds
%patch $E59E  $C7 $47 $0E $0001W
%patch $E5A7  $C7 $47 $10 $0001W

#Shot speeds:
#Up
%patch $E5CB  $C7 $47 $16 $0000W
%patch $E5D0  $C7 $47 $18 $FFB4W
#Right
%patch $E5DB  $C7 $47 $16 $0030W
%patch $E5E0  $C7 $47 $18 $FFE8W
#Down
%patch $E5EB  $C7 $47 $16 $0000W
%patch $E5F0  $C7 $47 $18 $0020W
#Left
%patch $E5FB  $C7 $47 $16 $FFC0W
%patch $E600  $C7 $47 $18 $FFE8W

#Change shot actions to work like Berkeloid shots, leaves three frames free
%patch $305A8 $00B1W $00B1W $0000W $0000W $0000W $0002W $0000W $0000W
              $09DC16E5RL   $00000000L    $0D8F0E32RL   $1738W

#Disable shooting on a pole
%patch $C672  $0EF0W #Keen start shooting
%patch $CA82  $0EF0W #Confirm shoot [Can't if this is changed]
%patch $C66B  $0F0EW #Keen shoots up on pole
%patch $CAC5  $0F0EW #Confirm shoot [Can't if this is changed]
%patch $C679  $0F68W #Keen shooting down on a pole
%patch $CB06  $0F68W #Confirm shoot [Can't if this is changed]

#THE BIG SHOT ANIMATION MESS UP:
%patch $2FBDA 00190W 00192W #Keen shoot l/r
%patch $2FBE4 $0012W        #Pause before shot
%patch $2FBF8 00191W 00193W
%patch $2FC02 $0009W        #Pause before standing
%patch $2FC16 00194W 00194W #Shooting up
%patch $2FC20 $0012W        #Pause before shot
%patch $2FC34 00195W 00195W 
%patch $2FC3E $0009W        #Pause before standing
%patch $3004E 00167W 00169W #Keen shoot l/r in air
%patch $30058 $0012W        #Pause before shot
%patch $3006C 00167W 00169W
%patch $3008A 00168W 00170W
%patch $30094 $0009W        #Pause before going to falling
%patch $30102 00171W 00171W #Shoot down in air
%patch $3010C $0010W        #Pause before shot
%patch $30120 00171W 00171W
%patch $3013E 00172W 00172W
%patch $30148 $0009W        #Pause before going to falling
%patch $300A8 00173W 00173W #Keen shooting up in air
%patch $300B2 $0010W        #Pause before shot
%patch $300C6 00172W 00172W
%patch $300E4 00174W 00174W
%patch $300EE $0009W        #Pause before going to falling

#Ghost poles (Poles that can vanish)
#SIDE EFFECCT: Keen can fall off pole tops
#Make Keen's sit on pole action check if pole is there
%patch $2FD60 $00BBW $00B4W $0004W $0000W $0000W $0006W $0000W $0000W
              $0B800ED3RL   $0B801632RL   $0B801A7BRL   $20A8W
%patch $30F18 $00BBW $00B4W $0004W $0000W $0000W $0000W $0000W $0000W
              $0B80101CRL   $0B801632RL   $0B801A7BRL   $0EF0W
%patch $C7CA $C7 $47 $16 $0000W $C7 $44 $1C $0F68W $56 $C7 $44 $06 $0001W

#Keen can't float on vanished tiles when looking up (Ghost platforms.)
#SIDE EFECT: Keen takes a little time to stop looking up if up key held long enough
%patch $2FAA0 $0B80139FRL
%patch $2FA9A $0018W
%patch $2FAAC $09AAW
%patch $2FA94 $0004W

#Remove the water level scrolling:
%patch $9059 $90

#Flags are always sitting
%patch $6146 $0D8F09FDRL

#Change flag animations
%patch $3045E $011AW $011AW
%patch $3047C $011BW $011BW
%patch $3049A $011CW $011CW
%patch $304B8 $011DW $011DW

#Change Keen cache to exclude free animations
%patch $306D2 $0082W #Keen Cache start
%patch $3072E $011DW #Keen cache end

#Change riding broom on map animations
%patch $30302 $0119W $0119W
%patch $30320 $011AW $011AW

#Keen ca't swim window: new message
%patch $F3A5 $4117W #Text read from
%patch $32F87 "I shouldn't waste time" $0A
              "wandering where I'm not" $0A
              "needed. Best get back to" $0A
              "being awesome!" $00


#################################################
#Bored Keen -> conditional book Keen		#
#################################################

#Remove giving book with F10-I
%patch $755E $7A5CW $0000W #Wetsuit set to

#Bored Keen action end at $0AD6W  (Disguised as normal Keen)
%patch $2F81A $008AW $0082W $0000W $0000W $0001W $0004W $0000W $0000W
              $06BD000BRL   $0B8014A9RL   $0B801AA2RL   $098CW

#Bored Keen behavior, goto bookread IF level >= 14 and book = 1 = $06BD000BRL
%patch $6BDB  $55 $8B $EC $83 $3E $7A5CW  $01 $75 $0C $83 $3E
              $A7EDW  $0E $75 $05 $C7 $44 $1C $0AD6W  $5D $CB


#################################################
#Swimming Keen->Flying Keen			#
#################################################

#Mooning Keen now transforms to flying instead
%patch $BBFC  $0060W	#1st bored time, now 'wait to read' time
%patch $BC16  $0004W	#2nd bored time (added to 1st) total wait = $44
%patch $BC29  $EB $04	#Keen can moon as often as he wants

#Reduce swimming Keen spawn to a mere cache:
%patch $EED7 $04E5W #Change pointer to code (Old mooning code)
%patch $EDD5 $C7 $06 $7B $CB $0001W  $EB $20 #Change cache

#Transform action, needs witch in-level, becomes swimming Keen
%patch $2F8EC $012BW $012BW $0000W $0000W $0001W $000EW $0000W $0000W
              $6BD008FRL   $0B8014A9RL   $0E8F112FRL   $19ECW

#Play sound = $6BD008FRL
%patch $6C5F  $55 $8B $EC $56 $8B $76 $06
              $8B $44 $0A $B8 $0027W  $50 $9A $187409F1RL     $83 $C4 $02
              $5E $5D $CB

#Remove bubbles and bubble sound from swimming Keen:
%patch $F69C $5E $5D $CB

#Swimming Keen can only swim right, also has no gravity
#Horizontal
%patch $F7C4 $0001W #Left (Change direction)
%patch $F7CF $0001W #Left
%patch $F7DA $0003W #Right
%patch $F7DF $0003W #Right (Change direction)
#Vertical
%patch $F819 $0000W #Up (Change direction)
%patch $F826 $0000W #Up
%patch $F833 $0000W #Down (This doubles as gravity)
%patch $F83A $0000W #Down (Change direction)

#Change the animations S.K. uses (2 frames, right)
%patch $3085C $01CDW $01CEW
%patch $3087A $01CEW $01CDW

#Enlarge swimming cache for several sprites
%patch $30710 $01CDW #Keen swimming Cache start (458)
%patch $3075A $01CEW #Keen swimming cache end (462)



#################################################
#Dead Keen->Angel Keen (See also WITCH)		#
#################################################

#Kill Keen code shorter and sweet, default code to $CC3C
%patch $CBE9  $55 $8B $EC $83 $3E $D1 $C5 $00 $75 $47 $83 $3E $29 $C6 $00 $75
              $40 $B8 $0CF2W  $50 $FF $36 $D6 $A7 $9A $09DC120ARL     $83 $C4
              $04 $8B $1E $D6 $A7 $C7 $06 $B5 $CA $0000W  $C7 $06 $D1 $C5 $001EW
                  $C7 $06 $DA $A7 $0001W  $C7 $47 $06 $0000W  $C7 $47 $20 $0003W
                  $B8 $0017W  $50 $9A $187409F1RL     $83 $C4 $02 $8B $1E
              $D6 $A7 $5D $CB

#Keen death, Keen flies up offscreen
%patch $2FB62 $00A2W $00A2W $0001W $0000W $0000W $0014W $0000W $FFE8W
              $10800F56RL   $00000000L    $09DC176ERL   $0D10W
%patch $2FB80 $00A3W $00A3W $0001W $0000W $0000W $0014W $0000W $FFE8W
              $10800F56RL   $00000000L    $09DC176ERL   $0CF2W

#Dead Keen behavior (Don't fall) = $10800F56RL
%patch $11756 $55 $8B $EC $56 $8B $76 $06 $56 $90 $90 $90 $90 $90 $83 $C4 $02
              $8B $44 $16 $F7 $2E $4C $A5 $A3 $23 $C9 $56 $9A $09DC1260RL
              $83 $C4 $02 $0B $C0 $75 $06 $C7 $06 $70 $7A $0001W  
              $9A $1D02002ARL     $3D $0020W  $7D $06 $C7 $06 $70 $7A $0001W #Randomly exit level (Fixes stuck Keen bug)
              $5E $5D $CB


#################################################
#Story						#
#################################################
#Story read from
%patch $5582 $1F24RW
%patch $5587 $0003W

#Star wars story
%patch $1F243 "COMMANDER KEEN'S" $0A
              "VALENTINE BASH" $0A $0A
              "It is the eve of" $0A
              "valentine's day and all" $0A
              "is not well; Keen's" $0A
              "best friend, Johnny" $0A
              "Dash has been struck" $0A
              "lovesick, another" $0A
              "victim of the" $0A
              "pernicious holiday!" $0A $0A
              "That evening, after an" $0A
              "exhausting few hours of" $0A
%patch $1F32E "work in his backyard" $0A
              "clubhouse, Keen" $0A
              "receives an ominous" $0A
              "message from a" $0A
              "mysterious source." $0A $0A
              "The evil Count Chuck" $0A
              "has risen once again to" $0A
              "afflict the world, and" $0A
              "this time Johnny Dash" $0A
              "is under his spell!" $0A $0A
%patch $1F3F9 "Only Keen stands" $0A
              "between earth and the" $0A
              "undead hordes. Supplied" $0A
              "with a magic slingshot" $0A
              "and his wits, Keen must" $0A
              "do battle with the" $0A
              "unholy armies of the" $0A
              "Count to save his town," $0A
              "the world, his friend," $0A
              "and even..." $0A $0A $0A $0A
              "(Sigh) Valentine's day" $00 $00

#Story background palette: (Dark green = light red; dark teal = dark grey; brown = yellow)
%patch $2F05E $00 $01 $1C $18 $04 $05 $1E $07 #Dark colors
              $1F $1F $1F $1F $1F $1F $1F $1F #Light colors


#################################################
#Music						#
#################################################

#Play music whenever help loaded (Overwrite cache graphic sub)
%patch $9924 $B8 $0016W $50 $9A $06BD20C7RL $83 $C4 $02

#Number of level song entries (Hypothetically 24 levels)
%patch $8CA4 $18

#Play music in the menu
#SIDE EFEFECT: Keen menu background color black, not cyan
%patch $1CC6F $06BD20C7RL
%patch $1CC6B $0015W      #Play this level's song

#Change number of songs:
%patch $8CEF $008FW #13 extra songs
%patch $8C75 $C87BW
%patch $8C83 $C87BW
%patch $8D83 $C87BW
%patch $8C91 $13


#Songs:
#0:	On a hill	1:	Reverence	2:	Haunted Maze
#3:	What is love?	4:	Pumpkin head	5:	Tocata
#6:	Zombie chase	7:	Weird		8:	Creepie
#9:	Hall o mirrors	10:	Sadness		11:	Spookie
#12	March o undead	13:	Angel		14:	Heaven 2
#15	Alfred H.	16:	Para Lolwut	17:	Sweet
#18	Zipreet

#This is the music played in each level:
#             VALUE   LEVEL                 MUSIC PLAYED         LEVEL No
%patch $2F206 $00 $00 #Map                  (On a hill)            0
              $03 $00 #Cemetary Trail       (What is love)         1
              $06 $00 #Cemetery             (Zombie)               2
              $04 $00 #Pumpkin Patch        (Pumpkin head)         3
              $01 $00 #Tomb Hall            (Reverence)            4
              $0B $00 #Swamp                (Spookie)		   5
              $08 $00 #Dead forest          (Creepie)		   6
              $09 $00 #Old Shack            (Mirrors)	           7
              $10 $00 #Boneyard             (Para Lol)		   8
              $10 $00 #Bone Crypt           (Para Lol)		   9
              $0A $00 #Cavern of Despair    (Sadness)		  10
              $02 $00 #Broom ride	    (Haunted Maze)        11
              $07 $00 #Witch's Cottage	    (Weird)	          12
              $0F $00 #The Void		    (Alfred)              13
              $05 $00 #Chuck's lair	    (Tocata)	          14
              $0C $00 #Castle Ramenstein    (Undead)	          15
              $0A $00 #Stumbledark          (Sadness)             16
              $0E $00 #Keen's house         (Heaven)		  17
              $0D $00 #Penny Lane	    (Angel)	          18
              $0D $00 #High scores          (Angel)		  19
              $0E $00 #Bourke St	    (Heaven)		  20
              $12 $00 #Extra level 2        (Zipreet)		  21
              $11 $00 #Extra level 3        (Sweet)		  22
              $00 $00 #Extra level 4        (No music, 'Fanfare') 23
              $00 $00 #Extra level 5        (No music, 'Fanfare') 24

#Other music played: (Values here is number of LEVEL who's music is used)
%patch $5836 $0B $00 #Story demo (Weird)
%patch $9CD7 $15 $00 #Ending Sequence (Zipreet)
%patch $F107 $0B $00 #Talking to Chuck (Haunted Maze)


#################################################
#SKYPEST->BUTTERFLY				#
#################################################

#Skypest has 3 flying frames and is nonlethal
%patch $312F6 $0147W $014AW $0003W $0001W $0000W $0009W $0000W $0000W
              $0FA80BE7RL   $00000000L    $0FA80D0BRL   $24A4W
%patch $31314 $0148W $014BW $0003W $0001W $0000W $0009W $0000W $0000W
              $0FA80BE7RL   $00000000L    $0FA80D0BRL   $24C2W
%patch $31332 $0149W $0146W $0003W $0001W $0000W $0009W $0000W $0000W
              $0FA80BE7RL   $00000000L    $0FA80D0BRL   $2486W

#And two sitting animations and one dead animation
%patch $31350 $014CW $014DW $0003W $0001W $0000W $00C5W $0000W $0000W #24e0
              $00000000L    $0FA80CB0RL   $09DC176ERL   $24FEW
%patch $3136E $014CW $014DW $0003W $0001W $0000W $0005W $0000W $0000W
              $0FA80CF1RL   $0FA80CB0RL   $09DC176ERL   $2486W
%patch $3138C $014EW $014EW $0002W $0000W $0000W $0000W $0000W $0000W
              $00000000L    $00000000L    $09DC176ERL   $251CW

#Change cache:
%patch $306FE $0135W #Skypest Cache start
%patch $30748 $013DW #Skypest cache end

#Change actions:
%patch $107BA $24E0W #Skypest hit ground
%patch $10751 $251CW #When squished


#################################################
#MINE -> TOAD					#
#################################################

#Split the h/v mines into two different actions. This destroys the right
#mine sprite, IT CANNOT BE PLACED
%patch $12759 $FF $FF #Up mine doesn't move up
%patch $1275B $B8 $253AW $50 $FF $36 $D8 $A7 $9A $09DC118CRL $83 $C4 $04
              $5D $CB

#New mine actions, sit (Use fee skypest acts)
%patch $313AA $0144W $0144W $0001W $0000W $0000W $0130W $0000W $0000W
              $00000000L    $0FA80C57RL   $11A20A3CRL   $2558W
%patch $313C8 $013EW $013EW $0001W $0000W $0000W $002AW $0000W $0000W
              $00000000L    $0FA80C57RL   $11A20A3CRL   $253AW

#New mine ations, lick (Use fee skypest acts) [Note unusual calls to collision!)
%patch $313E6 $013EW $013EW $0000W $0000W $0000W $0020W $0000W $0000W
              $00000000L    $00000000L    $11A20A3CRL   $2594W
%patch $31404 $013FW $013FW $0000W $0000W $0000W $000AW $0000W $0000W
              $00000000L    $000073CERL   $11A20A3CRL   $25B2W
%patch $31422 $0140W $0140W $0000W $0000W $0000W $000AW $0000W $0000W
              $00000000L    $000073CERL   $11A20A3CRL   $25D0W
%patch $31440 $0141W $0141W $0000W $0000W $0000W $000AW $0000W $0000W
              $00000000L    $000073CERL   $11A20A3CRL   $25EEW
%patch $3145E $0142W $0142W $0000W $0000W $0000W $000AW $0000W $0000W
              $00000000L    $000073CERL   $11A20A3CRL   $260CW
%patch $3147C $0143W $0143W $0000W $0000W $0000W $000AW $0000W $0000W
              $00000000L    $000073CERL   $11A20A3CRL   $2558W

#Toad stunned (Can be splattered)
%patch $3149A $0145W $0145W $0002W $0000W $0000W $0000W $0000W $0000W
              $09DC16C9RL   $03ED01E6RL   $09DC1913RL   $0000W

#Toad collision, block shots, Keen makes it lick
%patch $106D7 $55 $8B $EC $56 $8B $76 $08 $83 $3C $02 $75 $1E $B8 $2576W  $50
              $FF $76 $06 $9A $09DC120ARL     $83 $C4 $04 $B8 $0025W  $50 $9A
              $187409F1RL     $83 $C4 $02 $5E $5D $CB $83 $3C $03 $75 $10 $B8
              $2558W  $50 $56 $FF $76 $06 $9A $09DC1695RL $83 $C4 $06 $5E $5D
              $CB

#Liking toad collision, kill Keen, stun if shot
%patch $73CE  $55 $8B $EC $56 $8B $76 $08 $83 $3C $03 $75 $13 $B8 $262AW  $50
              $56 $FF $76 $06 $9A $09DC1695RL     $83 $C4 $06 $5E $5D $CB $83
              $3C $02 $75 $05 $9A $0B8013E9RL     $5E $5D $CB

#Change mine cache to hold toad anims
%patch $30714 $013EW
%patch $3075E $0145W


#################################################
#Separate Spider from mines			#
#################################################

#Spider uses new initiation code
%patch $EF11 $03FBW 

#Spider initiation; overwrites swim K. spawn, caches single frame
%patch $ECEB $FF $76 $FC $57 $9A $06BD0B87RL     $83 $C4 $04 $B8 $2A3ARW $8A
             $16 $EC $7A $8E $C0 $26 $08 $16 $00F1W  $E9 $00F5W

#Spider spawn
%patch $7757  $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0005W  $C7 $47 $02 $0001W  $C7 $47 $20 $0000W 
              $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05
              $FF80W  $89 $47 $0C $C7 $47 $10 $0001W  $C7 $47 $0E $0000W  $B8
              $3890W  $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#Spider action
%patch $32700 $00F1W $00F1W $0002W $0000W $0000W $000AW $0000W $0000W
              $10800D44RL   $11A20D86RL   $09DC176ERL   $3890W



#################################################
#Separate Messie from mines			#
#################################################

#Inrease gem cahe by 2 for dragon anim 
%patch $30756 $00FBW

#Messie uses new initiation code
%patch $EF13 $0418W

#Messie initiation; overwrites swim K. spawn, caches single frame
%patch $ED08 $FF $76 $FC $57 $9A $11A20202RL $83 $C4 $04 $B8 $2A3ARW $8A
             $16 $EC $7A $8E $C0 $26 $08 $16 $00FBW  $E9 $00D8W

#Messie spawn = $11A20202RL
%patch $11C22 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0005W  $C7 $47 $02 $0001W  $C7 $47 $20 $0000W 
              $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05
              $FF80W  $89 $47 $0C $C7 $47 $10 $0001W  $C7 $47 $0E $0000W  $B8
              $0032W  $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#Messie action
%patch $2EEA2 $00FBW $00FBW $0002W $0000W $0000W $000AW $0000W $0000W
              $10800D44RL   $0FA804BERL   $09DC176ERL   $0032W


#################################################
#CLOUD -> SNAKE					#
#################################################

#Switch skypest/cloud so we have 3 difficulties of snake:
%patch $EA7E $0FA80B67RL #Skypest
%patch $EA69 $108001C2RL #Cloud

#Snake waiting ations (Blinks occasionally)
%patch $31710 $0135W $0135W $0001W $0000W $0000W $0140W $0000W $0000W
              $00000000L    $1080037DRL   $09DC176ERL   $2648W
%patch $314B8 $0136W $0136W $0001W $0000W $0000W $0040W $0000W $0000W
              $00000000L    $1080037DRL   $09DC176ERL   $28A0W

#Snake biting actions- nonlethal
%patch $3172E $0136W $0136W $0001W $0000W $0000W $0006W $0000W $0000W
              $00000000L    $00000000L    $11A20A3CRL   $28DCW
%patch $3174C $0137W $0137W $0001W $0000W $0000W $0006W $0000W $0000W
              $00000000L    $00000000L    $11A20A3CRL   $28FAW
%patch $3176A $0138W $0138W $0001W $0000W $0000W $0006W $0000W $0000W
              $00000000L    $06BD0856RL   $11A20A3CRL   $2918W
%patch $31788 $0139W $0139W $0001W $0000W $0000W $0006W $0000W $0000W
              $00000000L    $06BD0856RL   $11A20A3CRL   $2936W
%patch $317A6 $013AW $013AW $0001W $0000W $0000W $0006W $0000W $0000W
              $6BD00C1RL    $00000000L    $11A20A3CRL   $2954W

#Snake chomp, lethal and shootable
%patch $317C4 $013BW $013BW $0000W $0000W $0000W $0006W $0000W $0000W
              $00000000L    $06BD082ARL   $11A20A3CRL   $2972W
%patch $317E2 $013CW $013CW $0001W $0000W $0000W $0010W $0000W $0000W
              $00000000L    $06BD082ARL   $11A20A3CRL   $2990W
%patch $31800 $013BW $013BW $0001W $0000W $0000W $0006W $0000W $0000W
              $00000000L    $06BD082ARL   $11A20A3CRL   $29AEW

#Snake re-hiding actions-nonlethal
%patch $3181E $013AW $013AW $0001W $0000W $0000W $0006W $0000W $0000W
              $00000000L    $06BD0856RL   $11A20A3CRL   $29CCW
%patch $3183C $0139W $0139W $0001W $0000W $0000W $0006W $0000W $0000W
              $00000000L    $06BD0856RL   $11A20A3CRL   $29EAW
%patch $3185A $0138W $0138W $0001W $0000W $0000W $0006W $0000W $0000W
              $00000000L    $00000000L    $11A20A3CRL   $2A08W
%patch $31878 $0137W $0137W $0001W $0000W $0000W $0006W $0000W $0000W
              $00000000L    $00000000L    $11A20A3CRL   $2648W

#Stunned snake - can be splattered
%patch $31896 $013DW $013DW $0002W $0000W $0000W $0000W $0000W $0000W
              $09DC16C9RL   $03ED01E6RL   $09DC1913RL   $0000W

#Biting snake collision, kill Keen, stun if shot
%patch $73FA  $55 $8B $EC $56 $8B $76 $08 $83 $3C $03 $75 $13 $B8 $2A26W  $50
              $56 $FF $76 $06 $9A $09DC1695RL     $83 $C4 $06 $5E $5D $CB $83
              $3C $02 $75 $05 $9A $0B8013E9RL     $5E $5D $CB

#Near biting snake collision, shootable (Perfet code fit! Oh yeah!)
%patch $7426  $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $03 $75 $12
              $B8 $2A26W  $50 $57 $56 $9A $09DC1695RL     $83 $C4 $06 $83 $6C
              $18 $10 $5F $5E $5D $CB

#Play sound when attacking = $6BD00C1RL
%patch $6C91  $55 $8B $EC $56 $8B $76 $06
              $8B $44 $0A $B8 $0026W  $50 $9A $187409F1RL     $83 $C4 $02
              $5E $5D $CB

#Change cloud cache
%patch $30708 $0146W		#Cloud Cache start
%patch $30752 $014EW		#Cloud cache end


#################################################
#Mushroom -> Pumpkin				#
#################################################

#Shift all mushroom animations to 
%patch $306E6 $016EW #Mushroom Cache start
%patch $30732 $0171W #Mushroom cache end (Include Scarecrow head!)
%patch $30F54 $0170W $0170W
%patch $30F72 $016FW $016FW
%patch $30F5E $0010W
%patch $30F7C $0010W

#Spawn as nappin 'shroom
%patch $FF05  $16FCW

#New action, sitting and waiting
%patch $3056C $016EW $016EW $0000W $0000W $0000W $0006W $0000W $0000W
              $00000000L    $0D8F0BFFRL   $09DC176ERL   $16FCW

#Pumpkin collision; when touched by anything, wake up = $0D8F0BFFRL
%patch $E4EF $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $03 $74 $05
             $C7 $44 $1C $20E4W  $5F $5E $8B $E5 $5D $CB

#Make bounce behavior a little more interesting
%patch $FF90 $05 $00 #Xth jump is tall
%patch $FF97 $02 $00 #Reset value


#################################################
#Platform -> stone platform			#
#################################################

#We have two types of platform, fall-rise and infoplane
#We give he fall-rise animation

#Don't draw accessory animations on moving platform
%patch $31FF2 $09DC176ERL

#Alter cache
%patch $30704 $01EEW #Airboard Cache start
%patch $3074E $01F2W #Airboard cache end

#Resting platform animates
%patch $31FF8 $01F2W $01F2W $0004W $0000W $0000W $002EW $0000W $0000W
              $1080114FRL   $00000000L    $09DC176ERL   $2A9EW
%patch $3190E $01F1W $01F1W $0004W $0000W $0000W $002EW $0000W $0000W
              $1080114FRL   $00000000L    $09DC176ERL   $3188W

#Falling plat animates
%patch $32016 $01F0W $01F0W $0004W $0000W $0000W $0006W $0000W $0000W
              $10801182RL   $00000000L    $09DC176ERL   $2A62W
%patch $318D2 $01EFW $01EFW $0004W $0000W $0000W $0006W $0000W $0000W
              $10801182RL   $00000000L    $09DC176ERL   $31A6W

#Rising plat animates and flies up slower
%patch $32034 $01F2W $01F2W $0004W $0000W $0000W $000AW $0000W $FFF8W
              $108011FBRL   $00000000L    $09DC176ERL   $2A80W
%patch $318F0 $01F1W $01F1W $0004W $0000W $0000W $000AW $0000W $FFF8W
              $108011FBRL   $00000000L    $09DC176ERL   $31C4W

#Set infoplat anim
%patch $31FDA $01EEW $01EEW

#Moving Platform has no clipping
%patch $114C8 $06 $0000W


#################################################
#Inchworm -> Mice				#
#################################################

#SIDE EFFECT: Mice fall and need to when spawned.

#Mice flee Keen instead of seeking him
%patch $10F86 $0001W
%patch $10F8E $FFFFW

#Change cache and anims
%patch $306EC $14FW #Inchworm Cache start
%patch $30738 $152W #Inchworm cache end

#Shootable mice
%patch $31D0A $014FW $0151W $0000W $0000W $0001W $0008W $00A8W $0000W
              $10800770RL   $11A20D86RL   $09DC1795RL   $2EB8W
%patch $31D28 $0150W $0152W $0000W $0000W $0001W $0008W $00A8W $0000W
              $10800770RL   $11A20D86RL   $09DC1795RL   $2E9AW

#Initial worm spawn falls to ground (Solves sprite size problem.)
%patch $3192C $014FW $0151W $0003W $0000W $0000W $0016W $0000W $0000W
              $09DC16C9RL   $11A20D86RL   $09DC176ERL   $2E9AW
%patch $10F0C $2ABCW

#Mouse collision: shootable. (Replaces mine col) $11A20D86RL
%patch $127A6 $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $03 $75 $12
              $B8 $1F46W  $50 $57 $56 $9A $09DC1695RL     $83 $C4 $06 $83 $6C
              $18 $10 $5F $5E $5D $CB


#################################################
#Egg -> Skull					#
#################################################

#Egg collision used for blood splatter
#SIDE EFFECT: All splatterable enemies need eggs in-level

#Fix skull spawn height
%patch $1000D $FF $FF #Spawn height (0 pixels up)

#Change egg animations and cache:
%patch $30F90 $015BW $015BW	#Egg
%patch $30718 $015BW		#Egg Cache start
%patch $30762 $015FW		#Egg cache end

#Falling skull actions, use remaining skypest actions: (Now bounces off floors)
%patch $314D6 $015CW $015CW $0003W $0000W $0000W $0010W $0000W $0000W
              $09DC16C9RL   $09DC1752RL   $0FA804ECRL   $2684W
%patch $314F4 $015DW $015DW $0003W $0000W $0000W $0010W $0000W $0000W
              $09DC16C9RL   $09DC1752RL   $0FA804ECRL   $26A2W
%patch $31512 $015EW $015EW $0003W $0000W $0000W $0010W $0000W $0000W
              $09DC16C9RL   $09DC1752RL   $0FA804ECRL   $26C0W
%patch $31530 $015FW $015FW $0003W $0000W $0000W $0010W $0000W $0000W
              $09DC16C9RL   $09DC1752RL   $0FA804ECRL   $1F46W

#Splatter end action (When splats hit ground)
%patch $318B4 $00B0W $00B0W  $0003W $0000W $0000W $0124W $0000W $0000W
              $09DC16C9RL    $00000000L    $0FA8097FRL   $1F46W

#Splatter fragments fall and go to splat
%patch $30FAE $00A4W $00A4W $0003W $0000W $0000W $0034W $0000W $0000W
              $09DC16C9RL   $00000000L    $0FA8097FRL   $2A44W
%patch $30FCC $00A5W $00A5W $0003W $0000W $0000W $0034W $0000W $0000W
              $09DC16C9RL   $00000000L    $0FA8097FRL   $2A44W
%patch $30FEA $00A6W $00A6W $0003W $0000W $0000W $0034W $0000W $0000W
              $09DC16C9RL   $00000000L    $0FA8097FRL   $2A44W
%patch $31008 $00AFW $00AFW $0003W $0000W $0000W $0034W $0000W $0000W
              $09DC16C9RL   $00000000L    $0FA8097FRL   $2A44W

#New egg col, all sprites make it go to falling. Both play sound
%patch $75F7  $55 $8B $EC $56 $8B $76 $08 $83 $3C $03 $74 $1E $B8 $2666W  $50
              $FF $76 $06 $9A $09DC120ARL     $83 $C4 $04 $B8 $25 $00 $50 $9A
              $187409F1RL     $83 $C4 $02 $5E $5D $CB $B8 $2666W  $50 $56 $FF
              $76 $06 $9A $09DC1695RL     $83 $C4 $06 $B8 $25 $00 $50 $9A
              $187409F1RL $83 $C4 $02 $5E $5D $CB

#Egg uses new collision
%patch $30FA4 $000075F7RL

#Eggs are deadly to Keen but still hatch when shot
#SIDE EFFECT: No bird hatches
%patch $100BB $75
%patch $1012F $EB $29 $9A $0B8013E9RL     $5F $5E $5D $CB


#################################################
#Lick -> Wolf\Pup				#
#################################################

#Cache
%patch $30702 $01F3W #Lick Cache start
%patch $3074C $0204W #Lick cache end

#Four pup frames, sit, jump, fall, land
%patch $31E36 $01F6W $01F4W $0000W $0000W $0000W $000AW $0000W $0000W
              $10800B42RL   $06BD0AC8RL   $09DC176ERL
%patch $31E54 $01F5W $01F3W $0002W $0000W $0000W $0000W $0000W $0000W
              $09DC16C9RL   $06BD0AC8RL   $10800C71RL
%patch $31E72 $01F5W $01F3W $0002W $0000W $0000W $0000W $0000W $0000W
              $09DC16C9RL   $06BD0AC8RL   $10800C71RL
%patch $31E90 $01F6W $01F4W $0000W $0000W $0000W $000AW $0040W $0000W
              $00000000L    $06BD0AC8RL   $09DC176ERL

#Pup->Wolf, 3 frames
%patch $31EAE $01F8W $01F7W $0004W $0000W $0000W $001AW $0000W $0000W
              $09DC16E5RL   $06BD0A85RL   $0FA8097FRL
%patch $31ECC $01FAW $01F9W $0004W $0000W $0000W $001AW $0000W $0000W
              $09DC16E5RL   $06BD0A85RL   $0FA8097FRL
%patch $31EEA $01FFW $0204W $0004W $0000W $0000W $0020W $0000W $0000W
              $09DC16E5RL   $06BD0A85RL   $0FA8097FRL

#Wolf, 4 frames, inchworm behavior (But faster)
%patch $31F08 $01FBW $0200W $0000W $0000W $0001W $0006W $00A0W $0000W
              $06BD0AA5RL   $0FA80627RL   $09DC1795RL 
%patch $31F26 $01FCW $0201W $0000W $0000W $0001W $0006W $00A0W $0000W
              $06BD0AA5RL   $0FA80627RL   $09DC1795RL 
%patch $31F44 $01FDW $0202W $0000W $0000W $0001W $0006W $00A0W $0000W
              $06BD0AA5RL   $0FA80627RL   $09DC1795RL 
%patch $31F62 $01FEW $0203W $0000W $0000W $0001W $0006W $00A0W $0000W
              $06BD0AA5RL   $0FA80627RL   $09DC1795RL   $3098W

#Transforming collision, block shots
%patch $7655 $55 $8B $EC $56 $57 $8B $7E $06 $8B $76 $08 $83 $C7 $4C $83 $3C
             $03 $75 $09 $56 $9A $0D8F0D43RL     $83 $C4 $02 $5F $5E $5D $CB

#Pup behavior, always bound about, never change
%patch $11342 $55 $8B $EC $83 $EC $02 $56 $57 $8B $76 $06 $8B $44 $0A $8B $1E #Check Keen's location
              $D6 $A7 $3B $47 $0A $76 $07 $C7 $44 $0E $FFFFW  $EB $05 $C7 $44 #Change H direction to follow him
              $0E $0001W  $8B $44 $0E $B1 $05 $D3 $E0 $89 $44 $16 $C7 $44 $18
              $FFE0W  $5F $5E $8B $E5 $5D $CB                                 #Large jump

#New inchworm behavior for wolf
%patch $7675 $55 $8B $EC $56 $8B $76 $06 $8B $44 $0A $8B $1E $D6 $A7 $3B $47
             $0A $76 $08 $C7 $44 $0E $FFFFW  $5E $5D $CB $C7 $44 $0E $0001W  
             $5E $5D $CB

#New dangerous puppy collision; when touched by [<3], wake up = $0FA8004ARL
%patch $7698 $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $03 $77 $05
             $C7 $44 $1C $303EW  $5F $5E $8B $E5 $5D $CB


#################################################
#'Mom' -> Wolf   				#
#################################################

#Make 'Mom' sprite spawn attacking Wolf
%patch $EECD $12A2W #'Mom' (At $FB92)

#Attack wolf spawn code (Set pup cache) ->11AFF
%patch $FB92 $FF $76 $FC $57 $9A $11A200EFRL     $83 $C4 $04 $C7 $06 $6D $CB
             $0001W  $E9 $F256W #To $EDFD

#Wolf spawn code
%patch $11B0F $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0010W  $C7 $47 $02 $0001W  $C7 $47 $20 $0000W
              $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A $8B $46 $08 $05 $FFFFW
              $D3 $E0 $89 $47 $0C $B8 $307AW  $50 $53 $9A $09DC118CRL     $83
              $C4 $04 $5D $CB


#################################################
#'Dad' -> Harmless pup 				#
#################################################

#Make 'Dad' spawn harmless pup
%patch $EECF $3263W #'Dad' (At $11B53)

#Harmless pup spawn code (Set pup cache) ->11B58
%patch $11B53 $FF $76 $FC $57 $9A $11A20148RL     $83 $C4 $04 $C7 $06 $6D $CB
              $0001W  $E9 $D295W #To $EDFD

#Harmless pup spawn code
%patch $11B68 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0010W  $C7 $47 $02 $0001W  $C7 $47 $20 $0000W
              $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A $8B $46 $08 $05 $FFFFW
              $D3 $E0 $89 $47 $0C $B8 $31E2W  $50 $53 $9A $09DC118CRL     $83
              $C4 $04 $5D $CB

#Four harmless pup frames, sit, jump, fall, land (But don't collide with Keen)
%patch $32052 $01F6W $01F4W $0000W $0000W $0000W $000AW $0000W $0000W
              $10800B42RL   $03ED01E6RL   $09DC176ERL   $3200W
%patch $32070 $01F5W $01F3W $0002W $0000W $0000W $0000W $0000W $0000W
              $09DC16C9RL   $03ED01E6RL   $11A2018DRL   $321EW
%patch $3208E $01F5W $01F3W $0002W $0000W $0000W $0000W $0000W $0000W
              $09DC16C9RL   $03ED01E6RL   $11A2018DRL   $323CW
%patch $320AC $01F6W $01F4W $0000W $0000W $0000W $000AW $0040W $0000W
              $00000000L    $03ED01E6RL   $09DC176ERL   $31E2W

#New puppy collision, harmless, splatters if shot (Call 100CD)  =$03ED01E6RL
%patch $40B6 $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $03 $75 $03
             $E9 $C004W  $5F $5E $5D $CB

#Harmless pup landing tile collision = $11A2018DRL
%patch $11BAD $55 $8B $EC $56 $8B $76 $06 $83 $7C $36 $00 $74 $0D $B8 $323CW  #If hit ground, change to landed Lick
              $50 $56 $9A $09DC120ARL     $83 $C4 $04 $FF $74 $20 $33 $C0 $50
              $FF $74 $1E $FF $74 $0C $FF $74 $0A $8B $C6 $05 $46 $00 $50 $9A
              $16541641RL     $83 $C4 $0C $5E $5D $CB


#################################################
#Low ammo gun-> bat				#
#################################################

#SIDE EFFECT: No low ammo gun!

#Always spawn bats (Not only when low ammo!)
%patch $ECA6 $FF $EB

#Change ammo cache to include bats
%patch $306E2 $0153W #Raygun Cache start
%patch $3072C $015AW #Raygun cache end

#Spawn using new spawn code:
%patch $ECB5 $000076E2RL #Low ammo 'IF' gun (Spawned as item)

#New bat spawning code
%patch $76E2 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
             $D8 $A7 $C7 $07 $0005W  $C7 $44 $06 $0002W  $8B $46 $06 $B1 $08
             $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05 $00 $FF $89 $47 $0C
             $B8 $4080W  $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#Bat collision; when touched by anything, wake up (Currently at bounder col pos)
%patch $7721 $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $03 $74 $05
             $C7 $44 $1C $409EW  $5F $5E $8B $E5 $5D $CB

#Bat napping action
%patch $32EF0 $0153W $0153W $0000W $0000W $0000W $0006W $0000W $0000W
              $00000000L    $06BD0B51RL   $09DC176ERL   $4080W

#Bat flapping actions, 4 frames, 3 anims
%patch $32F0E $0154W $0157W $0004W $0000W $0000W $000AW $0000W $0000W
              $0FA807D7RL   $0FA80627RL   $11A20A3CRL   $40BCW
%patch $32F2C $0155W $0158W $0004W $0000W $0000W $000AW $0000W $0000W
              $0FA807D7RL   $0FA80627RL   $11A20A3CRL   $40DAW
%patch $32F4A $0156W $0159W $0004W $0000W $0000W $000AW $0000W $0000W
              $0FA807D7RL   $0FA80627RL   $11A20A3CRL   $40F8W
%patch $32F68 $0154W $0157W $0004W $0000W $0000W $000AW $0000W $0000W
              $0FA807D7RL   $0FA80627RL   $11A20A3CRL   $409EW

#Stop bat from landing
%patch $103D0 $EB #Bird doesn't land when Keen is standing on ground level with it
%patch $1048B $EB #Don't land when Keen below it and Bird near ground

#Slow bat's speed:
%patch $10391 $F4 $FF #Speed up when starting flying
%patch $1027D $0A $00 #h ACCELERATION when flying [If 0 can only move up/down]
%patch $10299 $0A $00 #Up ACCELERATION when flying
%patch $102AD $0A $00 #Down ACCELERATION when flying


#################################################
#Arachnut->Zombie				#
#################################################

#SIDE EFFECT: Zombies can fall off edges if attacking Keen

#Change cache to hold our new anims:
%patch $306FC $01D4W #Arachnut Cache start
%patch $30746 $01DFW #Arachnut cache end

#Alter spawn height to match sprite:
%patch $1053E $FE7FW

#Zombie walk, 4 frames, 3 anims
%patch $311E8 $01DAW $01D4W $0000W $0000W $0001W $0018W $0080W $0000W
              $11A204F8RL   $0FA80627RL   $09DC1795RL   $2396W
%patch $31206 $01DCW $01D6W $0000W $0000W $0001W $0018W $0080W $0000W
              $11A204F8RL   $0FA80627RL   $09DC1795RL   $23B4W
%patch $31224 $01DBW $01D5W $0000W $0000W $0001W $0018W $0080W $0000W
              $11A204F8RL   $0FA80627RL   $09DC1795RL   $23D2W
%patch $31242 $01DCW $01D6W $0000W $0000W $0001W $0018W $0080W $0000W #This frame seeks Keen
              $06BD0AA5RL   $10800793RL   $09DC1795RL   $2378W        #Also destroys excess z.

#Zombie attcking frames, 3 frames
%patch $31260 $01DDW $01D7W $0003W $0000W $0000W $000AW $0000W $0000W
              $09DC16C9RL   $0FA80627RL   $09DC176ERL   $240EW
%patch $3127E $01DEW $01D8W $0003W $0000W $0000W $000AW $0000W $0000W
              $09DC16C9RL   $0FA80627RL   $09DC176ERL   $242CW
%patch $3129C $01DFW $01D9W $0002W $0000W $0000W $000AW $0000W $0000W
              $09DC16C9RL   $0FA80627RL   $09DC1913RL   $23D2W

#New behavior, wormouth-oid to attck Keen at y-range FD-01, x-range 03-FE
%patch $11F18 $55 $8B $EC $83 $EC $02 $56 $57 $8B $76 $06 $8B $1E $D6 $A7 $8B
              $47 $0A $2B $44 $0A $8B $F8 $8B $47 $28 $2B $44 $28 $89 $46 $FE
              $81 $7E $FE $FD00W  $7C $24 $81 $7E $FE $0100W  $7F $1D $81 $FF
              $0300W  $7D $17 $81 $FF $FE00W  $7E $11 $B8 $0005W  $50 $9A $187409F1RL
                      $83 $C4 $02 $C7 $44 $1C $23F0W  $5F $5E $8B $E5 $5D $CB


#################################################
#Dart shooter -> Zombie grave, dart shooter	#
#################################################

#Zombie grave\dart freq
%patch $327DC $0196W        #Animation speed

#Change dart cache to hold zombie anims:
%patch $3070E $01CFW #Darts Cache start
%patch $30758 $01D4W #Darts cache end

#Alter sprites used for dart positioning
%patch $128B2 $01D0W #Up dart
%patch $128C6 $01CEW #Right dart
%patch $128D6 $01CBW #Down dart
%patch $128E9 $01CBW #Left dart

#Zombie spawns at ground level from shooter 1 tile below.
%patch $128A9 $80     #Up dart v [+80!]
%patch $128AD $0000W  #Up dart h [+00!]

#Rising zombie actions
%patch $3282C $01D0W $01D0W $0000W $0000W $0000W $0018W $0000W $0000W
              $00000000L    $11A20D86RL   $09DC176ERL   $39DAW
%patch $3284A $01D1W $01D1W $0000W $0000W $0000W $0018W $0000W $0000W
              $00000000L    $11A20D86RL   $09DC176ERL   $244AW
%patch $312BA $01D2W $01D2W $0000W $0000W $0000W $0018W $0000W $0000W
              $00000000L    $11A20D86RL   $09DC176ERL   $2468W
%patch $312D8 $01D3W $01D3W $0000W $0000W $0000W $0018W $0000W $0000W
              $00000000L    $11A20D86RL   $09DC176ERL   $23D2W

#Too many enemies collision, destroy surplus enemies
%patch $10F93 $55 $8B $EC $56 $57 $8B $76 $06 $8B $44 $3E $3B $06 $48 $A5 $74
              $0B $A1 $48 $A5 $89 $44 $3E $C7 $44 $40 $00 $00 $FF $44 $40 $8B
              $44 $40 $3D $0003W  $74 $03 $E9 $0040W  $B8 $0025W  $50 $9A     #Check for 2 other
          $187409F1RL     $83 $C4 $02 $81 $6C $0C $00 $00 $C7 $04 $0003W  $B8
              $240EW  $50 $56 $9A $09DC120ARL     $83 $C4 $04 $8B $1E $D6 $A7 #Enemy splatters
              $8B $7F $48 $EB $11 $83 $3D $10 $75 $09 $57 $9A $06BD1E8BRL     #Remv sprt $10
              $83 $C4 $02 $8B $7D $48 $0B $FF $75 $EB $5F $5E $5D $CB


#################################################
#Slug->Skeleton					#
#################################################

#Change slug cache to that of skeleton
%patch $306E6 $015BW #Slug Cache start
%patch $30730 $016DW #Slug cache end

#Change slug spawn to sleeping skel- remove random l\r facing
%patch $FD7E  $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0005W  $C7 $47 $02 $0001W  $C7 $47 $20 $0002W
              $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05
              $FF8FW  $89 $47 $0C $8B $1E $D8 $A7 $C7 $47 $0E $FFFFW  $8B $1E
              $D8 $A7 $C7 $47 $10 $0001W  $B8 $2ADAW  $50 $53 $9A $09DC118CRL
                  $83 $C4 $04 $5D $CB

#Sleeping skeleton collision; when 'touched' by Keen, wake up
%patch $773C $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $03 $7F $05
             $C7 $44 $1C $2012W  $5F $5E $8B $E5 $5D $CB

#Sleeping skeleton action
%patch $3194A $0160W $0161W $0000W $0000W $0000W $0000W $0000W $0000W
              $00000000L    $06BD0B6CRL   $09DC176ERL   $2ADAW

#Falling skeleton action
%patch $30E82 $0167W $0163W $0002W $0000W $0000W $0000W $0000W $0000W
              $09DC16C9RL   $06BD0B6CRL   $09DC1913RL   $2030W

#Walking skeleton actions
%patch $30EA0 $0166W $0162W $0000W $0000W $0001W $0010W $0090W $0000W
              $06BD0AA5RL   $0D8F0A5BRL   $09DC1795RL   $204EW
%patch $30EBE $0167W $0163W $0000W $0000W $0001W $0010W $0090W $0000W
              $06BD0AA5RL   $0D8F0A5BRL   $09DC1795RL   $206CW
%patch $30EDC $0168W $0164W $0000W $0000W $0001W $0010W $0090W $0000W
              $06BD0AA5RL   $0D8F0A5BRL   $09DC1795RL   $208AW
%patch $30EFA $0169W $0165W $0000W $0000W $0001W $0010W $0090W $0000W
              $06BD0AA5RL   $0D8F0A5BRL   $09DC1795RL   $2030W

#New colision for skeleton
%patch $E34B $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $74 $08 #If keen, jump 8
             $83 $3D $03 $74 $03 $E9 $36 $01 $83 $3D $02 $75 $0D $57 $9A     #If not shot end
          $0B8013E9RL    $83 $C4 $02 $5F $5E $5D $CB $C7 $44 $02 $0003W  $B8 #If Keen, kill, end
             $1666W  $50 $56 $9A $09DC120ARL     $83 $C4 $04 $B8 $0001W  $50 #Change to skull
             $9A $06BD1E11RL     $83 $C4 $02 $8B $1E $D8 $A7 $C7 $07 $001BW  
             $C7 $47 $02 $0001W  $8B $44 $0A $89 $47 $0A $8B $44 $0C $2D $80
             $00 $89 $47 $0C $8B $44 $0A $8B $1E $D6 $A7 $3B $47 $0A $73 $0B
             $8B $1E $D8 $A7 $C7 $47 $0E $0001W  $EB $09 $8B $1E $D8 $A7 $C7
             $47 $0E $FFFFW  $8B $1E $D8 $A7 $C7 $47 $10 $0001W  $B8 $1E38W  #Spawn bone 1
             $50 $53 $9A $09DC118CRL     $83 $C4 $04 $B8 $0001W  $50 $9A    
          $06BD1E11RL    $83 $C4 $02 $8B $1E $D8 $A7 $C7 $07 $0001W  $C7 $47
             $02 $0003W  $8B $44 $0A $89 $47 $0A $8B $44 $0C $89 $47 $0C $C7
             $47 $16 $FFE4W  $C7 $47 $18 $FFD8W  $B8 $1684W  $50 $53 $9A     #Spawn 2
          $09DC118CRL    $83 $C4 $04 $B8 $0001W  $50 $9A $06BD1E11RL     $83
%patch $E42B $C4 $02 $8B $1E $D8 $A7 $C7 $07 $0001W  $C7 $47 $02 $0003W  $8B
             $44 $0A $89 $47 $0A $8B $44 $0C $89 $47 $0C $C7 $47 $16 $001CW 
             $C7 $47 $18 $FFD8W  $B8 $16A2W  $50 $53 $9A $09DC118CRL     $83 #Spawn 3
             $C4 $04 $B8 $0001W  $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
             $D8 $A7 $C7 $07 $0001W  $C7 $47 $02 $0003W  $8B $44 $0A $89 $47
             $0A $8B $44 $0C $89 $47 $0C $C7 $47 $16 $0000W  $C7 $47 $18 
          $FFC8W $B8 $16C0W  $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5F $5E #Spawn 4
             $5D $CB

#Inelegant Skeleton shot skull head action (To make scream)
%patch $30CA8 $015CW $015CW $0000W $0000W $0000W $0010W $0000W $0000W
              $6BD00A8RL    $09DC1752RL   $0FA804ECRL   $2666W

#Play sound = $6BD00A8RL
%patch $6C78  $55 $8B $EC $56 $8B $76 $06
              $8B $44 $0A $B8 $0025W  $50 $9A $187409F1RL     $83 $C4 $02
              $5E $5D $CB

#Skeleton bone fragments
%patch $304D6 $016AW $016AW $0003W $0000W $0000W $0038W $0000W $0000W
              $09DC16C9RL   $00000000L    $09DC176ERL   $16DEW
%patch $304F4 $016BW $016BW $0003W $0000W $0000W $0044W $0000W $0000W
              $09DC16C9RL   $00000000L    $09DC176ERL   $16DEW
%patch $30512 $016CW $016CW $0003W $0000W $0000W $0034W $0000W $0000W
              $09DC16C9RL   $00000000L    $09DC176ERL   $16DEW
%patch $30530 $016DW $016DW $0003W $0000W $0000W $0040W $0000W $0000W
              $09DC16C9RL   $00000000L    $09DC176ERL   $16DEW

#Landed bone fragments
%patch $3054E $016AW $016AW  $0003W $0000W $0000W $0100W $0000W $0000W
              $09DC16C9RL    $00000000L    $09DC176ERL   $17B0W


#################################################
#Create walking Skeleton for boneyards		#
#################################################

#Use before swimKeen as walking skeleton
%patch $EED5 $123BW #Mooning Keen (At $FB2B)

#New initiation code (Activates skeleton cache)
%patch $FB2B $FF $76 $FC $57 $9A $03ED0137RL     $83 $C4 $04 $C7 $06 $51 $CB
             $0001W  $E9 $F2BDW #To $EDFD

#New spawning code = $03ED0137RL
%patch $4007 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
             $D8 $A7 $C7 $07 $0005W  $C7 $44 $02 $0001W  $8B $46 $06 $B1 $08
             $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05 $00 $FF $89 $47 $0C
             $B8 $2012W  $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB


#################################################
#Dart shooter->Organ grinder			#
#################################################



#Change start sprites of projectiles to synch
%patch $128C6 $01CFW #Right dart
%patch $128D6 $7E $01 #Down dart
%patch $128E9 $01CFW #Left dart

#Set organs to have direction
%patch $12965 $0001W #Right Dart
%patch $1299F $FFFFW #Left dart

#Set organs to have horizontal speeds
%patch $12967 $C7 $47 $16 $0020W #Right
%patch $129A1 $C7 $47 $16 $FFD0W #Left

#Change horz dart action to be ballistic organs (Only one frame)
%patch $327F0 $01CFW $01CFW $0000W $0000W $0000W $0002W $0000W $0000W
              $09DC16E5RL   $09DC1752RL   $11A20CA1RL   $3980W

#Verical dart action is falling organs (Only one frame)
%patch $32868 $00A5W $00A5W $0002W $0000W $0000W $0000W $0000W $0000W
              $09DC16C9RL   $09DC1752RL   $11A20CA1RL   $39F8W

#Don't make sound when spawning organs
%patch $129B7 $90 $90 $90 $90 $90


#################################################
#Foot in level -> ghost				#
#################################################

#Foot spawning now caches Moon Keen cache (Replace Foot initiation with smaller version)
%patch $EA8E $FF $76 $FC $57 $9A $1080072CRL     $83 $C4 $04 $C7 $06 $81 $CB
             $0001W  $E9 $035AW

#Ghost cache
%patch $30716 $0205W #Ghost Cache start
%patch $30760 $0208W #Ghost cache end

#Make ghost from foot
%patch $10F62 $20C6W             #Spawn ghost
%patch $10F40 $0005W             #Ghost doesn't send Keen to map
%patch $10F42 $C7 $47 $06 $0000W #Ghost has no clipping
%patch $10F4A $0003W             #Ghost is in front of ALL tiles
%patch $12558 $0003W             #Speed up
%patch $1256C $0003W             #Speed down
%patch $1253C $0003W             #Speed l/r

#Ghost actions, two actions, schoolfish behavior.
%patch $30F36 $0205W $0207W $0003W $0000W $0000W $0007W $0000W $0000W
              $11A20AF6RL   $09DC1752RL   $09DC176ERL   $0014W
%patch $2EE84 $0206W $0208W $0003W $0000W $0000W $0007W $0000W $0000W
              $11A20AF6RL   $09DC1752RL   $09DC176ERL   $20C6W


#################################################
#Smirky->Map-Broom-Active			#
#################################################

#Chocolate sprite cache contains broom anim
%patch $306D4 $00E2W #Soda Cache start

#Broom spawning code (Overwrites Smirky code)
%patch $11A2E $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0011W  $C7 $47 $02 $0001W  $C7 $47 $20 $0000W
              $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A $8B $46 $08 $05 $FFFFW
              $D3 $E0 $89 $47 $0C $B8 $1A64W  $50 $53 $9A $09DC118CRL     $83
              $C4 $04 $5D $CB

#Broom action - appears invisible with wide collision box
%patch $308D4 $00E2W $00E2W $0000W $0000W $0000W $001CW $0000W $0000W
              $00000000L    $11A201C7RL   $09DC176ERL   $1A64W

#Mushroom collision - type 2 runs sprite alteration sub = $11A201C7RL
%patch $11BE7 $55 $8B $EC $56 $57 $8B $7E $06 $8B $76 $08 $83 $C7 $4C $83 $3C
              $02 $75 $09 $56 $9A $11A201E7RL     $83 $C4 $02 $5F $5E $5D $CB

#New MBA collision, transform type 2 to falling Keen = $11A201E7RL
%patch $11C07 $55 $8B $EC $56 $8B $76 $06 $C7 $04 $01 $00 $B8 $11C0W  $50 $56
              $9A $09DC120ARL     $83 $C4 $04 $5E $5D $CB


#################################################
#'I' Keen-> Attack Brrom			#
#################################################

#Broom cache 366-369
%patch $306F0 $0180W #Smirky Cache start
%patch $3073A $0185W #Smirky cache end

#'I Keen' uses new initation code
%patch $EECB $1263W #At $FB53

#Attack broom initation code- use Atk Broom spawn code at E116, set Smirky cache
%patch $FB53 $FF $76 $FC $57 $9A $0D8F0826RL     $83 $C4 $04 $C7 $06 $5B $CB
             $0001W  $E9 $F295W #To $EDFD

#Attack broom spawning code
%patch $0E116 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0010W  $C7 $47 $02 $0001W  $C7 $47 $20 $0000W
              $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A $8B $46 $08 $05 $FFFFW
              $D3 $E0 $89 $47 $0C $B8 $1A28W  $50 $53 $9A $09DC118CRL     $83
              $C4 $04 $5D $CB

#Attack broom actions
%patch $30898 $0184W $0182W $0004W $0000W $0000W $000AW $0000W $0000W
              $0FA807D7RL   $037D0526RL   $11A20A3CRL  $1A46W
%patch $308B6 $0185W $0183W $0004W $0000W $0000W $000AW $0000W $0000W
              $0FA807D7RL   $037D0526RL   $11A20A3CRL  $1A28W


#################################################
#Sprite -> Witch (And new Keen death)		#
#################################################

#Change cache
%patch $30712 $012BW #Sprite Cache start (Incl new dead Keen anims)
%patch $3075C $0134W #Sprite cache end

#Sprite actions (Two frames, third aims, shoots)
%patch $32610 $0131W $0132W $0004W $0000W $0000W $000AW $0000W $0000W
              $0FA807D7RL   $0FA80627RL   $11A20A3CRL  $37BEW
%patch $3262E $0134W $0133W $0004W $0000W $0000W $000AW $0000W $0000W
              $0FA807D7RL   $0FA80627RL   $11A20A3CRL  $37FAW
%patch $3266A $0134W $0133W $0004W $0000W $0000W $0002W $0000W $0000W
              $11A20BB1RL   $0FA80627RL   $11A20A3CRL  $37A0W

#Shooting
%patch $3264C $0134W $0133W $0004W $0000W $0000W $000CW $0000W $0000W
              $11A20C3BRL   $0FA80627RL   $11A20A3CRL  $37A0W

#Sprite shoots directly, doesn't aim
%patch $12633 $37DCW

#Sprite clipping
%patch $125A2 $0001W

#Sprite shot actions, new frames, animate faster, send Keen to death #2
%patch $32688 $012DW $0130W $0001W $0000W $0000W $000AW $0040W $0000W
              $00000000L    $0D8F0BADRL   $11A20CA1RL   $3836W
%patch $326A6 $012EW $012FW $0001W $0000W $0000W $000AW $0040W $0000W
              $00000000L    $0D8F0BADRL   $11A20CA1RL   $3854W
%patch $326C4 $012FW $012EW $0001W $0000W $0000W $000AW $0040W $0000W
              $00000000L    $0D8F0BADRL   $11A20CA1RL   $3872W
%patch $326E2 $0130W $012DW $0001W $0000W $0000W $000AW $0040W $0000W
              $00000000L    $0D8F0BADRL   $11A20CA1RL   $3818W

#Second Keen death (By green sparks) Cannot be killed again
%patch $CC3C  $55 $8B $EC $83 $3E $D1 $C5 $00 $75 $45 $83 $3E $29 $C6 $00 $75
              $3E $B8 $399EW  $50 $FF $36 $D6 $A7 $9A $09DC120ARL     $83 $C4
              $04 $8B $1E $D6 $A7 $C7 $06 $B5 $CA $0000W  $C7 $07 $0021W
                  $C7 $06 $DA $A7 $0001W  $C7 $47 $06 $0000W  $C7 $47 $20 $0003W
                  $B8 $0017W  $50 $9A $187409F1RL     $83 $C4 $02 $8B $1E
              $D6 $A7 $5D $CB

#Gren spark collision, send Keen to CC3C (2nd death) is $0D8F0BADRL
%patch $E49D  $55 $8B $EC $56 $57 $8B $7E $06 $8B $7E $08 $83 $3D $02 $75 $0E
              $83 $3D $02 $75 $05 $57 $9A $0B80143CRL     $83 $C4 $02 $5F $5E
              $5D $CB

#New Keen death actions ($399EW)
%patch $3280E $012CW $012BW $0001W $0000W $0000W $0014W $0000W $0000W
              $0D8F0BCFRL   $00000000L    $09DC176ERL   $3A16W
%patch $32886 $012BW $012CW $0002W $0000W $0000W $0014W $0000W $0000W
              $0D8F0BCFRL   $00000000L    $09DC176ERL   $399EW

#Dead Keen 2 behavior (Fall) is $0D8F0BCFRL
%patch $E4BF $55 $8B $EC $56 $8B $76 $06 $56 $9A $09DC1315RL     $83 $C4 $02
             $8B $44 $16 $F7 $2E $4C $A5 $A3 $23 $C9 $56 $9A $09DC1260RL
             $83 $C4 $02 $0B $C0 $75 $06 $C7 $06 $70 $7A $0001W  $5E $5D $CB


#################################################
#Mooning Keen - stationary bat (2 frames)	#
#################################################

#Reroute spawn pointer to new initiation code
%patch $EF19 $128DW #Mooning Keen (At $FB7D)

#New initiation code (Activates Bat cache)
%patch $FB7D $FF $76 $FC $57 $9A $0FA80354RL     $83 $C4 $04 $C7 $06 $4D $CB
             $0001W  $E9 $F26BW #To $EDFD

#New spawning code
%patch $FDD4 $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
             $D8 $A7 $C7 $07 $0005W  $C7 $44 $02 $0000W  $8B $46 $06 $B1 $08
             $D3 $E0 $89 $47 $0A $8B $46 $08 $D3 $E0 $05 $00 $FF $89 $47 $0C
             $B8 $011FW  $50 $53 $9A $09DC118CRL     $83 $C4 $04 $5D $CB

#Flying bat actions, 2 frames = $011FW
%patch $2EF8F $0156W $0156W $0000W $0000W $0000W $000AW $0000W $0000W
              $09DC1701RL   $0FA80627RL   $09DC176ERL   $013DW
%patch $2EFAD $0155W $0155W $0000W $0000W $0000W $000AW $0000W $0000W
              $09DC1701RL   $0FA80627RL   $09DC176ERL   $011FW


#################################################
#Mimrock->Vampire				#
#################################################

#Swap Mimrock and Dopefish spawns and cache:
%patch $EB5E $11A20447RL #Dopefish
%patch $EBC6 $11A20690RL #Mimrock
%patch $306F8 $01E0W     #Dopefish Cache start
%patch $30742 $01EDW     #Dopefish cache end

#Change fore behavior to prevent odd looking bug
%patch $11E85 $0002W #Mimrock

#Alter spawn height to compensate for sprite size
%patch $11E97 $FEB0W #13 pixels up

#Vampire hide - only eyes visible
%patch $322AA $01EDW $01EDW $0000W $0000W $0001W $000AW $0000W $0000W
              $09DC1701RL   $11A20052RL   $09DC1795RL   $343AW

#Vampire awaken actions, 5 frames
%patch $322C8 $01ECW $01ECW $0000W $0000W $0001W $000AW $0000W $0000W
              $09DC1701RL   $00000000L    $09DC1795RL   $3476W
%patch $322E6 $01EBW $01EBW $0000W $0000W $0001W $000AW $0000W $0000W
              $09DC1701RL   $00000000L    $09DC1795RL   $3494W
%patch $32304 $01EAW $01EAW $0000W $0000W $0001W $000AW $0000W $0000W
              $09DC1701RL   $00000000L    $09DC1795RL   $34B2W
%patch $32322 $01E9W $01E9W $0000W $0000W $0001W $000AW $0000W $0000W
              $09DC1701RL   $00000000L    $09DC1795RL   $34D0W
%patch $32340 $01E8W $01E8W $0000W $0000W $0001W $000AW $0000W $0000W
              $09DC1701RL   $00000000L    $09DC1795RL   $34EEW

#Vampire run actions (Random revert behavior) 4 frames
%patch $3235E $01E4W $01E0W $0000W $0000W $0001W $000AW $00A0W $0000W #Seek Keen
              $06BD0AA5RL   $0FA80627RL   $09DC1795RL   $350CW
%patch $3237C $01E5W $01E1W $0000W $0000W $0001W $000AW $00A0W $0000W
              $11A2006DRL   $0FA80627RL   $09DC1795RL   $352AW
%patch $3239A $01E6W $01E2W $0000W $0000W $0001W $000AW $00A0W $0000W
              $11A2006DRL   $0FA80627RL   $09DC1795RL   $3548W
%patch $323B8 $01E7W $01E3W $0000W $0000W $0001W $000AW $00A0W $0000W
              $11A2006DRL   $0FA80627RL   $09DC1795RL   $34EEW

#Vampire nap actions, 5 frames - 1
%patch $323D6 $01E8W $01E8W $0000W $0000W $0001W $000AW $0000W $0000W
              $09DC1701RL   $00000000L    $09DC1795RL   $3584W
%patch $323F4 $01E9W $01E9W $0000W $0000W $0001W $000AW $0000W $0000W
              $09DC1701RL   $00000000L    $09DC1795RL   $35A2W
%patch $32412 $01EAW $01EAW $0000W $0000W $0001W $000AW $0000W $0000W
              $09DC1701RL   $00000000L    $09DC1795RL   $3692W
%patch $32502 $01EBW $01EBW $0000W $0000W $0001W $000AW $0000W $0000W
              $09DC1701RL   $00000000L    $09DC1795RL   $343AW

#New vampire collision, if Keen, awaken (->$3458W) = $11A20052
%patch $11A72 $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $05
              $C7 $44 $1C $3458W  $5F $5E $8B $E5 $5D $CB

#New Vampire behavior, randomly revert to napping = $11A2006D
%patch $11A8D $55 $8B $EC $56 $8B $76 $06 $9A $1D02002ARL     $3D $0010W  $7D
              $1D $8B $44 $0A $8B $1E $D6 $A7 $3B $47 $0A $73 $07 $C7 $44 $0E
              $0001W  $EB $05 $C7 $44 $0E $FFFFW  $C7 $44 $1C $3566W
              $5E $5D $CB


#################################################
#Miragia -> special doors			#
#################################################

#Miragia spawning code
%patch $FA80  $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0001W  $C7 $47 $02 $0002W  $8B $46 $06 $89 $47
              $0A $8B $46 $08 $89 $47 $0C $C7 $47 $1C $1DFCW  $5D $CB

#Miragia cycle 1- Check for blue gem = 1
%patch $FAAE  $55 $8B $EC $56 $57 $8B $7E $06 $8B $1E $D6 $A7 $90 $83 $3E $7A62W
                  $00 $77 $22
                                                          $B8 $0004W  $50 $B8 #If no Key, block 1 is 2x4 at 26,3F
              $0002W  $50 $FF $75 $0C $FF $75 $0A $B8 $003FW  $50 $B8 $0026W
              $50 $9A $16540D78RL     $83 $C4 $0C $5F $5E $5D $CB
                                                          $B8 $0004W  $50 $B8 #If Key, block 1 is 2x4 at 26,3F
              $0002W  $50 $FF $75 $0C $FF $75 $0A $B8 $003FW  $50 $B8 $0028W
              $50 $9A $16540D78RL     $83 $C4 $0C $5F $5E $5D $CB


#Miragia action
%patch $30C6C $0000W $0000W $0000W $0000W $0000W $0080W $0000W $0000W
              $0FA8002ERL   $00000000L    $00000000L    $1DFCW


#################################################
#Schoolfish -> Lots of float enemies		#
#################################################

#Cache all sorts of graphics (391-395)
%patch $306FA $0187W #Schoolfish Cache start
%patch $30744 $018BW #Schoolfish cache end

#Schoolfish floating actions, 2 frames, deadly smush collision
%patch $325D4 $0187W $018AW $0003W $0000W $0000W $0007W $0000W $0000W
              $11A20AF6RL   $037D067ARL   $11A20A3CRL   $3782W
%patch $325F2 $0188W $0189W $0003W $0000W $0000W $0007W $0000W $0000W
              $11A20AF6RL   $037D067ARL   $11A20A3CRL   $3764W

#Schoolfish clipping
%patch $124E5 $0001W #Stop Objclass error


#################################################
#Berkeloid->Scarecrow				#
#################################################

#Cache
%patch $3070A $0171W #Berkeloid Cache start
%patch $30754 $0181W #Berkeloid cache end

#Berkeloid spawn, if wrong difficulty, they appear as heads (@FB68)
%patch $E9E9 $83 $3E $7A6CW  $03 $7D $03 $E9 $1175W  $83 $3E $7A6CW  $02 $7D
             $03 $E9 $116BW  $FF $76 $FC $57 $9A $1080039BRL     $83 $C4 $04
             $C7 $06 $75 $CB $0001W  $E9 $03EBW

#Scarecrow head initaation code
%patch $FB68 $FF $76 $FC $57 $9A $0D8F0C1ARL     $83 $C4 $04 $C7 $06 $75 $CB
             $0001W  $E9 $F280W

#Stationary Scarecrow spawn code - make heads
%patch $0E50A $55 $8B $EC $33 $C0 $50 $9A $06BD1E11RL     $83 $C4 $02 $8B $1E
              $D8 $A7 $C7 $07 $0010W  $C7 $47 $02 $0001W  $C7 $47 $20 $0000W
              $8B $46 $06 $B1 $08 $D3 $E0 $89 $47 $0A $8B $46 $08 $05 $FFFFW
              $D3 $E0 $89 $47 $0C $B8 $2C42W  $50 $53 $9A $09DC118CRL     $83
              $C4 $04 $5D $CB

#Alter spawn height to match sprite:
%patch $10BCB $00 $FE #Spawn height (1 tile up, z = fe7f)

#Stationary head,
%patch $3058A $0171W $0171W $0003W $0000W $0000W $0010W $0080W $0000W
              $0FA80493RL   $037D067ARL   $0FA804ECRL   $2C60W

#Scare walk (Faster animation than Zombie)
%patch $31968 $0176W $0175W $0000W $0000W $0001W $0010W $0080W $0000W
              $11A2009ERL   $037D055BRL   $09DC1795RL   $2B16W
%patch $31986 $0177W $0174W $0000W $0000W $0001W $0010W $0080W $0000W
              $11A2009ERL   $037D055BRL   $09DC1795RL   $2B34W
%patch $319A4 $0178W $0173W $0000W $0000W $0001W $0010W $0080W $0000W
              $11A2009ERL   $037D055BRL   $09DC1795RL   $2B52W
%patch $319C2 $0179W $0172W $0000W $0000W $0001W $0010W $0080W $0000W #This frame seeks Keen
              $06BD0AA5RL   $037D055BRL   $09DC1795RL   $2AF8W

#Scarecrow flaming actions, 5+1 frames
%patch $319E0 $017DW $017AW $0003W $0000W $0001W $0028W $0000W $0000W
              $09DC16C9RL   $037D055BRL   $09DC176ERL   $2B8EW
%patch $319FE $017EW $017BW $0003W $0000W $0001W $0018W $0000W $0000W
              $09DC16C9RL   $037D055BRL   $09DC176ERL   $2BACW
%patch $31A1C $017FW $017CW $0003W $0000W $0001W $0018W $0000W $0000W
              $09DC16C9RL   $037D055BRL   $09DC176ERL   $2BCAW
%patch $31A3A $017EW $017BW $0003W $0000W $0001W $0018W $0000W $0000W
              $09DC16C9RL   $037D055BRL   $09DC176ERL   $2BE8W
%patch $31A58 $017FW $017CW $0003W $0000W $0001W $0018W $0000W $0000W
              $09DC16C9RL   $037D055BRL   $09DC176ERL   $2C06W
%patch $31A76 $0179W $0172W $0003W $0000W $0000W $0010W $0080W $0000W
              $0FA80493RL   $0FA80627RL   $0FA80086RL   $2C06W        #(If moves ff of edge or on slope)

#Scarecrow fall down slopes, off edges tile col = $0FA80086RL
%patch $FB06  $55 $8B $EC $56 $8B $76 $06 $83 $7C $3A $00 $74 $05 $C7 $44 $18
              $0000W  $83 $7C $36 $00 $74 $0A $C7 $44 $18 $0000W  $C7 $44 $1C
              $2B52W  $5E $5D $CB

#New behavior, wormouth-oid to attck Keen at y-range FD-01, x-range 03-FE SCARECROW is $11A20079RL
%patch $11ABE $55 $8B $EC $83 $EC $02 $56 $57 $8B $76 $06 $8B $1E $D6 $A7 $8B
              $47 $0A $2B $44 $0A $8B $F8 $8B $47 $28 $2B $44 $28 $89 $46 $FE
              $81 $7E $FE $FD00W  $7C $24 $81 $7E $FE $0100W  $7F $1D $81 $FF
              $0300W  $7D $17 $81 $FF $FE00W  $7E $11 $B8 $0005W  $50 $9A $187409F1RL
                      $83 $C4 $02 $C7 $44 $1C $2B70W  $5F $5E $8B $E5 $5D $CB

#Scarecrow head (Bounces) = $2C42, $2C60 -uses mush behavior and head collision
%patch $31AB2 $0171W $0171W $0003W $0000W $0000W $0010W $0080W $0000W
              $0FA80493RL   $037D067ARL   $0FA804ECRL   $2C60W
%patch $31AD0 $0171W $0171W $0003W $0000W $0000W $0010W $0080W $0000W
              $0FA80493RL   $037D067ARL   $0FA804ECRL   $2C42W

#Straw fragments fall and go to splat (Not shown, head) = $2C24, $2C7E
%patch $31A94 $0181W $0181W $0003W $0000W $0000W $0024W $0000W $0000W
              $09DC16C9RL   $00000000L    $09DC176ERL   $2A44W
%patch $31AEE $0180W $0180W $0003W $0000W $0000W $0024W $0000W $0000W
              $09DC16C9RL   $00000000L    $09DC176ERL   $2A44W

#Disable EGAGRAPH check (Frees 389 bytes at $3CF6 for Scare collision)
%patch $3CE5 $90 $90

#Broom collision = $037D0526RL
%patch $3CF6  $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $03 $75 $0B
              $57 $9A $0D8F0D43RL $83 $C4 $02 $EB $0B $83 $3D $02 $74 $03 $E9
              $0146W  $E9 $013EW  $C7 $04 $0001W  $C7 $44 $02 $0003W  $B8 $213EW
                  $50 $EB $36

#Scare collision = $037D055BRL to $3E4A
%patch $3D2B  $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $03 $74 $0B
              $83 $3D $02 $74 $03 $E9 $00FDW  $E9 $0114W  $83 $3D $03 $75 $09 $57 $9A
              $0D8F0D43RL $83 $C4 $02 $C7 $04 $0001W  $C7 $44 $02 $0003W  $B8 #Make large shell
              $2C42W  $50 $56 $9A $09DC120ARL     $83 $C4 $04 $B8 $0001W  $50
              $9A $06BD1E11RL     $83 $C4 $02 $8B $1E $D8 $A7 $C7 $07 $001BW  #Make Bird
              $C7 $47 $02 $0001W  $8B $44 $0A $89 $47 $0A $8B $44 $0C $2D $0080W
%patch $3D8F      $89 $47 $0C $8B $44 $0A $8B $1E $D6 $A7 $3B $47 $0A $73 $0B
              $8B $1E $D8 $A7 $C7 $47 $0E $0001W  $EB $09 $8B $1E $D8 $A7 $C7
              $47 $0E $FFFFW  $8B $1E $D8 $A7 $C7 $47 $10 $0001W  $B8 $2C24W
              $50 $53 $9A $09DC118CRL     $83 $C4 $04 $B8 $0001W  $50 $9A
              $06BD1E11RL $83 $C4 $02 $8B $1E $D8 $A7 $C7 $07 $0001W  $C7 $47 #Make left shell
              $02 $0003W  $8B $44 $0A $89 $47 $0A $8B $44 $0C $89 $47 $0C $C7
              $47 $16 $FFE4W  $C7 $47 $18 $FFD8W  $B8 $2C7EW  $50 $53 $9A
              $09DC118CRL $83 $C4 $04 $B8 $0001W  $50 $9A $06BD1E11RL     $83
              $C4 $02 $8B $1E $D8 $A7 $C7 $07 $0001W  $C7 $47 $02 $0003W  $8B #Make right shell
              $44 $0A $89 $47 $0A $8B $44 $0C $89 $47 $0C $C7 $47 $16 $001CW
              $C7 $47 $18 $FFD8W  $B8 $2C24W  $50 $53 $9A $09DC118CRL     $83
              $C4 $04 $5F $5E $5D $CB

#Pumpkin head collision - near perfect code fit! =$037D067ARL
%patch $3E4A  $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $09
              $9A $0B8013E9RL     $5F $5E $5D $CB $83 $3D $03 $75 $0E 
              $B8 $1F46W  $50 $57 $56 $9A $09DC1695RL  $83 $C4 $06 $5F $5E $5D $CB


%end